.TH Matplot1 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
Matplot1 - 2D plot of a matrix using colors 
.SH CALLING SEQUENCE
.nf
Matplot1(a,rect)
.fi
.SH PARAMETERS
.TP 3
a
: real matrix of size (n1,n2).
.TP
rect
: \fV[xmin;ymin,xmax,ymax]\fR
.SH DESCRIPTION
The entries of matrix \fVint(a)\fR are used as colormap entries in 
the current colormap. \fVrect\fR specify a rectangle in the 
current scale and the matrix is drawn inside this rectangle.
Each matrix entry will be rendered as a small rectangle filled with its 
associated color. 
.SH EXAMPLE 
.nf 
//--- first example
//  fix current scale 
xsetech(frect=[0,0,10,10])
xrect(0,10,10,10)
a=5*ones(11,11); a(2:10,2:10)=4; a(5:7,5:7)=2;
// first matrix in rectangle [1,1,3,3]
Matplot1(a,[1,1,3,3])
a=ones(10,10); a= 3*tril(a)+ 2*a; 
// second matrix in rectangle [5,6,7,8]
Matplot1(a,[5,6,7,8])
xset('default')
xbasc()
//--- second example 
xsetech(frect=[0,0,10,10])
xrect(0,10,10,10)
n=100;
xset('pixmap',1)
driver('X11');
for k=-n:n,
  a=ones(n,n);
  a= 3*tril(a,k)+ 2*a;
  a= a + a';
  k1= 3*(k+100)/200;
  Matplot1(a,[k1,2,k1+7,9])
  xset('wshow')
  xset('wwpc')
end
xset('pixmap',0)
xset('default')
xbasc()
.fi
.SH SEE ALSO
colormap, plot2d, Matplot
.SH AUTHOR
J.Ph.C.
