.TH grayplot 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
grayplot - 2D plot of a surface using colors
.SH CALLING SEQUENCE
.nf
grayplot(x,y,z,[strf,rect,nax])
grayplot(x,y,z,<opt_args>)
.fi
.SH PARAMETERS
.TP 11
x,y
: real row vectors of size n1 and n2.
.TP
z
: real matrix of size (n1,n2). \fVz(i,j)\fR is the value of the surface at 
the point (x(i),y(j)).
.TP 
<opt_args>
: This represents a sequence of statements \fVkey1=value1,
key2=value2\fR,... where \fVkey1\fR, \fVkey2,...\fR can be one of the
following: rect, nax, strf or axesflag and frameflag (see \fVplot2d\fR).
.TP
strf,rect,nax
: see \fVplot2d\fR.
.SH DESCRIPTION
\fVgrayplot\fR makes a 2D plot of the surface given by \fVz\fR on a grid 
defined by \fVx\fR and \fVy\fR.
Each rectangle on the grid is filled with a gray or color level depending 
on the average value of \fVz\fR on the corners of the rectangle.

.LP
Enter the command \fVgrayplot()\fR to see a demo.
.SH EXAMPLE 
.nf 
x=-10:10; y=-10:10;m =rand(21,21);
grayplot(x,y,m,rect=[-20,-20,20,20])
t=-%pi:0.1:%pi; m=sin(t)'*cos(t);
xbasc()
grayplot(t,t,m)
.fi
.SH SEE ALSO
fgrayplot, plot2d, Sgrayplot, Sfgrayplot
.SH AUTHOR
J.Ph.C.
