.TH plot2d 2 "April 1993" "Scilab Group" "Scilab Function"
.SH NAME
plot2d - 2D plot
.SH CALLING SEQUENCE
.nf
plot2d([x],y)
plot2d([x],y,<opt_args>)
plot2d([logflag],x,y,[style,strf,leg,rect,nax])
.fi
.SH PARAMETERS 
.TP 11
x,y
: two matrices or vectors.
.RS
.TP 2
-
If \fVy\fR is a vector, \fVx\fR must be a vector
with the same size. If \fVx\fR is not given, it is supposed to
be the vector \fV1:<size of \fVy\fR>\fR.
.TP 
-
If \fVy\fR is a matrix, \fVx\fR can be:
.RS
.TP 4
+
a vector with size equal to the row dimension of \fVy\fR (each
column of \fVy\fR is plotted with respect to \fVx\fR)
.TP
+
a matrix with the same dimensions as \fVy\fR (each column
of \fVy\fR is plotted with respect to the corresponding column of
\fVx\fR)
.TP
+ 
If \fVx\fR is not given, it is supposed to be the vector 
\fV1:<row dimension of \fVy\fR>\fR
.RE
.RE
.TP 10
<opt_args>
: This represents a sequence of statements \fVkey1=value1,
key2=value2\fR,... where \fVkey1\fR, \fVkey2,...\fR can be one of the
following:
.RS
.TP 9
style
: sets the style for each curve, see below for value.
.TP
leg 
: sets the curves captions. If this key is given and \fVstrf\fR
is not given then \fVx\fR character of \fVstrf\fR is supposed to be
\fV1\fR. See below for value.
.TP
rect 
: sets the bounds of the plot. If this key is given and neither \fVframeflag\fR
nor \fVstrf\fR is  given then the \fVy\fR character of \fVstrf\fR is
supposed to be \fV7\fR.  See below for value.
.TP
nax 
: sets the grids definition. If this key is given and neither
\fVaxesflag\fR nor \fVstrf\fR is given then the \fVz\fR character of
\fVstrf\fR is supposed to be \fV1\fR.  See below for value.
.TP
logflag
: sets the graduation type (linear or logarithmic) along the axes. See below for value.
.TP
frameflag
: specifies how the frame of the plot is computed. The value is an
integer ranging from 0 to 8. It corresponds to the \fVy\fR character of \fVstrf\fR. See below.
.TP
axesflags
: specifies what kind of axes are drawn around the plot. The value is
an integer ranging from 0 to 5. It corresponds to the \fVz\fR character of \fVstrf\fR. See below.
.RE
.TP 
style
: is a real row vector of size nc. The style to use for curve \fVi\fR is
defined by \fVstyle(i)\fR.

The default style is \fV1:nc\fR (1 for the first curve, 
2 for the second, etc.).
.RS
.TP 3
-
if \fVstyle(i)\fR is negative or zero, the curve is plotted using the mark with id 
\fVabs(style(i))\fR; use \fVxset()\fR to set the mark id and
xget('mark') to get the current mark id.
.TP
-
if \fVstyle(i)\fR is strictly positive, a plain line with color id 
\fVstyle(i)\fR or a dashed line with dash id \fVstyle(i)\fR is used; 
use \fVxset()\fR to see the color ids.
.TP
- 
When only one curve is drawn, \fVstyle\fR can be the row vector 
of size 2 \fV[sty,pos]\fR
where \fVsty\fR is used to specify the style and \fVpos\fR is an integer
ranging from 1 to 6 which specifies a position to use for the caption. 
This can be useful when a user wants to draw multiple curves on a plot by 
calling the function \fVplot2d\fR several times and wants to give a caption 
for each curve.
.RE
.TP
strf
: is a string of length 3 \fV"xyz"\fR.
.RS
.TP
The default is \fV"081"\fR.
.TP 3
x
: controls the display of captions.
.RS
.TP 5
x=0
: no caption.
.TP
x=1
: captions are displayed. They are given by the optional argument \fVleg\fR.
.RE
.TP
y
: controls the computation of the actual coordinate ranges from the
minimal requested values. Actual ranges can be larger than minimal
requirements.
.IG

.TS
tab(@);
l l l l.
   requirements@ranges       @ranges    @ranges
               @of a previous@given by  @computed from
actual         @plot         @rect arg  @x and y
-------------- @------------ @--------- @-------------
requested      @             @          @
one            @      y=0    @    y=1   @      y=2
-------------- @------------ @--------- @-------------
Computed       @             @          @ 
for isometric  @             @    y=3   @      y=4
view           @             @          @
-------------- @------------ @--------- @-------------
Enlarged       @             @          @
For pretty     @             @    y=5   @      y=6
axes           @             @          @
-------------- @------------ @--------- @-------------
Previous and   @             @          @
current        @             @    y=7   @      y=8
plots merged   @             @          @
-------------- @------------ @--------- @-------------

.TE
.FI
\" This is for LaTeX 
.LA 
.LA \begin{tabular}{|l|l|l|l|}                               \hline
.LA    requirements&ranges       &ranges    &ranges       \\    
.LA                &of a previous&given by  &computed from\\
.LA actual         &plot         &rect arg  &x and y      \\ \hline
.LA requested      &             &          &             \\
.LA one            &      y=0    &    y=1   &      y=2    \\ \hline
.LA Computed       &             &          &             \\
.LA for isometric  &             &    y=3   &      y=4    \\
.LA view           &             &          &             \\ \hline
.LA Enlarged       &             &          &             \\  
.LA For pretty     &             &    y=5   &      y=6    \\
.LA axes           &             &          &             \\ \hline
.LA Previous and   &             &          &             \\
.LA current        &             &    y=7   &      y=8    \\
.LA plots merged   &             &          &             \\ \hline
.LA \end{tabular}
.LA 

.TP
z 
: controls the display of information on the frame around the plot.
If axes are requested, the number
of tics can be specified by the \fVnax\fR optional argument.
.RS
.TP 5
z=0
: 
nothing is drawn around the plot.
.TP
z=1 
: 
axes are drawn, the y=axis is displayed on the left. 
.TP
z=2
: 
the plot is surrounded by a box without tics.
.TP
z=3 
: 
axes are drawn, the y=axis is displayed on the right. 
.TP
z=4
: 
axes are drawn centred in the middle of the frame box. 
.TP
z=5 
: 
axes are drawn so as to cross at point \fV(0,0)\fR.  If point
\fV(0,0)\fR does not lie inside the frame, axes will not appear on the graph.
.RE
.RE
.TP
leg
: 
a string. It is used when the first character x of argument \fVstrf\fR is 1.
\fVleg\fR has the form \fV"leg1@leg2@...."\fR where \fVleg1\fR, \fVleg2\fR, 
etc. are respectively the captions of the first curve,
of the second curve, etc.

The default is \fV" "\fR.
.TP
rect
: 
This argument is used when the second character y of argument \fVstrf\fR is 1,
3 or 5. It is a row vector of size 4 and gives the dimension of the frame: 
\fVrect=[xmin,ymin,xmax,ymax]\fR.
.TP
nax
: 
This argument is used when the third character z of argument \fVstrf\fR is 1.
It is a row vector with four entries \fV[nx,Nx,ny,Ny]\fR where
\fVnx\fR (\fVny\fR) is the number of subgraduations on the x (y) axis and
\fVNx\fR (\fVNy\fR) is the number of graduations on the x (y) axis.
.TP
logflag
: 
a string formed by to characters h (for horizontal axis) and v (for
vertical axis) each of these characters
can take the values "n" or "l". "l" stands for logarithmic graduation
and "n" for normal graduation. For example "ll"stands for a log-log
plot. Default value is "nn".
.LP
.SH DESCRIPTION
\fVplot2d\fR plots a set of 2D curves. Piecewise linear plotting is used.

By default, successive plots are superposed. To clear the previous plot, 
use \fVxbasc()\fR.

See the meaning of the parameters above for a complete description.

Enter the command \fVplot2d()\fR to see a demo.

Other high level plot2d function exist:
.TP 8
\fVplot2d2\fR
: same as \fVplot2d\fR but the curve is supposed to be 
piecewise constant.
.TP
\fVplot2d3\fR
: same as \fVplot2d\fR but the curve is plotted with
vertical bars.
.TP
\fVplot2d4\fR
: same as \fVplot2d\fR but the curve is plotted with
arrows.
.SH EXAMPLE
.nf
//simple plot
x=[0:0.1:2*%pi]';
plot2d(sin(x))
xbasc()
plot2d(x,sin(x))
//multiple plot
xbasc()
plot2d(x,[sin(x) sin(2*x) sin(3*x)])
// multiple plot giving the dimensions of the frame
//   old syntax and new syntax
xbasc()
plot2d(x,[sin(x) sin(2*x) sin(3*x)],1:3,"011"," ",[0,0,6,0.5])
xbasc()
plot2d(x,[sin(x) sin(2*x) sin(3*x)],rect=[0,0,6,0.5])
//multiple plot with captions and given tics
//   old syntax and new syntax
xbasc()
plot2d(x,[sin(x) sin(2*x) sin(3*x)],..
  [1,2,3],"111","L1@L2@L3",[0,-2,2*%pi,2],[2,10,2,10])
xbasc()
plot2d(x,[sin(x) sin(2*x) sin(3*x)],..
  [1,2,3],leg="L1@L2@L3",nax=[2,10,2,10],rect=[0,-2,2*%pi,2])
// isoview
xbasc()
plot2d(x,sin(x),1,"041")
// scale 
xbasc()
plot2d(x,sin(x),1,"061") 
// auto scaling with previous plots 
xbasc()
plot2d(x,sin(x),1)
plot2d(x,2*sin(x),2)
plot2d(2*x,cos(x),3)
// axis on the right 
xbasc()
plot2d(x,sin(x),1,"183","sin(x)")
// centered axis
xbasc()
plot2d(x,sin(x),1,"184","sin(x)")
// axis centered at (0,0)
xbasc()
plot2d(x-4,sin(x),1,"185","sin(x)")
.fi
.SH SEE ALSO
plot2d1, plot2d2, plot2d3, plot2d4, xbasc, xset
.SH AUTHOR
J.Ph.C.
