.TH plot3d 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
plot3d - 3D plot of a surface
.SH CALLING SEQUENCE
.nf
plot3d(x,y,z,[theta,alpha,leg,flag,ebox])
plot3d(x,y,z,<opt_args>)

plot3d(xf,yf,zf,[theta,alpha,leg,flag,ebox])
plot3d(xf,yf,zf,<opt_args>)

plot3d(xf,yf,list(zf,colors),[theta,alpha,leg,flag,ebox])
plot3d(xf,yf,list(zf,colors),<opt_args>)
.fi
.SH PARAMETERS
.TP 13
x,y
: row vectors of sizes n1 and n2 (x-axis and y-axis coordinates). These
coordinates must be monotone.
.TP 13
z
: matrix of size (n1,n2). \fVz(i,j)\fR is the value of the surface at the point
(x(i),y(j)).
.TP
xf,yf,zf
: matrices of size (nf,n). 
They define the facets used to draw the surface. There are \fVn\fR
facets.
Each facet \fVi\fR is defined by a polygon with \fVnf\fR points. 
The x-axis, y-axis and z-axis coordinates of the points of the ith
facet
are given respectively by \fVxf(:,i)\fR, \fVyf(:,i)\fR and
\fVzf(:,i)\fR.
.TP
colors
: a vector of size n giving the color of each facets or a matrix of
size (nf,n) giving color near each facet boundary (facet color is
interpolated )

.TP 
<opt_args>
: This represents a sequence of statements \fVkey1=value1,
key2=value2\fR,... where \fVkey1\fR, \fVkey2,...\fR can be one of the
following: theta, alpha ,leg,flag,ebox (see definition below)

.TP
theta, alpha 
: real values giving in degree the spherical coordinates of 
the observation point.
.TP
leg 
: string defining the captions for each axis with @ as a field
separator, for example "X@Y@Z".
.TP
flag
: a real vector of size three \fVflag=[mode,type,box]\fR.
.RS 
.TP 5
mode 
: string (treatment of hidden parts).
.RS
.TP 
mode>0 
the hidden parts of the surface are removed and the surface is painted 
with color \fVmode\fR.
.TP
mode=0
the hidden parts of the surface are drawn.
.TP
mode<0
only the shadow of the surface is painted with color or pattern id
\fV-mode\fR. Use \fVxset()\fR to see the meaning of the ids.
.RE
.TP
type 
: an integer (scaling).
.RS 
.TP 8
type=0
the plot is made using the current 3D scaling (set by a previous call to
\fVparam3d\fR, \fVplot3d\fR, \fVcontour\fR or \fVplot3d1\fR).
.TP
type=1
rescales
automatically 3d boxes with extreme aspect ratios, the boundaries are specified by the value of the optional argument \fVebox\fR.
.TP
type=2
rescales
automatically 3d boxes with extreme aspect ratios, the boundaries are computed using the given data.
.TP
type=3
3d isometric with box bounds given by optional
\fVebox\fR, similarily to \fVtype=1\fR
.TP
type=4
3d isometric bounds  derived from the data, to similarily\fVtype=2\fR
.TP
type=5
3d expanded isometric bounds  with box bounds given by optional
\fVebox\fR, similarily to \fVtype=1\fR
.TP
type=6
3d expanded isometric bounds  derived from the data, similarily to \fVtype=2\fR
.RE
.TP
box
: an integer (frame around the plot).
.RS
.TP
box=0 
nothing is drawn around the plot.
.TP
box=1 
unimplemented (like box=0).
.TP
box=2 
only the axes behind the surface are drawn.
.TP
box=3 
a box surrounding the surface is drawn and captions are added.
.TP
box=4
a box surrounding the surface is drawn, captions and axes are added.
.RE
.RE
.TP
ebox
: used when \fVtype\fR in \fVflag\fR is 1. It specifies the boundaries
of the plot as the vector \fV[xmin,xmax,ymin,ymax,zmin,zmax]\fR.
.SH DESCRIPTION
\fVplot3d(x,y,z,[theta,alpha,leg,flag,ebox])\fR draws the surface
\fVz=f(x,y)\fR.
.LP
\fVplot3d(xf,yf,zf,[theta,alpha,leg ,flag,ebox])\fR draws a
surface defined by a set of facets. You can draw multiple plots by replacing
\fVxf\fR, \fVyf\fR and \fVzf\fR by multiple matrices assembled by rows
as \fV[xf1 xf2 ...]\fR, \fV[yf1 yf2 ...]\fR and \fV[zf1 zf2 ...]\fR.
.LP
You can give a specific 
color for each facet by using \fVlist(zf,colors)\fR instead of \fVzf\fR,
where \fVcolors\fR is a vector of size \fVn\fR. If \fVcolors(i)\fR is
positive it gives the color of facet \fVi\fR and the boundary of the
facet is drawn with current line style and color.
If \fVcolors(i)\fR is negative, color id \fV-colors(i)\fR is used and
the boundary of the facet is not drawn. Use \fVxset()\fR to see the
ids of the colors. 
.LP
It is also possible to get interpolated color for facets. For that the
color argument must be a matrix of size nfxn giving the color near
each boundary of each facets. In this case positive values for colors
mean that the boundary are not drawn.
.LP 
The optional arguments \fVtheta,alpha,leg ,flag,ebox\fR, can be passed
by a sequence of statements \fVkey1=value1,
key2=value2\fR, ... In this case, the order has no special meaning.


.LP
You can use the function \fVgenfac3d\fR to compute four sided facets
from the surface \fVz=f(x,y)\fR. \fVeval3dp\fR can also be used.

Enter the command  \fVplot3d()\fR to see a demo.
.SH EXAMPLE
.nf
// simple plot using z=f(x,y)
t=[0:0.3:2*%pi]'; z=sin(t)*cos(t');
plot3d(t,t,z)
// same plot using facets computed by genfac3d
[xx,yy,zz]=genfac3d(t,t,z);
xbasc()
plot3d(xx,yy,zz)
// multiple plots
xbasc()
plot3d([xx xx],[yy yy],[zz 4+zz])
// multiple plots using colors
xbasc()
plot3d([xx xx],[yy yy],list([zz zz+4],[4*ones(1,400) 5*ones(1,400)]))
// simple plot with viewpoint and captions
xbasc()
plot3d(1:10,1:20,10*rand(10,20),35,45,"X@Y@Z",[2,2,3])
// plot of a sphere using facets computed by eval3dp
deff("[x,y,z]=sph(alp,tet)",["x=r*cos(alp).*cos(tet)+orig(1)*ones(tet)";..
  "y=r*cos(alp).*sin(tet)+orig(2)*ones(tet)";..
  "z=r*sin(alp)+orig(3)*ones(tet)"]);
r=1; orig=[0 0 0];
[xx,yy,zz]=eval3dp(sph,linspace(-%pi/2,%pi/2,40),linspace(0,%pi*2,20));
xbasc();plot3d(xx,yy,zz)

xbasc();xset('colormap',hotcolormap(128));
r=0.3;orig=[1.5 0 0];
[xx1,yy1,zz1]=eval3dp(sph,linspace(-%pi/2,%pi/2,40),linspace(0,%pi*2,20));
cc=(xx+zz+2)*32;cc1=(xx1-orig(1)+zz1/r+2)*32;   
xbasc();plot3d1([xx xx1],[yy yy1],list([zz,zz1],[cc cc1]),70,80)

xbasc();plot3d1([xx xx1],[yy yy1],list([zz,zz1],[cc cc1]),theta=70,alpha=80,flag=[5,6,3])
.fi
.SH SEE ALSO
eval3dp, genfac3d, geom3d, param3d, plot3d1, xset
.SH AUTHOR
J.Ph.C.
