.TH xarrows 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
xarrows - draw a set of arrows
.SH CALLING SEQUENCE
.nf
xarrows(nx,ny,[arsize,style])
.fi
.SH PARAMETERS
.TP 8
nx,ny
: real vectors or matrices of same size.
.TP
arsize
: real scalar, size of the arrow head. The default value can be obtained 
by setting arsize to -1.
.TP
style
: matrix or scalar. If \fVstyle\fR is a positive scalar 
it gives the dash style to use for all arrows. If it is a negative scalar 
then the current dash style is used. If it is a vector \fVstyle(i)\fR
gives the style to use for arrow \fVi\fR.
.LP
.SH DESCRIPTION
\fVxarrows\fR draws a set of arrows given by \fVnx\fR and \fVny\fR.
If \fVnx\fR and \fVny\fR are vectors,
the ith arrow is defined by
\fV(nx(i),ny(i))-->(nx(i+1),ny(i+1))\fR.
If \fVnx\fR and \fVny\fR are matrices:
.nf
nx=[xi_1 x1_2 ...; xf_1 xf_2 ...]
ny=[yi_1 y1_2 ...; yf_1 yf_2 ...]
.fi
the \fVk\fR th arrow is defined by \fV(xi_k,yi_k)-->(xf_k,yf_k)\fR.
.LP
\fVxarrows\fR uses the current graphics scale 
which can be set by calling a high level drawing function such as \fVplot2d\fR.
.SH EXAMPLE
.nf
x=2*%pi*(0:9)/8;
x1=[sin(x);9*sin(x)];
y1=[cos(x);9*cos(x)];
plot2d([-10,10],[-10,10],[-1,-1],"022")
xset("clipgrf")
xarrows(x1,y1,1,1:10)
xset("clipoff")
.fi
.SH AUTHOR
J.Ph.C.
