.TH xset 2 "April 1993" "Scilab Group" "Scilab Function"
.SH NAME
xset - set values of the graphics context
.SH CALLING SEQUENCE
.nf
xset(choice-name,x1,x2,x3,x4,x5)
xset()
.fi
.SH PARAMETERS
.TP 13
choice-name
: string
.TP 13
x1,...,x5
: depending on \fVchoice-name\fR
.SH DESCRIPTION
\fVxset\fR is used to set default values of the current window graphic
context. 
.LP
When called no argument, a choice menu is created showing the
current values and changes can be performed through toggle buttons.

Use \fVxset()\fR to display or set the current color, mark and fonts used.

.TP 13
xset("alufunction",number)
: Used to set the logical function for drawing. 
The logical function used is set by \fVx1\fR.
Usual values are: 3 for copying (default), 6 for animation and 0 for clearing.
See alufunctions for more details.
.TP
xset("auto clear","on"|"off")
: Switch "on" or "off" the auto clear mode for graphics.
When the auto clear mode is "on", successive plots are not superposed, ie
an \fVxbasc()\fR operation (the graphics
window is cleared and the associated recorded graphics is erased) is 
performed before each high level graphics function. Default value is "off".
.TP
xset("background",color)
: Set the background color of the current graphics window.
.TP
xset("clipping",x,y,w,h) 
: Set the clipping
zone (the zone of the graphics window where plots can be drawn)
to the rectangle (x,y,w,h) (Upper-Left point Width Height).
This function uses the current coordinates of the plot.
.TP
xset("color",value) 
: Set the default color for filling, line or text
drawing functions. \fVvalue\fR is an integer projected in the interval
[0,whiteid]. 0 is used for black filling and whiteid for white. The
value of whiteid can be obtained with \fVxget("white")\fR.
.TP
xset("colormap",cmap)
: Set the colormap as a m x 3 matrix. m is the number of colors.
Color number i is given as a 3-uple cmap(i,1), cmap(i,2), cmap(i,3)
corresponding respectively to red, green and blue intensity between
0 and 1.
.TP
xset("dashes",i)
: In black and white mode (\fVxset("use color",0)\fR), set the dash
style to style i (0 for solid line). In color mode (\fVxset("use
color",1 )\fR) this is used to set line, mark and text color. This
keyword is obsolete, please use \fVxset('color',i)\fR or 
\fVxset('line style',i)\fR instead.
.TP
xset("default")
: Reset the graphics context to default values.
.TP
xset("font",fontid,fontsize) : Set the current font and its current
size.  Note that \fVfontsize\fR applies to all fonts not only
 \fVfontid\fR . 
.TP
xset("font size",fontsize)
: Set the  fonts  size.
.TP
xset("foreground",color)
: Set the foreground color of the current graphics window.
.TP
xset("fpf",string)
: Set the floating point format for number display in 
contour functions. \fVstring\fR is a string giving the format 
in C format syntax (for example \fVstring="%.3f"\fR). Use 
\fVstring=""\fR to switch back to default format.
.TP
xset("hidden3d",colorid) : Set the color number for hidden faces in
\fVplot3d\fR. 
 \fVcolorid=0\fR zero suppress the drawing of backward
facing faces of 3d objects. This is technically called 'culling' and
is useful for closed surfaces.
.TP
xset("line mode",type)
: This function is used to set the line drawing mode. Absolute mode is set 
with type=1 and relative mode with type=0. (Warning: the mode type=0
has bugs)
.TP
xset("line style",value)
: Set the current line style (1: solid, >1 for dashed lines).
.TP
xset("mark",markid,marksize)
: Set the current mark and the current mark size. Use \fVxset()\fR
to see the marks. Note that  \fVmarksize\fR applies to all marks not only
 \fVmarkid\fR . 
.TP
xset("mark size",marksize)
: Set the marks size. 
.TP
xset("pattern",value)
: Set the current pattern for filling functions. value is an integer 
projected in the interval [0,whiteid]. 0 is used for black filling and 
whiteid for white. The value of whiteid can be obtained with 
\fVxget("white")\fR. "pattern" is equivalent to "color".
.TP
xset("pixmap",flag)

If flag=0 the graphics are directly displayed on the screen.

If flag=1 the graphics are done on a pixmap and are sent to the
graphics window with the command \fVxset("wshow")\fR. The pixmap is
cleared with the  command \fVxset("wwpc")\fR. Note that the usual command
\fVxbasc()\fR also clears the pixmap.
.TP
xset("thickness",value)
: Set the thickness of lines in pixel  (0 and 1 have the same meaning: 1 pixel thick).
.TP
xset("use color",flag)

If flag=1 then \fVxset("pattern",.)\fR or \fVxset("dashes",.)\fR will be 
used so
as to change the default color for drawing or for filling patterns.

If flag=0 then we switch back to the gray and dashes mode.
.TP
xset("viewport",x,y)
: Set the position of the panner.
.TP
xset("wdim",width,height)
: Set the width and the height of the current graphics window.
This option is not
used by the postscript driver.
.TP
xset("wpdim",width,height)
: Sets the width and the height of the current physical graphic
window (which can be different from the actual size in mode wresize 1).
This option is not
used by the postscript driver.
.TP
xset("window",window-number)
: Set the current window to the window \fVwindow-number\fR and creates the
window if it does not exist.
.TP
xset("wpos",x,y)
: Set the position of the upper left point of the graphics window.
.TP
xset("wresize",flag)

If flag=1 then the graphic is automatically resized to fill the
graphics window.
.nf
xdel();xset("wresize",1);plot2d();xset("wdim",1000,500)
.fi

If flag=0 the scale of the graphic is left unchanged when the graphics
window is resized. Top left panner or keyboard arrows may be used to
scroll over the graphic.
.nf
xdel();plot2d();xset("wresize",0);xset("wdim",1000,500)
.fi
.TP 
xset("wshow")
: See \fVxset("pixmap",1)\fR above.
.TP
xset("wwpc")
: See \fVxset("pixmap",1)\fR above.

.SH SEE ALSO
colormap, xget, getcolor, getsymbol
.SH AUTHOR
J.Ph.C.
