.TH addmenu 3 "December 1995" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
addmenu - interactive button or menu definition
.SH CALLING SEQUENCE
.nf
addmenu(button [,submenus] [,action]) 
addmenu(gwin,button [,submenus] [,action]) 
.fi
.SH PARAMETERS
.TP 10
button
: a character string. The button name. On Windows operating
systems (not X_window), an & can be placed before the character
in the name to be used for keyboard shortcut; this character
will be underlined on the GUI. 
.TP
submenus
: a vector of character string. The sub_menus items names
.TP
action
: a list with 2 elements action=list(flag,proc_name)
.RS
.TP 10
flag
: an integer (default value is 0)
.RS
.TP 15
flag==0
: the action is defined by a scilab instruction
.TP
flag==1
: the action is defined by a C or Fortran procedure
.RE
.TP
proc_name
: a character string which gives the name of scilab variable
containing the instruction or the name of procedure to call.
.RE
.TP
gwin
: integer. The number of graphic window where the button is required
to be installed
.SH DESCRIPTION
The function allows the user to add new buttons or menus in the main
window or graphics windows command panels.

If \fVaction\fR is not given the action associated with a button must
be defined by a scilab instruction given by the character string
variable which name is  
.TP 20
button
for a main window command
.TP
button_gwin
for a graphic window command
.LP
If \fVproc_name\fR designes a C or Fortran procedure, this procedure
may be interfaced in Fortran subroutine default/fbutn.f or dynamically
linked with scilab using the \fVlink function\fR. the calling sequence
is in C: \fV(char* name, int* win,int *entry)\fR

.LP
Actions associated with the kth sub_menu must be defined by  scilab
instructions stored in the kth element of the character string
variable which name is  
.TP 20
button
for a main window command
.TP
button_gwin
for a graphic window command
.SH EXAMPLE
.nf
addmenu('foo')
foo='disp(''hello'')'

addmenu('Hello',['Franck';'Peter'])
Hello=['disp(''hello Franck'')';'disp(''hello Peter'')']

addmenu(0,'Hello',['Franck';'Peter'])
Hello_0=['disp(''hello Franck'')';'disp(''hello Peter'')']

addmenu('Bye',list(0,'French_Bye'))
French_Bye='disp(''Au revoir'')'

//C defined Callback
// creating Callback code
code=[
 '#include ""'+SCI+'/routines/machine.h""'
 'void C2F(foo)(name,win,entry)'
 '     char *name;'
 '     int * win,*entry;'
 '{'
 '  if (*win==-1) '
 '    sciprint(""menu %s(%i) in Scilab window selected\\r\\n"",name,*entry+1);'
 '  else'
 '    sciprint(""menu %s(%i) in window %i selected\\r\\n"",name,*entry+1,*win);'
 '}']
//creating foo.c file
mputl(code,TMPDIR+'/foo.c');
//reating Makefile
ilib_gen_Make('foo','foo','',TMPDIR+'/Makefile',%f)
// Compiling and linking
link(ilib_compile('foo',TMPDIR+'/Makefile'),'foo')
//add menu
addmenu('foo',['a','b','c'],list(1,'foo'))

.fi
.SH SEE ALSO
setmenu, unsetmenu, delmenu
