.TH classmarkov 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
classmarkov - recurrent and transient classes of Markov matrix
.SH CALLING SEQUENCE
.nf
[perm,rec,tr,indsRec,indsT]=classmarkov(M)
.fi
.SH PARAMETERS
.TP 10
M
: real N x N Markov matrix. Sum of entries in each row should add to one.
.TP
perm
: integer permutation vector.
.TP
rec, tr
: integer vector, number (number of states in each recurrent classes, number of transient states).
.TP
indsRec,indsT
: integer vectors. (Indexes of recurrent and transient states).
.SH DESCRIPTION
Returns a permutation vector \fVperm\fR such that
.nf
M(perm,perm) = [M11 0 0 0 0   0]
               [0 M22 0 0     0]
               [0 0 M33       0]
               [      ...      ]
               [0 0       Mrr 0]
               [* *        *  Q]
.fi
Each \fVMii\fR is a Markov matrix of dimension \fVrec(i)  i=1,..,r\fR.
\fVQ\fR is sub-Markov matrix of dimension \fVtr\fR.
States 1 to sum(rec) are recurrent and states from r+1 to n
are transient. 
One has \fVperm=[indsRec,indsT]\fR where indsRec is a  vector of size sum(rec) 
and indsT is a vector of size tr.
.SH EXAMPLE
.nf
//P has two recurrent classes (with 2 and 1 states) 2 transient states
P=genmarkov([2,1],2,'perm')
[perm,rec,tr,indsRec,indsT]=classmarkov(P);
P(perm,perm)
.fi
.SH SEE ALSO
genmarkov, eigenmarkov




