.TH faurre 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
faurre - filter computation by simple Faurre algorithm
.SH CALLING SEQUENCE
.nf
[P,R,T]=faurre(n,H,F,G,R0)
.fi
.SH PARAMETERS
.TP 12
n
: number of iterations.
.TP
H, F, G
: estimated triple from the covariance sequence of \fVy\fR.
.TP
R0
: E(yk*yk')
.TP
P
: solution of the Riccati equation after n iterations.
.TP
R, T
: gain matrix of the filter.
.SH DESCRIPTION
This function computes iteratively the minimal solution of the algebraic
Riccati equation and gives the matrices \fVR\fR and \fVT\fR of the 
filter model.
The algorithm tries to compute the solution P as the growing limit of a
sequence of matrices Pn such that
.nf 
                                     -1
Pn+1=F*Pn*F'+(G-F*Pn*h')*(R0-H*Pn*H')  *(G'-H*Pn*F')
       -1
P0=G*R0 *G'
.fi
Note that this method may not converge,especially when F has poles
near the unit circle. Use preferably the srfaur function.
.SH AUTHOR
G. Le V.
.SH SEE ALSO
srfaur, linquist, phc
