.TH "ScilabEval" 2 " 04 June 1998" "Fractales Group" "TCL Function"
.so ../sci.an
.SH NAME
ScilabEval - tcl instruction : Evaluate a string with scilab interpreter
.SH CALLING SEQUENCE
ScilabEval str
.SH PARAMETERS
.TP
o 
str : tcl string character
Contains the string to evaluate with the current scilab interpreter. 

.SH Description
This function must be called in a tcl/tk script executed from scilab.
It allows to associate scilab actions to tcl/tk widgets (graphic
objects).  The string str is put in the scilab interpreter buffer
which then evaluates it.  This has in general no border effect in the
tcl/tk interpreter.
.SH EXAMPLE (tcl/tk script)
.nf
//Create a Tcl script using ScilabEval
tcl_script=['toplevel .w1'
'button .w1.b -text ""Click here to see a new Scilab Graphic Window""\'
'  -command {ScilabEval ""xselect()""}'
'pack .w1.b ']
mputl(tcl_script,TMPDIR+'/test.tcl')
// Execute the tcl script
TK_EvalFile(TMPDIR+'/test.tcl')
.fi
.SH SEE ALSO
TK_EvalFile, TK_EvalStr, TK_GetVar, TK_Setvar
.SH AUTHOR
Bertrand Guiheneuf
