.TH "TK_SetVar" 2 " 04 June 1998" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
TK_SetVar - Set a tcl/tk variable value
.SH CALLING SEQUENCE
.nf
TK_SetVar(varname, value)
.fi
.SH PARAMETERS
.TP 8
varname 
: string character
Contains the name of the tcl/tk variable to set.
.nr bi 1
.TP
value 
: string character
Contains the value to set up in the tcl/tk variable

.SH Description
This routine allows to set a variable within the tcl/tk interpreter. 
When tcl/tk support is enabled in scilab, this routine can be used to set up
the value of a tcl/tk variable. This can be useful to change some value
in the tcl/tk without having to build a tcl/tk instruction (and use TK_EvalStr).
.SH EXAMPLE
.nf
TK_EvalStr('toplevel .tst2');
// creates a toplevel TK window. 
TK_EvalStr('label .tst2.l -textvariable tvar');
// create a static label
TK_EvalStr('pack .tst2.l');
// pack the label widget. It appears on the screen.
TK_SetVar('tvar','This text has been set directly within scilab');
.fi
.SH AUTHOR
Bertrand Guiheneuf

.SH See also
ScilabEval, TK_EvalFile, TK_EvalStr, TK_GetVar
