.TH "get" 2 " 04 June 1998" "Fractales Group" "Scilab Function"
.SH NAME
get - Retrieve a property value from an User Interface object.
.SH CALLING SEQUENCE
val=get(h,prop)
.SH PARAMETERS
.TP
o 
h : integer
the handle of the object to retrieve a property
.TP
o 
Bprop : character string name of the property
.TP
o 
val : scilab object value of the property
.SH Description
This routine can be used to retrieve a specified property from a GUI object. 
Property name are character strings like 'style', 'position' ....
This routine returns the value associated to the specified property.
Obviously, the type of the returned object depends on the property
one aims at querying. For example, the 'style' property which represents
the kind of Object the UI control is (ie button, label, list, ..... ) will
be represented as a string. On the contrary, the 'position' property, which 
represents the geometrical aspect of the UI control, will be coded as 
a [1,4] vector. 
.SH EXAMPLE
.nf
h=uicontrol('string', 'Button');
// Opens a window with a  button.
p=get(h,'position');
// get the geometric qspect of the button
disp('Button width: ' + string(p(3)));
// print the width of the button
close();
// close figure
.fi 
.SH SEE ALSO
uicontrol, uimenu, set
.SH AUTHOR
Bertrand Guiheneuf
