.TH "uicontrol" 2 " 04 June 1998" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
uicontrol - create a Graphic User Interface object
.SH CALLING SEQUENCE
.nf
h=uicontrol([prop1,val1] [,prop2, val2] ...)
h=uicontrol(f,[prop1, val1] [,prop2, val2] ...)
.fi
.SH PARAMETERS
.TP
o 
f : integer
handle of the figure which will contain the control
.TP
o 
prop{1, 2 ...} : character string
name of a property to set
.TP
o 
val{1, 2 ...} : scilab object
value to give to the corresponding property
.TP
o 
h :
handle of the created object
.SH DESCRIPTION
this routine creates an object in a figure. If the handle of the figure
is given (as the first parameter), the uicontrol is created in this figure.
If no handle is given, the uicontrol is created in the current figure
( which may be obtained with a call to gcf() ). If there is no current 
figure, then one is created before the creation of the uicontrol.
Then when the control is created, the properties given as parameters
are set with the coresponding values. It is equivalent to create the uicontrol,
and then set its properties with the set() command. Nevertheless, it generally
more efficient to set the properties in the call to uicontrol(). This is particularly true coincerning the 'style' field. Indeed, the default value for
this property is 'pushbutton'. So if you do not set it at creation time,
a button will be created, and will be transformed to another uicontrol
when you call the get(h,'style', ... ) instruction.
Scilab and all the graphic objects communicate through the property
mechanism. Thus, to create adapted uicontrol, one has to know the
use of the property fields. Those are descibed under:
.SH PROPERTIES
.TP 15
BackgroundColor
[1,3] real vector or string
Background color of the uicontrol. A color is specified as Red,
Green and Blue values. Those values are real in [ 0,1].
The color can be given as a real vector, ie [R,G,B] or
a string where each value is separated by a |, ie "R|G|B"
.TP 
callback
string
String evaluated by the  scilab interpreter when an usicontrol is activated.
(for example when you click on a button).
.TP 
fontangle
string : {'normal'} | italic | oblique
For a control containing some text, this property sets the slant of the 
font.
.TP 
fontsize
real 
For a control containing some text, this property sets the size  of the 
font in FontUnits.
.TP 
fontunits
string : {points} | pixels | normalized
For a control containing some text, this property sets the units with 
which the fontsize is specified.
.TP 
fontweight
string : light | {normal} | demi | bold
For a control containing some text, this property sets the weight of
the used font
.TP 
ListboxTop
integer 
For a ListBox, this property tells which item of the list appears
on the first line of the visible area of the list.
.TP 
Max
scalar 
Specifies the largest value the 'value' property can be set to. 
It has however differnet meaning on each uicontrol:
.RS
.TP
o 
 Check Boxes : Max is the value the 'value' property take when 
control is checked
.TP
o 
 Silders  : Maximinum value of the slider 
.TP
o 
 List boxes : if (Max-Min)>1 the list allows multiple selection,
Otherwise not. 
.RE
.TP
Min
scalar 
Specifies the lowest value the 'value' property can be set to. 
It has however differnet meaning on each uicontrol:
.RS
.TP
o 
 Check Boxes : Min is the value the 'value' property take when 
control is unchecked
.TP
o 
 Silders  : Mininum value of the slider 
.TP
o 
 List boxes : if (Max-Min)>1 the list allows multiple selection, Otherwise not. 
.RE
.TP
Parent
integer 
Handle of the control parent. Changing this property allows to move
a control from a figure to another.
.TP
Position
[1,4] real vector or string
This property is used to set or get the geometrical configuration of a control.
It is a real; vector : x y w h where the letters stand for the x location of the left bottom corner, the y location of the left bottom corner, the width and the height of the uicontrol.
The unit is determined by the 'Unit' property. 
One can also set this property by giving a string where the fields are separated by a '|', ie "x|y|w|h".
.TP
SliderStep
[1,2] real vector or string
small big
This property represents the step a slider is moved when the user click on the arrow (small step) or on the slide bar (big step). 
.TP
String
string 
Generally, this property represents the text appearing in a uicontrol.
Its exact meaning sometimes depends on the uicontrol style:
.RS
.TP
o 
 List Boxes, Popup Menu
the value can be a vector of string or a string where the items are
separated by a '|'. 
.RE
.TP
Style
string : {pushbutton} | radiobutton | checkbox | edit | text | slider | frame |listbox | popupmenu 
Style of the uicontrol. Here is a short description of each one:
.RS
.TP
o 
 pushbutton 
A rectangular button generally used to run a callback. 
.TP
o 
 radiobutton
A button whith to states : on or off.
.TP
o 
 checkbox
a small uicontrol that have to state : on or off
.TP
o 
 edit 
an editable string control
.TP
o 
 text
a text control (generally static).
.TP
o 
 slider
a scale control, that is a scrollbar use to set values between in  range
with the mouse.
.TP
o 
 frame
a control representing a zone used to group of related controls.
.TP
o 
 listbox
a control representing a list of item that can be scrolled. The item can be selected with the mouse.
.TP
o 
 popupmenu
a button which make a menu appear when clicked.
.RE
.TP
Tag
string 
this property is generally used to identify the control. It allows to
give it a "name". Mainly used in conjontion with findobj().
.TP
Units
string :  {points} | pixels | normalized
Set the units used to specify the 'position' property.
.TP
Userdata
scilab object
this can be used to associate any scilab object to an uicontrol.
.TP
Value
Value of the uicontrol. The eact meaning depends on the style of the uicontrol.
.RS
.TP
o 
 Check boxes, Radio buttons
value is set to Max (see above) when on and Min when off.
.TP
o 
 List Boxes, Popu Menu
value is a vector of indexes corresponding to the index of the selected entry in the list. 1 is the first item of the list.

.TP
o 
 Sliders
value indicated by the slider bar.
.RE
.SH EXAMPLE
.nf
f=figure();
// create a figure
h=uicontrol(f,'style','listbox', ...
 'position', [10 10 150 160]);
// create a listbox
set(h, 'string', "item 1|item 2|item3");
// fill the list
set(h, 'value', [1 3]);
// select item 1 and 3 in the list
close();
// close the figure
f=figure();
// create a figure
h=uicontrol(f,'style','listbox', ...
 'position', [10 10 150 160]);
// create a listbox
set(h, 'string', "item 1|item 2|item3");
// fill the list
set(h, 'value', [1 3]);
// select (highlight) the item 1 and 3 in the list
close();
//close the figure
.fi 
.SH SEE ALSO
figure, set, get, uimenu
.SH AUTHOR
Bertrand Guiheneuf
