.TH "uimenu" 2 " 05 June 1998" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
uimenu - Create a menu or a submenu in a figure
.SH CALLING SEQUENCE
h=uimenu(parent,prop1, val1, prop2, val2 ...) 
.SH  PARAMETERS
.TP
o 
parent : integer
Handle of menu's parent 
.TP
o 
propi : string character
name of a property to set up
.TP
o 
vali : scilab object
value to affect to the corresponding property
.TP
o 
h : integer
handle of the corresponding menu

.SH Description
This allows to create menus in a figure. If 'parent' is a figure, then
the menu item will be added to the menu bar of the figure.
If 'parent' is a menu item , then the new  item will be added to the parent
item, allowing to create cascaded submenu.
The 'callback' property allows to set up the scilab instruction to call
when the item is selected by the user.
The 'label' property allows to set up the text appearing for the item.
.SH EXAMPLE
.nf
f=figure('position', [10 10 300 200]);
// create a figure
m=uimenu(f,'label', 'windows');
// create an item on the menu bar
m1=uimenu(m,'label', 'operations');
m2=uimenu(m,'label', 'quit scilab', 'callback', "exit");
//create two items in the menu "windows"
m11=uimenu(m1,'label', 'new window', 'callback',"xselect()");
m12=uimenu(m1,'label', 'clear  window', 'callback',"xbasc()");
// create a submenu to the item "operations"
close(f);
// close the figure
.fi 
.SH SEE ALSO
figure, uicontrol, set, get
.SH AUTHOR
Bertrand Guiheneuf
