.TH ilib_build 1 "May 2000" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
ilib_build - utility for shared library management
.SH CALLING SEQUENCE
.nf
ilib_build(lib_name,table,files,libs [,makename])
.fi
.SH PARAMETERS
.TP 10
lib_name
: a character string, the generic name of the library without path and
extension.
.TP 10
table
: 2 column string matrix giving the table of pairs 'scilab-name', 'interface name'
.TP 10 
files
: string matrix giving objects files needed for shared library
creation
.TP 10 
libs 
: string matrix giving extra libraries needed for shred library creation
.TP 10
makename
: character string. The path of the Makefile file without extension.
.SH DESCRIPTION
.LP 
This tool is used to create shared libraries and to generate a 
loader file which can be used to dynamically load the shared library 
into Scilab with \fVaddinter\fR

Many examples are provided in \fVexamples/interface-tour-so\fR
directory. 

.SH EXAMPLE
.nf
//Here with give a complete example on adding new primitive to Scilab
//create the procedure files
f1=['extern double fun2();'
    'void fun1(x,y)'
    'double *x, *y;'
    '{*y=fun2(*x)/(*x);}'];

mputl(f1,'fun1.c')

f2=['#include <math.h>'
    'double fun2(x)'
    'double x;'
    '{ return( sin(x+1.));}'];
mputl(f2,'fun2.c');

//creating the interface file
i=['#include ""stack-c.h""'
   'extern int fun1 _PARAMS(( double *x, double *y));'
   'int intfun1(fname)' 
   'char * fname;'
   '{'
   '  int m1,n1,l1;'
   '  CheckRhs(1,1);'
   '  CheckLhs(1,1);'
   '  GetRhsVar(1, ""d"", &m1, &n1, &l1);'
   '  fun1(stk(l1),stk(l1));'
   '  LhsVar(1) = 1;'
   '  return 0;'
   '}'];
mputl(i,'intfun1.c')

//creating the shared library (a gateway, a Makefile and a loader are 
//generated. 

files=['fun1.o','fun2.o','intfun1.o'];
ilib_build('foo',['scifun1','intfun1'],files,[]);

// load the shared library 

exec loader.sce 

//using the new primitive
scifun1(33)
.fi 
.SH SEE ALSO
addinter, link, ilib_compile, ilib_gen_Make, ilib_gen_gateway,
ilib_gen_loader, ilib_for_link



