#include "petsc.h"
#include "petscfix.h"
/* orthog.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "slepceps.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsqrdecomposition_ EPSQRDECOMPOSITION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsqrdecomposition_ epsqrdecomposition
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsorthogonalize_ EPSORTHOGONALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsorthogonalize_ epsorthogonalize
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsbiorthogonalize_ EPSBIORTHOGONALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsbiorthogonalize_ epsbiorthogonalize
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  epsqrdecomposition_(EPS *eps,Vec *V,int *m,int *n,PetscScalar *R,int *ldr, int *__ierr ){
*__ierr = EPSQRDecomposition(*eps,V,*m,*n,R,*ldr);
}
void PETSC_STDCALL  epsorthogonalize_(EPS *eps,int *n,PetscTruth *which,Vec *V,Vec v,PetscScalar *H,PetscReal *norm,PetscTruth *lindep, int *__ierr ){
*__ierr = EPSOrthogonalize(*eps,*n,which,V,
	(Vec)PetscToPointer((v) ),H,norm,lindep);
}
void PETSC_STDCALL  epsbiorthogonalize_(EPS *eps,int *n,Vec *V,Vec *W,Vec v,PetscScalar *H,PetscReal *norm, int *__ierr ){
*__ierr = EPSBiOrthogonalize(*eps,*n,V,W,
	(Vec)PetscToPointer((v) ),H,norm);
}
#if defined(__cplusplus)
}
#endif
