/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.CloneableCompatibility;

public final class ImageData
implements CloneableCompatibility {
    public int width;
    public int height;
    public int depth;
    public int scanlinePad;
    public int bytesPerLine;
    public byte[] data;
    public PaletteData palette;
    public int transparentPixel;
    public byte[] maskData;
    public int maskPad;
    public byte[] alphaData;
    public int alpha;
    public int type;
    public int x;
    public int y;
    public int disposalMethod;
    public int delayTime;
    static final byte[][] ANY_TO_EIGHT = new byte[9][];
    static final byte[] ONE_TO_ONE_MAPPING;
    static final int[][] DITHER_MATRIX;
    static final int BLIT_SRC = 1;
    static final int BLIT_ALPHA = 2;
    static final int BLIT_DITHER = 4;
    static final int ALPHA_OPAQUE = 255;
    static final int ALPHA_TRANSPARENT = 0;
    static final int ALPHA_CHANNEL_SEPARATE = -1;
    static final int ALPHA_CHANNEL_SOURCE = -2;
    static final int ALPHA_MASK_UNPACKED = -3;
    static final int ALPHA_MASK_PACKED = -4;
    static final int ALPHA_MASK_INDEX = -5;
    static final int ALPHA_MASK_RGB = -6;
    static final int LSB_FIRST = 0;
    static final int MSB_FIRST = 1;
    private static final int TYPE_GENERIC_8 = 0;
    private static final int TYPE_GENERIC_16_MSB = 1;
    private static final int TYPE_GENERIC_16_LSB = 2;
    private static final int TYPE_GENERIC_24 = 3;
    private static final int TYPE_GENERIC_32_MSB = 4;
    private static final int TYPE_GENERIC_32_LSB = 5;
    private static final int TYPE_INDEX_8 = 6;
    private static final int TYPE_INDEX_4 = 7;
    private static final int TYPE_INDEX_2 = 8;
    private static final int TYPE_INDEX_1_MSB = 9;
    private static final int TYPE_INDEX_1_LSB = 10;

    static {
        int n = 0;
        while (n < 9) {
            ImageData.ANY_TO_EIGHT[n] = new byte[1 << n];
            byte[] byArray = ImageData.ANY_TO_EIGHT[n];
            if (n != 0) {
                int n2 = 0;
                int n3 = 65536;
                while ((n3 >>= n) != 0) {
                    n2 |= n3;
                }
                n3 = 0;
                int n4 = 0;
                while (n3 < 65536) {
                    byArray[n4++] = (byte)(n3 >> 8);
                    n3 += n2;
                }
            }
            ++n;
        }
        ONE_TO_ONE_MAPPING = ANY_TO_EIGHT[8];
        int[][] nArrayArray = new int[8][];
        nArrayArray[0] = new int[]{0xFC0000, 0x7C0000, 0xDC0000, 0x5C0000, 0xF40000, 0x740000, 0xD40000, 0x540000};
        nArrayArray[1] = new int[]{0x3C0000, 0xBC0000, 0x1C0000, 0x9C0000, 0x340000, 0xB40000, 0x140000, 0x940000};
        nArrayArray[2] = new int[]{0xCC0000, 0x4C0000, 0xEC0000, 0x6C0000, 0xC40000, 0x440000, 0xE40000, 0x640000};
        nArrayArray[3] = new int[]{786432, 0x8C0000, 0x2C0000, 0xAC0000, 262144, 0x840000, 0x240000, 0xA40000};
        nArrayArray[4] = new int[]{0xF00000, 0x700000, 0xD00000, 0x500000, 0xF80000, 0x780000, 0xD80000, 0x580000};
        nArrayArray[5] = new int[]{0x300000, 0xB00000, 0x100000, 0x900000, 0x380000, 0xB80000, 0x180000, 0x980000};
        nArrayArray[6] = new int[]{0xC00000, 0x400000, 0xE00000, 0x600000, 0xC80000, 0x480000, 0xE80000, 0x680000};
        int[] nArray = new int[8];
        nArray[1] = 0x800000;
        nArray[2] = 0x200000;
        nArray[3] = 0xA00000;
        nArray[4] = 524288;
        nArray[5] = 0x880000;
        nArray[6] = 0x280000;
        nArray[7] = 0xA80000;
        nArrayArray[7] = nArray;
        DITHER_MATRIX = nArrayArray;
    }

    public ImageData(int n, int n2, int n3, PaletteData paletteData) {
        this(n, n2, n3, paletteData, 4, null, 0, null, null, -1, -1, -1, 0, 0, 0, 0);
    }

    public ImageData(int n, int n2, int n3, PaletteData paletteData, int n4, byte[] byArray) {
        this(n, n2, n3, paletteData, n4, ImageData.checkData(byArray), 0, null, null, -1, -1, -1, 0, 0, 0, 0);
    }

    public ImageData(InputStream inputStream) {
        ImageData[] imageDataArray = new ImageLoader().load(inputStream);
        if (imageDataArray.length < 1) {
            SWT.error(40);
        }
        ImageData imageData = imageDataArray[0];
        this.setAllFields(imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, imageData.bytesPerLine, imageData.data, imageData.palette, imageData.transparentPixel, imageData.maskData, imageData.maskPad, imageData.alphaData, imageData.alpha, imageData.type, imageData.x, imageData.y, imageData.disposalMethod, imageData.delayTime);
    }

    public ImageData(String string) {
        ImageData[] imageDataArray = new ImageLoader().load(string);
        if (imageDataArray.length < 1) {
            SWT.error(40);
        }
        ImageData imageData = imageDataArray[0];
        this.setAllFields(imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, imageData.bytesPerLine, imageData.data, imageData.palette, imageData.transparentPixel, imageData.maskData, imageData.maskPad, imageData.alphaData, imageData.alpha, imageData.type, imageData.x, imageData.y, imageData.disposalMethod, imageData.delayTime);
    }

    ImageData() {
    }

    ImageData(int n, int n2, int n3, PaletteData paletteData, int n4, byte[] byArray, int n5, byte[] byArray2, byte[] byArray3, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        if (paletteData == null) {
            SWT.error(4);
        }
        if (n3 != 1 && n3 != 2 && n3 != 4 && n3 != 8 && n3 != 16 && n3 != 24 && n3 != 32) {
            SWT.error(5);
        }
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        if (n4 == 0) {
            SWT.error(7);
        }
        int n13 = ((n * n3 + 7) / 8 + (n4 - 1)) / n4 * n4;
        this.setAllFields(n, n2, n3, n4, n13, byArray != null ? byArray : new byte[n13 * n2], paletteData, n7, byArray2, n5, byArray3, n6, n8, n9, n10, n11, n12);
    }

    void setAllFields(int n, int n2, int n3, int n4, int n5, byte[] byArray, PaletteData paletteData, int n6, byte[] byArray2, int n7, byte[] byArray3, int n8, int n9, int n10, int n11, int n12, int n13) {
        this.width = n;
        this.height = n2;
        this.depth = n3;
        this.scanlinePad = n4;
        this.bytesPerLine = n5;
        this.data = byArray;
        this.palette = paletteData;
        this.transparentPixel = n6;
        this.maskData = byArray2;
        this.maskPad = n7;
        this.alphaData = byArray3;
        this.alpha = n8;
        this.type = n9;
        this.x = n10;
        this.y = n11;
        this.disposalMethod = n12;
        this.delayTime = n13;
    }

    public static ImageData internal_new(int n, int n2, int n3, PaletteData paletteData, int n4, byte[] byArray, int n5, byte[] byArray2, byte[] byArray3, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        return new ImageData(n, n2, n3, paletteData, n4, byArray, n5, byArray2, byArray3, n6, n7, n8, n9, n10, n11, n12);
    }

    ImageData colorMaskImage(int n) {
        ImageData imageData = new ImageData(this.width, this.height, 1, ImageData.bwPalette(), 2, null, 0, null, null, -1, -1, -1, 0, 0, 0, 0);
        int[] nArray = new int[this.width];
        int n2 = 0;
        while (n2 < this.height) {
            this.getPixels(0, n2, this.width, nArray, 0);
            int n3 = 0;
            while (n3 < this.width) {
                nArray[n3] = n != -1 && nArray[n3] == n ? 0 : 1;
                ++n3;
            }
            imageData.setPixels(0, n2, this.width, nArray, 0);
            ++n2;
        }
        return imageData;
    }

    static byte[] checkData(byte[] byArray) {
        if (byArray == null) {
            SWT.error(4);
        }
        return byArray;
    }

    public Object clone() {
        byte[] byArray = new byte[this.data.length];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        byte[] byArray2 = null;
        if (this.maskData != null) {
            byArray2 = new byte[this.maskData.length];
            System.arraycopy(this.maskData, 0, byArray2, 0, this.maskData.length);
        }
        byte[] byArray3 = null;
        if (this.alphaData != null) {
            byArray3 = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, byArray3, 0, this.alphaData.length);
        }
        return new ImageData(this.width, this.height, this.depth, this.palette, this.scanlinePad, byArray, this.maskPad, byArray2, byArray3, this.alpha, this.transparentPixel, this.type, this.x, this.y, this.disposalMethod, this.delayTime);
    }

    public int getAlpha(int n, int n2) {
        if (n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (this.alphaData == null) {
            return 255;
        }
        return this.alphaData[n2 * this.width + n] & 0xFF;
    }

    public void getAlphas(int n, int n2, int n3, byte[] byArray, int n4) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        if (this.alphaData == null) {
            int n5 = n4 + n3;
            int n6 = n4;
            while (n6 < n5) {
                byArray[n6] = -1;
                ++n6;
            }
            return;
        }
        System.arraycopy(this.alphaData, n2 * this.width + n, byArray, n4, n3);
    }

    public int getPixel(int n, int n2) {
        if (n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (this.depth == 1) {
            int n3 = n2 * this.bytesPerLine + (n >> 3);
            int n4 = this.data[n3] & 0xFF;
            int n5 = 1 << 7 - (n & 7);
            if ((n4 & n5) == 0) {
                return 0;
            }
            return 1;
        }
        if (this.depth == 2) {
            int n6 = n2 * this.bytesPerLine + (n >> 2);
            int n7 = this.data[n6] & 0xFF;
            int n8 = 3 - n % 4;
            int n9 = 3 << n8 * 2;
            return (n7 & n9) >> n8 * 2;
        }
        if (this.depth == 4) {
            int n10 = n2 * this.bytesPerLine + (n >> 1);
            int n11 = this.data[n10] & 0xFF;
            if ((n & 1) == 0) {
                return n11 >> 4;
            }
            return n11 & 0xF;
        }
        if (this.depth == 8) {
            int n12 = n2 * this.bytesPerLine + n;
            return this.data[n12] & 0xFF;
        }
        if (this.depth == 16) {
            int n13 = n2 * this.bytesPerLine + n * 2;
            return ((this.data[n13 + 1] & 0xFF) << 8) + (this.data[n13] & 0xFF);
        }
        if (this.depth == 24) {
            int n14 = n2 * this.bytesPerLine + n * 3;
            return ((this.data[n14] & 0xFF) << 16) + ((this.data[n14 + 1] & 0xFF) << 8) + (this.data[n14 + 2] & 0xFF);
        }
        if (this.depth == 32) {
            int n15 = n2 * this.bytesPerLine + n * 4;
            return ((this.data[n15] & 0xFF) << 24) + ((this.data[n15 + 1] & 0xFF) << 16) + ((this.data[n15 + 2] & 0xFF) << 8) + (this.data[n15 + 3] & 0xFF);
        }
        SWT.error(38);
        return 0;
    }

    public void getPixels(int n, int n2, int n3, byte[] byArray, int n4) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        int n5 = 0;
        int n6 = n3;
        int n7 = n4;
        int n8 = n;
        int n9 = n2;
        if (this.depth == 1) {
            int n10 = n2 * this.bytesPerLine + (n >> 3);
            int n11 = this.data[n10] & 0xFF;
            while (n6 > 0) {
                n5 = 1 << 7 - (n8 & 7);
                byArray[n7] = (n11 & n5) == 0 ? (byte)0 : 1;
                ++n7;
                --n6;
                if (++n8 >= this.width) {
                    n10 = ++n9 * this.bytesPerLine;
                    if (n6 > 0) {
                        n11 = this.data[n10] & 0xFF;
                    }
                    n8 = 0;
                    continue;
                }
                if (n5 != 1) continue;
                ++n10;
                if (n6 <= 0) continue;
                n11 = this.data[n10] & 0xFF;
            }
            return;
        }
        if (this.depth == 2) {
            int n12 = n2 * this.bytesPerLine + (n >> 2);
            int n13 = this.data[n12] & 0xFF;
            while (n6 > 0) {
                int n14 = 3 - n8 % 4;
                n5 = 3 << n14 * 2;
                byArray[n7] = (byte)((n13 & n5) >> n14 * 2);
                ++n7;
                --n6;
                if (++n8 >= this.width) {
                    n12 = ++n9 * this.bytesPerLine;
                    if (n6 > 0) {
                        n13 = this.data[n12] & 0xFF;
                    }
                    n8 = 0;
                    continue;
                }
                if (n14 != 0) continue;
                n13 = this.data[++n12] & 0xFF;
            }
            return;
        }
        if (this.depth == 4) {
            int n15;
            int n16 = n2 * this.bytesPerLine + (n >> 1);
            if ((n & 1) == 1) {
                n15 = this.data[n16] & 0xFF;
                byArray[n7] = (byte)(n15 & 0xF);
                ++n7;
                --n6;
                if (++n8 >= this.width) {
                    n16 = ++n9 * this.bytesPerLine;
                    n8 = 0;
                } else {
                    ++n16;
                }
            }
            while (n6 > 1) {
                n15 = this.data[n16] & 0xFF;
                byArray[n7] = (byte)(n15 >> 4);
                ++n7;
                --n6;
                if (++n8 >= this.width) {
                    n16 = ++n9 * this.bytesPerLine;
                    n8 = 0;
                    continue;
                }
                byArray[n7] = (byte)(n15 & 0xF);
                ++n7;
                --n6;
                if (++n8 >= this.width) {
                    n16 = ++n9 * this.bytesPerLine;
                    n8 = 0;
                    continue;
                }
                ++n16;
            }
            if (n6 > 0) {
                n15 = this.data[n16] & 0xFF;
                byArray[n7] = (byte)(n15 >> 4);
            }
            return;
        }
        if (this.depth == 8) {
            int n17 = n2 * this.bytesPerLine + n;
            int n18 = 0;
            while (n18 < n3) {
                byArray[n7] = this.data[n17];
                ++n7;
                if (++n8 >= this.width) {
                    n17 = ++n9 * this.bytesPerLine;
                    n8 = 0;
                } else {
                    ++n17;
                }
                ++n18;
            }
            return;
        }
        SWT.error(38);
    }

    public void getPixels(int n, int n2, int n3, int[] nArray, int n4) {
        if (nArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        int n5 = n3;
        int n6 = n4;
        int n7 = n;
        int n8 = n2;
        if (this.depth == 1) {
            int n9 = n2 * this.bytesPerLine + (n >> 3);
            int n10 = this.data[n9] & 0xFF;
            while (n5 > 0) {
                int n11 = 1 << 7 - (n7 & 7);
                nArray[n6] = (n10 & n11) == 0 ? 0 : 1;
                ++n6;
                --n5;
                if (++n7 >= this.width) {
                    n9 = ++n8 * this.bytesPerLine;
                    if (n5 > 0) {
                        n10 = this.data[n9] & 0xFF;
                    }
                    n7 = 0;
                    continue;
                }
                if (n11 != 1) continue;
                ++n9;
                if (n5 <= 0) continue;
                n10 = this.data[n9] & 0xFF;
            }
            return;
        }
        if (this.depth == 2) {
            int n12 = n2 * this.bytesPerLine + (n >> 2);
            int n13 = this.data[n12] & 0xFF;
            while (n5 > 0) {
                int n14 = 3 - n7 % 4;
                int n15 = 3 << n14 * 2;
                nArray[n6] = (byte)((n13 & n15) >> n14 * 2);
                ++n6;
                --n5;
                if (++n7 >= this.width) {
                    n12 = ++n8 * this.bytesPerLine;
                    if (n5 > 0) {
                        n13 = this.data[n12] & 0xFF;
                    }
                    n7 = 0;
                    continue;
                }
                if (n14 != 0) continue;
                n13 = this.data[++n12] & 0xFF;
            }
            return;
        }
        if (this.depth == 4) {
            int n16;
            int n17 = n2 * this.bytesPerLine + (n >> 1);
            if ((n & 1) == 1) {
                n16 = this.data[n17] & 0xFF;
                nArray[n6] = n16 & 0xF;
                ++n6;
                --n5;
                if (++n7 >= this.width) {
                    n17 = ++n8 * this.bytesPerLine;
                    n7 = 0;
                } else {
                    ++n17;
                }
            }
            while (n5 > 1) {
                n16 = this.data[n17] & 0xFF;
                nArray[n6] = n16 >> 4;
                ++n6;
                --n5;
                if (++n7 >= this.width) {
                    n17 = ++n8 * this.bytesPerLine;
                    n7 = 0;
                    continue;
                }
                nArray[n6] = n16 & 0xF;
                ++n6;
                --n5;
                if (++n7 >= this.width) {
                    n17 = ++n8 * this.bytesPerLine;
                    n7 = 0;
                    continue;
                }
                ++n17;
            }
            if (n5 > 0) {
                n16 = this.data[n17] & 0xFF;
                nArray[n6] = n16 >> 4;
            }
            return;
        }
        if (this.depth == 8) {
            int n18 = n2 * this.bytesPerLine + n;
            int n19 = 0;
            while (n19 < n3) {
                nArray[n6] = this.data[n18] & 0xFF;
                ++n6;
                if (++n7 >= this.width) {
                    n18 = ++n8 * this.bytesPerLine;
                    n7 = 0;
                } else {
                    ++n18;
                }
                ++n19;
            }
            return;
        }
        if (this.depth == 16) {
            int n20 = n2 * this.bytesPerLine + n * 2;
            int n21 = 0;
            while (n21 < n3) {
                nArray[n6] = ((this.data[n20 + 1] & 0xFF) << 8) + (this.data[n20] & 0xFF);
                ++n6;
                if (++n7 >= this.width) {
                    n20 = ++n8 * this.bytesPerLine;
                    n7 = 0;
                } else {
                    n20 += 2;
                }
                ++n21;
            }
            return;
        }
        if (this.depth == 24) {
            int n22 = n2 * this.bytesPerLine + n * 3;
            int n23 = 0;
            while (n23 < n3) {
                nArray[n6] = (this.data[n22] & 0xFF) << 16 | (this.data[n22 + 1] & 0xFF) << 8 | this.data[n22 + 2] & 0xFF;
                ++n6;
                if (++n7 >= this.width) {
                    n22 = ++n8 * this.bytesPerLine;
                    n7 = 0;
                } else {
                    n22 += 3;
                }
                ++n23;
            }
            return;
        }
        if (this.depth == 32) {
            int n24 = n2 * this.bytesPerLine + n * 4;
            n6 = n4;
            int n25 = 0;
            while (n25 < n3) {
                nArray[n6] = (this.data[n24] & 0xFF) << 24 | (this.data[n24 + 1] & 0xFF) << 16 | (this.data[n24 + 2] & 0xFF) << 8 | this.data[n24 + 3] & 0xFF;
                ++n6;
                if (++n7 >= this.width) {
                    n24 = ++n8 * this.bytesPerLine;
                    n7 = 0;
                } else {
                    n24 += 4;
                }
                ++n25;
            }
            return;
        }
        SWT.error(38);
    }

    public RGB[] getRGBs() {
        return this.palette.getRGBs();
    }

    public ImageData getTransparencyMask() {
        if (this.getTransparencyType() == 2) {
            return new ImageData(this.width, this.height, 1, ImageData.bwPalette(), this.maskPad, this.maskData);
        }
        return this.colorMaskImage(this.transparentPixel);
    }

    public int getTransparencyType() {
        if (this.maskData != null) {
            return 2;
        }
        if (this.transparentPixel != -1) {
            return 4;
        }
        if (this.alphaData != null) {
            return 1;
        }
        return 0;
    }

    int getByteOrder() {
        return this.depth != 16 ? 1 : 0;
    }

    public ImageData scaledTo(int n, int n2) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = n < 0;
        if (bl2) {
            n = -n;
        }
        boolean bl4 = bl = n2 < 0;
        if (bl) {
            n2 = -n2;
        }
        ImageData imageData = new ImageData(n, n2, this.depth, this.palette, this.scanlinePad, null, 0, null, null, -1, this.transparentPixel, this.type, this.x, this.y, this.disposalMethod, this.delayTime);
        if (this.palette.isDirect) {
            ImageData.blit(1, this.data, this.depth, this.bytesPerLine, this.getByteOrder(), 0, 0, this.width, this.height, 0, 0, 0, 255, null, 0, 0, 0, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, 0, 0, 0, bl2, bl);
        } else {
            ImageData.blit(1, this.data, this.depth, this.bytesPerLine, this.getByteOrder(), 0, 0, this.width, this.height, null, null, null, 255, null, 0, 0, 0, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, null, null, null, bl2, bl);
        }
        if (this.maskData != null) {
            imageData.maskPad = this.maskPad;
            int n3 = (imageData.width + 7) / 8;
            n3 = (n3 + (imageData.maskPad - 1)) / imageData.maskPad * imageData.maskPad;
            imageData.maskData = new byte[n3 * imageData.height];
            int n4 = (this.width + 7) / 8;
            n4 = (n4 + (this.maskPad - 1)) / this.maskPad * this.maskPad;
            ImageData.blit(1, this.maskData, 1, n4, 1, 0, 0, this.width, this.height, null, null, null, 255, null, 0, 0, 0, imageData.maskData, 1, n3, 1, 0, 0, imageData.width, imageData.height, null, null, null, bl2, bl);
        } else if (this.alpha != -1) {
            imageData.alpha = this.alpha;
        } else if (this.alphaData != null) {
            imageData.alphaData = new byte[imageData.width * imageData.height];
            ImageData.blit(1, this.alphaData, 8, this.width, 1, 0, 0, this.width, this.height, null, null, null, 255, null, 0, 0, 0, imageData.alphaData, 8, imageData.width, 1, 0, 0, imageData.width, imageData.height, null, null, null, bl2, bl);
        }
        return imageData;
    }

    public void setAlpha(int n, int n2, int n3) {
        if (n >= this.width || n2 >= this.height || n < 0 || n2 < 0 || n3 < 0 || n3 > 255) {
            SWT.error(5);
        }
        if (this.alphaData == null) {
            this.alphaData = new byte[this.width * this.height];
        }
        this.alphaData[n2 * this.width + n] = (byte)n3;
    }

    public void setAlphas(int n, int n2, int n3, byte[] byArray, int n4) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        if (this.alphaData == null) {
            this.alphaData = new byte[this.width * this.height];
        }
        System.arraycopy(byArray, n4, this.alphaData, n2 * this.width + n, n3);
    }

    public void setPixel(int n, int n2, int n3) {
        if (n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (this.depth == 1) {
            int n4 = n2 * this.bytesPerLine + (n >> 3);
            byte by = this.data[n4];
            int n5 = 1 << 7 - (n & 7);
            this.data[n4] = (n3 & 1) == 1 ? (byte)(by | n5) : (byte)(by & ~n5);
            return;
        }
        if (this.depth == 2) {
            int n6 = n2 * this.bytesPerLine + (n >> 2);
            byte by = this.data[n6];
            int n7 = 3 - n % 4;
            int n8 = 0xFF ^ 3 << n7 * 2;
            this.data[n6] = (byte)(this.data[n6] & n8 | n3 << n7 * 2);
            return;
        }
        if (this.depth == 4) {
            int n9 = n2 * this.bytesPerLine + (n >> 1);
            this.data[n9] = (n & 1) == 0 ? (byte)(this.data[n9] & 0xF | (n3 & 0xF) << 4) : (byte)(this.data[n9] & 0xF0 | n3 & 0xF);
            return;
        }
        if (this.depth == 8) {
            int n10 = n2 * this.bytesPerLine + n;
            this.data[n10] = (byte)(n3 & 0xFF);
            return;
        }
        if (this.depth == 16) {
            int n11 = n2 * this.bytesPerLine + n * 2;
            this.data[n11 + 1] = (byte)(n3 >> 8 & 0xFF);
            this.data[n11] = (byte)(n3 & 0xFF);
            return;
        }
        if (this.depth == 24) {
            int n12 = n2 * this.bytesPerLine + n * 3;
            this.data[n12] = (byte)(n3 >> 16 & 0xFF);
            this.data[n12 + 1] = (byte)(n3 >> 8 & 0xFF);
            this.data[n12 + 2] = (byte)(n3 & 0xFF);
            return;
        }
        if (this.depth == 32) {
            int n13 = n2 * this.bytesPerLine + n * 4;
            this.data[n13] = (byte)(n3 >> 24 & 0xFF);
            this.data[n13 + 1] = (byte)(n3 >> 16 & 0xFF);
            this.data[n13 + 2] = (byte)(n3 >> 8 & 0xFF);
            this.data[n13 + 3] = (byte)(n3 & 0xFF);
            return;
        }
        SWT.error(38);
    }

    public void setPixels(int n, int n2, int n3, byte[] byArray, int n4) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        int n5 = n3;
        int n6 = n4;
        int n7 = n;
        int n8 = n2;
        if (this.depth == 1) {
            int n9 = n2 * this.bytesPerLine + (n >> 3);
            while (n5 > 0) {
                int n10 = 1 << 7 - (n7 & 7);
                this.data[n9] = (byArray[n6] & 1) == 1 ? (byte)(this.data[n9] & 0xFF | n10) : (byte)(this.data[n9] & 0xFF & ~n10);
                ++n6;
                --n5;
                if (++n7 >= this.width) {
                    n9 = ++n8 * this.bytesPerLine;
                    n7 = 0;
                    continue;
                }
                if (n10 != 1) continue;
                ++n9;
            }
            return;
        }
        if (this.depth == 2) {
            byte[] byArray2 = new byte[]{-4, -13, -49, 63};
            int n11 = n2 * this.bytesPerLine + (n >> 2);
            int n12 = 3 - n % 4;
            while (n5 > 0) {
                int n13 = byArray[n6] & 3;
                this.data[n11] = (byte)(this.data[n11] & byArray2[n12] | n13 << n12 * 2);
                ++n6;
                --n5;
                if (++n7 >= this.width) {
                    n11 = ++n8 * this.bytesPerLine;
                    n12 = 0;
                    n7 = 0;
                    continue;
                }
                if (n12 == 0) {
                    ++n11;
                    n12 = 3;
                    continue;
                }
                --n12;
            }
            return;
        }
        if (this.depth == 4) {
            int n14 = n2 * this.bytesPerLine + (n >> 1);
            boolean bl = (n & 1) == 0;
            while (n5 > 0) {
                int n15 = byArray[n6] & 0xF;
                this.data[n14] = bl ? (byte)(this.data[n14] & 0xF | n15 << 4) : (byte)(this.data[n14] & 0xF0 | n15);
                ++n6;
                --n5;
                if (++n7 >= this.width) {
                    n14 = ++n8 * this.bytesPerLine;
                    bl = true;
                    n7 = 0;
                    continue;
                }
                if (!bl) {
                    ++n14;
                }
                boolean bl2 = bl = !bl;
            }
            return;
        }
        if (this.depth == 8) {
            int n16 = n2 * this.bytesPerLine + n;
            int n17 = 0;
            while (n17 < n3) {
                this.data[n16] = (byte)(byArray[n6] & 0xFF);
                ++n6;
                if (++n7 >= this.width) {
                    n16 = ++n8 * this.bytesPerLine;
                    n7 = 0;
                } else {
                    ++n16;
                }
                ++n17;
            }
            return;
        }
        SWT.error(38);
    }

    public void setPixels(int n, int n2, int n3, int[] nArray, int n4) {
        if (nArray == null) {
            SWT.error(4);
        }
        if (n3 < 0 || n >= this.width || n2 >= this.height || n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n3 == 0) {
            return;
        }
        int n5 = n3;
        int n6 = n4;
        int n7 = n;
        int n8 = n2;
        if (this.depth == 1) {
            int n9 = n2 * this.bytesPerLine + (n >> 3);
            while (n5 > 0) {
                int n10 = 1 << 7 - (n7 & 7);
                this.data[n9] = (nArray[n6] & 1) == 1 ? (byte)(this.data[n9] & 0xFF | n10) : (byte)(this.data[n9] & 0xFF & ~n10);
                ++n6;
                --n5;
                if (++n7 >= this.width) {
                    n9 = ++n8 * this.bytesPerLine;
                    n7 = 0;
                    continue;
                }
                if (n10 != 1) continue;
                ++n9;
            }
            return;
        }
        if (this.depth == 2) {
            byte[] byArray = new byte[]{-4, -13, -49, 63};
            int n11 = n2 * this.bytesPerLine + (n >> 2);
            int n12 = 3 - n % 4;
            while (n5 > 0) {
                int n13 = nArray[n6] & 3;
                this.data[n11] = (byte)(this.data[n11] & byArray[n12] | n13 << n12 * 2);
                ++n6;
                --n5;
                if (++n7 >= this.width) {
                    n11 = ++n8 * this.bytesPerLine;
                    n12 = 3;
                    n7 = 0;
                    continue;
                }
                if (n12 == 0) {
                    ++n11;
                    n12 = 3;
                    continue;
                }
                --n12;
            }
            return;
        }
        if (this.depth == 4) {
            int n14 = n2 * this.bytesPerLine + (n >> 1);
            boolean bl = (n & 1) == 0;
            while (n5 > 0) {
                int n15 = nArray[n6] & 0xF;
                this.data[n14] = bl ? (byte)(this.data[n14] & 0xF | n15 << 4) : (byte)(this.data[n14] & 0xF0 | n15);
                ++n6;
                --n5;
                if (++n7 >= this.width) {
                    n14 = ++n8 * this.bytesPerLine;
                    bl = true;
                    n7 = 0;
                    continue;
                }
                if (!bl) {
                    ++n14;
                }
                boolean bl2 = bl = !bl;
            }
            return;
        }
        if (this.depth == 8) {
            int n16 = n2 * this.bytesPerLine + n;
            int n17 = 0;
            while (n17 < n3) {
                this.data[n16] = (byte)(nArray[n6] & 0xFF);
                ++n6;
                if (++n7 >= this.width) {
                    n16 = ++n8 * this.bytesPerLine;
                    n7 = 0;
                } else {
                    ++n16;
                }
                ++n17;
            }
            return;
        }
        if (this.depth == 16) {
            int n18 = n2 * this.bytesPerLine + n * 2;
            int n19 = 0;
            while (n19 < n3) {
                int n20 = nArray[n6];
                this.data[n18] = (byte)(n20 & 0xFF);
                this.data[n18 + 1] = (byte)(n20 >> 8 & 0xFF);
                ++n6;
                if (++n7 >= this.width) {
                    n18 = ++n8 * this.bytesPerLine;
                    n7 = 0;
                } else {
                    n18 += 2;
                }
                ++n19;
            }
            return;
        }
        if (this.depth == 24) {
            int n21 = n2 * this.bytesPerLine + n * 3;
            int n22 = 0;
            while (n22 < n3) {
                int n23 = nArray[n6];
                this.data[n21] = (byte)(n23 >> 16 & 0xFF);
                this.data[n21 + 1] = (byte)(n23 >> 8 & 0xFF);
                this.data[n21 + 2] = (byte)(n23 & 0xFF);
                ++n6;
                if (++n7 >= this.width) {
                    n21 = ++n8 * this.bytesPerLine;
                    n7 = 0;
                } else {
                    n21 += 3;
                }
                ++n22;
            }
            return;
        }
        if (this.depth == 32) {
            int n24 = n2 * this.bytesPerLine + n * 4;
            int n25 = 0;
            while (n25 < n3) {
                int n26 = nArray[n6];
                this.data[n24] = (byte)(n26 >> 24 & 0xFF);
                this.data[n24 + 1] = (byte)(n26 >> 16 & 0xFF);
                this.data[n24 + 2] = (byte)(n26 >> 8 & 0xFF);
                this.data[n24 + 3] = (byte)(n26 & 0xFF);
                ++n6;
                if (++n7 >= this.width) {
                    n24 = ++n8 * this.bytesPerLine;
                    n7 = 0;
                } else {
                    n24 += 4;
                }
                ++n25;
            }
            return;
        }
        SWT.error(38);
    }

    static PaletteData bwPalette() {
        return new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
    }

    static int getMSBOffset(int n) {
        int n2 = 31;
        while (n2 >= 0) {
            if ((n >> n2 & 1) != 0) {
                return n2 + 1;
            }
            --n2;
        }
        return 0;
    }

    static int closestMatch(int n, byte by, byte by2, byte by3, int n2, int n3, int n4, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (n > 8) {
            int n5 = 32 - ImageData.getMSBOffset(n2);
            int n6 = 32 - ImageData.getMSBOffset(n3);
            int n7 = 32 - ImageData.getMSBOffset(n4);
            return by << 24 >>> n5 & n2 | by2 << 24 >>> n6 & n3 | by3 << 24 >>> n7 & n4;
        }
        int n8 = Integer.MAX_VALUE;
        int n9 = 0;
        int n10 = byArray.length;
        int n11 = 0;
        while (n11 < n10) {
            int n12 = (byArray[n11] & 0xFF) - (by & 0xFF);
            int n13 = (byArray2[n11] & 0xFF) - (by2 & 0xFF);
            int n14 = (byArray3[n11] & 0xFF) - (by3 & 0xFF);
            int n15 = n12 * n12 + n13 * n13 + n14 * n14;
            if (n15 < n8) {
                n9 = n11;
                if (n15 == 0) break;
                n8 = n15;
            }
            ++n11;
        }
        return n9;
    }

    static final byte[] convertPad(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        if (n4 == n5) {
            return byArray;
        }
        int n6 = (n * n3 + 7) / 8;
        int n7 = (n6 + (n4 - 1)) / n4 * n4;
        int n8 = (n6 + (n5 - 1)) / n5 * n5;
        byte[] byArray2 = new byte[n2 * n8];
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n2) {
            System.arraycopy(byArray, n9, byArray2, n10, n6);
            n9 += n7;
            n10 += n8;
            ++n11;
        }
        return byArray2;
    }

    static void blit(int n, byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, byte[] byArray2, int n13, int n14, int n15, byte[] byArray3, int n16, int n17, int n18, int n19, int n20, int n21, int n22, int n23, int n24, int n25, boolean bl, boolean bl2) {
        int n26;
        int n27;
        int n28;
        int n29;
        int n30;
        int n31;
        if (n21 <= 0 || n22 <= 0 || n12 == 0) {
            return;
        }
        int n32 = n21 - 1;
        int n33 = n32 != 0 ? (int)((((long)n7 << 16) - 1L) / (long)n32) : 0;
        int n34 = n22 - 1;
        int n35 = n34 != 0 ? (int)((((long)n8 << 16) - 1L) / (long)n34) : 0;
        switch (n2) {
            case 8: {
                n31 = 1;
                n30 = 0;
                break;
            }
            case 16: {
                n31 = 2;
                n30 = n4 == 1 ? 1 : 2;
                break;
            }
            case 24: {
                n31 = 3;
                n30 = 3;
                break;
            }
            case 32: {
                n31 = 4;
                n30 = n4 == 1 ? 4 : 5;
                break;
            }
            default: {
                return;
            }
        }
        int n36 = n6 * n3 + n5 * n31;
        switch (n16) {
            case 8: {
                n29 = 1;
                n28 = 0;
                break;
            }
            case 16: {
                n29 = 2;
                n28 = n18 == 1 ? 1 : 2;
                break;
            }
            case 24: {
                n29 = 3;
                n28 = 3;
                break;
            }
            case 32: {
                n29 = 4;
                n28 = n18 == 1 ? 4 : 5;
                break;
            }
            default: {
                return;
            }
        }
        int n37 = (bl2 ? n20 + n34 : n20) * n17 + (bl ? n19 + n32 : n19) * n29;
        int n38 = bl ? -n29 : n29;
        int n39 = n27 = bl2 ? -n17 : n17;
        if ((n & 2) != 0) {
            switch (n12) {
                case -3: 
                case -1: {
                    if (byArray2 == null) {
                        n12 = 65536;
                    }
                    n26 = n15 * n13 + n14;
                    break;
                }
                case -4: {
                    if (byArray2 == null) {
                        n12 = 65536;
                    }
                    n26 = n15 * (n13 <<= 3) + n14;
                    break;
                }
                case -5: {
                    return;
                }
                case -6: {
                    if (byArray2 == null) {
                        n12 = 65536;
                    }
                    n26 = 0;
                    break;
                }
                default: {
                    n12 = (n12 << 16) / 255;
                }
                case -2: {
                    n26 = 0;
                    break;
                }
            }
        } else {
            n12 = 65536;
            n26 = 0;
        }
        int n40 = n37;
        int n41 = n36;
        if (n12 == 65536 && n30 == n28 && n9 == n23 && n10 == n24 && n11 == n25) {
            switch (n31) {
                case 1: {
                    int n42 = n22;
                    int n43 = n35;
                    while (n42 > 0) {
                        int n44 = n21;
                        int n45 = n33;
                        while (n44 > 0) {
                            byArray3[n40] = byArray[n41];
                            n41 += n45 >>> 16;
                            --n44;
                            n40 += n38;
                            n45 = (n45 & 0xFFFF) + n33;
                        }
                        --n42;
                        n41 = n36 += (n43 >>> 16) * n3;
                        n43 = (n43 & 0xFFFF) + n35;
                        n40 = n37 += n27;
                    }
                    break;
                }
                case 2: {
                    int n46 = n22;
                    int n47 = n35;
                    while (n46 > 0) {
                        int n48 = n21;
                        int n49 = n33;
                        while (n48 > 0) {
                            byArray3[n40] = byArray[n41];
                            byArray3[n40 + 1] = byArray[n41 + 1];
                            n41 += (n49 >>> 16) * 2;
                            --n48;
                            n40 += n38;
                            n49 = (n49 & 0xFFFF) + n33;
                        }
                        --n46;
                        n41 = n36 += (n47 >>> 16) * n3;
                        n47 = (n47 & 0xFFFF) + n35;
                        n40 = n37 += n27;
                    }
                    break;
                }
                case 3: {
                    int n50 = n22;
                    int n51 = n35;
                    while (n50 > 0) {
                        int n52 = n21;
                        int n53 = n33;
                        while (n52 > 0) {
                            byArray3[n40] = byArray[n41];
                            byArray3[n40 + 1] = byArray[n41 + 1];
                            byArray3[n40 + 2] = byArray[n41 + 2];
                            n41 += (n53 >>> 16) * 3;
                            --n52;
                            n40 += n38;
                            n53 = (n53 & 0xFFFF) + n33;
                        }
                        --n50;
                        n41 = n36 += (n51 >>> 16) * n3;
                        n51 = (n51 & 0xFFFF) + n35;
                        n40 = n37 += n27;
                    }
                    break;
                }
                case 4: {
                    int n54 = n22;
                    int n55 = n35;
                    while (n54 > 0) {
                        int n56 = n21;
                        int n57 = n33;
                        while (n56 > 0) {
                            byArray3[n40] = byArray[n41];
                            byArray3[n40 + 1] = byArray[n41 + 1];
                            byArray3[n40 + 2] = byArray[n41 + 2];
                            byArray3[n40 + 3] = byArray[n41 + 3];
                            n41 += (n57 >>> 16) * 4;
                            --n56;
                            n40 += n38;
                            n57 = (n57 & 0xFFFF) + n33;
                        }
                        --n54;
                        n41 = n36 += (n55 >>> 16) * n3;
                        n55 = (n55 & 0xFFFF) + n35;
                        n40 = n37 += n27;
                    }
                    break;
                }
            }
            return;
        }
        int n58 = ImageData.getChannelShift(n9);
        byte[] byArray4 = ANY_TO_EIGHT[ImageData.getChannelWidth(n9, n58)];
        int n59 = ImageData.getChannelShift(n10);
        byte[] byArray5 = ANY_TO_EIGHT[ImageData.getChannelWidth(n10, n59)];
        int n60 = ImageData.getChannelShift(n11);
        byte[] byArray6 = ANY_TO_EIGHT[ImageData.getChannelWidth(n11, n60)];
        int n61 = ImageData.getChannelShift(0);
        byte[] byArray7 = ANY_TO_EIGHT[ImageData.getChannelWidth(0, n61)];
        int n62 = ImageData.getChannelShift(n23);
        int n63 = ImageData.getChannelWidth(n23, n62);
        byte[] byArray8 = ANY_TO_EIGHT[n63];
        int n64 = 8 - n63;
        int n65 = ImageData.getChannelShift(n24);
        int n66 = ImageData.getChannelWidth(n24, n65);
        byte[] byArray9 = ANY_TO_EIGHT[n66];
        int n67 = 8 - n66;
        int n68 = ImageData.getChannelShift(n25);
        int n69 = ImageData.getChannelWidth(n25, n68);
        byte[] byArray10 = ANY_TO_EIGHT[n69];
        int n70 = 8 - n69;
        int n71 = ImageData.getChannelShift(0);
        int n72 = ImageData.getChannelWidth(0, n71);
        byte[] byArray11 = ANY_TO_EIGHT[n72];
        int n73 = 8 - n72;
        int n74 = n26;
        int n75 = n12;
        int n76 = 0;
        int n77 = 0;
        int n78 = 0;
        int n79 = 0;
        int n80 = 0;
        int n81 = 0;
        int n82 = 0;
        int n83 = 0;
        int n84 = n22;
        int n85 = n35;
        while (n84 > 0) {
            int n86 = n21;
            int n87 = n33;
            while (n86 > 0) {
                block79: {
                    int n88;
                    block78: {
                        switch (n30) {
                            case 0: {
                                n88 = byArray[n41] & 0xFF;
                                n41 += n87 >>> 16;
                                n76 = byArray4[(n88 & n9) >>> n58] & 0xFF;
                                n77 = byArray5[(n88 & n10) >>> n59] & 0xFF;
                                n78 = byArray6[(n88 & n11) >>> n60] & 0xFF;
                                n79 = byArray7[0 >>> n61] & 0xFF;
                                break;
                            }
                            case 1: {
                                n88 = (byArray[n41] & 0xFF) << 8 | byArray[n41 + 1] & 0xFF;
                                n41 += (n87 >>> 16) * 2;
                                n76 = byArray4[(n88 & n9) >>> n58] & 0xFF;
                                n77 = byArray5[(n88 & n10) >>> n59] & 0xFF;
                                n78 = byArray6[(n88 & n11) >>> n60] & 0xFF;
                                n79 = byArray7[0 >>> n61] & 0xFF;
                                break;
                            }
                            case 2: {
                                n88 = (byArray[n41 + 1] & 0xFF) << 8 | byArray[n41] & 0xFF;
                                n41 += (n87 >>> 16) * 2;
                                n76 = byArray4[(n88 & n9) >>> n58] & 0xFF;
                                n77 = byArray5[(n88 & n10) >>> n59] & 0xFF;
                                n78 = byArray6[(n88 & n11) >>> n60] & 0xFF;
                                n79 = byArray7[0 >>> n61] & 0xFF;
                                break;
                            }
                            case 3: {
                                n88 = ((byArray[n41] & 0xFF) << 8 | byArray[n41 + 1] & 0xFF) << 8 | byArray[n41 + 2] & 0xFF;
                                n41 += (n87 >>> 16) * 3;
                                n76 = byArray4[(n88 & n9) >>> n58] & 0xFF;
                                n77 = byArray5[(n88 & n10) >>> n59] & 0xFF;
                                n78 = byArray6[(n88 & n11) >>> n60] & 0xFF;
                                n79 = byArray7[0 >>> n61] & 0xFF;
                                break;
                            }
                            case 4: {
                                n88 = (((byArray[n41] & 0xFF) << 8 | byArray[n41 + 1] & 0xFF) << 8 | byArray[n41 + 2] & 0xFF) << 8 | byArray[n41 + 3] & 0xFF;
                                n41 += (n87 >>> 16) * 4;
                                n76 = byArray4[(n88 & n9) >>> n58] & 0xFF;
                                n77 = byArray5[(n88 & n10) >>> n59] & 0xFF;
                                n78 = byArray6[(n88 & n11) >>> n60] & 0xFF;
                                n79 = byArray7[0 >>> n61] & 0xFF;
                                break;
                            }
                            case 5: {
                                n88 = (((byArray[n41 + 3] & 0xFF) << 8 | byArray[n41 + 2] & 0xFF) << 8 | byArray[n41 + 1] & 0xFF) << 8 | byArray[n41] & 0xFF;
                                n41 += (n87 >>> 16) * 4;
                                n76 = byArray4[(n88 & n9) >>> n58] & 0xFF;
                                n77 = byArray5[(n88 & n10) >>> n59] & 0xFF;
                                n78 = byArray6[(n88 & n11) >>> n60] & 0xFF;
                                n79 = byArray7[0 >>> n61] & 0xFF;
                            }
                        }
                        block33 : switch (n12) {
                            case -1: {
                                n75 = ((byArray2[n74] & 0xFF) << 16) / 255;
                                n74 += n87 >> 16;
                                break;
                            }
                            case -2: {
                                n75 = (n79 << 16) / 255;
                                break;
                            }
                            case -3: {
                                n75 = byArray2[n74] != 0 ? 65536 : 0;
                                n74 += n87 >> 16;
                                break;
                            }
                            case -4: {
                                n75 = byArray2[n74 >> 3] << (n74 & 7) + 9 & 0x10000;
                                n74 += n87 >> 16;
                                break;
                            }
                            case -6: {
                                n75 = 65536;
                                n88 = 0;
                                while (n88 < byArray2.length) {
                                    if (n76 == byArray2[n88] && n77 == byArray2[n88 + 1] && n78 == byArray2[n88 + 2]) {
                                        n75 = 0;
                                        break block33;
                                    }
                                    n88 += 3;
                                }
                                break;
                            }
                        }
                        if (n75 == 65536) break block78;
                        if (n75 == 0) break block79;
                        switch (n28) {
                            case 0: {
                                n88 = byArray3[n40] & 0xFF;
                                n80 = byArray8[(n88 & n23) >>> n62] & 0xFF;
                                n81 = byArray9[(n88 & n24) >>> n65] & 0xFF;
                                n82 = byArray10[(n88 & n25) >>> n68] & 0xFF;
                                n83 = byArray11[0 >>> n71] & 0xFF;
                                break;
                            }
                            case 1: {
                                n88 = (byArray3[n40] & 0xFF) << 8 | byArray3[n40 + 1] & 0xFF;
                                n80 = byArray8[(n88 & n23) >>> n62] & 0xFF;
                                n81 = byArray9[(n88 & n24) >>> n65] & 0xFF;
                                n82 = byArray10[(n88 & n25) >>> n68] & 0xFF;
                                n83 = byArray11[0 >>> n71] & 0xFF;
                                break;
                            }
                            case 2: {
                                n88 = (byArray3[n40 + 1] & 0xFF) << 8 | byArray3[n40] & 0xFF;
                                n80 = byArray8[(n88 & n23) >>> n62] & 0xFF;
                                n81 = byArray9[(n88 & n24) >>> n65] & 0xFF;
                                n82 = byArray10[(n88 & n25) >>> n68] & 0xFF;
                                n83 = byArray11[0 >>> n71] & 0xFF;
                                break;
                            }
                            case 3: {
                                n88 = ((byArray3[n40] & 0xFF) << 8 | byArray3[n40 + 1] & 0xFF) << 8 | byArray3[n40 + 2] & 0xFF;
                                n80 = byArray8[(n88 & n23) >>> n62] & 0xFF;
                                n81 = byArray9[(n88 & n24) >>> n65] & 0xFF;
                                n82 = byArray10[(n88 & n25) >>> n68] & 0xFF;
                                n83 = byArray11[0 >>> n71] & 0xFF;
                                break;
                            }
                            case 4: {
                                n88 = (((byArray3[n40] & 0xFF) << 8 | byArray3[n40 + 1] & 0xFF) << 8 | byArray3[n40 + 2] & 0xFF) << 8 | byArray3[n40 + 3] & 0xFF;
                                n80 = byArray8[(n88 & n23) >>> n62] & 0xFF;
                                n81 = byArray9[(n88 & n24) >>> n65] & 0xFF;
                                n82 = byArray10[(n88 & n25) >>> n68] & 0xFF;
                                n83 = byArray11[0 >>> n71] & 0xFF;
                                break;
                            }
                            case 5: {
                                n88 = (((byArray3[n40 + 3] & 0xFF) << 8 | byArray3[n40 + 2] & 0xFF) << 8 | byArray3[n40 + 1] & 0xFF) << 8 | byArray3[n40] & 0xFF;
                                n80 = byArray8[(n88 & n23) >>> n62] & 0xFF;
                                n81 = byArray9[(n88 & n24) >>> n65] & 0xFF;
                                n82 = byArray10[(n88 & n25) >>> n68] & 0xFF;
                                n83 = byArray11[0 >>> n71] & 0xFF;
                            }
                        }
                        n79 = n83 + ((n79 - n83) * n75 >> 16);
                        n76 = n80 + ((n76 - n80) * n75 >> 16);
                        n77 = n81 + ((n77 - n81) * n75 >> 16);
                        n78 = n82 + ((n78 - n82) * n75 >> 16);
                    }
                    n88 = n76 >>> n64 << n62 | n77 >>> n67 << n65 | n78 >>> n70 << n68 | n79 >>> n73 << n71;
                    switch (n28) {
                        case 0: {
                            byArray3[n40] = (byte)n88;
                            break;
                        }
                        case 1: {
                            byArray3[n40] = (byte)(n88 >>> 8);
                            byArray3[n40 + 1] = (byte)(n88 & 0xFF);
                            break;
                        }
                        case 2: {
                            byArray3[n40] = (byte)(n88 & 0xFF);
                            byArray3[n40 + 1] = (byte)(n88 >>> 8);
                            break;
                        }
                        case 3: {
                            byArray3[n40] = (byte)(n88 >>> 16);
                            byArray3[n40 + 1] = (byte)(n88 >>> 8);
                            byArray3[n40 + 2] = (byte)(n88 & 0xFF);
                            break;
                        }
                        case 4: {
                            byArray3[n40] = (byte)(n88 >>> 24);
                            byArray3[n40 + 1] = (byte)(n88 >>> 16);
                            byArray3[n40 + 2] = (byte)(n88 >>> 8);
                            byArray3[n40 + 3] = (byte)(n88 & 0xFF);
                            break;
                        }
                        case 5: {
                            byArray3[n40] = (byte)(n88 & 0xFF);
                            byArray3[n40 + 1] = (byte)(n88 >>> 8);
                            byArray3[n40 + 2] = (byte)(n88 >>> 16);
                            byArray3[n40 + 3] = (byte)(n88 >>> 24);
                        }
                    }
                }
                --n86;
                n40 += n38;
                n87 = (n87 & 0xFFFF) + n33;
            }
            --n84;
            n41 = n36 += (n85 >>> 16) * n3;
            n74 = n26 += (n85 >>> 16) * n13;
            n85 = (n85 & 0xFFFF) + n35;
            n40 = n37 += n27;
        }
    }

    /*
     * Unable to fully structure code
     */
    static void blit(int var0, byte[] var1_1, int var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, byte[] var9_9, byte[] var10_10, byte[] var11_11, int var12_12, byte[] var13_13, int var14_14, int var15_15, int var16_16, byte[] var17_17, int var18_18, int var19_19, int var20_20, int var21_21, int var22_22, int var23_23, int var24_24, byte[] var25_25, byte[] var26_26, byte[] var27_27, boolean var28_28, boolean var29_29) {
        block135: {
            block137: {
                block136: {
                    if (var23_23 <= 0 || var24_24 <= 0 || var12_12 == 0) {
                        return;
                    }
                    var30_30 = var23_23 - 1;
                    var31_31 = var30_30 != 0 ? (int)((((long)var7_7 << 16) - 1L) / (long)var30_30) : 0;
                    var32_32 = var24_24 - 1;
                    var33_33 = var32_32 != 0 ? (int)((((long)var8_8 << 16) - 1L) / (long)var32_32) : 0;
                    switch (var2_2) {
                        case 8: {
                            var34_34 = 6;
                            break;
                        }
                        case 4: {
                            var3_3 <<= 1;
                            var34_34 = 7;
                            break;
                        }
                        case 2: {
                            var3_3 <<= 2;
                            var34_34 = 8;
                            break;
                        }
                        case 1: {
                            var3_3 <<= 3;
                            var34_34 = var4_4 == 1 ? 9 : 10;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    var35_35 = var6_6 * var3_3 + var5_5;
                    switch (var18_18) {
                        case 8: {
                            var36_36 = 6;
                            break;
                        }
                        case 4: {
                            var19_19 <<= 1;
                            var36_36 = 7;
                            break;
                        }
                        case 2: {
                            var19_19 <<= 2;
                            var36_36 = 8;
                            break;
                        }
                        case 1: {
                            var19_19 <<= 3;
                            var36_36 = var20_20 == 1 ? 9 : 10;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    var37_37 = (var29_29 != false ? var22_22 + var32_32 : var22_22) * var19_19 + (var28_28 != false ? var21_21 + var30_30 : var21_21);
                    var38_38 = var28_28 != false ? -1 : 1;
                    v0 = var39_39 = var29_29 != false ? -var19_19 : var19_19;
                    if ((var0 & 2) != 0) {
                        switch (var12_12) {
                            case -3: 
                            case -1: {
                                if (var13_13 == null) {
                                    var12_12 = 65536;
                                }
                                var40_40 = var16_16 * var14_14 + var15_15;
                                break;
                            }
                            case -4: {
                                if (var13_13 == null) {
                                    var12_12 = 65536;
                                }
                                var40_40 = var16_16 * (var14_14 <<= 3) + var15_15;
                                break;
                            }
                            case -6: 
                            case -5: {
                                if (var13_13 == null) {
                                    var12_12 = 65536;
                                }
                                var40_40 = 0;
                                break;
                            }
                            default: {
                                var12_12 = (var12_12 << 16) / 255;
                            }
                            case -2: {
                                var40_40 = 0;
                                break;
                            }
                        }
                    } else {
                        var12_12 = 65536;
                        var40_40 = 0;
                    }
                    var41_41 = (var0 & 4) != 0;
                    var42_42 = var37_37;
                    var43_43 = var35_35;
                    var44_44 = var40_40;
                    var45_45 = 1 << var18_18;
                    if (var25_25 != null && var25_25.length < var45_45) {
                        var45_45 = var25_25.length;
                    }
                    var46_46 = null;
                    var47_47 = true;
                    switch (var12_12) {
                        case 65536: {
                            if (var34_34 == var36_36 && var9_9 == var25_25 && var10_10 == var26_26 && var11_11 == var27_27) {
                                var46_46 = ImageData.ONE_TO_ONE_MAPPING;
                                break;
                            }
                            if (var9_9 == null || var25_25 == null) {
                                if (var2_2 <= var18_18) {
                                    var46_46 = ImageData.ONE_TO_ONE_MAPPING;
                                    break;
                                }
                                var46_46 = new byte[1 << var2_2];
                                var48_48 = 255 << var18_18 >>> 8;
                                var49_49 = 0;
                                while (var49_49 < var46_46.length) {
                                    var46_46[var49_49] = (byte)(var49_49 & var48_48);
                                    ++var49_49;
                                }
                                break;
                            }
                        }
                        case -6: 
                        case -5: 
                        case -4: 
                        case -3: {
                            var48_48 = 1 << var2_2;
                            var46_46 = new byte[var48_48];
                            if (var9_9 != null && var9_9.length < var48_48) {
                                var48_48 = var9_9.length;
                            }
                            var49_49 = 0;
                            while (var49_49 < var48_48) {
                                var50_50 = var9_9[var49_49] & 255;
                                var51_51 = var10_10[var49_49] & 255;
                                var52_52 = var11_11[var49_49] & 255;
                                var53_53 = 0;
                                var54_54 = 0x7FFFFFFF;
                                var55_55 = 0;
                                while (var55_55 < var45_45) {
                                    var56_57 = (var25_25[var55_55] & 255) - var50_50;
                                    var57_59 = (var26_26[var55_55] & 255) - var51_51;
                                    var58_61 = (var27_27[var55_55] & 255) - var52_52;
                                    var59_62 = var56_57 * var56_57 + var57_59 * var57_59 + var58_61 * var58_61;
                                    if (var59_62 < var54_54) {
                                        var53_53 = var55_55;
                                        if (var59_62 == 0) break;
                                        var54_54 = var59_62;
                                    }
                                    ++var55_55;
                                }
                                var46_46[var49_49] = (byte)var53_53;
                                if (var54_54 != 0) {
                                    var47_47 = false;
                                }
                                ++var49_49;
                            }
                            break;
                        }
                    }
                    if (var46_46 == null || !var47_47 && var41_41) break block135;
                    if (var34_34 != var36_36 || var12_12 != 65536) break block136;
                    switch (var34_34) {
                        case 6: {
                            var48_48 = var24_24;
                            var49_49 = var33_33;
                            while (var48_48 > 0) {
                                var50_50 = var23_23;
                                var51_51 = var31_31;
                                while (var50_50 > 0) {
                                    var17_17[var42_42] = var46_46[var1_1[var43_43] & 255];
                                    var43_43 += var51_51 >>> 16;
                                    --var50_50;
                                    var42_42 += var38_38;
                                    var51_51 = (var51_51 & 65535) + var31_31;
                                }
                                --var48_48;
                                var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                                var49_49 = (var49_49 & 65535) + var33_33;
                                var42_42 = var37_37 += var39_39;
                            }
                            break block137;
                        }
                        case 7: {
                            var48_48 = var24_24;
                            var49_49 = var33_33;
                            while (var48_48 > 0) {
                                var50_50 = var23_23;
                                var51_51 = var31_31;
                                while (var50_50 > 0) {
                                    var52_52 = (var43_43 & 1) != 0 ? var46_46[var1_1[var43_43 >> 1] & 15] : var1_1[var43_43 >> 1] >>> 4 & 15;
                                    var43_43 += var51_51 >>> 16;
                                    var17_17[var42_42 >> 1] = (var42_42 & 1) != 0 ? (byte)(var17_17[var42_42 >> 1] & 240 | var52_52) : (byte)(var17_17[var42_42 >> 1] & 15 | var52_52 << 4);
                                    --var50_50;
                                    var42_42 += var38_38;
                                    var51_51 = (var51_51 & 65535) + var31_31;
                                }
                                --var48_48;
                                var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                                var49_49 = (var49_49 & 65535) + var33_33;
                                var42_42 = var37_37 += var39_39;
                            }
                            break block137;
                        }
                        case 8: {
                            var48_48 = var24_24;
                            var49_49 = var33_33;
                            while (var48_48 > 0) {
                                var50_50 = var23_23;
                                var51_51 = var31_31;
                                while (var50_50 > 0) {
                                    var52_52 = var46_46[var1_1[var43_43 >> 2] >>> 6 - (var43_43 & 3) * 2 & 3];
                                    var43_43 += var51_51 >>> 16;
                                    var53_53 = 6 - (var42_42 & 3) * 2;
                                    var17_17[var42_42 >> 2] = (byte)(var17_17[var42_42 >> 2] & ~(3 << var53_53) | var52_52 << var53_53);
                                    --var50_50;
                                    var42_42 += var38_38;
                                    var51_51 = (var51_51 & 65535) + var31_31;
                                }
                                --var48_48;
                                var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                                var49_49 = (var49_49 & 65535) + var33_33;
                                var42_42 = var37_37 += var39_39;
                            }
                            break block137;
                        }
                        case 9: {
                            var48_48 = var24_24;
                            var49_49 = var33_33;
                            while (var48_48 > 0) {
                                var50_50 = var23_23;
                                var51_51 = var31_31;
                                while (var50_50 > 0) {
                                    var52_52 = var46_46[var1_1[var43_43 >> 3] >>> 7 - (var43_43 & 7) & 1];
                                    var43_43 += var51_51 >>> 16;
                                    var53_53 = 7 - (var42_42 & 7);
                                    var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var53_53) | var52_52 << var53_53);
                                    --var50_50;
                                    var42_42 += var38_38;
                                    var51_51 = (var51_51 & 65535) + var31_31;
                                }
                                --var48_48;
                                var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                                var49_49 = (var49_49 & 65535) + var33_33;
                                var42_42 = var37_37 += var39_39;
                            }
                            break block137;
                        }
                        case 10: {
                            var48_48 = var24_24;
                            var49_49 = var33_33;
                            while (var48_48 > 0) {
                                var50_50 = var23_23;
                                var51_51 = var31_31;
                                while (var50_50 > 0) {
                                    var52_52 = var46_46[var1_1[var43_43 >> 3] >>> (var43_43 & 7) & 1];
                                    var43_43 += var51_51 >>> 16;
                                    var53_53 = var42_42 & 7;
                                    var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var53_53) | var52_52 << var53_53);
                                    --var50_50;
                                    var42_42 += var38_38;
                                    var51_51 = (var51_51 & 65535) + var31_31;
                                }
                                --var48_48;
                                var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                                var49_49 = (var49_49 & 65535) + var33_33;
                                var42_42 = var37_37 += var39_39;
                            }
                            break block22;
                        }
                    }
                    break block137;
                }
                var48_48 = var24_24;
                var49_49 = var33_33;
                while (var48_48 > 0) {
                    var50_50 = var23_23;
                    var51_51 = var31_31;
                    while (var50_50 > 0) {
                        switch (var34_34) {
                            case 6: {
                                var52_52 = var1_1[var43_43] & 255;
                                var43_43 += var51_51 >>> 16;
                                break;
                            }
                            case 7: {
                                var52_52 = (var43_43 & 1) != 0 ? var1_1[var43_43 >> 1] & 15 : var1_1[var43_43 >> 1] >>> 4 & 15;
                                var43_43 += var51_51 >>> 16;
                                break;
                            }
                            case 8: {
                                var52_52 = var1_1[var43_43 >> 2] >>> 6 - (var43_43 & 3) * 2 & 3;
                                var43_43 += var51_51 >>> 16;
                                break;
                            }
                            case 9: {
                                var52_52 = var1_1[var43_43 >> 3] >>> 7 - (var43_43 & 7) & 1;
                                var43_43 += var51_51 >>> 16;
                                break;
                            }
                            case 10: {
                                var52_52 = var1_1[var43_43 >> 3] >>> (var43_43 & 7) & 1;
                                var43_43 += var51_51 >>> 16;
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        block36 : switch (var12_12) {
                            case -3: {
                                var53_53 = var13_13[var44_44];
                                var44_44 += var51_51 >> 16;
                                if (var53_53 == 0) {
                                    break;
                                }
                                ** GOTO lbl294
                            }
                            case -4: {
                                var53_53 = var13_13[var44_44 >> 3] & 1 << (var44_44 & 7);
                                var44_44 += var51_51 >> 16;
                                if (var53_53 == 0) {
                                    break;
                                }
                                ** GOTO lbl294
                            }
                            case -5: {
                                var53_53 = 0;
                                while (var53_53 < var13_13.length) {
                                    if (var52_52 == (var13_13[var53_53] & 255)) break;
                                }
                                if (var53_53 < var13_13.length) {
                                    break;
                                }
                                ** GOTO lbl294
                            }
                            case -6: {
                                var53_53 = var9_9[var52_52];
                                var54_54 = var10_10[var52_52];
                                var55_55 = var11_11[var52_52];
                                var56_57 = 0;
                                while (var56_57 < var13_13.length) {
                                    if (var53_53 == var13_13[var56_57] && var54_54 == var13_13[var56_57 + 1] && var55_55 == var13_13[var56_57 + 2]) break;
                                    var56_57 += 3;
                                }
                                if (var56_57 < var13_13.length) break;
                            }
lbl294:
                            // 5 sources

                            default: {
                                var52_52 = var46_46[var52_52] & 255;
                                switch (var36_36) {
                                    case 6: {
                                        var17_17[var42_42] = (byte)var52_52;
                                        break block36;
                                    }
                                    case 7: {
                                        if ((var42_42 & 1) != 0) {
                                            var17_17[var42_42 >> 1] = (byte)(var17_17[var42_42 >> 1] & 240 | var52_52);
                                            break block36;
                                        }
                                        var17_17[var42_42 >> 1] = (byte)(var17_17[var42_42 >> 1] & 15 | var52_52 << 4);
                                        break block36;
                                    }
                                    case 8: {
                                        var53_53 = 6 - (var42_42 & 3) * 2;
                                        var17_17[var42_42 >> 2] = (byte)(var17_17[var42_42 >> 2] & ~(3 << var53_53) | var52_52 << var53_53);
                                        break block36;
                                    }
                                    case 9: {
                                        var53_53 = 7 - (var42_42 & 7);
                                        var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var53_53) | var52_52 << var53_53);
                                        break block36;
                                    }
                                    case 10: {
                                        var53_53 = var42_42 & 7;
                                        var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var53_53) | var52_52 << var53_53);
                                    }
                                }
                            }
                        }
                        --var50_50;
                        var42_42 += var38_38;
                        var51_51 = (var51_51 & 65535) + var31_31;
                    }
                    --var48_48;
                    var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                    var49_49 = (var49_49 & 65535) + var33_33;
                    var42_42 = var37_37 += var39_39;
                }
            }
            return;
        }
        var48_48 = var12_12;
        var49_49 = 0;
        var50_50 = 0;
        var51_51 = 0;
        var52_52 = -1;
        var53_53 = -1;
        var54_54 = -1;
        if (var41_41) {
            var55_56 = new int[var23_23 + 2];
            var56_58 = new int[var23_23 + 2];
            var57_60 = new int[var23_23 + 2];
        } else {
            var55_56 = null;
            var56_58 = null;
            var57_60 = null;
        }
        var58_61 = var24_24;
        var59_62 = var33_33;
        while (var58_61 > 0) {
            var60_63 = 0;
            var61_64 = 0;
            var62_65 = 0;
            var63_66 = var23_23;
            var64_67 = var31_31;
            while (var63_66 > 0) {
                switch (var34_34) {
                    case 6: {
                        var49_49 = var1_1[var43_43] & 255;
                        var43_43 += var64_67 >>> 16;
                        break;
                    }
                    case 7: {
                        var49_49 = (var43_43 & 1) != 0 ? var1_1[var43_43 >> 1] & 15 : var1_1[var43_43 >> 1] >>> 4 & 15;
                        var43_43 += var64_67 >>> 16;
                        break;
                    }
                    case 8: {
                        var49_49 = var1_1[var43_43 >> 2] >>> 6 - (var43_43 & 3) * 2 & 3;
                        var43_43 += var64_67 >>> 16;
                        break;
                    }
                    case 9: {
                        var49_49 = var1_1[var43_43 >> 3] >>> 7 - (var43_43 & 7) & 1;
                        var43_43 += var64_67 >>> 16;
                        break;
                    }
                    case 10: {
                        var49_49 = var1_1[var43_43 >> 3] >>> (var43_43 & 7) & 1;
                        var43_43 += var64_67 >>> 16;
                    }
                }
                var65_68 = var9_9[var49_49] & 255;
                var66_69 = var10_10[var49_49] & 255;
                var67_70 = var11_11[var49_49] & 255;
                block56 : switch (var12_12) {
                    case -1: {
                        var48_48 = ((var13_13[var44_44] & 255) << 16) / 255;
                        var44_44 += var64_67 >> 16;
                        ** GOTO lbl404
                    }
                    case -3: {
                        var48_48 = var13_13[var44_44] != 0 ? 65536 : 0;
                        var44_44 += var64_67 >> 16;
                        ** GOTO lbl404
                    }
                    case -4: {
                        var48_48 = var13_13[var44_44 >> 3] << (var44_44 & 7) + 9 & 65536;
                        var44_44 += var64_67 >> 16;
                        ** GOTO lbl404
                    }
                    case -5: {
                        var68_71 = 0;
                        while (var68_71 < var13_13.length) {
                            if (var49_49 == (var13_13[var68_71] & 255)) break;
                        }
                        if (var68_71 < var13_13.length) {
                            break;
                        }
                        ** GOTO lbl404
                    }
                    case -6: {
                        var68_71 = 0;
                        while (var68_71 < var13_13.length) {
                            if (var65_68 == (var13_13[var68_71] & 255) && var66_69 == (var13_13[var68_71 + 1] & 255) && var67_70 == (var13_13[var68_71 + 2] & 255)) break;
                            var68_71 += 3;
                        }
                        if (var68_71 < var13_13.length) break;
                    }
lbl404:
                    // 6 sources

                    default: {
                        if (var48_48 != 65536) {
                            if (var48_48 == 0) break;
                            switch (var36_36) {
                                case 6: {
                                    var50_50 = var17_17[var42_42] & 255;
                                    break;
                                }
                                case 7: {
                                    if ((var42_42 & 1) != 0) {
                                        var50_50 = var17_17[var42_42 >> 1] & 15;
                                        break;
                                    }
                                    var50_50 = var17_17[var42_42 >> 1] >>> 4 & 15;
                                    break;
                                }
                                case 8: {
                                    var50_50 = var17_17[var42_42 >> 2] >>> 6 - (var42_42 & 3) * 2 & 3;
                                    break;
                                }
                                case 9: {
                                    var50_50 = var17_17[var42_42 >> 3] >>> 7 - (var42_42 & 7) & 1;
                                    break;
                                }
                                case 10: {
                                    var50_50 = var17_17[var42_42 >> 3] >>> (var42_42 & 7) & 1;
                                }
                            }
                            var68_71 = var25_25[var50_50] & 255;
                            var69_72 = var26_26[var50_50] & 255;
                            var70_73 = var27_27[var50_50] & 255;
                            var65_68 = var68_71 + ((var65_68 - var68_71) * var48_48 >> 16);
                            var66_69 = var69_72 + ((var66_69 - var69_72) * var48_48 >> 16);
                            var67_70 = var70_73 + ((var67_70 - var70_73) * var48_48 >> 16);
                        }
                        if (var41_41) {
                            if ((var65_68 += var55_56[var63_66] >> 4) < 0) {
                                var65_68 = 0;
                            } else if (var65_68 > 255) {
                                var65_68 = 255;
                            }
                            if ((var66_69 += var56_58[var63_66] >> 4) < 0) {
                                var66_69 = 0;
                            } else if (var66_69 > 255) {
                                var66_69 = 255;
                            }
                            if ((var67_70 += var57_60[var63_66] >> 4) < 0) {
                                var67_70 = 0;
                            } else if (var67_70 > 255) {
                                var67_70 = 255;
                            }
                            var55_56[var63_66] = var60_63;
                            var56_58[var63_66] = var61_64;
                            var57_60[var63_66] = var62_65;
                        }
                        if (var65_68 != var52_52 || var66_69 != var53_53 || var67_70 != var54_54) {
                            var68_71 = 0;
                            var73_76 = 0x7FFFFFFF;
                            while (var68_71 < var45_45) {
                                var69_72 = (var25_25[var68_71] & 255) - var65_68;
                                var70_73 = (var26_26[var68_71] & 255) - var66_69;
                                var71_74 = (var27_27[var68_71] & 255) - var67_70;
                                var72_75 = var69_72 * var69_72 + var70_73 * var70_73 + var71_74 * var71_74;
                                if (var72_75 < var73_76) {
                                    var51_51 = var68_71;
                                    if (var72_75 == 0) break;
                                    var73_76 = var72_75;
                                }
                                ++var68_71;
                            }
                            var52_52 = var65_68;
                            var53_53 = var66_69;
                            var54_54 = var67_70;
                        }
                        if (var41_41) {
                            var68_71 = var63_66 - 1;
                            v1 = var69_72 = var63_66 + 1;
                            var60_63 = var65_68 - (var25_25[var51_51] & 255);
                            var70_73 = var60_63 + var60_63 + var60_63;
                            var55_56[v1] = var55_56[v1] + var70_73;
                            v2 = var63_66;
                            var55_56[v2] = var55_56[v2] + (var70_73 += var60_63 + var60_63);
                            v3 = var68_71;
                            var55_56[v3] = var55_56[v3] + (var70_73 + var60_63 + var60_63);
                            v4 = var69_72;
                            var61_64 = var66_69 - (var26_26[var51_51] & 255);
                            var70_73 = var61_64 + var61_64 + var61_64;
                            var56_58[v4] = var56_58[v4] + var70_73;
                            v5 = var63_66;
                            var56_58[v5] = var56_58[v5] + (var70_73 += var61_64 + var61_64);
                            v6 = var68_71;
                            var56_58[v6] = var56_58[v6] + (var70_73 + var61_64 + var61_64);
                            v7 = var69_72;
                            var62_65 = var67_70 - (var27_27[var51_51] & 255);
                            var70_73 = var62_65 + var62_65 + var62_65;
                            var57_60[v7] = var57_60[v7] + var70_73;
                            v8 = var63_66;
                            var57_60[v8] = var57_60[v8] + (var70_73 += var62_65 + var62_65);
                            v9 = var68_71;
                            var57_60[v9] = var57_60[v9] + (var70_73 + var62_65 + var62_65);
                        }
                        switch (var36_36) {
                            case 6: {
                                var17_17[var42_42] = (byte)var51_51;
                                break block56;
                            }
                            case 7: {
                                if ((var42_42 & 1) != 0) {
                                    var17_17[var42_42 >> 1] = (byte)(var17_17[var42_42 >> 1] & 240 | var51_51);
                                    break block56;
                                }
                                var17_17[var42_42 >> 1] = (byte)(var17_17[var42_42 >> 1] & 15 | var51_51 << 4);
                                break block56;
                            }
                            case 8: {
                                var68_71 = 6 - (var42_42 & 3) * 2;
                                var17_17[var42_42 >> 2] = (byte)(var17_17[var42_42 >> 2] & ~(3 << var68_71) | var51_51 << var68_71);
                                break block56;
                            }
                            case 9: {
                                var68_71 = 7 - (var42_42 & 7);
                                var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var68_71) | var51_51 << var68_71);
                                break block56;
                            }
                            case 10: {
                                var68_71 = var42_42 & 7;
                                var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var68_71) | var51_51 << var68_71);
                            }
                        }
                    }
                }
                --var63_66;
                var42_42 += var38_38;
                var64_67 = (var64_67 & 65535) + var31_31;
            }
            --var58_61;
            var43_43 = var35_35 += (var59_62 >>> 16) * var3_3;
            var44_44 = var40_40 += (var59_62 >>> 16) * var14_14;
            var59_62 = (var59_62 & 65535) + var33_33;
            var42_42 = var37_37 += var39_39;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void blit(int n, byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n9, byte[] byArray5, int n10, int n11, int n12, byte[] byArray6, int n13, int n14, int n15, int n16, int n17, int n18, int n19, int n20, int n21, int n22, boolean bl, boolean bl2) {
        int n23;
        int n24;
        int n25;
        int n26;
        int n27;
        if (n18 <= 0 || n19 <= 0 || n9 == 0) {
            return;
        }
        int n28 = n18 - 1;
        int n29 = n28 != 0 ? (int)((((long)n7 << 16) - 1L) / (long)n28) : 0;
        int n30 = n19 - 1;
        int n31 = n30 != 0 ? (int)((((long)n8 << 16) - 1L) / (long)n30) : 0;
        switch (n2) {
            case 8: {
                n27 = 6;
                break;
            }
            case 4: {
                n3 <<= 1;
                n27 = 7;
                break;
            }
            case 2: {
                n3 <<= 2;
                n27 = 8;
                break;
            }
            case 1: {
                n3 <<= 3;
                n27 = n4 == 1 ? 9 : 10;
                break;
            }
            default: {
                return;
            }
        }
        int n32 = n6 * n3 + n5;
        switch (n13) {
            case 8: {
                n26 = 1;
                n25 = 0;
                break;
            }
            case 16: {
                n26 = 2;
                n25 = n15 == 1 ? 1 : 2;
                break;
            }
            case 24: {
                n26 = 3;
                n25 = 3;
                break;
            }
            case 32: {
                n26 = 4;
                n25 = n15 == 1 ? 4 : 5;
                break;
            }
            default: {
                return;
            }
        }
        int n33 = (bl2 ? n17 + n30 : n17) * n14 + (bl ? n16 + n28 : n16) * n26;
        int n34 = bl ? -n26 : n26;
        int n35 = n24 = bl2 ? -n14 : n14;
        if ((n & 2) != 0) {
            switch (n9) {
                case -3: 
                case -1: {
                    if (byArray5 == null) {
                        n9 = 65536;
                    }
                    n23 = n12 * n10 + n11;
                    break;
                }
                case -4: {
                    if (byArray5 == null) {
                        n9 = 65536;
                    }
                    n23 = n12 * (n10 <<= 3) + n11;
                    break;
                }
                case -6: 
                case -5: {
                    if (byArray5 == null) {
                        n9 = 65536;
                    }
                    n23 = 0;
                    break;
                }
                default: {
                    n9 = (n9 << 16) / 255;
                }
                case -2: {
                    n23 = 0;
                    break;
                }
            }
        } else {
            n9 = 65536;
            n23 = 0;
        }
        int n36 = ImageData.getChannelShift(n20);
        int n37 = ImageData.getChannelWidth(n20, n36);
        byte[] byArray7 = ANY_TO_EIGHT[n37];
        int n38 = 8 - n37;
        int n39 = ImageData.getChannelShift(n21);
        int n40 = ImageData.getChannelWidth(n21, n39);
        byte[] byArray8 = ANY_TO_EIGHT[n40];
        int n41 = 8 - n40;
        int n42 = ImageData.getChannelShift(n22);
        int n43 = ImageData.getChannelWidth(n22, n42);
        byte[] byArray9 = ANY_TO_EIGHT[n43];
        int n44 = 8 - n43;
        int n45 = ImageData.getChannelShift(0);
        int n46 = ImageData.getChannelWidth(0, n45);
        byte[] byArray10 = ANY_TO_EIGHT[n46];
        int n47 = 8 - n46;
        int n48 = n33;
        int n49 = n32;
        int n50 = n23;
        int n51 = n9;
        int n52 = 0;
        int n53 = 0;
        int n54 = 0;
        int n55 = 0;
        int n56 = 0;
        int n57 = 0;
        int n58 = 0;
        int n59 = 0;
        int n60 = 0;
        int n61 = n19;
        int n62 = n31;
        while (n61 > 0) {
            int n63 = n18;
            int n64 = n29;
            while (n63 > 0) {
                block61: {
                    int n65;
                    block62: {
                        switch (n27) {
                            case 6: {
                                n56 = byArray[n49] & 0xFF;
                                n49 += n64 >>> 16;
                                break;
                            }
                            case 7: {
                                n56 = (n49 & 1) != 0 ? byArray[n49 >> 1] & 0xF : byArray[n49 >> 1] >>> 4 & 0xF;
                                n49 += n64 >>> 16;
                                break;
                            }
                            case 8: {
                                n56 = byArray[n49 >> 2] >>> 6 - (n49 & 3) * 2 & 3;
                                n49 += n64 >>> 16;
                                break;
                            }
                            case 9: {
                                n56 = byArray[n49 >> 3] >>> 7 - (n49 & 7) & 1;
                                n49 += n64 >>> 16;
                                break;
                            }
                            case 10: {
                                n56 = byArray[n49 >> 3] >>> (n49 & 7) & 1;
                                n49 += n64 >>> 16;
                                break;
                            }
                        }
                        n52 = byArray2[n56] & 0xFF;
                        n53 = byArray3[n56] & 0xFF;
                        n54 = byArray4[n56] & 0xFF;
                        switch (n9) {
                            case -1: {
                                n51 = ((byArray5[n50] & 0xFF) << 16) / 255;
                                n50 += n64 >> 16;
                                break;
                            }
                            case -3: {
                                n51 = byArray5[n50] != 0 ? 65536 : 0;
                                n50 += n64 >> 16;
                                break;
                            }
                            case -4: {
                                n51 = byArray5[n50 >> 3] << (n50 & 7) + 9 & 0x10000;
                                n50 += n64 >> 16;
                                break;
                            }
                            case -5: {
                                n65 = 0;
                                while (n65 < byArray5.length && n56 != (byArray5[n65] & 0xFF)) {
                                }
                                if (n65 >= byArray5.length) break;
                                break block61;
                            }
                            case -6: {
                                n65 = 0;
                                while (n65 < byArray5.length) {
                                    if (n52 == (byArray5[n65] & 0xFF) && n53 == (byArray5[n65 + 1] & 0xFF) && n54 == (byArray5[n65 + 2] & 0xFF)) break;
                                    n65 += 3;
                                }
                                if (n65 < byArray5.length) break block61;
                            }
                        }
                        if (n51 == 65536) break block62;
                        if (n51 == 0) break block61;
                        switch (n25) {
                            case 0: {
                                n65 = byArray6[n48] & 0xFF;
                                n57 = byArray7[(n65 & n20) >>> n36] & 0xFF;
                                n58 = byArray8[(n65 & n21) >>> n39] & 0xFF;
                                n59 = byArray9[(n65 & n22) >>> n42] & 0xFF;
                                n60 = byArray10[0 >>> n45] & 0xFF;
                                break;
                            }
                            case 1: {
                                n65 = (byArray6[n48] & 0xFF) << 8 | byArray6[n48 + 1] & 0xFF;
                                n57 = byArray7[(n65 & n20) >>> n36] & 0xFF;
                                n58 = byArray8[(n65 & n21) >>> n39] & 0xFF;
                                n59 = byArray9[(n65 & n22) >>> n42] & 0xFF;
                                n60 = byArray10[0 >>> n45] & 0xFF;
                                break;
                            }
                            case 2: {
                                n65 = (byArray6[n48 + 1] & 0xFF) << 8 | byArray6[n48] & 0xFF;
                                n57 = byArray7[(n65 & n20) >>> n36] & 0xFF;
                                n58 = byArray8[(n65 & n21) >>> n39] & 0xFF;
                                n59 = byArray9[(n65 & n22) >>> n42] & 0xFF;
                                n60 = byArray10[0 >>> n45] & 0xFF;
                                break;
                            }
                            case 3: {
                                n65 = ((byArray6[n48] & 0xFF) << 8 | byArray6[n48 + 1] & 0xFF) << 8 | byArray6[n48 + 2] & 0xFF;
                                n57 = byArray7[(n65 & n20) >>> n36] & 0xFF;
                                n58 = byArray8[(n65 & n21) >>> n39] & 0xFF;
                                n59 = byArray9[(n65 & n22) >>> n42] & 0xFF;
                                n60 = byArray10[0 >>> n45] & 0xFF;
                                break;
                            }
                            case 4: {
                                n65 = (((byArray6[n48] & 0xFF) << 8 | byArray6[n48 + 1] & 0xFF) << 8 | byArray6[n48 + 2] & 0xFF) << 8 | byArray6[n48 + 3] & 0xFF;
                                n57 = byArray7[(n65 & n20) >>> n36] & 0xFF;
                                n58 = byArray8[(n65 & n21) >>> n39] & 0xFF;
                                n59 = byArray9[(n65 & n22) >>> n42] & 0xFF;
                                n60 = byArray10[0 >>> n45] & 0xFF;
                                break;
                            }
                            case 5: {
                                n65 = (((byArray6[n48 + 3] & 0xFF) << 8 | byArray6[n48 + 2] & 0xFF) << 8 | byArray6[n48 + 1] & 0xFF) << 8 | byArray6[n48] & 0xFF;
                                n57 = byArray7[(n65 & n20) >>> n36] & 0xFF;
                                n58 = byArray8[(n65 & n21) >>> n39] & 0xFF;
                                n59 = byArray9[(n65 & n22) >>> n42] & 0xFF;
                                n60 = byArray10[0 >>> n45] & 0xFF;
                                break;
                            }
                        }
                        n55 = n60 + ((n55 - n60) * n51 >> 16);
                        n52 = n57 + ((n52 - n57) * n51 >> 16);
                        n53 = n58 + ((n53 - n58) * n51 >> 16);
                        n54 = n59 + ((n54 - n59) * n51 >> 16);
                    }
                    n65 = n52 >>> n38 << n36 | n53 >>> n41 << n39 | n54 >>> n44 << n42 | n55 >>> n47 << n45;
                    switch (n25) {
                        case 0: {
                            byArray6[n48] = (byte)n65;
                            break;
                        }
                        case 1: {
                            byArray6[n48] = (byte)(n65 >>> 8);
                            byArray6[n48 + 1] = (byte)(n65 & 0xFF);
                            break;
                        }
                        case 2: {
                            byArray6[n48] = (byte)(n65 & 0xFF);
                            byArray6[n48 + 1] = (byte)(n65 >>> 8);
                            break;
                        }
                        case 3: {
                            byArray6[n48] = (byte)(n65 >>> 16);
                            byArray6[n48 + 1] = (byte)(n65 >>> 8);
                            byArray6[n48 + 2] = (byte)(n65 & 0xFF);
                            break;
                        }
                        case 4: {
                            byArray6[n48] = (byte)(n65 >>> 24);
                            byArray6[n48 + 1] = (byte)(n65 >>> 16);
                            byArray6[n48 + 2] = (byte)(n65 >>> 8);
                            byArray6[n48 + 3] = (byte)(n65 & 0xFF);
                            break;
                        }
                        case 5: {
                            byArray6[n48] = (byte)(n65 & 0xFF);
                            byArray6[n48 + 1] = (byte)(n65 >>> 8);
                            byArray6[n48 + 2] = (byte)(n65 >>> 16);
                            byArray6[n48 + 3] = (byte)(n65 >>> 24);
                            break;
                        }
                    }
                }
                --n63;
                n48 += n34;
                n64 = (n64 & 0xFFFF) + n29;
            }
            --n61;
            n49 = n32 += (n62 >>> 16) * n3;
            n50 = n23 += (n62 >>> 16) * n10;
            n62 = (n62 & 0xFFFF) + n31;
            n48 = n33 += n24;
        }
    }

    static void blit(int n, byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, byte[] byArray2, int n13, int n14, int n15, byte[] byArray3, int n16, int n17, int n18, int n19, int n20, int n21, int n22, byte[] byArray4, byte[] byArray5, byte[] byArray6, boolean bl, boolean bl2) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int n23;
        int n24;
        int n25;
        int n26;
        int n27;
        if (n21 <= 0 || n22 <= 0 || n12 == 0) {
            return;
        }
        int n28 = n21 - 1;
        int n29 = n28 != 0 ? (int)((((long)n7 << 16) - 1L) / (long)n28) : 0;
        int n30 = n22 - 1;
        int n31 = n30 != 0 ? (int)((((long)n8 << 16) - 1L) / (long)n30) : 0;
        switch (n2) {
            case 8: {
                n27 = 1;
                n26 = 0;
                break;
            }
            case 16: {
                n27 = 2;
                n26 = n4 == 1 ? 1 : 2;
                break;
            }
            case 24: {
                n27 = 3;
                n26 = 3;
                break;
            }
            case 32: {
                n27 = 4;
                n26 = n4 == 1 ? 4 : 5;
                break;
            }
            default: {
                return;
            }
        }
        int n32 = n6 * n3 + n5 * n27;
        switch (n16) {
            case 8: {
                n25 = 6;
                break;
            }
            case 4: {
                n17 <<= 1;
                n25 = 7;
                break;
            }
            case 2: {
                n17 <<= 2;
                n25 = 8;
                break;
            }
            case 1: {
                n17 <<= 3;
                n25 = n18 == 1 ? 9 : 10;
                break;
            }
            default: {
                return;
            }
        }
        int n33 = (bl2 ? n20 + n30 : n20) * n17 + (bl ? n19 + n28 : n19);
        int n34 = bl ? -1 : 1;
        int n35 = n24 = bl2 ? -n17 : n17;
        if ((n & 2) != 0) {
            switch (n12) {
                case -3: 
                case -1: {
                    if (byArray2 == null) {
                        n12 = 65536;
                    }
                    n23 = n15 * n13 + n14;
                    break;
                }
                case -4: {
                    if (byArray2 == null) {
                        n12 = 65536;
                    }
                    n23 = n15 * (n13 <<= 3) + n14;
                    break;
                }
                case -5: {
                    return;
                }
                case -6: {
                    if (byArray2 == null) {
                        n12 = 65536;
                    }
                    n23 = 0;
                    break;
                }
                default: {
                    n12 = (n12 << 16) / 255;
                }
                case -2: {
                    n23 = 0;
                    break;
                }
            }
        } else {
            n12 = 65536;
            n23 = 0;
        }
        boolean bl3 = (n & 4) != 0;
        int n36 = ImageData.getChannelShift(n9);
        byte[] byArray7 = ANY_TO_EIGHT[ImageData.getChannelWidth(n9, n36)];
        int n37 = ImageData.getChannelShift(n10);
        byte[] byArray8 = ANY_TO_EIGHT[ImageData.getChannelWidth(n10, n37)];
        int n38 = ImageData.getChannelShift(n11);
        byte[] byArray9 = ANY_TO_EIGHT[ImageData.getChannelWidth(n11, n38)];
        int n39 = ImageData.getChannelShift(0);
        byte[] byArray10 = ANY_TO_EIGHT[ImageData.getChannelWidth(0, n39)];
        int n40 = n33;
        int n41 = n32;
        int n42 = n23;
        int n43 = n12;
        int n44 = 0;
        int n45 = 0;
        int n46 = 0;
        int n47 = 0;
        int n48 = 0;
        int n49 = 0;
        int n50 = -1;
        int n51 = -1;
        int n52 = -1;
        int n53 = 1 << n16;
        if (byArray4 != null && byArray4.length < n53) {
            n53 = byArray4.length;
        }
        if (bl3) {
            nArray3 = new int[n21 + 2];
            nArray2 = new int[n21 + 2];
            nArray = new int[n21 + 2];
        } else {
            nArray3 = null;
            nArray2 = null;
            nArray = null;
        }
        int n54 = n22;
        int n55 = n31;
        while (n54 > 0) {
            int n56 = 0;
            int n57 = 0;
            int n58 = 0;
            int n59 = n21;
            int n60 = n29;
            while (n59 > 0) {
                block81: {
                    int n61;
                    int n62;
                    int n63;
                    block80: {
                        switch (n26) {
                            case 0: {
                                n63 = byArray[n41] & 0xFF;
                                n41 += n60 >>> 16;
                                n44 = byArray7[(n63 & n9) >>> n36] & 0xFF;
                                n45 = byArray8[(n63 & n10) >>> n37] & 0xFF;
                                n46 = byArray9[(n63 & n11) >>> n38] & 0xFF;
                                n47 = byArray10[0 >>> n39] & 0xFF;
                                break;
                            }
                            case 1: {
                                n63 = (byArray[n41] & 0xFF) << 8 | byArray[n41 + 1] & 0xFF;
                                n41 += (n60 >>> 16) * 2;
                                n44 = byArray7[(n63 & n9) >>> n36] & 0xFF;
                                n45 = byArray8[(n63 & n10) >>> n37] & 0xFF;
                                n46 = byArray9[(n63 & n11) >>> n38] & 0xFF;
                                n47 = byArray10[0 >>> n39] & 0xFF;
                                break;
                            }
                            case 2: {
                                n63 = (byArray[n41 + 1] & 0xFF) << 8 | byArray[n41] & 0xFF;
                                n41 += (n60 >>> 16) * 2;
                                n44 = byArray7[(n63 & n9) >>> n36] & 0xFF;
                                n45 = byArray8[(n63 & n10) >>> n37] & 0xFF;
                                n46 = byArray9[(n63 & n11) >>> n38] & 0xFF;
                                n47 = byArray10[0 >>> n39] & 0xFF;
                                break;
                            }
                            case 3: {
                                n63 = ((byArray[n41] & 0xFF) << 8 | byArray[n41 + 1] & 0xFF) << 8 | byArray[n41 + 2] & 0xFF;
                                n41 += (n60 >>> 16) * 3;
                                n44 = byArray7[(n63 & n9) >>> n36] & 0xFF;
                                n45 = byArray8[(n63 & n10) >>> n37] & 0xFF;
                                n46 = byArray9[(n63 & n11) >>> n38] & 0xFF;
                                n47 = byArray10[0 >>> n39] & 0xFF;
                                break;
                            }
                            case 4: {
                                n63 = (((byArray[n41] & 0xFF) << 8 | byArray[n41 + 1] & 0xFF) << 8 | byArray[n41 + 2] & 0xFF) << 8 | byArray[n41 + 3] & 0xFF;
                                n41 += (n60 >>> 16) * 4;
                                n44 = byArray7[(n63 & n9) >>> n36] & 0xFF;
                                n45 = byArray8[(n63 & n10) >>> n37] & 0xFF;
                                n46 = byArray9[(n63 & n11) >>> n38] & 0xFF;
                                n47 = byArray10[0 >>> n39] & 0xFF;
                                break;
                            }
                            case 5: {
                                n63 = (((byArray[n41 + 3] & 0xFF) << 8 | byArray[n41 + 2] & 0xFF) << 8 | byArray[n41 + 1] & 0xFF) << 8 | byArray[n41] & 0xFF;
                                n41 += (n60 >>> 16) * 4;
                                n44 = byArray7[(n63 & n9) >>> n36] & 0xFF;
                                n45 = byArray8[(n63 & n10) >>> n37] & 0xFF;
                                n46 = byArray9[(n63 & n11) >>> n38] & 0xFF;
                                n47 = byArray10[0 >>> n39] & 0xFF;
                            }
                        }
                        block27 : switch (n12) {
                            case -1: {
                                n43 = ((byArray2[n42] & 0xFF) << 16) / 255;
                                n42 += n60 >> 16;
                                break;
                            }
                            case -2: {
                                n43 = (n47 << 16) / 255;
                                break;
                            }
                            case -3: {
                                n43 = byArray2[n42] != 0 ? 65536 : 0;
                                n42 += n60 >> 16;
                                break;
                            }
                            case -4: {
                                n43 = byArray2[n42 >> 3] << (n42 & 7) + 9 & 0x10000;
                                n42 += n60 >> 16;
                                break;
                            }
                            case -6: {
                                n43 = 65536;
                                n63 = 0;
                                while (n63 < byArray2.length) {
                                    if (n44 == byArray2[n63] && n45 == byArray2[n63 + 1] && n46 == byArray2[n63 + 2]) {
                                        n43 = 0;
                                        break block27;
                                    }
                                    n63 += 3;
                                }
                                break;
                            }
                        }
                        if (n43 == 65536) break block80;
                        if (n43 == 0) break block81;
                        switch (n25) {
                            case 6: {
                                n48 = byArray3[n40] & 0xFF;
                                break;
                            }
                            case 7: {
                                if ((n40 & 1) != 0) {
                                    n48 = byArray3[n40 >> 1] & 0xF;
                                    break;
                                }
                                n48 = byArray3[n40 >> 1] >>> 4 & 0xF;
                                break;
                            }
                            case 8: {
                                n48 = byArray3[n40 >> 2] >>> 6 - (n40 & 3) * 2 & 3;
                                break;
                            }
                            case 9: {
                                n48 = byArray3[n40 >> 3] >>> 7 - (n40 & 7) & 1;
                                break;
                            }
                            case 10: {
                                n48 = byArray3[n40 >> 3] >>> (n40 & 7) & 1;
                            }
                        }
                        n63 = byArray4[n48] & 0xFF;
                        n62 = byArray5[n48] & 0xFF;
                        n61 = byArray6[n48] & 0xFF;
                        n44 = n63 + ((n44 - n63) * n43 >> 16);
                        n45 = n62 + ((n45 - n62) * n43 >> 16);
                        n46 = n61 + ((n46 - n61) * n43 >> 16);
                    }
                    if (bl3) {
                        if ((n44 += nArray3[n59] >> 4) < 0) {
                            n44 = 0;
                        } else if (n44 > 255) {
                            n44 = 255;
                        }
                        if ((n45 += nArray2[n59] >> 4) < 0) {
                            n45 = 0;
                        } else if (n45 > 255) {
                            n45 = 255;
                        }
                        if ((n46 += nArray[n59] >> 4) < 0) {
                            n46 = 0;
                        } else if (n46 > 255) {
                            n46 = 255;
                        }
                        nArray3[n59] = n56;
                        nArray2[n59] = n57;
                        nArray[n59] = n58;
                    }
                    if (n44 != n50 || n45 != n51 || n46 != n52) {
                        n63 = 0;
                        int n64 = Integer.MAX_VALUE;
                        while (n63 < n53) {
                            n62 = (byArray4[n63] & 0xFF) - n44;
                            n61 = (byArray5[n63] & 0xFF) - n45;
                            int n65 = (byArray6[n63] & 0xFF) - n46;
                            int n66 = n62 * n62 + n61 * n61 + n65 * n65;
                            if (n66 < n64) {
                                n49 = n63;
                                if (n66 == 0) break;
                                n64 = n66;
                            }
                            ++n63;
                        }
                        n50 = n44;
                        n51 = n45;
                        n52 = n46;
                    }
                    if (bl3) {
                        n63 = n59 - 1;
                        int n67 = n62 = n59 + 1;
                        n56 = n44 - (byArray4[n49] & 0xFF);
                        n61 = n56 + n56 + n56;
                        nArray3[n67] = nArray3[n67] + n61;
                        int n68 = n59;
                        nArray3[n68] = nArray3[n68] + (n61 += n56 + n56);
                        int n69 = n63;
                        nArray3[n69] = nArray3[n69] + (n61 + n56 + n56);
                        int n70 = n62;
                        n57 = n45 - (byArray5[n49] & 0xFF);
                        n61 = n57 + n57 + n57;
                        nArray2[n70] = nArray2[n70] + n61;
                        int n71 = n59;
                        nArray2[n71] = nArray2[n71] + (n61 += n57 + n57);
                        int n72 = n63;
                        nArray2[n72] = nArray2[n72] + (n61 + n57 + n57);
                        int n73 = n62;
                        n58 = n46 - (byArray6[n49] & 0xFF);
                        n61 = n58 + n58 + n58;
                        nArray[n73] = nArray[n73] + n61;
                        int n74 = n59;
                        nArray[n74] = nArray[n74] + (n61 += n58 + n58);
                        int n75 = n63;
                        nArray[n75] = nArray[n75] + (n61 + n58 + n58);
                    }
                    switch (n25) {
                        case 6: {
                            byArray3[n40] = (byte)n49;
                            break;
                        }
                        case 7: {
                            if ((n40 & 1) != 0) {
                                byArray3[n40 >> 1] = (byte)(byArray3[n40 >> 1] & 0xF0 | n49);
                                break;
                            }
                            byArray3[n40 >> 1] = (byte)(byArray3[n40 >> 1] & 0xF | n49 << 4);
                            break;
                        }
                        case 8: {
                            n63 = 6 - (n40 & 3) * 2;
                            byArray3[n40 >> 2] = (byte)(byArray3[n40 >> 2] & ~(3 << n63) | n49 << n63);
                            break;
                        }
                        case 9: {
                            n63 = 7 - (n40 & 7);
                            byArray3[n40 >> 3] = (byte)(byArray3[n40 >> 3] & ~(1 << n63) | n49 << n63);
                            break;
                        }
                        case 10: {
                            n63 = n40 & 7;
                            byArray3[n40 >> 3] = (byte)(byArray3[n40 >> 3] & ~(1 << n63) | n49 << n63);
                        }
                    }
                }
                --n59;
                n40 += n34;
                n60 = (n60 & 0xFFFF) + n29;
            }
            --n54;
            n41 = n32 += (n55 >>> 16) * n3;
            n42 = n23 += (n55 >>> 16) * n13;
            n55 = (n55 & 0xFFFF) + n31;
            n40 = n33 += n24;
        }
    }

    static int getChannelShift(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        while ((n & 1) == 0 && n2 < 32) {
            n >>>= 1;
            ++n2;
        }
        return n2;
    }

    static int getChannelWidth(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        n >>>= n2;
        int n3 = n2;
        while ((n & 1) != 0 && n3 < 32) {
            n >>>= 1;
            ++n3;
        }
        return n3 - n2;
    }

    static byte getChannelField(int n, int n2) {
        int n3 = ImageData.getChannelShift(n2);
        return ANY_TO_EIGHT[ImageData.getChannelWidth(n2, n3)][(n & n2) >>> n3];
    }

    static ImageData createGradientBand(int n, int n2, boolean bl, RGB rGB, RGB rGB2, int n3, int n4, int n5) {
        byte[] byArray;
        int n6;
        int n7;
        int n8;
        PaletteData paletteData;
        if (n3 != 0 && n4 != 0 && n5 != 0) {
            paletteData = new PaletteData(65280, 0xFF0000, -16777216);
            n8 = 32;
            if (n3 >= 8 && n4 >= 8 && n5 >= 8) {
                int n9;
                if (bl) {
                    n7 = 1;
                    n6 = n2;
                    n9 = n6 > 1 ? n6 - 1 : 1;
                } else {
                    n7 = n;
                    n6 = 1;
                    n9 = n7 > 1 ? n7 - 1 : 1;
                }
                int n10 = n7 * 4;
                byArray = new byte[n6 * n10];
                ImageData.buildPreciseGradientChannel(rGB.blue, rGB2.blue, n9, n7, n6, bl, byArray, 0, n10);
                ImageData.buildPreciseGradientChannel(rGB.green, rGB2.green, n9, n7, n6, bl, byArray, 1, n10);
                ImageData.buildPreciseGradientChannel(rGB.red, rGB2.red, n9, n7, n6, bl, byArray, 2, n10);
            } else {
                int n11;
                if (bl) {
                    n7 = n < 8 ? n : 8;
                    n6 = n2;
                    n11 = n6 > 1 ? n6 - 1 : 1;
                } else {
                    n7 = n;
                    n6 = n2 < 8 ? n2 : 8;
                    n11 = n7 > 1 ? n7 - 1 : 1;
                }
                int n12 = n7 * 4;
                byArray = new byte[n6 * n12];
                ImageData.buildDitheredGradientChannel(rGB.blue, rGB2.blue, n11, n7, n6, bl, byArray, 0, n12, n5);
                ImageData.buildDitheredGradientChannel(rGB.green, rGB2.green, n11, n7, n6, bl, byArray, 1, n12, n4);
                ImageData.buildDitheredGradientChannel(rGB.red, rGB2.red, n11, n7, n6, bl, byArray, 2, n12, n3);
            }
        } else {
            int n13;
            paletteData = new PaletteData(new RGB[]{rGB, rGB2});
            n8 = 8;
            if (bl) {
                n7 = n < 8 ? n : 8;
                n6 = n2;
                n13 = n6 > 1 ? 0x1040000 / (n6 - 1) + 1 : 1;
            } else {
                n7 = n;
                n6 = n2 < 8 ? n2 : 8;
                n13 = n7 > 1 ? 0x1040000 / (n7 - 1) + 1 : 1;
            }
            int n14 = n7 + 3 & 0xFFFFFFFC;
            byArray = new byte[n6 * n14];
            if (bl) {
                int n15 = 0;
                int n16 = 0;
                int n17 = 0;
                while (n15 < n6) {
                    int n18 = 0;
                    while (n18 < n7) {
                        byArray[n17 + n18] = n16 + DITHER_MATRIX[n15 & 7][n18] < 0x1000000 ? (byte)0 : 1;
                        ++n18;
                    }
                    ++n15;
                    n16 += n13;
                    n17 += n14;
                }
            } else {
                int n19 = 0;
                int n20 = 0;
                while (n19 < n7) {
                    int n21 = 0;
                    int n22 = n19;
                    while (n21 < n6) {
                        byArray[n22] = n20 + DITHER_MATRIX[n21][n19 & 7] < 0x1000000 ? (byte)0 : 1;
                        ++n21;
                        n22 += n14;
                    }
                    ++n19;
                    n20 += n13;
                }
            }
        }
        return new ImageData(n7, n6, n8, paletteData, 4, byArray);
    }

    static final void buildPreciseGradientChannel(int n, int n2, int n3, int n4, int n5, boolean bl, byte[] byArray, int n6, int n7) {
        int n8 = n << 16;
        int n9 = ((n2 << 16) - n8) / n3 + 1;
        if (bl) {
            int n10 = 0;
            while (n10 < n5) {
                byArray[n6] = (byte)(n8 >>> 16);
                n8 += n9;
                ++n10;
                n6 += n7;
            }
        } else {
            int n11 = 0;
            while (n11 < n4) {
                byArray[n6] = (byte)(n8 >>> 16);
                n8 += n9;
                ++n11;
                n6 += 4;
            }
        }
    }

    static final void buildDitheredGradientChannel(int n, int n2, int n3, int n4, int n5, boolean bl, byte[] byArray, int n6, int n7, int n8) {
        int n9 = 65280 >>> n8;
        int n10 = n << 16;
        int n11 = ((n2 << 16) - n10) / n3 + 1;
        if (bl) {
            int n12 = 0;
            while (n12 < n5) {
                int n13 = 0;
                int n14 = n6;
                while (n13 < n4) {
                    int n15 = DITHER_MATRIX[n12 & 7][n13] >>> n8;
                    int n16 = n10 + n15;
                    byArray[n14] = n16 > 0xFFFFFF ? -1 : (byte)(n16 >>> 16 & n9);
                    ++n13;
                    n14 += 4;
                }
                n10 += n11;
                ++n12;
                n6 += n7;
            }
        } else {
            int n17 = 0;
            while (n17 < n4) {
                int n18 = 0;
                int n19 = n6;
                while (n18 < n5) {
                    int n20 = DITHER_MATRIX[n18][n17 & 7] >>> n8;
                    int n21 = n10 + n20;
                    byArray[n19] = n21 > 0xFFFFFF ? -1 : (byte)(n21 >>> 16 & n9);
                    ++n18;
                    n19 += n7;
                }
                n10 += n11;
                ++n17;
                n6 += 4;
            }
        }
    }

    static void fillGradientRectangle(GC gC, Device device, int n, int n2, int n3, int n4, boolean bl, RGB rGB, RGB rGB2, int n5, int n6, int n7) {
        ImageData imageData = ImageData.createGradientBand(n3, n4, bl, rGB, rGB2, n5, n6, n7);
        Image image = new Image(device, imageData);
        if (imageData.width == 1 || imageData.height == 1) {
            gC.drawImage(image, 0, 0, imageData.width, imageData.height, n, n2, n3, n4);
        } else if (bl) {
            int n8 = 0;
            while (n8 < n3) {
                int n9 = n3 - n8;
                if (n9 > imageData.width) {
                    n9 = imageData.width;
                }
                gC.drawImage(image, 0, 0, n9, imageData.height, n8 + n, n2, n9, imageData.height);
                n8 += imageData.width;
            }
        } else {
            int n10 = 0;
            while (n10 < n4) {
                int n11 = n4 - n10;
                if (n11 > imageData.height) {
                    n11 = imageData.height;
                }
                gC.drawImage(image, 0, 0, imageData.width, n11, n, n10 + n2, imageData.width, n11);
                n10 += imageData.height;
            }
        }
        image.dispose();
    }
}

