/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.OS;

class ImageList {
    int handle = OS.ImageList_Create(32, 32, CREATE_FLAGS, 16, 16);
    int refCount;
    Image[] images = new Image[4];
    static final int CREATE_FLAGS;

    static {
        if (OS.IsWinCE) {
            CREATE_FLAGS = 1;
        } else {
            int n = 1;
            int n2 = OS.GetDC(0);
            int n3 = OS.GetDeviceCaps(n2, 12);
            int n4 = OS.GetDeviceCaps(n2, 14);
            OS.ReleaseDC(0, n2);
            int n5 = n3 * n4;
            switch (n5) {
                case 4: {
                    n |= 4;
                    break;
                }
                case 8: {
                    n |= 8;
                    break;
                }
                case 16: {
                    n |= 0x10;
                    break;
                }
                case 24: {
                    n |= 0x18;
                    break;
                }
                case 32: {
                    n |= 0x20;
                    break;
                }
                default: {
                    n |= 0;
                }
            }
            CREATE_FLAGS = n;
        }
    }

    public int add(Image image) {
        int n = OS.ImageList_GetImageCount(this.handle);
        int n2 = 0;
        while (n2 < n) {
            if (this.images[n2] != null && this.images[n2].isDisposed()) {
                this.images[n2] = null;
            }
            if (this.images[n2] == null) break;
            ++n2;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (n == 0) {
            Rectangle rectangle = image.getBounds();
            nArray[0] = rectangle.width;
            nArray2[0] = rectangle.height;
            OS.ImageList_SetIconSize(this.handle, nArray[0], nArray2[0]);
        }
        int n3 = image.handle;
        OS.ImageList_GetIconSize(this.handle, nArray, nArray2);
        switch (image.type) {
            case 0: {
                int n4 = this.copyBitmap(n3, nArray[0], nArray2[0]);
                int n5 = -1;
                Color color = image.getBackground();
                if (color != null) {
                    n5 = color.handle;
                }
                if (n2 == n) {
                    if (n5 != -1) {
                        OS.ImageList_AddMasked(this.handle, n4, n5);
                    } else {
                        int n6 = this.createMask(n4, nArray[0], nArray2[0], n5);
                        OS.ImageList_Add(this.handle, n4, n6);
                        OS.DeleteObject(n6);
                    }
                } else {
                    int n7 = this.createMask(n4, nArray[0], nArray2[0], n5);
                    OS.ImageList_Replace(this.handle, n2, n4, n7);
                    OS.DeleteObject(n7);
                }
                OS.DeleteObject(n4);
                break;
            }
            case 1: {
                if (OS.IsWinCE) {
                    OS.ImageList_ReplaceIcon(this.handle, n2 == n ? -1 : n2, n3);
                    break;
                }
                int n4 = this.copyIcon(n3, nArray[0], nArray2[0]);
                OS.ImageList_ReplaceIcon(this.handle, n2 == n ? -1 : n2, n4);
                OS.DestroyIcon(n4);
            }
        }
        if (n2 == this.images.length) {
            Image[] imageArray = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
            this.images = imageArray;
        }
        this.images[n2] = image;
        return n2;
    }

    int addRef() {
        return ++this.refCount;
    }

    int copyBitmap(int n, int n2, int n3) {
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(n, 24, bITMAP);
        int n4 = OS.GetDC(0);
        int n5 = OS.CreateCompatibleDC(n4);
        OS.SelectObject(n5, n);
        int n6 = OS.CreateCompatibleDC(n4);
        int n7 = OS.CreateCompatibleBitmap(n4, n2, n3);
        OS.SelectObject(n6, n7);
        if (n2 != bITMAP.bmWidth || n3 != bITMAP.bmHeight) {
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(n6, 3);
            }
            OS.StretchBlt(n6, 0, 0, n2, n3, n5, 0, 0, bITMAP.bmWidth, bITMAP.bmHeight, 0xCC0020);
        } else {
            OS.BitBlt(n6, 0, 0, n2, n3, n5, 0, 0, 0xCC0020);
        }
        OS.DeleteDC(n5);
        OS.DeleteDC(n6);
        OS.ReleaseDC(0, n4);
        return n7;
    }

    int copyIcon(int n, int n2, int n3) {
        int n4;
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        return (n4 = OS.CopyImage(n, 1, n2, n3, 0)) != 0 ? n4 : n;
    }

    int createMask(int n, int n2, int n3, int n4) {
        int n5 = OS.CreateBitmap(n2, n3, 1, 1, null);
        int n6 = OS.GetDC(0);
        int n7 = OS.CreateCompatibleDC(n6);
        if (n4 != -1) {
            OS.SelectObject(n7, n);
            int n8 = OS.CreateCompatibleDC(n6);
            OS.SelectObject(n8, n5);
            OS.SetBkColor(n7, n4);
            OS.BitBlt(n8, 0, 0, n2, n3, n7, 0, 0, 0xCC0020);
            OS.DeleteDC(n8);
        } else {
            int n9 = OS.SelectObject(n7, n5);
            OS.PatBlt(n7, 0, 0, n2, n3, 66);
            OS.SelectObject(n7, n9);
        }
        OS.ReleaseDC(0, n6);
        OS.DeleteDC(n7);
        return n5;
    }

    public void dispose() {
        if (this.handle != 0) {
            OS.ImageList_Destroy(this.handle);
        }
        this.handle = 0;
        this.images = null;
    }

    public Image get(int n) {
        return this.images[n];
    }

    public int getHandle() {
        return this.handle;
    }

    public Point getImageSize() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize(this.handle, nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    public int indexOf(Image image) {
        int n = OS.ImageList_GetImageCount(this.handle);
        int n2 = 0;
        while (n2 < n) {
            if (this.images[n2] != null) {
                if (this.images[n2].isDisposed()) {
                    this.images[n2] = null;
                }
                if (this.images[n2] != null && this.images[n2].equals(image)) {
                    return n2;
                }
            }
            ++n2;
        }
        return -1;
    }

    public void put(int n, Image image) {
        int n2 = OS.ImageList_GetImageCount(this.handle);
        if (n < 0 || n >= n2) {
            return;
        }
        if (image != null) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.ImageList_GetIconSize(this.handle, nArray, nArray2);
            int n3 = image.handle;
            switch (image.type) {
                case 0: {
                    int n4 = -1;
                    Color color = image.getBackground();
                    if (color != null) {
                        n4 = color.handle;
                    }
                    int n5 = this.copyBitmap(n3, nArray[0], nArray2[0]);
                    int n6 = this.createMask(n5, nArray[0], nArray2[0], n4);
                    OS.ImageList_Replace(this.handle, n, n5, n6);
                    OS.DeleteObject(n5);
                    OS.DeleteObject(n6);
                    break;
                }
                case 1: {
                    if (OS.IsWinCE) {
                        OS.ImageList_ReplaceIcon(this.handle, n, n3);
                        break;
                    }
                    int n7 = this.copyIcon(n3, nArray[0], nArray2[0]);
                    OS.ImageList_ReplaceIcon(this.handle, n, n7);
                    OS.DestroyIcon(n7);
                }
            }
        }
        this.images[n] = image;
    }

    public void remove(int n) {
        int n2 = OS.ImageList_GetImageCount(this.handle);
        if (n < 0 || n >= n2) {
            return;
        }
        OS.ImageList_Remove(this.handle, n);
        System.arraycopy(this.images, n + 1, this.images, n, --n2 - n);
        this.images[n] = null;
    }

    int removeRef() {
        return --this.refCount;
    }

    public int size() {
        int n = 0;
        int n2 = OS.ImageList_GetImageCount(this.handle);
        int n3 = 0;
        while (n3 < n2) {
            if (this.images[n3] != null) {
                if (this.images[n3].isDisposed()) {
                    this.images[n3] = null;
                }
                if (this.images[n3] != null) {
                    ++n;
                }
            }
            ++n3;
        }
        return n;
    }
}

