/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite composite, int n) {
        super(composite, n);
    }

    int callWindowProc(int n, int n2, int n3) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.DefWindowProc(this.handle, n, n2, n3);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        RECT rECT = new RECT();
        OS.SetRect(rECT, n, n2, n + n3, n2 + n4);
        int n5 = OS.GetWindowLong(this.handle, -16);
        OS.AdjustWindowRectEx(rECT, n5, false, OS.GetWindowLong(this.handle, -20));
        if (this.horizontalBar != null) {
            rECT.bottom += OS.GetSystemMetrics(3);
        }
        if (this.verticalBar != null) {
            rECT.right += OS.GetSystemMetrics(2);
        }
        int n6 = rECT.right - rECT.left;
        int n7 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n6, n7);
    }

    ScrollBar createScrollBar(int n) {
        ScrollBar scrollBar = new ScrollBar(this, n);
        if ((this.state & 2) != 0) {
            scrollBar.setMaximum(100);
            scrollBar.setThumb(10);
        }
        return scrollBar;
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        return new Rectangle(0, 0, rECT.right, rECT.bottom);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    void releaseWidget() {
        if (this.horizontalBar != null) {
            this.horizontalBar.releaseResources();
        }
        if (this.verticalBar != null) {
            this.verticalBar.releaseResources();
        }
        this.verticalBar = null;
        this.horizontalBar = null;
        super.releaseWidget();
    }

    int widgetExtStyle() {
        return super.widgetExtStyle();
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x10000;
        if ((this.style & 0x100) != 0) {
            n |= 0x100000;
        }
        if ((this.style & 0x200) != 0) {
            n |= 0x200000;
        }
        return n;
    }

    TCHAR windowClass() {
        return this.display.windowClass;
    }

    int windowProc() {
        return this.display.windowProc;
    }

    LRESULT WM_HSCROLL(int n, int n2) {
        LRESULT lRESULT = super.WM_HSCROLL(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((n2 == 0 || n2 == this.handle) && this.horizontalBar != null) {
            return this.wmScroll(this.horizontalBar, 276, n, n2);
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEWHEEL(int n, int n2) {
        Event event;
        int n3;
        LRESULT lRESULT = super.WM_MOUSEWHEEL(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.state & 2) != 0) {
            int n4;
            boolean bl;
            if ((n & 0xC) != 0) {
                return lRESULT;
            }
            boolean bl2 = this.verticalBar != null && this.verticalBar.getEnabled();
            boolean bl3 = bl = this.horizontalBar != null && this.horizontalBar.getEnabled();
            int n5 = bl2 ? 277 : (n4 = bl ? 276 : 0);
            if (n4 == 0) {
                return lRESULT;
            }
            int[] nArray = new int[1];
            OS.SystemParametersInfo(104, 0, nArray, 0);
            int n6 = n >> 16;
            int n7 = 0;
            int n8 = 0;
            if (nArray[0] == -1) {
                n7 = n6 < 0 ? 3 : 2;
                n8 = 1;
            } else {
                n7 = n6 < 0 ? 1 : 0;
                if ((n6 = Math.abs(n6)) < 120) {
                    return lRESULT;
                }
                n8 = n4 == 277 ? nArray[0] * n6 / 120 : n6 / 120;
            }
            int n9 = 0;
            while (n9 < n8) {
                OS.SendMessage(this.handle, n4, n7, 0);
                ++n9;
            }
            return LRESULT.ZERO;
        }
        int n10 = this.verticalBar == null ? 0 : this.verticalBar.getSelection();
        int n11 = this.horizontalBar == null ? 0 : this.horizontalBar.getSelection();
        int n12 = this.callWindowProc(522, n, n2);
        if (this.verticalBar != null && (n3 = this.verticalBar.getSelection()) != n10) {
            event = new Event();
            event.detail = n3 < n10 ? 0x1000005 : 0x1000006;
            this.verticalBar.sendEvent(13, event);
        }
        if (this.horizontalBar != null && (n3 = this.horizontalBar.getSelection()) != n11) {
            event = new Event();
            event.detail = n3 < n11 ? 0x1000005 : 0x1000006;
            this.horizontalBar.sendEvent(13, event);
        }
        return new LRESULT(n12);
    }

    LRESULT WM_SIZE(int n, int n2) {
        int n3 = this.callWindowProc(5, n, n2);
        super.WM_SIZE(n, n2);
        if (n3 == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(n3);
    }

    LRESULT WM_VSCROLL(int n, int n2) {
        LRESULT lRESULT = super.WM_VSCROLL(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((n2 == 0 || n2 == this.handle) && this.verticalBar != null) {
            return this.wmScroll(this.verticalBar, 277, n, n2);
        }
        return lRESULT;
    }

    LRESULT wmScroll(ScrollBar scrollBar, int n, int n2, int n3) {
        LRESULT lRESULT = null;
        if ((this.state & 2) != 0) {
            int n4 = n == 276 ? 0 : 1;
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = 28;
            sCROLLINFO.fMask = 21;
            OS.GetScrollInfo(this.handle, n4, sCROLLINFO);
            sCROLLINFO.fMask = 4;
            int n5 = n2 & 0xFFFF;
            switch (n5) {
                case 8: {
                    return null;
                }
                case 4: 
                case 5: {
                    sCROLLINFO.nPos = sCROLLINFO.nTrackPos;
                    break;
                }
                case 6: {
                    sCROLLINFO.nPos = sCROLLINFO.nMin;
                    break;
                }
                case 7: {
                    sCROLLINFO.nPos = sCROLLINFO.nMax;
                    break;
                }
                case 1: {
                    sCROLLINFO.nPos += scrollBar.getIncrement();
                    break;
                }
                case 0: {
                    int n6 = scrollBar.getIncrement();
                    sCROLLINFO.nPos = Math.max(sCROLLINFO.nMin, sCROLLINFO.nPos - n6);
                    break;
                }
                case 3: {
                    sCROLLINFO.nPos += scrollBar.getPageIncrement();
                    break;
                }
                case 2: {
                    int n7 = scrollBar.getPageIncrement();
                    sCROLLINFO.nPos = Math.max(sCROLLINFO.nMin, sCROLLINFO.nPos - n7);
                }
            }
            OS.SetScrollInfo(this.handle, n4, sCROLLINFO, true);
        } else {
            int n8 = this.callWindowProc(n, n2, n3);
            lRESULT = n8 == 0 ? LRESULT.ZERO : new LRESULT(n8);
        }
        scrollBar.wmScrollChild(n2, n3);
        return lRESULT;
    }
}

