/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Des Herriott
*          Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifdef XBELL_AUDIO
#ifndef lint
static char beep_c[] = "$Id: beep.c,v 4.11 1998/12/30 15:36:27 erik Rel $";
#endif
#include <X11/Xlib.h>
#include "debug.h"
#include "resource.h"
#include "mem.h"
#include "machine.h"
#include "util.h"
#include "screen.h"
#include "beep.h"
#ifdef DEBUG
#define DEB(x)			{ if (GETCFG(debug) & D_AUDIO) { x } }
#else
#define DEB(x)
#endif
void
SetBeepTrap(int model)
{
uns16 bellAddr;
int basicrom;
switch (Machines[model].romType)
{
case ROM_STANDARD:
case ROM_128:
case ROM_PLUS2:
#ifdef XZX_PLUS3
case ROM_PLUS3:
#endif
#ifdef XZX_PENTAGON
case ROM_PENTAGON:
#endif
#ifdef XZX_SCORPION
case ROM_SCORPION:
#endif
bellAddr = 0x3b5;
break;
default:
return;
}
basicrom = Machines[model].basicRom;
RealMemory[basicrom][bellAddr] = 0xed;
RealMemory[basicrom][bellAddr + 1] = BELL_BPT;
}
void
RingBell(int freq, int duration)
{
XKeyboardState kbs, oldKbs;
if (!GETCFG(audioActive) || !GETCFG(audioVolume) || GETCFG(fast))
{
return;
}
DEB(Msg(M_DEBUG, "BEEP: freq = %d Hz, time = %d ms", freq, duration););
XGetKeyboardControl(Dpy, &oldKbs);
kbs.bell_pitch = freq;
kbs.bell_duration = duration;
kbs.bell_percent = GETCFG(audioVolume);
#define KEYBOARD_FLAG (KBBellPitch | KBBellDuration | KBBellPercent)
XChangeKeyboardControl(Dpy, KEYBOARD_FLAG, (XKeyboardControl *)&kbs);
XBell(Dpy, 0);
XChangeKeyboardControl(Dpy, KEYBOARD_FLAG, (XKeyboardControl *)&oldKbs);
#undef KEYBOARD_FLAG
XFlush(Dpy);
}
#endif
