%{
/********************************************************************************
* Copyright (c) Erik Kunze 1997 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifndef lint
static char debug2_l[] = "$Id: monitor2.l,v 4.5 1999/01/14 16:51:41 erik Rel $";
#endif
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "monitor.h"
#include "y.tab.h"
#undef getc
#define getc(x)		(*CmdLine ? tolower(*CmdLine++) : EOF)
#undef feof
#define feof(x)		(*CmdLine ? 0 : 1)
extern int yylval;
%}
DELIM				[ \t]+
BP					"breakpoint"|"bp"
ADD					"add"
REM					"rem"("ove")?
SHOW				"show"
%%
{DELIM}				{	}
\n					{ return NL;				}
"+"					{ return PLUS;				}
"-"					{ return MINUS;				}
"="					{ return EQUAL;				}
"ay"				{ return AY;				}
"base"				{ return BASE;				}
{BP}{DELIM}{ADD}	{ return BP_ADD;			}
{BP}{DELIM}{REM}	{ return BP_REMOVE;			}
{BP}{DELIM}{SHOW}	{ return BP_SHOW;			}
"copy"				{ return COPY;				}
"dis"				{ return DIS;				}
"fill"				{ return FILL;				}
"g"("o")?			{ return GO;				}
"help"|"?"			{ return HELP;				}
"im"				{ return INT_MODE;			}
"iff1"				{ return INT_FF1;			}
"iff2"				{ return INT_FF2;			}
"r"("eg")?			{ return REGISTER;			}
"q"("uit")?			{ return QUIT;				}
[01]+				{
if (NumberBase == 2)
{
yylval = strtol(yytext, NULL, NumberBase);
return NUMBER;
}
REJECT;
}
[0-7]+				{
if (NumberBase == 8)
{
yylval = strtol(yytext, NULL, NumberBase);
return NUMBER;
}
REJECT;
}
[0-9]+				{
if (NumberBase == 10)
{
yylval = strtol(yytext, NULL, NumberBase);
return NUMBER;
}
REJECT;
}
[0-9a-f]+			{
if (NumberBase == 16)
{
yylval = strtol(yytext, NULL, NumberBase);
return NUMBER;
}
return UNKNOWN;
}
"yydebug"			{ return YACC_DEBUG;		}
.					{ return UNKNOWN;			}
%%
void
yylex_init(void)
{
BEGIN(INITIAL);
}
