/********************************************************************************
* Copyright (c) Erik Kunze 1995 - 1998
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*
* $Id: loadsave.h,v 4.13 1999/05/11 16:12:06 erik Rel $
*******************************************************************************/
#ifndef _XZX_LOADSAVE_H
#define _XZX_LOADSAVE_H
#include "util.h"
#define LOAD_BPT		0xfc
#define SAVE_BPT		0xfd
#define TO_READ			0x01
#define TO_WRITE		0x02
#define TO_TAP			0x10
#define TO_VOC			0x20
#define TO_TZX			0x40
#define TS_TRAPLOAD		0x0001
#define TS_TRAPSAVE		0x0002
#define TS_ERRIN		0x0004
#define TS_ERROUT		0x0008
#define TS_ENDIN		0x0010
#define TS_ENDOUT		0x0020
#define TS_PLAY			0x0040
#define TS_QUICKLOAD	0x0080
#define TS_AUTOSTOP		0x0100
#define TS_TAPIN		0x0200
#define TS_VOCIN		0x0400
#define TS_TZXIN		0x0800
#define TS_TAPOUT		0x1000
#define GET1(a,o)		(a[o])
#define GET2(a,o)		(a[o] + (a[o+1] << 8))
#define GET3(a,o)		(a[o] + (a[o+1] << 8) + (a[o+2] << 16))
#define GET4(a,o) 		(a[o] + (a[o+1] << 8) + (a[o+2] << 16) + (a[o+3] << 24))
typedef struct _tapeRecord {
uns8 *pos;
char *str;
} TapeRecord;
extern void TpPatchRom(int);
extern void TpLoadBlock(void);
extern void TpSaveBlock(void);
extern int TpInsertTape(const char *, int);
extern void TpEjectTape(int);
extern char *TpTapeName(int);
extern void TpStartPlayback(void);
extern void TpStopPlayback(void);
extern void TpBrowser(void);
extern unsigned short TpState;
extern uns8 *TpInBegin, *TpInEnd;
extern Llist *TpInBlockList;
extern unsigned int TpInBlockCount, TpInBlockCurrent;
extern uns8 (*TpGetNextBit)(void);
#endif
