/********************************************************************************
* Copyright (c) Erik Kunze 1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifndef lint
static char rcsid[] = "$Id: machine.c,v 1.13 1999/01/16 08:58:29 erik Rel $";
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_MEMORY_H
# include <memory.h>
#endif
#include <assert.h>
#include "z80.h"
#include "resource.h"
#include "mem.h"
#include "io.h"
#include "util.h"
#ifdef AUDIO
#include "audio.h"
#endif
#include "emul.h"
#ifdef XZX_PLUS3
#include "fdc.h"
#endif
#ifdef XZX_IF1
#include "if1.h"
#endif
#ifdef XZX_KMOUSE
#include "kmouse.h"
#endif
#ifndef NO_ED_TRAPS
#include "loadsave.h"
#endif
#ifdef REGISTERED
#include "menu.h"
#endif
#ifdef XZX_MGT
#include "mgt.h"
#endif
#ifdef XZX_PENTAGON
#include "pentagon.h"
#endif
#include "sbar.h"
#ifdef XZX_SCORPION
#include "scorpion.h"
#endif
#ifdef XZX_TRDOS
#include "trdos.h"
#endif
#include "machine.h"
static void genUlaDelay(int);
MachineSettings Machines[NMACHINES], *Machine;
unsigned char *UlaDelay = NULL;
void
MachineInit(void)
{
int checksum, romtype;
Machines[SP_48_2].basicRom = SP48ROM;
Machines[SP_48_2].romType = ROM_UNKNOWN;
Machines[SP_48_2].tvLines = 312;
Machines[SP_48_2].tstatesPerLine = 224;
Machines[SP_48_2].tstatesPerFrame = 69888;
Machines[SP_48_2].intLine = 0;
Machines[SP_48_2].topBorder = 64;
Machines[SP_48_2].readOpcode = ReadOpcode48;
Machines[SP_48_2].readMem = ReadMem48;
Machines[SP_48_2].writeMem = WriteMem48;
Machines[SP_48_2].inPort = InPort48;
Machines[SP_48_2].outPort = OutPort48;
Machines[SP_48_2].initPages = InitPages48;
Machines[SP_48_2].pageIn = PageIn48;
(void)memcpy(&Machines[SP_48_3], &Machines[SP_48_2], sizeof(Machines[0]));
Machines[SP_48_2].name = "Spectrum 48K Issue 2";
Machines[SP_48_3].name = "Spectrum 48K";
if (!LoadRomImage(GETCFG(sp48Rom), SP48ROM, 1))
{
checksum = GetRomChecksum(Machines[SP_48_3].basicRom, XZX_PAGESIZE);
switch (checksum)
{
case 8686:
romtype = ROM_STANDARD;
break;
case 44175:
Machines[SP_48_2].name = "TK 95";
Machines[SP_48_3].name = "TK 95";
romtype = ROM_TK95;
break;
case 58561:
romtype = ROM_GROOT;
break;
case 53858:
romtype = ROM_IMC;
break;
default:
Msg(M_WARN, "unknown 48K ROM image - checksum %u", checksum);
romtype = ROM_UNKNOWN;
break;
}
Machines[SP_48_2].romType = romtype;
Machines[SP_48_3].romType = romtype;
#ifndef NO_ED_TRAPS
TpPatchRom(SP_48_3);
#ifdef XBELL_AUDIO
SetBeepTrap(SP_48_3);
#endif
#endif
}
Machines[SP_128].name = "Spectrum 128K";
Machines[SP_128].basicRom = SP128ROM1;
Machines[SP_128].romType = ROM_UNKNOWN;
Machines[SP_128].tvLines = 311;
Machines[SP_128].tstatesPerLine = 228;
Machines[SP_128].tstatesPerFrame = 70908;
Machines[SP_128].intLine = 0;
Machines[SP_128].topBorder = 63;
Machines[SP_128].readOpcode = ReadOpcode128;
Machines[SP_128].readMem = ReadMem128;
Machines[SP_128].writeMem = WriteMem128;
Machines[SP_128].inPort = InPort128;
Machines[SP_128].outPort = OutPort128;
Machines[SP_128].initPages = InitPages128;
Machines[SP_128].pageIn = PageIn128;
if (!LoadRomImage(GETCFG(sp128Rom), SP128ROM0, 2))
{
checksum = GetRomChecksum(Machines[SP_128].basicRom, XZX_PAGESIZE);
switch (checksum)
{
case 44809:
romtype = ROM_128;
break;
case 32991:
Machines[SP_128].name = "Spectrum +2";
romtype = ROM_PLUS2;
break;
default:
Msg(M_WARN, "unknown 128K ROM image - checksum %u", checksum);
romtype = ROM_UNKNOWN;
break;
}
Machines[SP_128].romType = romtype;
#ifndef NO_ED_TRAPS
TpPatchRom(SP_128);
#ifdef XBELL_AUDIO
SetBeepTrap(SP_128);
#endif
#endif
}
#ifdef XZX_PLUS3
Machines[SP_3].name = "Spectrum +3";
Machines[SP_3].basicRom = SP3ROM3;
Machines[SP_3].romType = ROM_UNKNOWN;
Machines[SP_3].tvLines = 311;
Machines[SP_3].tstatesPerLine = 228;
Machines[SP_3].tstatesPerFrame = 70908;
Machines[SP_3].intLine = 0;
Machines[SP_3].topBorder = 63;
Machines[SP_3].readOpcode = ReadOpcode3;
Machines[SP_3].readMem = ReadMem3;
Machines[SP_3].writeMem = WriteMem3;
Machines[SP_3].inPort = InPort3;
Machines[SP_3].outPort = OutPort3;
Machines[SP_3].initPages = InitPages3;
Machines[SP_3].pageIn = PageIn3;
if (LoadRomImage(GETCFG(plus3Rom), SP3ROM0, 4))
{
checksum = GetRomChecksum(Machines[SP_3].basicRom, XZX_PAGESIZE);
switch (checksum)
{
case 48934:
romtype = ROM_PLUS3;
break;
default:
Msg(M_WARN, "unknown +3 ROM image - checksum %u", checksum);
romtype = ROM_UNKNOWN;
break;
}
Machines[SP_3].romType = romtype;
#ifndef NO_ED_TRAPS
TpPatchRom(SP_3);
#ifdef XBELL_AUDIO
SetBeepTrap(SP_3);
#endif
#endif
}
#endif
#ifdef XZX_MF
if (!LoadRomImage(GETCFG(mf128Rom), MF128ROM, 1))
{
checksum = GetRomChecksum(MF128ROM, XZX_PAGESIZE / 2);
switch (checksum)
{
case 46066:
break;
default:
Msg(M_WARN, "unknown Multiface 128 ROM image - checksum %u",
checksum);
break;
}
}
else
{
Msg(M_INFO, "MF128 emulation disabled");
SETCFG(mfActive, 0);
}
#ifdef XZX_PLUS3
if (!LoadRomImage(GETCFG(mf3Rom), MF3ROM, 1))
{
checksum = GetRomChecksum(MF3ROM, XZX_PAGESIZE / 2);
switch (checksum)
{
case 46694:
break;
default:
Msg(M_WARN, "unknown Multiface 3 ROM image - checksum %u",
checksum);
break;
}
}
else
{
Msg(M_INFO, "MF3 emulation disabled");
SETCFG(mfActive, 0);
}
#endif
#endif
#ifdef XZX_PENTAGON
PentInit();
#endif
#ifdef XZX_SCORPION
ScorInit();
#endif
assert(GETCFG(machine) < NMACHINES);
Machine = &Machines[GETCFG(machine)];
SbarDisplayModel(Machine->name);
genUlaDelay(GETCFG(machine));
#ifdef XZX_PLUS3
FdcInit();
#endif
#ifdef XZX_IF1
If1Init();
#endif
#ifdef XZX_TRDOS
TrdosInit();
#endif
#ifdef XZX_MGT
MgtInit();
#endif
}
void
SelectModel(int model, int reset)
{
assert(model < NMACHINES);
if (GETCFG(machine) != model)
{
SETCFG(machine, model);
Machine = &Machines[model];
SbarDisplayModel(Machine->name);
genUlaDelay(model);
EmuSetSpeed(GETCFG(speed));
#ifdef REGISTERED
#ifdef XZX_IF1
if (GETCFG(if1Active) >= 0 && GETCFG(machine) > SP_128)
{
SETCFG(if1Active, 0);
UpdateCartridgeMenu();
}
#endif
#ifdef XZX_MF
#ifdef XZX_PLUS3
if (GETCFG(mfActive) > 0 && GETCFG(machine) > SP_3)
#else
if (GETCFG(mfActive) > 0 && GETCFG(machine) > SP_128)
#endif
{
SETCFG(mfActive, 0);
}
#endif
#ifdef XZX_TRDOS
if (GETCFG(trdosActive) > 0 && GETCFG(machine) > SP_128)
{
SETCFG(trdosActive, 0);
}
#endif
#ifdef XZX_MGT
if (GETCFG(mgtActive) > 0 && GETCFG(machine) > SP_128)
{
SETCFG(mgtActive, 0);
}
#endif
#if DISK_DRIVES > 0
UpdateDiskMenu();
#endif
#endif
#ifdef XZX_KMOUSE
#ifdef XZX_PLUS3
if (GETCFG(kmouseActive) > 0 && GETCFG(machine) <= SP_3)
#else
if (GETCFG(kmouseActive) > 0 && GETCFG(machine) <= SP_128)
#endif
{
SETCFG(kmouseActive, 0);
KmouseOff();
}
#endif
}
if (reset)
{
Z80_Reset();
}
else
{
Machine->initPages();
}
}
static void
genUlaDelay(int model)
{
int i, j, k, size;
if (UlaDelay)
{
free(UlaDelay);
}
size = Machine->tstatesPerFrame + 23;
UlaDelay = Malloc((size_t)(size * sizeof(int)), "genUlaDelay");
switch (model)
{
case SP_48_2:
case SP_48_3:
for (i = 0; i < 14335; i++)
{
UlaDelay[i] = 0x80;
}
for (j = 192; j; j --)
{
for (k = 128; k; k--)
{
UlaDelay[i++] = 4;
}
for (k = 96; k; k--)
{
UlaDelay[i++] = 0x80;
}
}
for (; i < size; i++)
{
UlaDelay[i] = 0x80;
}
break;
case SP_128:
for (i = 0; i < 14361; i++)
{
UlaDelay[i] = 0x80;
}
for (j = 192; j; j --)
{
for (k = 128; k; k--)
{
UlaDelay[i++] = 4;
}
for (k = 100; k; k--)
{
UlaDelay[i++] = 0x80;
}
}
for (; i < size; i++)
{
UlaDelay[i] = 0x80;
}
break;
#ifdef XZX_PLUS3
case SP_3:
for (i = 0; i < 14364; i++)
{
UlaDelay[i] = 0x80;
}
for (j = 192; j; j --)
{
for (k = 128; k; k--)
{
UlaDelay[i++] = 4;
}
for (k = 100; k; k--)
{
UlaDelay[i++] = 0x80;
}
}
for (; i < size; i++)
{
UlaDelay[i] = 0x80;
}
break;
#endif
#ifdef XZX_PENTAGON
case SP_PENTAGON:
PentGenUlaDelay(UlaDelay, size);
break;
#endif
#ifdef XZX_SCORPION
case SP_SCORPION:
ScorGenUlaDelay(UlaDelay, size);
break;
#endif
}
}
