/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1998
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Des Herriott
*          Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifndef lint
static char z80_c[] = "$Id: z80.c,v 4.18 1998/12/22 08:40:31 erik Rel $";
#endif
#include <string.h>
#ifdef HAVE_MEMORY_H
# include <memory.h>
#endif
#include "z80.h"
#include "debug.h"
#include "resource.h"
#include "mem.h"
#include "io.h"
#include "machine.h"
#include "util.h"
#ifdef XBELL_AUDIO
#include "audio.h"
#endif
#ifdef XZX_IF1
#include "if1.h"
#endif
#include "loadsave.h"
#include "monitor.h"
#include "snapshot.h"
#ifndef HAVE_ENOUGH_SWAP
static void z80_DecodeCB(void);
static void z80_DecodeED(void);
static void z80_DecodeDD(void);
static void z80_DecodeFD(void);
#endif
struct z80 Cpu;
static uns8 halfCarryTbl[]    = { 0, 0, H_FLAG, 0, H_FLAG, 0, H_FLAG, H_FLAG };
static uns8 subHalfCarryTbl[] = { 0, H_FLAG, H_FLAG, H_FLAG, 0, 0, 0, H_FLAG };
static uns8 overflowTbl[]     = { 0, V_FLAG, 0, 0, 0, 0, V_FLAG, 0 };
static uns8 subOverflowTbl[]  = { 0, 0, 0, V_FLAG, V_FLAG, 0, 0, 0 };
static uns8 *parityTbl, *sz53pTbl, *sz53Tbl;
void
Z80_Init(void)
{
int i, j, k, p;
parityTbl = Malloc(3 * 256, "Z80_Init");
sz53pTbl = &parityTbl[256];
sz53Tbl = &parityTbl[512];
for (i = 0; i < 256; i++)
{
for (j = i, k = 8, p = 0; k; k--)
{
p ^= j & 1;
j >>= 1;
}
parityTbl[i] = (uns8)(p ? 0 : P_FLAG);
sz53Tbl[i] = (uns8)(i & (S_FLAG | B5_FLAG | B3_FLAG));
sz53pTbl[i] = sz53Tbl[i] | parityTbl[i];
}
sz53Tbl[0] |= Z_FLAG;
sz53pTbl[0] |= Z_FLAG;
(void)memset(&Cpu, 0, sizeof(Cpu));
Z80_Reset();
}
void
Z80_Reset(void)
{
PC   = 0;
I    = 0;
R    = 0;
IM   = 0;
IFF1 = 0;
IFF2 = 0;
HALT = 0;
IoReset();
}
void
Z80_INT(uns8 ivec)
{
#ifdef DEBUG
if (GETCFG(debug) & D_INTERRUPT)
{
Msg(M_DEBUG, "interrupt: IM=%d IFF1=%d IFF2=%d", IM, IFF1, IFF2);
}
#endif
if (IFF1)
{
IFF1 = IFF2 = HALT = 0;
INC_R();
switch (IM)
{
case 0:
TSTATES += 13;
PUSH(HPC, LPC);
PC = 0x0038;
break;
case 1:
TSTATES += 13;
PUSH(HPC, LPC);
PC = 0x0038;
break;
case 2:
TSTATES += 19;
PUSH(HPC, LPC);
{
uns16 t16 = (I << 8) | ivec;
LPC = Z80_RDMEM(t16++);
HPC = Z80_RDMEM(t16);
}
break;
}
}
#ifdef DEBUG_HALT
else if (HALT)
{
Msg(M_WARN, "leaving HALT mode (forced)");
HALT = 0;
}
#endif
}
void
Z80_NMI(void)
{
IFF1 = HALT = 0;
INC_R();
TSTATES += 11;
PUSH(HPC, LPC);
PC = 0x0066;
IoNMI();
}
unsigned int
Z80_Execute(unsigned int cycles)
{
if (HALT)
{
unsigned int inc = ((cycles - TSTATES - 1) >> 2) + 1;
TSTATES += inc << 2;
R += inc;
#ifdef DELAY_EI
if (Cpu.eiDelayed)
{
IFF1 = 1;
IFF2 = 1;
Cpu.eiDelayed = 0;
}
#endif
}
else
{
uns8 op;
do {
#ifdef REGISTERED
if (DbgState != S_RUN)
{
Debugger(DBG_SINGLESTEP);
}
#endif
#ifdef DEBUG
if (GETCFG(debug) & (D_CPU | D_SYSVAR | D_MNEMO))
{
DebugZ80();
}
#endif
op = Z80_RDOP(PC++);
R++;
switch (op)
{
#				include "z80_ops.c"
}
#ifdef DELAY_EI
if (Cpu.eiDelayed && !Cpu.eiCount--)
{
IFF1 = 1;
IFF2 = 1;
Cpu.eiDelayed = 0;
Cpu.eiCount = 1;
}
#endif
} while (TSTATES < cycles);
}
R = (R & 0x7f) | R7;
return (TSTATES - cycles);
}
#ifndef HAVE_ENOUGH_SWAP
static void
z80_DecodeCB(void)
{
uns8 op = Z80_RDOP2(PC++);
R++;
switch(op)
{
#		include "z80_cbops.c"
}
}
static void
z80_DecodeED(void)
{
uns8 op = Z80_RDOP2(PC++);
R++;
switch(op)
{
#		include "z80_edops.c"
}
}
static void
z80_DecodeDD(void)
{
uns8 op = Z80_RDOP2(PC++);
R++;
switch(op)
{
#		define XX  IX
#		define LXX LIX
#		define HXX HIX
#		include "z80_xxops.c"
#		undef XX
#		undef LXX
#		undef HXX
}
}
static void
z80_DecodeFD(void)
{
uns8 op = Z80_RDOP2(PC++);
R++;
switch(op)
{
#		define NO_RCSID
#		define XX  IY
#		define LXX LIY
#		define HXX HIY
#		include "z80_xxops.c"
#		undef XX
#		undef LXX
#		undef HXX
#		undef NO_RCSID
}
}
#endif
