# iNET Apache2 DDoS Protection Scripts

Die iNET Apache2 DDoS Protection Scripts dienen zur unmittelbaren Abwehr
von laufenden DDoS-Attacken gegen Apache2 Webserver. 

## Liste der Apache2 DDos Protecion Scripts

- `apache2-logs.sh` - Script zur Ausgabe der Apache2 Access/Error Logfiles.
- `apache2-block-ip.sh` - Script zum (un)blocken von Client IPs per iptables.
- `apache2-ddos-protect.sh` - Wrapper Script für automatisierten DDoS Schutz.

## Verwendung der Apache2 DDoS Protection Scripts

1. Installieren als Debian Paket:  
 `# apt-get install apache2-ddos-protect-inet`  
2. Starten des Wrapper Scripts für automatisierten Live-Schutz:  
 `# apache2-ddos-protect.sh start`  
3. Einige Zeit warten um IPs sperren zu lassen  
4. Script abbrechen mit folgender Tastenkombination:  
 `<Strg>+<C>`  
5. Nach Ende der DDoS-Attacke alle IP-Sperren aufheben:  
 `# apache2-ddos-protect.sh stop`  

## Detaillierte Beschreibung der Funktion der Apache2 DDos Protection Scripts

### apache2-logs.sh - Script zur Ausgabe der Apache2 Access/Error Logfiles.

`apache2-logs.sh` liest sämtliche aktiv verwendeten Apache2 Custom/Error
Logfiles aus der Apache2 Konfiguration aus und listet sie auf. Das Script
wird folgendermaßen aufgerufen:

- `# apache2-logs.sh {custom|error}`  
 gibt eine Liste aller aktiven Custom bzw. Error Logfiles aus.  
- `# apache2-logs.sh`  
 gibt exportierbare Variablen $customlogs und $errorlogs mit allen Logs aus.  

### apache2-block-ip.sh - Script zum (un)blocken von Client IPs per iptables.

`apache2-block-ip.sh` blockt eingehenden HTTP/HTTPS Traffic für einzelne IPs,
beziehungsweise hebt diese Sperre wieder auf. Das Script kann zur manuellen
Sperre einzelner IPs verwendet werden. Es wird folgendermaßen aufgerufen:

- `# apache2-block-ip.sh <IP> block`  
 startet die Sperre der IP-Adresse `<IP>`.  
- `# apache2-block-ip.sh <IP> unblock`  
 hebt die Sperre der zuvor geblockten IP-Adresse `<IP>` auf.  
- `# apache2-block-ip.sh <IP> status`  
 gibt den Status der IP-Adresse `<IP>` aus (geblockt oder nicht).  
- `# apache2-block-ip.sh 0.0.0.0 unblockall`  
 hebt global die Sperre aller zuvor geblockten IP-Adressen auf.  

### apache2-ddos-protect.sh - Wrapper Script für automatisierten DDoS Schutz.

`apache2-ddos-protect.sh` ist ein Wrapper Script zur automatisierten Sperre
von IPs, die an DDoS-Attacken beteiligt sind. Das Script kann live während
einer laufenden DDoS-Attacke gestartet und beobachtet werden. Beendet wird
das Script mit der Tastenkombination `<Strg>+<C>`.

Dieses Script startet einen Hintergrund-Prozess, der live IP-Adressen sammelt,
die ungültige Anfragen an den Apache2-Webserver senden. Alle 30 Sekunden wird
die Liste der gesammelten IPs durchgegangen. Bei mehr als fünf ungültigen
Aufrufen von der selben IP, wird diese gesperrt.

Nach Abklingen der DDoS-Attacke müssen die geblockten IPs unbedingt wieder
freigegeben werden. Das wird mit `apache2-ddos-protect.sh stop` erledigt.

## `apache2-ddos-protect-inet` Debian Paket ändern, bauen, hochladen

Um Änderungen in dem Debian Paket verfügbar zu machen, muss

1. das Repository lokal geklont werden:  
 `# git clone ssh://git@git.inet.de:55555/~/apache-ddos-protect-inet.git apache-ddos-protect-inet`  
2. die Änderungen eingefügt werden. Am Ende sollten die Änderungen im Changelog des Pakets beschrieben werden:  
 `# dch -i`  
3. die Änderungen in das Git-Repository hochgeladen werden:  
 `# git add .`  
 `# git commit -m "Genaue Beschreibung der Änderungen"`  
 `# git push origin master`  
4. das Paket gebaut werden:  
 `# git-buildpackage`  
 `# debuild clean`  
5. das Paket in das debian-inet Repository hochgeladen werden:  
 `# dput debian-inet apache-ddos-protect-inet_....changes`  

