#!/bin/sh

# apache2-ddos-protect.sh: block IPs with >4 bad HTTP(S) requests in firewall
# (c) 2015 Jonas Meurer / INTERNET AG <jmeurer@inet.de>
#
# usage:
# apache2-ddos-protect.sh {start|stop}
#
# stop the script with <Ctrl>+<C>

AGGLOG="/tmp/apache2-bad-ips-$(date +%Y%m%d).log"
SLEEP=30

aggregate_ips() {
	# aggregate IPs with bad requests from Apache2 error_log
	echo "DDoS-Protect Info: aggregating IPs from Apache2 error_log"
	tail -f $(apache2-logs.sh error) | \
		sed -ne 's/^.*\[client \([0-9\.]\+\)\].*$/\1/gp' >>$AGGLOG
}

cleanup() {
	echo "STOP"
	if [ -n "$agg_pid" ]; then
		cpids="$(pgrep -P $agg_pid)"
		kill $cpids $child_pid
	else
		echo "DDoS-Protect Error: no child PID detected to kill"
	fi
	exit 0
}

trap 'cleanup' INT QUIT

case "$1" in
  start)
	unset agg_pid
	aggregate_ips &
	agg_pid=$!
	sleep 1

	# block all IPs with >4 bad requests in firewall
	while true; do
		echo "DDoS-Protect Info: sleeping for $SLEEP seconds"
		echo "DDoS-Protect Info: stop the script with <Ctrl>+<C>"
		sleep $SLEEP

		echo "DDoS-Protect Info: blocking IPs with >4 bad requests"
		sort $AGGLOG | uniq -c | sort -rn | grep -v "^\s*[1-4]\s\+" | \
			awk '{print $2}' | xargs -n1 -I{} apache2-block-ip.sh {} block
	done
  ;;
  stop)
	apache2-block-ip.sh 0.0.0.0 stopall
  ;;
  *)
	echo "Error: unknown action: $2" >&2
	echo "Usage: $0 {start|stop}" >&2
	exit 1
  ;;
esac
	
