#!/bin/sh

# apache2-logs.sh: list Apache2 custom/error log files
# (c) 2015 Jonas Meurer / INTERNET AG <jmeurer@inet.de>
#
# usage:
# apache2-logs.sh {custom|error}
#	output a list of all active {custom|error} log files
# apache2-logs.sh
#	output exportable variables $customlogs and $errorlogs with all active log files

conf_custom_logs=""
conf_error_logs=""
lsof_all_logs=""
lsof_custom_logs=""
lsof_error_logs=""

set_conf() {
	if [ -x "/usr/sbin/apache2ctl" ]; then
		actl="/usr/sbin/apache2ctl"
	elif [ -x "/usr/sbin/apachectl" ]; then
		actl="/usr/sbin/apachectl"
	else
		echo "Error: apache2ctl not found" >&2
		exit 1
	fi

	apache_conf_dir="$(apachectl -V | sed -ne 's/^.*HTTPD_ROOT="\(.*\)"$/\1/gp')"
	apache_conf_file="$(apachectl -V | sed -ne 's/^.*SERVER_CONFIG_FILE="\(.*\)"$/\1/gp')"
	apache_log_dir="$(sed -ne 's/^.*APACHE_LOG_DIR=\(.*\)\$SUFFIX$/\1/gp' $apache_conf_dir/envvars)"

	conf_custom_logs="$(grep --exclude-dir=sites-available -rih -e "^\s*CustomLog" $apache_conf_dir | sed -e "s#\${APACHE_LOG_DIR}#$apache_log_dir#g" | sed -e 's/^\s*\w\+Log\s\+\([a-zA-Z0-9\/_\.-]\+\)\s\+.*$/\1/g' | sort | uniq | tr '\n' ' ')"
	conf_error_logs="$(grep --exclude-dir=sites-available -rih -e "^\s*ErrorLog" $apache_conf_dir | sed -e "s#\${APACHE_LOG_DIR}#$apache_log_dir#g" | sed -e 's/^\s*\w\+Log\s\+\([a-zA-Z0-9\/_\.-]\+\)\s*$/\1/g' | sort | uniq | tr '\n' ' ')"
}

set_lsof() {
	lsof_all_logs="$(lsof -nP -c apache2 -c httpd | grep -i log | grep -v "(deleted)" | awk '{print $9}' | sort | uniq | tr '\n' ' ')"
	lsof_custom_logs="$(lsof -nP -c apache2 -c httpd | grep -i log | grep -v "(deleted)" | awk '{print $9}' | sort | uniq | grep -i access | tr '\n' ' ')"
	lsof_error_logs="$(lsof -nP -c apache2 -c httpd | grep -i log | grep -v "(deleted)" | awk '{print $9}' | sort | uniq | grep -i error | tr '\n' ' ')"
}

set_conf
#set_lsof

if [ -z "$1" ]; then
	echo "customlogs=\"$conf_custom_logs\""
	echo "errorlogs=\"$conf_error_logs\""
	#echo "customlogs=\"$lsof_custom_logs\""
	#echo "errorlogs=\"$lsof_error_logs\""
	exit 0
fi

case "$1" in
  custom)
	echo "$conf_custom_logs"
	#echo "$lsof_custom_logs"
	exit 0
  ;;
  error)
	echo "$conf_error_logs"
	#echo "$lsof_error_logs"
	exit 0
  ;;
  *)
	echo "Error: unknown action $1" >&2
	exit 1
  ;;
esac

