// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/monitoring/v3/uptime.proto

package monitoring

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	monitoredres "google.golang.org/genproto/googleapis/api/monitoredres"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The regions from which an Uptime check can be run.
type UptimeCheckRegion int32

const (
	// Default value if no region is specified. Will result in Uptime checks
	// running from all regions.
	UptimeCheckRegion_REGION_UNSPECIFIED UptimeCheckRegion = 0
	// Allows checks to run from locations within the United States of America.
	UptimeCheckRegion_USA UptimeCheckRegion = 1
	// Allows checks to run from locations within the continent of Europe.
	UptimeCheckRegion_EUROPE UptimeCheckRegion = 2
	// Allows checks to run from locations within the continent of South
	// America.
	UptimeCheckRegion_SOUTH_AMERICA UptimeCheckRegion = 3
	// Allows checks to run from locations within the Asia Pacific area (ex:
	// Singapore).
	UptimeCheckRegion_ASIA_PACIFIC UptimeCheckRegion = 4
)

var UptimeCheckRegion_name = map[int32]string{
	0: "REGION_UNSPECIFIED",
	1: "USA",
	2: "EUROPE",
	3: "SOUTH_AMERICA",
	4: "ASIA_PACIFIC",
}

var UptimeCheckRegion_value = map[string]int32{
	"REGION_UNSPECIFIED": 0,
	"USA":                1,
	"EUROPE":             2,
	"SOUTH_AMERICA":      3,
	"ASIA_PACIFIC":       4,
}

func (x UptimeCheckRegion) String() string {
	return proto.EnumName(UptimeCheckRegion_name, int32(x))
}

func (UptimeCheckRegion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{0}
}

// The supported resource types that can be used as values of
// `group_resource.resource_type`.
// `INSTANCE` includes `gce_instance` and `aws_ec2_instance` resource types.
// The resource types `gae_app` and `uptime_url` are not valid here because
// group checks on App Engine modules and URLs are not allowed.
type GroupResourceType int32

const (
	// Default value (not valid).
	GroupResourceType_RESOURCE_TYPE_UNSPECIFIED GroupResourceType = 0
	// A group of instances from Google Cloud Platform (GCP) or
	// Amazon Web Services (AWS).
	GroupResourceType_INSTANCE GroupResourceType = 1
	// A group of Amazon ELB load balancers.
	GroupResourceType_AWS_ELB_LOAD_BALANCER GroupResourceType = 2
)

var GroupResourceType_name = map[int32]string{
	0: "RESOURCE_TYPE_UNSPECIFIED",
	1: "INSTANCE",
	2: "AWS_ELB_LOAD_BALANCER",
}

var GroupResourceType_value = map[string]int32{
	"RESOURCE_TYPE_UNSPECIFIED": 0,
	"INSTANCE":                  1,
	"AWS_ELB_LOAD_BALANCER":     2,
}

func (x GroupResourceType) String() string {
	return proto.EnumName(GroupResourceType_name, int32(x))
}

func (GroupResourceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{1}
}

// Operational states for an internal checker.
type InternalChecker_State int32

const (
	// An internal checker should never be in the unspecified state.
	InternalChecker_UNSPECIFIED InternalChecker_State = 0
	// The checker is being created, provisioned, and configured. A checker in
	// this state can be returned by `ListInternalCheckers` or
	// `GetInternalChecker`, as well as by examining the [long running
	// Operation](https://cloud.google.com/apis/design/design_patterns#long_running_operations)
	// that created it.
	InternalChecker_CREATING InternalChecker_State = 1
	// The checker is running and available for use. A checker in this state
	// can be returned by `ListInternalCheckers` or `GetInternalChecker` as
	// well as by examining the [long running
	// Operation](https://cloud.google.com/apis/design/design_patterns#long_running_operations)
	// that created it.
	// If a checker is being torn down, it is neither visible nor usable, so
	// there is no "deleting" or "down" state.
	InternalChecker_RUNNING InternalChecker_State = 2
)

var InternalChecker_State_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "CREATING",
	2: "RUNNING",
}

var InternalChecker_State_value = map[string]int32{
	"UNSPECIFIED": 0,
	"CREATING":    1,
	"RUNNING":     2,
}

func (x InternalChecker_State) String() string {
	return proto.EnumName(InternalChecker_State_name, int32(x))
}

func (InternalChecker_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{0, 0}
}

// Options to perform content matching.
type UptimeCheckConfig_ContentMatcher_ContentMatcherOption int32

const (
	// No content matcher type specified (maintained for backward
	// compatibility, but deprecated for future use).
	// Treated as `CONTAINS_STRING`.
	UptimeCheckConfig_ContentMatcher_CONTENT_MATCHER_OPTION_UNSPECIFIED UptimeCheckConfig_ContentMatcher_ContentMatcherOption = 0
	// Selects substring matching. The match succeeds if the output contains
	// the `content` string.  This is the default value for checks without
	// a `matcher` option, or where the value of `matcher` is
	// `CONTENT_MATCHER_OPTION_UNSPECIFIED`.
	UptimeCheckConfig_ContentMatcher_CONTAINS_STRING UptimeCheckConfig_ContentMatcher_ContentMatcherOption = 1
	// Selects negation of substring matching. The match succeeds if the
	// output does _NOT_ contain the `content` string.
	UptimeCheckConfig_ContentMatcher_NOT_CONTAINS_STRING UptimeCheckConfig_ContentMatcher_ContentMatcherOption = 2
	// Selects regular-expression matching. The match succeeds of the output
	// matches the regular expression specified in the `content` string.
	UptimeCheckConfig_ContentMatcher_MATCHES_REGEX UptimeCheckConfig_ContentMatcher_ContentMatcherOption = 3
	// Selects negation of regular-expression matching. The match succeeds if
	// the output does _NOT_ match the regular expression specified in the
	// `content` string.
	UptimeCheckConfig_ContentMatcher_NOT_MATCHES_REGEX UptimeCheckConfig_ContentMatcher_ContentMatcherOption = 4
)

var UptimeCheckConfig_ContentMatcher_ContentMatcherOption_name = map[int32]string{
	0: "CONTENT_MATCHER_OPTION_UNSPECIFIED",
	1: "CONTAINS_STRING",
	2: "NOT_CONTAINS_STRING",
	3: "MATCHES_REGEX",
	4: "NOT_MATCHES_REGEX",
}

var UptimeCheckConfig_ContentMatcher_ContentMatcherOption_value = map[string]int32{
	"CONTENT_MATCHER_OPTION_UNSPECIFIED": 0,
	"CONTAINS_STRING":                    1,
	"NOT_CONTAINS_STRING":                2,
	"MATCHES_REGEX":                      3,
	"NOT_MATCHES_REGEX":                  4,
}

func (x UptimeCheckConfig_ContentMatcher_ContentMatcherOption) String() string {
	return proto.EnumName(UptimeCheckConfig_ContentMatcher_ContentMatcherOption_name, int32(x))
}

func (UptimeCheckConfig_ContentMatcher_ContentMatcherOption) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{1, 3, 0}
}

// An internal checker allows Uptime checks to run on private/internal GCP
// resources.
//
// Deprecated: Do not use.
type InternalChecker struct {
	// A unique resource name for this InternalChecker. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/internalCheckers/[INTERNAL_CHECKER_ID]
	//
	// `[PROJECT_ID_OR_NUMBER]` is the Stackdriver Workspace project for the
	// Uptime check config associated with the internal checker.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The checker's human-readable name. The display name
	// should be unique within a Stackdriver Workspace in order to make it easier
	// to identify; however, uniqueness is not enforced.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The [GCP VPC network](https://cloud.google.com/vpc/docs/vpc) where the
	// internal resource lives (ex: "default").
	Network string `protobuf:"bytes,3,opt,name=network,proto3" json:"network,omitempty"`
	// The GCP zone the Uptime check should egress from. Only respected for
	// internal Uptime checks, where internal_network is specified.
	GcpZone string `protobuf:"bytes,4,opt,name=gcp_zone,json=gcpZone,proto3" json:"gcp_zone,omitempty"`
	// The GCP project ID where the internal checker lives. Not necessary
	// the same as the Workspace project.
	PeerProjectId string `protobuf:"bytes,6,opt,name=peer_project_id,json=peerProjectId,proto3" json:"peer_project_id,omitempty"`
	// The current operational state of the internal checker.
	State                InternalChecker_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.monitoring.v3.InternalChecker_State" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *InternalChecker) Reset()         { *m = InternalChecker{} }
func (m *InternalChecker) String() string { return proto.CompactTextString(m) }
func (*InternalChecker) ProtoMessage()    {}
func (*InternalChecker) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{0}
}

func (m *InternalChecker) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InternalChecker.Unmarshal(m, b)
}
func (m *InternalChecker) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InternalChecker.Marshal(b, m, deterministic)
}
func (m *InternalChecker) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InternalChecker.Merge(m, src)
}
func (m *InternalChecker) XXX_Size() int {
	return xxx_messageInfo_InternalChecker.Size(m)
}
func (m *InternalChecker) XXX_DiscardUnknown() {
	xxx_messageInfo_InternalChecker.DiscardUnknown(m)
}

var xxx_messageInfo_InternalChecker proto.InternalMessageInfo

func (m *InternalChecker) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *InternalChecker) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *InternalChecker) GetNetwork() string {
	if m != nil {
		return m.Network
	}
	return ""
}

func (m *InternalChecker) GetGcpZone() string {
	if m != nil {
		return m.GcpZone
	}
	return ""
}

func (m *InternalChecker) GetPeerProjectId() string {
	if m != nil {
		return m.PeerProjectId
	}
	return ""
}

func (m *InternalChecker) GetState() InternalChecker_State {
	if m != nil {
		return m.State
	}
	return InternalChecker_UNSPECIFIED
}

// This message configures which resources and services to monitor for
// availability.
type UptimeCheckConfig struct {
	// A unique resource name for this Uptime check configuration. The format is:
	//
	//      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
	//
	// This field should be omitted when creating the Uptime check configuration;
	// on create, the resource name is assigned by the server and included in the
	// response.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A human-friendly name for the Uptime check configuration. The display name
	// should be unique within a Stackdriver Workspace in order to make it easier
	// to identify; however, uniqueness is not enforced. Required.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The resource the check is checking. Required.
	//
	// Types that are valid to be assigned to Resource:
	//	*UptimeCheckConfig_MonitoredResource
	//	*UptimeCheckConfig_ResourceGroup_
	Resource isUptimeCheckConfig_Resource `protobuf_oneof:"resource"`
	// The type of Uptime check request.
	//
	// Types that are valid to be assigned to CheckRequestType:
	//	*UptimeCheckConfig_HttpCheck_
	//	*UptimeCheckConfig_TcpCheck_
	CheckRequestType isUptimeCheckConfig_CheckRequestType `protobuf_oneof:"check_request_type"`
	// How often, in seconds, the Uptime check is performed.
	// Currently, the only supported values are `60s` (1 minute), `300s`
	// (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
	// defaults to `60s`.
	Period *duration.Duration `protobuf:"bytes,7,opt,name=period,proto3" json:"period,omitempty"`
	// The maximum amount of time to wait for the request to complete (must be
	// between 1 and 60 seconds). Required.
	Timeout *duration.Duration `protobuf:"bytes,8,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// The content that is expected to appear in the data returned by the target
	// server against which the check is run.  Currently, only the first entry
	// in the `content_matchers` list is supported, and additional entries will
	// be ignored. This field is optional and should only be specified if a
	// content match is required as part of the/ Uptime check.
	ContentMatchers []*UptimeCheckConfig_ContentMatcher `protobuf:"bytes,9,rep,name=content_matchers,json=contentMatchers,proto3" json:"content_matchers,omitempty"`
	// The list of regions from which the check will be run.
	// Some regions contain one location, and others contain more than one.
	// If this field is specified, enough regions must be provided to include a
	// minimum of 3 locations.  Not specifying this field will result in Uptime
	// checks running from all available regions.
	SelectedRegions []UptimeCheckRegion `protobuf:"varint,10,rep,packed,name=selected_regions,json=selectedRegions,proto3,enum=google.monitoring.v3.UptimeCheckRegion" json:"selected_regions,omitempty"`
	// If this is `true`, then checks are made only from the 'internal_checkers'.
	// If it is `false`, then checks are made only from the 'selected_regions'.
	// It is an error to provide 'selected_regions' when is_internal is `true`,
	// or to provide 'internal_checkers' when is_internal is `false`.
	IsInternal bool `protobuf:"varint,15,opt,name=is_internal,json=isInternal,proto3" json:"is_internal,omitempty"` // Deprecated: Do not use.
	// The internal checkers that this check will egress from. If `is_internal` is
	// `true` and this list is empty, the check will egress from all the
	// InternalCheckers configured for the project that owns this
	// `UptimeCheckConfig`.
	InternalCheckers     []*InternalChecker `protobuf:"bytes,14,rep,name=internal_checkers,json=internalCheckers,proto3" json:"internal_checkers,omitempty"` // Deprecated: Do not use.
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *UptimeCheckConfig) Reset()         { *m = UptimeCheckConfig{} }
func (m *UptimeCheckConfig) String() string { return proto.CompactTextString(m) }
func (*UptimeCheckConfig) ProtoMessage()    {}
func (*UptimeCheckConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{1}
}

func (m *UptimeCheckConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UptimeCheckConfig.Unmarshal(m, b)
}
func (m *UptimeCheckConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UptimeCheckConfig.Marshal(b, m, deterministic)
}
func (m *UptimeCheckConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UptimeCheckConfig.Merge(m, src)
}
func (m *UptimeCheckConfig) XXX_Size() int {
	return xxx_messageInfo_UptimeCheckConfig.Size(m)
}
func (m *UptimeCheckConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_UptimeCheckConfig.DiscardUnknown(m)
}

var xxx_messageInfo_UptimeCheckConfig proto.InternalMessageInfo

func (m *UptimeCheckConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UptimeCheckConfig) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

type isUptimeCheckConfig_Resource interface {
	isUptimeCheckConfig_Resource()
}

type UptimeCheckConfig_MonitoredResource struct {
	MonitoredResource *monitoredres.MonitoredResource `protobuf:"bytes,3,opt,name=monitored_resource,json=monitoredResource,proto3,oneof"`
}

type UptimeCheckConfig_ResourceGroup_ struct {
	ResourceGroup *UptimeCheckConfig_ResourceGroup `protobuf:"bytes,4,opt,name=resource_group,json=resourceGroup,proto3,oneof"`
}

func (*UptimeCheckConfig_MonitoredResource) isUptimeCheckConfig_Resource() {}

func (*UptimeCheckConfig_ResourceGroup_) isUptimeCheckConfig_Resource() {}

func (m *UptimeCheckConfig) GetResource() isUptimeCheckConfig_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *UptimeCheckConfig) GetMonitoredResource() *monitoredres.MonitoredResource {
	if x, ok := m.GetResource().(*UptimeCheckConfig_MonitoredResource); ok {
		return x.MonitoredResource
	}
	return nil
}

func (m *UptimeCheckConfig) GetResourceGroup() *UptimeCheckConfig_ResourceGroup {
	if x, ok := m.GetResource().(*UptimeCheckConfig_ResourceGroup_); ok {
		return x.ResourceGroup
	}
	return nil
}

type isUptimeCheckConfig_CheckRequestType interface {
	isUptimeCheckConfig_CheckRequestType()
}

type UptimeCheckConfig_HttpCheck_ struct {
	HttpCheck *UptimeCheckConfig_HttpCheck `protobuf:"bytes,5,opt,name=http_check,json=httpCheck,proto3,oneof"`
}

type UptimeCheckConfig_TcpCheck_ struct {
	TcpCheck *UptimeCheckConfig_TcpCheck `protobuf:"bytes,6,opt,name=tcp_check,json=tcpCheck,proto3,oneof"`
}

func (*UptimeCheckConfig_HttpCheck_) isUptimeCheckConfig_CheckRequestType() {}

func (*UptimeCheckConfig_TcpCheck_) isUptimeCheckConfig_CheckRequestType() {}

func (m *UptimeCheckConfig) GetCheckRequestType() isUptimeCheckConfig_CheckRequestType {
	if m != nil {
		return m.CheckRequestType
	}
	return nil
}

func (m *UptimeCheckConfig) GetHttpCheck() *UptimeCheckConfig_HttpCheck {
	if x, ok := m.GetCheckRequestType().(*UptimeCheckConfig_HttpCheck_); ok {
		return x.HttpCheck
	}
	return nil
}

func (m *UptimeCheckConfig) GetTcpCheck() *UptimeCheckConfig_TcpCheck {
	if x, ok := m.GetCheckRequestType().(*UptimeCheckConfig_TcpCheck_); ok {
		return x.TcpCheck
	}
	return nil
}

func (m *UptimeCheckConfig) GetPeriod() *duration.Duration {
	if m != nil {
		return m.Period
	}
	return nil
}

func (m *UptimeCheckConfig) GetTimeout() *duration.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *UptimeCheckConfig) GetContentMatchers() []*UptimeCheckConfig_ContentMatcher {
	if m != nil {
		return m.ContentMatchers
	}
	return nil
}

func (m *UptimeCheckConfig) GetSelectedRegions() []UptimeCheckRegion {
	if m != nil {
		return m.SelectedRegions
	}
	return nil
}

// Deprecated: Do not use.
func (m *UptimeCheckConfig) GetIsInternal() bool {
	if m != nil {
		return m.IsInternal
	}
	return false
}

// Deprecated: Do not use.
func (m *UptimeCheckConfig) GetInternalCheckers() []*InternalChecker {
	if m != nil {
		return m.InternalCheckers
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*UptimeCheckConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*UptimeCheckConfig_MonitoredResource)(nil),
		(*UptimeCheckConfig_ResourceGroup_)(nil),
		(*UptimeCheckConfig_HttpCheck_)(nil),
		(*UptimeCheckConfig_TcpCheck_)(nil),
	}
}

// The resource submessage for group checks. It can be used instead of a
// monitored resource, when multiple resources are being monitored.
type UptimeCheckConfig_ResourceGroup struct {
	// The group of resources being monitored. Should be only the `[GROUP_ID]`,
	// and not the full-path
	// `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
	GroupId string `protobuf:"bytes,1,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	// The resource type of the group members.
	ResourceType         GroupResourceType `protobuf:"varint,2,opt,name=resource_type,json=resourceType,proto3,enum=google.monitoring.v3.GroupResourceType" json:"resource_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UptimeCheckConfig_ResourceGroup) Reset()         { *m = UptimeCheckConfig_ResourceGroup{} }
func (m *UptimeCheckConfig_ResourceGroup) String() string { return proto.CompactTextString(m) }
func (*UptimeCheckConfig_ResourceGroup) ProtoMessage()    {}
func (*UptimeCheckConfig_ResourceGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{1, 0}
}

func (m *UptimeCheckConfig_ResourceGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UptimeCheckConfig_ResourceGroup.Unmarshal(m, b)
}
func (m *UptimeCheckConfig_ResourceGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UptimeCheckConfig_ResourceGroup.Marshal(b, m, deterministic)
}
func (m *UptimeCheckConfig_ResourceGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UptimeCheckConfig_ResourceGroup.Merge(m, src)
}
func (m *UptimeCheckConfig_ResourceGroup) XXX_Size() int {
	return xxx_messageInfo_UptimeCheckConfig_ResourceGroup.Size(m)
}
func (m *UptimeCheckConfig_ResourceGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_UptimeCheckConfig_ResourceGroup.DiscardUnknown(m)
}

var xxx_messageInfo_UptimeCheckConfig_ResourceGroup proto.InternalMessageInfo

func (m *UptimeCheckConfig_ResourceGroup) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

func (m *UptimeCheckConfig_ResourceGroup) GetResourceType() GroupResourceType {
	if m != nil {
		return m.ResourceType
	}
	return GroupResourceType_RESOURCE_TYPE_UNSPECIFIED
}

// Information involved in an HTTP/HTTPS Uptime check request.
type UptimeCheckConfig_HttpCheck struct {
	// If `true`, use HTTPS instead of HTTP to run the check.
	UseSsl bool `protobuf:"varint,1,opt,name=use_ssl,json=useSsl,proto3" json:"use_ssl,omitempty"`
	// Optional (defaults to "/"). The path to the page against which to run
	// the check. Will be combined with the `host` (specified within the
	// `monitored_resource`) and `port` to construct the full URL. If the
	// provided path does not begin with "/", a "/" will be prepended
	// automatically.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Optional (defaults to 80 when `use_ssl` is `false`, and 443 when
	// `use_ssl` is `true`). The TCP port on the HTTP server against which to
	// run the check. Will be combined with host (specified within the
	// `monitored_resource`) and `path` to construct the full URL.
	Port int32 `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`
	// The authentication information. Optional when creating an HTTP check;
	// defaults to empty.
	AuthInfo *UptimeCheckConfig_HttpCheck_BasicAuthentication `protobuf:"bytes,4,opt,name=auth_info,json=authInfo,proto3" json:"auth_info,omitempty"`
	// Boolean specifiying whether to encrypt the header information.
	// Encryption should be specified for any headers related to authentication
	// that you do not wish to be seen when retrieving the configuration. The
	// server will be responsible for encrypting the headers.
	// On Get/List calls, if `mask_headers` is set to `true` then the headers
	// will be obscured with `******.`
	MaskHeaders bool `protobuf:"varint,5,opt,name=mask_headers,json=maskHeaders,proto3" json:"mask_headers,omitempty"`
	// The list of headers to send as part of the Uptime check request.
	// If two headers have the same key and different values, they should
	// be entered as a single header, with the value being a comma-separated
	// list of all the desired values as described at
	// https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
	// Entering two separate headers with the same key in a Create call will
	// cause the first to be overwritten by the second.
	// The maximum number of headers allowed is 100.
	Headers map[string]string `protobuf:"bytes,6,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Boolean specifying whether to include SSL certificate validation as a
	// part of the Uptime check. Only applies to checks where
	// `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`,
	// setting `validate_ssl` to `true` has no effect.
	ValidateSsl          bool     `protobuf:"varint,7,opt,name=validate_ssl,json=validateSsl,proto3" json:"validate_ssl,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UptimeCheckConfig_HttpCheck) Reset()         { *m = UptimeCheckConfig_HttpCheck{} }
func (m *UptimeCheckConfig_HttpCheck) String() string { return proto.CompactTextString(m) }
func (*UptimeCheckConfig_HttpCheck) ProtoMessage()    {}
func (*UptimeCheckConfig_HttpCheck) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{1, 1}
}

func (m *UptimeCheckConfig_HttpCheck) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UptimeCheckConfig_HttpCheck.Unmarshal(m, b)
}
func (m *UptimeCheckConfig_HttpCheck) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UptimeCheckConfig_HttpCheck.Marshal(b, m, deterministic)
}
func (m *UptimeCheckConfig_HttpCheck) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UptimeCheckConfig_HttpCheck.Merge(m, src)
}
func (m *UptimeCheckConfig_HttpCheck) XXX_Size() int {
	return xxx_messageInfo_UptimeCheckConfig_HttpCheck.Size(m)
}
func (m *UptimeCheckConfig_HttpCheck) XXX_DiscardUnknown() {
	xxx_messageInfo_UptimeCheckConfig_HttpCheck.DiscardUnknown(m)
}

var xxx_messageInfo_UptimeCheckConfig_HttpCheck proto.InternalMessageInfo

func (m *UptimeCheckConfig_HttpCheck) GetUseSsl() bool {
	if m != nil {
		return m.UseSsl
	}
	return false
}

func (m *UptimeCheckConfig_HttpCheck) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *UptimeCheckConfig_HttpCheck) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *UptimeCheckConfig_HttpCheck) GetAuthInfo() *UptimeCheckConfig_HttpCheck_BasicAuthentication {
	if m != nil {
		return m.AuthInfo
	}
	return nil
}

func (m *UptimeCheckConfig_HttpCheck) GetMaskHeaders() bool {
	if m != nil {
		return m.MaskHeaders
	}
	return false
}

func (m *UptimeCheckConfig_HttpCheck) GetHeaders() map[string]string {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *UptimeCheckConfig_HttpCheck) GetValidateSsl() bool {
	if m != nil {
		return m.ValidateSsl
	}
	return false
}

// The authentication parameters to provide to the specified resource or
// URL that requires a username and password. Currently, only
// [Basic HTTP authentication](https://tools.ietf.org/html/rfc7617) is
// supported in Uptime checks.
type UptimeCheckConfig_HttpCheck_BasicAuthentication struct {
	// The username to use when authenticating with the HTTP server.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// The password to use when authenticating with the HTTP server.
	Password             string   `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) Reset() {
	*m = UptimeCheckConfig_HttpCheck_BasicAuthentication{}
}
func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) String() string {
	return proto.CompactTextString(m)
}
func (*UptimeCheckConfig_HttpCheck_BasicAuthentication) ProtoMessage() {}
func (*UptimeCheckConfig_HttpCheck_BasicAuthentication) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{1, 1, 0}
}

func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UptimeCheckConfig_HttpCheck_BasicAuthentication.Unmarshal(m, b)
}
func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UptimeCheckConfig_HttpCheck_BasicAuthentication.Marshal(b, m, deterministic)
}
func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UptimeCheckConfig_HttpCheck_BasicAuthentication.Merge(m, src)
}
func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) XXX_Size() int {
	return xxx_messageInfo_UptimeCheckConfig_HttpCheck_BasicAuthentication.Size(m)
}
func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) XXX_DiscardUnknown() {
	xxx_messageInfo_UptimeCheckConfig_HttpCheck_BasicAuthentication.DiscardUnknown(m)
}

var xxx_messageInfo_UptimeCheckConfig_HttpCheck_BasicAuthentication proto.InternalMessageInfo

func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *UptimeCheckConfig_HttpCheck_BasicAuthentication) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

// Information required for a TCP Uptime check request.
type UptimeCheckConfig_TcpCheck struct {
	// The TCP port on the server against which to run the check. Will be
	// combined with host (specified within the `monitored_resource`) to
	// construct the full URL. Required.
	Port                 int32    `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UptimeCheckConfig_TcpCheck) Reset()         { *m = UptimeCheckConfig_TcpCheck{} }
func (m *UptimeCheckConfig_TcpCheck) String() string { return proto.CompactTextString(m) }
func (*UptimeCheckConfig_TcpCheck) ProtoMessage()    {}
func (*UptimeCheckConfig_TcpCheck) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{1, 2}
}

func (m *UptimeCheckConfig_TcpCheck) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UptimeCheckConfig_TcpCheck.Unmarshal(m, b)
}
func (m *UptimeCheckConfig_TcpCheck) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UptimeCheckConfig_TcpCheck.Marshal(b, m, deterministic)
}
func (m *UptimeCheckConfig_TcpCheck) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UptimeCheckConfig_TcpCheck.Merge(m, src)
}
func (m *UptimeCheckConfig_TcpCheck) XXX_Size() int {
	return xxx_messageInfo_UptimeCheckConfig_TcpCheck.Size(m)
}
func (m *UptimeCheckConfig_TcpCheck) XXX_DiscardUnknown() {
	xxx_messageInfo_UptimeCheckConfig_TcpCheck.DiscardUnknown(m)
}

var xxx_messageInfo_UptimeCheckConfig_TcpCheck proto.InternalMessageInfo

func (m *UptimeCheckConfig_TcpCheck) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

// Optional. Used to perform content matching. This allows matching based on
// substrings and regular expressions, together with their negations. Only the
// first 4&nbsp;MB of an HTTP or HTTPS check's response (and the first
// 1&nbsp;MB of a TCP check's response) are examined for purposes of content
// matching.
type UptimeCheckConfig_ContentMatcher struct {
	// String or regex content to match. Maximum 1024 bytes. An empty `content`
	// string indicates no content matching is to be performed.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// The type of content matcher that will be applied to the server output,
	// compared to the `content` string when the check is run.
	Matcher              UptimeCheckConfig_ContentMatcher_ContentMatcherOption `protobuf:"varint,2,opt,name=matcher,proto3,enum=google.monitoring.v3.UptimeCheckConfig_ContentMatcher_ContentMatcherOption" json:"matcher,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                              `json:"-"`
	XXX_unrecognized     []byte                                                `json:"-"`
	XXX_sizecache        int32                                                 `json:"-"`
}

func (m *UptimeCheckConfig_ContentMatcher) Reset()         { *m = UptimeCheckConfig_ContentMatcher{} }
func (m *UptimeCheckConfig_ContentMatcher) String() string { return proto.CompactTextString(m) }
func (*UptimeCheckConfig_ContentMatcher) ProtoMessage()    {}
func (*UptimeCheckConfig_ContentMatcher) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{1, 3}
}

func (m *UptimeCheckConfig_ContentMatcher) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UptimeCheckConfig_ContentMatcher.Unmarshal(m, b)
}
func (m *UptimeCheckConfig_ContentMatcher) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UptimeCheckConfig_ContentMatcher.Marshal(b, m, deterministic)
}
func (m *UptimeCheckConfig_ContentMatcher) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UptimeCheckConfig_ContentMatcher.Merge(m, src)
}
func (m *UptimeCheckConfig_ContentMatcher) XXX_Size() int {
	return xxx_messageInfo_UptimeCheckConfig_ContentMatcher.Size(m)
}
func (m *UptimeCheckConfig_ContentMatcher) XXX_DiscardUnknown() {
	xxx_messageInfo_UptimeCheckConfig_ContentMatcher.DiscardUnknown(m)
}

var xxx_messageInfo_UptimeCheckConfig_ContentMatcher proto.InternalMessageInfo

func (m *UptimeCheckConfig_ContentMatcher) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

func (m *UptimeCheckConfig_ContentMatcher) GetMatcher() UptimeCheckConfig_ContentMatcher_ContentMatcherOption {
	if m != nil {
		return m.Matcher
	}
	return UptimeCheckConfig_ContentMatcher_CONTENT_MATCHER_OPTION_UNSPECIFIED
}

// Contains the region, location, and list of IP
// addresses where checkers in the location run from.
type UptimeCheckIp struct {
	// A broad region category in which the IP address is located.
	Region UptimeCheckRegion `protobuf:"varint,1,opt,name=region,proto3,enum=google.monitoring.v3.UptimeCheckRegion" json:"region,omitempty"`
	// A more specific location within the region that typically encodes
	// a particular city/town/metro (and its containing state/province or country)
	// within the broader umbrella region category.
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// The IP address from which the Uptime check originates. This is a fully
	// specified IP address (not an IP address range). Most IP addresses, as of
	// this publication, are in IPv4 format; however, one should not rely on the
	// IP addresses being in IPv4 format indefinitely, and should support
	// interpreting this field in either IPv4 or IPv6 format.
	IpAddress            string   `protobuf:"bytes,3,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UptimeCheckIp) Reset()         { *m = UptimeCheckIp{} }
func (m *UptimeCheckIp) String() string { return proto.CompactTextString(m) }
func (*UptimeCheckIp) ProtoMessage()    {}
func (*UptimeCheckIp) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ca0e36dfc8221d8, []int{2}
}

func (m *UptimeCheckIp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UptimeCheckIp.Unmarshal(m, b)
}
func (m *UptimeCheckIp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UptimeCheckIp.Marshal(b, m, deterministic)
}
func (m *UptimeCheckIp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UptimeCheckIp.Merge(m, src)
}
func (m *UptimeCheckIp) XXX_Size() int {
	return xxx_messageInfo_UptimeCheckIp.Size(m)
}
func (m *UptimeCheckIp) XXX_DiscardUnknown() {
	xxx_messageInfo_UptimeCheckIp.DiscardUnknown(m)
}

var xxx_messageInfo_UptimeCheckIp proto.InternalMessageInfo

func (m *UptimeCheckIp) GetRegion() UptimeCheckRegion {
	if m != nil {
		return m.Region
	}
	return UptimeCheckRegion_REGION_UNSPECIFIED
}

func (m *UptimeCheckIp) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *UptimeCheckIp) GetIpAddress() string {
	if m != nil {
		return m.IpAddress
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.monitoring.v3.UptimeCheckRegion", UptimeCheckRegion_name, UptimeCheckRegion_value)
	proto.RegisterEnum("google.monitoring.v3.GroupResourceType", GroupResourceType_name, GroupResourceType_value)
	proto.RegisterEnum("google.monitoring.v3.InternalChecker_State", InternalChecker_State_name, InternalChecker_State_value)
	proto.RegisterEnum("google.monitoring.v3.UptimeCheckConfig_ContentMatcher_ContentMatcherOption", UptimeCheckConfig_ContentMatcher_ContentMatcherOption_name, UptimeCheckConfig_ContentMatcher_ContentMatcherOption_value)
	proto.RegisterType((*InternalChecker)(nil), "google.monitoring.v3.InternalChecker")
	proto.RegisterType((*UptimeCheckConfig)(nil), "google.monitoring.v3.UptimeCheckConfig")
	proto.RegisterType((*UptimeCheckConfig_ResourceGroup)(nil), "google.monitoring.v3.UptimeCheckConfig.ResourceGroup")
	proto.RegisterType((*UptimeCheckConfig_HttpCheck)(nil), "google.monitoring.v3.UptimeCheckConfig.HttpCheck")
	proto.RegisterMapType((map[string]string)(nil), "google.monitoring.v3.UptimeCheckConfig.HttpCheck.HeadersEntry")
	proto.RegisterType((*UptimeCheckConfig_HttpCheck_BasicAuthentication)(nil), "google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication")
	proto.RegisterType((*UptimeCheckConfig_TcpCheck)(nil), "google.monitoring.v3.UptimeCheckConfig.TcpCheck")
	proto.RegisterType((*UptimeCheckConfig_ContentMatcher)(nil), "google.monitoring.v3.UptimeCheckConfig.ContentMatcher")
	proto.RegisterType((*UptimeCheckIp)(nil), "google.monitoring.v3.UptimeCheckIp")
}

func init() {
	proto.RegisterFile("google/monitoring/v3/uptime.proto", fileDescriptor_7ca0e36dfc8221d8)
}

var fileDescriptor_7ca0e36dfc8221d8 = []byte{
	// 1307 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0x41, 0x6f, 0x1b, 0xb7,
	0x12, 0xce, 0x4a, 0xb6, 0x24, 0x8f, 0x6c, 0x4b, 0x66, 0x9c, 0x97, 0xb5, 0x00, 0x07, 0x8e, 0x83,
	0x97, 0x67, 0x24, 0x80, 0xf4, 0x62, 0xe1, 0x3d, 0xb4, 0x0a, 0x90, 0x62, 0xa5, 0x6c, 0x6d, 0xa1,
	0xb6, 0x24, 0x50, 0xb2, 0x9b, 0xa6, 0x41, 0x89, 0xcd, 0x8a, 0x96, 0xb6, 0x96, 0x96, 0xdb, 0x25,
	0xd7, 0xa9, 0x63, 0xe4, 0x17, 0xf4, 0xde, 0x7b, 0xaf, 0xf9, 0x1b, 0xbd, 0xf5, 0x2f, 0xf4, 0x1f,
	0xe4, 0xd2, 0x43, 0x2f, 0x3d, 0x16, 0x24, 0x77, 0x65, 0xc9, 0x76, 0x11, 0x3b, 0x37, 0xce, 0x7c,
	0x33, 0x1f, 0x39, 0xc3, 0x99, 0x21, 0xe1, 0xfe, 0x80, 0xb1, 0xc1, 0x88, 0x56, 0xc6, 0xcc, 0xf7,
	0x04, 0x0b, 0x3d, 0x7f, 0x50, 0x39, 0xa9, 0x56, 0xa2, 0x40, 0x78, 0x63, 0x5a, 0x0e, 0x42, 0x26,
	0x18, 0x5a, 0xd5, 0x26, 0xe5, 0x73, 0x93, 0xf2, 0x49, 0xb5, 0xf4, 0x20, 0x76, 0x74, 0x02, 0x2f,
	0x71, 0xa6, 0x7d, 0x12, 0x52, 0xce, 0xa2, 0xd0, 0x8d, 0x5d, 0x4b, 0x6b, 0x53, 0x46, 0x17, 0xa0,
	0x7b, 0x31, 0xa4, 0xa4, 0xd7, 0xd1, 0x51, 0xa5, 0x1f, 0x85, 0x8e, 0xf0, 0x98, 0xaf, 0xf1, 0xcd,
	0x5f, 0x52, 0x50, 0x68, 0xfa, 0x82, 0x86, 0xbe, 0x33, 0x6a, 0x0c, 0xa9, 0x7b, 0x4c, 0x43, 0x84,
	0x60, 0xce, 0x77, 0xc6, 0xd4, 0x34, 0x36, 0x8c, 0xad, 0x05, 0xac, 0xd6, 0xe8, 0x3e, 0x2c, 0xf6,
	0x3d, 0x1e, 0x8c, 0x9c, 0x53, 0xa2, 0xb0, 0x94, 0xc2, 0xf2, 0xb1, 0xae, 0x25, 0x4d, 0x4c, 0xc8,
	0xfa, 0x54, 0xbc, 0x61, 0xe1, 0xb1, 0x99, 0x56, 0x68, 0x22, 0xa2, 0x35, 0xc8, 0x0d, 0xdc, 0x80,
	0xbc, 0x65, 0x3e, 0x35, 0xe7, 0x34, 0x34, 0x70, 0x83, 0x97, 0xcc, 0xa7, 0xe8, 0x21, 0x14, 0x02,
	0x4a, 0x43, 0x12, 0x84, 0xec, 0x7b, 0xea, 0x0a, 0xe2, 0xf5, 0xcd, 0x8c, 0xb2, 0x58, 0x92, 0xea,
	0x8e, 0xd6, 0x36, 0xfb, 0xc8, 0x82, 0x79, 0x2e, 0x1c, 0x41, 0xcd, 0xec, 0x86, 0xb1, 0xb5, 0xbc,
	0xfd, 0xb8, 0x7c, 0x55, 0xb6, 0xca, 0x17, 0x22, 0x29, 0x77, 0xa5, 0x0b, 0xd6, 0x9e, 0x9b, 0x55,
	0x98, 0x57, 0x32, 0x2a, 0x40, 0xfe, 0xa0, 0xd5, 0xed, 0xd8, 0x8d, 0xe6, 0x97, 0x4d, 0xfb, 0x79,
	0xf1, 0x16, 0x5a, 0x84, 0x5c, 0x03, 0xdb, 0x56, 0xaf, 0xd9, 0xda, 0x29, 0x1a, 0x28, 0x0f, 0x59,
	0x7c, 0xd0, 0x6a, 0x49, 0x21, 0x55, 0x4b, 0x99, 0xc6, 0xe6, 0x5f, 0x05, 0x58, 0x39, 0x50, 0x57,
	0xa5, 0x78, 0x1b, 0xcc, 0x3f, 0xf2, 0x06, 0x9f, 0x9a, 0xa5, 0x16, 0xa0, 0xcb, 0xf7, 0xa8, 0x12,
	0x96, 0xdf, 0x5e, 0x4f, 0xa2, 0x72, 0x02, 0xaf, 0xbc, 0x9f, 0x58, 0xe1, 0xd8, 0x68, 0xf7, 0x16,
	0x5e, 0x19, 0x5f, 0x54, 0xa2, 0xef, 0x60, 0x39, 0x61, 0x21, 0x83, 0x90, 0x45, 0x81, 0xca, 0x70,
	0x7e, 0xfb, 0x7f, 0x57, 0x67, 0xe8, 0x52, 0x1c, 0xe5, 0x84, 0x69, 0x47, 0x3a, 0xef, 0xde, 0xc2,
	0x4b, 0xe1, 0xb4, 0x02, 0x61, 0x80, 0xa1, 0x10, 0x01, 0x71, 0xa5, 0x8b, 0x39, 0xaf, 0xb8, 0x9f,
	0x5c, 0x97, 0x7b, 0x57, 0x88, 0x40, 0xc9, 0xbb, 0x06, 0x5e, 0x18, 0x26, 0x02, 0x6a, 0xc3, 0x82,
	0x70, 0x13, 0xca, 0x8c, 0xa2, 0xfc, 0xef, 0x75, 0x29, 0x7b, 0xee, 0x84, 0x31, 0x27, 0xe2, 0x35,
	0x7a, 0x02, 0x99, 0x80, 0x86, 0x1e, 0xeb, 0xab, 0xf2, 0xc8, 0x6f, 0xaf, 0x25, 0x6c, 0x49, 0xd9,
	0x97, 0x9f, 0xc7, 0x65, 0x8f, 0x63, 0x43, 0x54, 0x85, 0xac, 0xa4, 0x66, 0x91, 0x30, 0x73, 0x1f,
	0xf3, 0x49, 0x2c, 0x91, 0x03, 0x45, 0x97, 0xf9, 0x82, 0xfa, 0x82, 0x8c, 0x1d, 0xe1, 0x0e, 0x69,
	0xc8, 0xcd, 0x85, 0x8d, 0xf4, 0x56, 0x7e, 0xfb, 0xff, 0xd7, 0x3d, 0x7f, 0x43, 0xfb, 0xef, 0x6b,
	0x77, 0x5c, 0x70, 0x67, 0x64, 0x8e, 0x30, 0x14, 0x39, 0x1d, 0x51, 0x57, 0xa8, 0xf2, 0x18, 0x78,
	0xcc, 0xe7, 0x26, 0x6c, 0xa4, 0xb7, 0x96, 0xb7, 0xff, 0xf3, 0xd1, 0x2d, 0xb0, 0xb2, 0xc7, 0x85,
	0x84, 0x40, 0xcb, 0x1c, 0x3d, 0x80, 0xbc, 0xc7, 0x89, 0x17, 0x37, 0x87, 0x59, 0xd8, 0x30, 0xb6,
	0x72, 0xf5, 0x94, 0x69, 0x60, 0xf0, 0x78, 0xd2, 0x32, 0xe8, 0x10, 0x56, 0x12, 0x0b, 0x7d, 0x33,
	0x32, 0xb8, 0x65, 0x15, 0xdc, 0xbf, 0xaf, 0xd5, 0x6d, 0x8a, 0xb1, 0xe8, 0xcd, 0x2a, 0x79, 0xe9,
	0x47, 0x58, 0x9a, 0x29, 0x31, 0x35, 0x0d, 0xe4, 0x42, 0xf6, 0xba, 0x11, 0x4f, 0x03, 0x29, 0x37,
	0xfb, 0x68, 0x0f, 0x26, 0xd5, 0x47, 0xc4, 0x69, 0xa0, 0x1b, 0xe8, 0x1f, 0x23, 0x57, 0x74, 0x09,
	0x77, 0xef, 0x34, 0xa0, 0x78, 0x31, 0x9c, 0x92, 0x4a, 0xbf, 0xa7, 0x61, 0x61, 0x52, 0x81, 0xe8,
	0x2e, 0x64, 0x23, 0x4e, 0x09, 0xe7, 0x23, 0xb5, 0x6b, 0x0e, 0x67, 0x22, 0x4e, 0xbb, 0x7c, 0x24,
	0x1b, 0x39, 0x70, 0xc4, 0x30, 0x6e, 0x56, 0xb5, 0x56, 0x3a, 0x16, 0x0a, 0xd5, 0x97, 0xf3, 0x58,
	0xad, 0xd1, 0x6b, 0x58, 0x70, 0x22, 0x31, 0x24, 0x9e, 0x7f, 0xc4, 0xe2, 0x26, 0xb3, 0x6f, 0xdc,
	0x08, 0xe5, 0xba, 0xc3, 0x3d, 0xd7, 0x8a, 0xc4, 0x90, 0xfa, 0xc2, 0x73, 0x75, 0x7d, 0xe5, 0x24,
	0x6f, 0xd3, 0x3f, 0x62, 0x72, 0x80, 0x8c, 0x1d, 0x7e, 0x4c, 0x86, 0xd4, 0xe9, 0xcb, 0xfc, 0xcf,
	0xab, 0x93, 0xe6, 0xa5, 0x6e, 0x57, 0xab, 0xd0, 0x0b, 0xc8, 0x26, 0x68, 0x46, 0xdd, 0xce, 0xb3,
	0x9b, 0x1f, 0x22, 0xe6, 0xb2, 0x7d, 0x11, 0x9e, 0xe2, 0x84, 0x4e, 0x6e, 0x7e, 0xe2, 0x8c, 0xbc,
	0xbe, 0x23, 0x74, 0x9a, 0xb2, 0x7a, 0xf3, 0x44, 0xd7, 0xe5, 0xa3, 0xd2, 0x3e, 0xdc, 0xbe, 0x22,
	0x00, 0x54, 0x82, 0x5c, 0xc4, 0xe5, 0xb5, 0x4f, 0xe6, 0xe1, 0x44, 0x96, 0x58, 0xe0, 0x70, 0xfe,
	0x86, 0x85, 0xfd, 0x38, 0xc5, 0x13, 0xb9, 0x54, 0x83, 0xc5, 0xe9, 0xa3, 0xa0, 0x22, 0xa4, 0x8f,
	0xe9, 0x69, 0x4c, 0x21, 0x97, 0x68, 0x15, 0xe6, 0x4f, 0x9c, 0x51, 0x94, 0x8c, 0x52, 0x2d, 0xd4,
	0x52, 0x9f, 0x19, 0xa5, 0x7b, 0x90, 0x4b, 0x66, 0xc1, 0xe4, 0xba, 0x8c, 0xf3, 0xeb, 0x2a, 0xbd,
	0x4f, 0xc1, 0xf2, 0x6c, 0xb3, 0xc9, 0x17, 0x2a, 0x6e, 0xb7, 0xa4, 0xf0, 0x62, 0x11, 0x51, 0xc8,
	0xc6, 0x0d, 0x1d, 0x97, 0xdc, 0x57, 0x9f, 0xd6, 0xcf, 0x17, 0xc4, 0x76, 0xa0, 0xe7, 0x47, 0xcc,
	0xbd, 0xf9, 0xb3, 0x01, 0xab, 0x57, 0x59, 0xa0, 0x87, 0xb0, 0xd9, 0x68, 0xb7, 0x7a, 0x76, 0xab,
	0x47, 0xf6, 0xad, 0x5e, 0x63, 0xd7, 0xc6, 0xa4, 0xdd, 0xe9, 0x35, 0xdb, 0x2d, 0x32, 0xfb, 0x52,
	0xdd, 0x86, 0x82, 0xb4, 0xb3, 0x9a, 0xad, 0x2e, 0xe9, 0xf6, 0xb0, 0x7e, 0xb0, 0xee, 0xc2, 0xed,
	0x56, 0xbb, 0x47, 0x2e, 0x02, 0x29, 0xb4, 0x02, 0x4b, 0x9a, 0xad, 0x4b, 0xb0, 0xbd, 0x63, 0xbf,
	0x28, 0xa6, 0xd1, 0x1d, 0x58, 0x91, 0xb6, 0xb3, 0xea, 0xb9, 0xda, 0x9f, 0xc6, 0x07, 0xeb, 0x0f,
	0x03, 0x1e, 0x4f, 0x45, 0xab, 0xe3, 0x77, 0x02, 0x8f, 0x97, 0x5d, 0x36, 0xae, 0x5c, 0x7e, 0x00,
	0x9f, 0xc6, 0x6f, 0x36, 0xaf, 0x9c, 0xc5, 0xab, 0x77, 0xf1, 0x8f, 0x66, 0xca, 0x8a, 0x57, 0xce,
	0xb4, 0x4e, 0xcf, 0x14, 0xe2, 0x2a, 0xed, 0x3b, 0x64, 0xb3, 0x70, 0xe0, 0xf8, 0xde, 0x5b, 0x55,
	0x3f, 0xbc, 0x72, 0x36, 0x2d, 0xde, 0x80, 0xe6, 0xf3, 0x23, 0x36, 0x92, 0xe5, 0x53, 0x39, 0xd3,
	0x8b, 0x1b, 0xb8, 0x1a, 0x8f, 0xea, 0x00, 0xb9, 0x64, 0x60, 0xd4, 0x57, 0x01, 0x69, 0x3c, 0xa4,
	0x3f, 0x44, 0x94, 0x0b, 0x35, 0x7f, 0x36, 0x7f, 0x32, 0x60, 0x69, 0x2a, 0xf2, 0x66, 0x80, 0xbe,
	0x80, 0x8c, 0x1e, 0xcb, 0xaa, 0x84, 0x6e, 0x30, 0x95, 0x63, 0x37, 0xd9, 0x0f, 0x23, 0xa6, 0xfb,
	0x26, 0xe9, 0x87, 0x44, 0x46, 0xeb, 0x00, 0x5e, 0x40, 0x9c, 0x7e, 0x3f, 0xa4, 0x9c, 0xc7, 0xbf,
	0xa8, 0x05, 0x2f, 0xb0, 0xb4, 0xe2, 0x11, 0x9d, 0xf9, 0x87, 0x68, 0x5e, 0xf4, 0x2f, 0x40, 0xd8,
	0xde, 0xb9, 0x5c, 0x2a, 0x59, 0x48, 0x1f, 0x74, 0xad, 0xa2, 0x81, 0x00, 0x32, 0xf6, 0x01, 0x6e,
	0x77, 0x6c, 0x5d, 0x11, 0xdd, 0xf6, 0x41, 0x6f, 0x97, 0x58, 0xfb, 0x36, 0x6e, 0x36, 0xac, 0x62,
	0x1a, 0x15, 0x61, 0xd1, 0xea, 0x36, 0x2d, 0xd2, 0xb1, 0xa4, 0x6b, 0xa3, 0x38, 0xf7, 0xe8, 0x5b,
	0x58, 0xb9, 0x34, 0x5a, 0xd1, 0x3a, 0xac, 0x61, 0xbb, 0xdb, 0x3e, 0xc0, 0x0d, 0x9b, 0xf4, 0xbe,
	0xe9, 0xd8, 0xe4, 0xd2, 0x17, 0xaa, 0xd9, 0xea, 0xf6, 0xac, 0x56, 0xc3, 0x2e, 0x1a, 0x68, 0x0d,
	0xee, 0x58, 0x5f, 0x77, 0x89, 0xbd, 0x57, 0x27, 0x7b, 0x6d, 0xeb, 0x39, 0xa9, 0x5b, 0x7b, 0x12,
	0xc1, 0xc5, 0x54, 0xfd, 0x57, 0x03, 0x4c, 0x97, 0x8d, 0xaf, 0xcc, 0x5a, 0x3d, 0xaf, 0xc3, 0xeb,
	0xc8, 0x17, 0xb8, 0x63, 0xbc, 0x7c, 0x16, 0x1b, 0x0d, 0xd8, 0xc8, 0xf1, 0x07, 0x65, 0x16, 0x0e,
	0x2a, 0x03, 0xea, 0xab, 0xf7, 0xb9, 0x72, 0x5e, 0x9e, 0xb3, 0x9f, 0xea, 0xa7, 0xe7, 0xd2, 0xfb,
	0x54, 0x69, 0x47, 0x13, 0x34, 0x46, 0x2c, 0xea, 0x27, 0x3f, 0x2a, 0xb9, 0xd7, 0x61, 0xf5, 0xb7,
	0x04, 0x7c, 0xa5, 0xc0, 0x57, 0xe7, 0xe0, 0xab, 0xc3, 0xea, 0x87, 0xd4, 0xba, 0x06, 0x6b, 0x35,
	0x85, 0xd6, 0x6a, 0xe7, 0x70, 0xad, 0x76, 0x58, 0x7d, 0x9d, 0x51, 0x87, 0xa8, 0xfe, 0x1d, 0x00,
	0x00, 0xff, 0xff, 0x2f, 0x24, 0x34, 0xbc, 0xd8, 0x0b, 0x00, 0x00,
}
