#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Silence
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240901.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='silence'
GAME_NAME='Silence'

ARCHIVE_BASE_0_NAME='gog_silence_2.1.0.3.sh'
ARCHIVE_BASE_0_MD5='e00082adcfa826eae91b9d92a386f0d5'
ARCHIVE_BASE_0_SIZE='7400000'
ARCHIVE_BASE_0_VERSION='1.2.20280-gog2.1.0.3'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/silence'

UNITY3D_NAME='Silence'

CONTENT_PATH_DEFAULT='data/noarch/game'
## TODO: An explicit list of plugins to include should be set using UNITY3D_PLUGINS
CONTENT_GAME0_BIN64_FILES="
${UNITY3D_NAME}_Data/Plugins/x86_64"
CONTENT_GAME0_BIN32_FILES="
${UNITY3D_NAME}_Data/Plugins/x86"

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXcursor.so.1
libXrandr.so.2'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	## Drop Steam-specific plugin
	## TODO: This should be dropped in favour of UNITY3D_PLUGINS
	rm \
		"$(unity3d_name)_Data/Plugins/x86/libDaedalic.Ecosystems.Steam.External.so" \
		"$(unity3d_name)_Data/Plugins/x86_64/libDaedalic.Ecosystems.Steam.External.so"
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
