#include "update.h"


extern "C" {
#if defined(__WINDOWS__)
#include "avrdude/libavrdude.h"
#else
#include "libavrdude.h"
#endif
/*

#include "avrdude/avrdude.h"
#include "avrdude/avr.h"
#include "avrdude/config.h"
#include "avrdude/confwin.h"
#include "avrdude/fileio.h"
#include "avrdude/lists.h"
#include "avrdude/par.h"
#include "avrdude/pindefs.h"
#include "avrdude/term.h"
#include "avrdude/safemode.h"
#include "avrdude/update.h"
#include "avrdude/usbasp.h"
#include "avrdude/avrpart.h"
#include "avrdude/update.h"
*/
}

namespace avrdude {

class UpdatePrivate {
  public:
    UPDATE * update;
};


Update::Update(int op, const std::string & memtype, int filefmt, const std::string & filename) {
  priv = new UpdatePrivate;
  priv->update = ::new_update(op, (char *)memtype.c_str(), filefmt, (char *)filename.c_str());
}

Update::Update(Update & update) {
  priv = new UpdatePrivate;
  priv->update = ::dup_update(update.priv->update);
}

Update::~Update() {
  delete priv;
}

Update * Update::clone() {
  return new Update(*this);
}

void * Update::getPointer() {
  return priv->update;
}

}
