// Copyright (c) 2013, Fabrice Robinet
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#ifndef __GLTF_WEBGL_1_0_PROFILE__
#define __GLTF_WEBGL_1_0_PROFILE__


namespace GLTF
{
    class GLTFWebGL_1_0_Profile : public GLTFProfile
    {
    public:
        GLTFWebGL_1_0_Profile();
        virtual ~GLTFWebGL_1_0_Profile();

        std::string id();
        unsigned int getGLTypeForComponentTypeAndType(const std::string& componentType, const std::string& type);
        std::string getGLSLTypeForGLType(unsigned int glType);
        size_t getComponentsCountForGLType(unsigned int glType);
        size_t sizeOfGLType(unsigned int glType);
        unsigned int getGLComponentTypeForGLType(unsigned int glType);
        std::string getTypeForGLType(unsigned int glType);
        virtual std::shared_ptr<JSONValue> defaultValueForState(const std::string& state);
        virtual bool isDefaultValueForState(const std::string& state, std::shared_ptr<JSONValue> value);
    private:
        std::shared_ptr <JSONObject> _defaultValues;
    };
}

#endif