/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __sine_mixer
#define __sine_mixer

#include "box.h"
#include "levels.h"
#include "ui.h"
#include "multi_curve.h"

#include <vector>

struct sine_mixer : ui {

  static const float pi;

  static int NUM_SINE_SAMPLES;
  static const int MIN_SINE_SAMPLES = 4;
  static void set_sine_samples (int s);

  int nharmonics;
  std::vector< std::vector<float> > harmonics;

  // output
  std::vector<float> nonorm, norm;
  void normalise ();

  levels sine_levels;

  sine_mixer ();
  ~sine_mixer ();

  void draw ();
  bool handle_input ();

  void prep_harmonics ();
  void num_harmonics (int n);
  void mix ();
  void make_curve (multi_curve& c);

};

#endif
