/* ev-color-contrast.h
 *  this file is part of evince, a gnome document viewer
 *
 * Copyright (C) 2020 Vanadiae <vanadiae35@gmail.com>
 *
 * Evince is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Evince is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#if !defined (EVINCE_COMPILATION)
#error "This is a private header."
#endif

#ifndef __EV_COLOR_CONTRAST_H__
#define __EV_COLOR_CONTRAST_H__

#include <gdk/gdk.h>

GdkRGBA  *ev_color_contrast_get_most_readable_color   (const GdkRGBA *bg_color,
						       GdkRGBA *first_color,
						       GdkRGBA *second_color);

GdkRGBA  *ev_color_contrast_get_best_foreground_color (const GdkRGBA *bg_color);

#endif /* __EV_COLOR_CONTRAST_H__ */
