Gradle Script Kotlin 0.1.0 Release Notes
========================================

_**UPDATE 2016.06.20**: Gradle Script Kotlin version `1.0 M1` has been renamed to version `0.1.0`. This change is being made to accommodate more frequent feature and patch releases on the road to `1.0` GA. Note that names and versions of published artifacts have not changed. Only the tag and release notes themselves have been updated for consistency and continuity with future `0.*` pre-releases._

_**UPDATE 2016.06.09**: Gradle [`3.0 M1`](https://github.com/gradle/gradle/releases/tag/v3.0.0-M1) has been released, including within it Gradle Script Kotlin `1.0 M1`. This means it is no longer necessary to work with a custom Gradle distribution, and Kotlin scripting is available "out of the box". The instructions below have been updated to reflect._


General Notes
-------------

With this first pre-release, Gradle users can now write their build scripts in [Kotlin](http://kotlinlang.org).

Such scripts may technically have any name ending in `.kts`, but users may want to consider naming them `*.gradle.kts` by convention. For example: `build.gradle.kts`.

See the [samples][1] for a complete getting started experience and examples of each of the following features.

Gradle Script Kotlin 0.1.0 is available for use within Gradle 3.0 M1. To use it, upgrade your Gradle wrapper to `3.0-milestone-1` in the following fashion:

    $ cd $YOUR_PROJECT_ROOT
    $ gradle wrapper --gradle-version 3.0-milestone-1

With this wrapper in place and pointing to the custom distribution, you'll be able work with a Kotlin-based build as follows:

    $ ./gradlew -b build.gradle.kts yourTask

Note that each of the samples are configured with a wrapper as per the instructions above, and this is why they "just work".


Initial Features
----------------

 * Tasks can be declared using the lightweight `task` function.

 * Core Gradle plugins, e.g. `JavaPlugin` and `ApplicationPlugin` can be applied using `apply<PluginType>()`. Resolving and applying external plugins is not yet supported, see Limitations.

 * Plugins that publish an associated "convention" objects can be configured using `configure<ConventionType>() { ... }`.

 * Build scripts can be modularized using `applyFrom("other.kts")`, and the target script to be applied may be Groovy or Kotlin-based, opening up opportunities for incremental migration. The same is true from the Groovy side: `apply from: "other.gradle"` may refer to either Groovy or Kotlin-based scripts.

 * Repositories may be declared using `repositories { ... }`

 * Dependencies may be declared using `dependencies { ... }` and individual dependency declarations following the form `"compile"("group:artifact:1.0")`.

 * A variety of tooling use cases work as expected within IDEA (2016.1.2 or better), including:

   - Project import (a `settings.gradle` file is required, see Limitations)

   - Quick documentation with `F1`/`CTRL-J`

   - Navigation to source with `CMD-B`

   - Auto-completion / content-assist with `CTRL-SPACE`

   - Refactoring actions

   For best results within IDEA, follow the setup instructions in the [samples][1] README.


Limitations
-----------

 * `settings.gradle` cannot yet be written Kotlin, continue to use Groovy there for now.

 * Gradle does not yet have auto-detection of Kotlin-based build scripts, meaning you must either:

   a. use `gradle -b build.gradle.kts`, or

   b. add `rootProject.buildFileName='build.gradle.kts'` to your `settings.gradle` file.

   Due to this limitation, importing projects into IDEA currently requires the presence of a `settings.gradle` in order for IDEA to recognize the project as a Gradle project

 * There is not yet support for additions to the `buildscript` classpath. This means that there there is not yet support for resolving external plugins. Naturally, this is a high priority for the next milestone.

 * For a complete, error-free experience in IDEA, it is necessary to run `./gradlew generateKtsConfig` _prior_ to importing your project into IDEA, and it is necessary to run `./gradlew patchIdeaConfig` _after_ importing your project. Both of these workarounds will be unnecessary in future milestones. See the the [samples][1] README for step-by-step instructions on how to do this.

 * There is not yet any support for caching Kotlin-based build scripts, meaning that they must be compiled on every build. For this reason, expect most simple Kotlin-based builds to be marginally slower that an equivalent Groovy-based build.

[1]: https://github.com/gradle/gradle-script-kotlin/tree/v0.1.0/samples
