#! /bin/sh

# Find COD record counts by year

set -ue

BASENAME=$(basename $0 .com)

OUTPUT_DAT=outputs/${BASENAME}.dat

set -x

YEAR_NOW=$(date +%Y)

set +x

echo "# year\tCOD records" > ${OUTPUT_DAT}

for YEAR in $(seq 2008 $YEAR_NOW)
do
    echo $YEAR"\t"$(svn list -R -r{$YEAR-01-01} \
        svn://www.crystallography.net/cod/cif \
        | grep '\.cif$' | wc -l)
done \
| tee -a ${OUTPUT_DAT}
