/*
* @license Apache-2.0
*
* Copyright (c) 2022 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

import function2string = require( './index' );


// TESTS //

// The function returns a string...
{
	function2string( function add( x: number, y: number ): number { return x + y; } ); // $ExpectType string
}

// The compiler throws an error if the function is not provided a function...
{
	function2string( 'abc' ); // $ExpectError
	function2string( 5 ); // $ExpectError
	function2string( true ); // $ExpectError
	function2string( false ); // $ExpectError
	function2string( [] ); // $ExpectError
	function2string( {} ); // $ExpectError
}

// The compiler throws an error if the function is provided an unsupported number of arguments...
{
	function2string(); // $ExpectError
	function2string( function add( x: number, y: number ): number { return x + y; }, {} ); // $ExpectError
}
