module.exports = {
	'aliasToProperty': new Map([
		['cjkaccountingnumeric', 'kAccountingNumeric'],
		['kaccountingnumeric', 'kAccountingNumeric'],
		['cjkothernumeric', 'kOtherNumeric'],
		['kothernumeric', 'kOtherNumeric'],
		['cjkprimarynumeric', 'kPrimaryNumeric'],
		['kprimarynumeric', 'kPrimaryNumeric'],
		['nv', 'Numeric_Value'],
		['numericvalue', 'Numeric_Value'],
		['cf', 'Case_Folding'],
		['casefolding', 'Case_Folding'],
		['cjkcompatibilityvariant', 'kCompatibilityVariant'],
		['kcompatibilityvariant', 'kCompatibilityVariant'],
		['dm', 'Decomposition_Mapping'],
		['decompositionmapping', 'Decomposition_Mapping'],
		['fcnfkc', 'FC_NFKC_Closure'],
		['fcnfkcclosure', 'FC_NFKC_Closure'],
		['lc', 'Lowercase_Mapping'],
		['lowercasemapping', 'Lowercase_Mapping'],
		['nfkccf', 'NFKC_Casefold'],
		['nfkccasefold', 'NFKC_Casefold'],
		['scf', 'Simple_Case_Folding'],
		['simplecasefolding', 'Simple_Case_Folding'],
		['sfc', 'Simple_Case_Folding'],
		['slc', 'Simple_Lowercase_Mapping'],
		['simplelowercasemapping', 'Simple_Lowercase_Mapping'],
		['stc', 'Simple_Titlecase_Mapping'],
		['simpletitlecasemapping', 'Simple_Titlecase_Mapping'],
		['suc', 'Simple_Uppercase_Mapping'],
		['simpleuppercasemapping', 'Simple_Uppercase_Mapping'],
		['tc', 'Titlecase_Mapping'],
		['titlecasemapping', 'Titlecase_Mapping'],
		['uc', 'Uppercase_Mapping'],
		['uppercasemapping', 'Uppercase_Mapping'],
		['bmg', 'Bidi_Mirroring_Glyph'],
		['bidimirroringglyph', 'Bidi_Mirroring_Glyph'],
		['bpb', 'Bidi_Paired_Bracket'],
		['bidipairedbracket', 'Bidi_Paired_Bracket'],
		['cjkiicore', 'kIICore'],
		['kiicore', 'kIICore'],
		['cjkirggsource', 'kIRG_GSource'],
		['kirggsource', 'kIRG_GSource'],
		['cjkirghsource', 'kIRG_HSource'],
		['kirghsource', 'kIRG_HSource'],
		['cjkirgjsource', 'kIRG_JSource'],
		['kirgjsource', 'kIRG_JSource'],
		['cjkirgkpsource', 'kIRG_KPSource'],
		['kirgkpsource', 'kIRG_KPSource'],
		['cjkirgksource', 'kIRG_KSource'],
		['kirgksource', 'kIRG_KSource'],
		['cjkirgmsource', 'kIRG_MSource'],
		['kirgmsource', 'kIRG_MSource'],
		['cjkirgtsource', 'kIRG_TSource'],
		['kirgtsource', 'kIRG_TSource'],
		['cjkirgusource', 'kIRG_USource'],
		['kirgusource', 'kIRG_USource'],
		['cjkirgvsource', 'kIRG_VSource'],
		['kirgvsource', 'kIRG_VSource'],
		['cjkrsunicode', 'kRSUnicode'],
		['krsunicode', 'kRSUnicode'],
		['unicoderadicalstroke', 'kRSUnicode'],
		['urs', 'kRSUnicode'],
		['equideo', 'Equivalent_Unified_Ideograph'],
		['equivalentunifiedideograph', 'Equivalent_Unified_Ideograph'],
		['isc', 'ISO_Comment'],
		['isocomment', 'ISO_Comment'],
		['jsn', 'Jamo_Short_Name'],
		['jamoshortname', 'Jamo_Short_Name'],
		['na', 'Name'],
		['name', 'Name'],
		['na1', 'Unicode_1_Name'],
		['unicode1name', 'Unicode_1_Name'],
		['namealias', 'Name_Alias'],
		['scx', 'Script_Extensions'],
		['scriptextensions', 'Script_Extensions'],
		['age', 'Age'],
		['blk', 'Block'],
		['block', 'Block'],
		['sc', 'Script'],
		['script', 'Script'],
		['bc', 'Bidi_Class'],
		['bidiclass', 'Bidi_Class'],
		['bpt', 'Bidi_Paired_Bracket_Type'],
		['bidipairedbrackettype', 'Bidi_Paired_Bracket_Type'],
		['ccc', 'Canonical_Combining_Class'],
		['canonicalcombiningclass', 'Canonical_Combining_Class'],
		['dt', 'Decomposition_Type'],
		['decompositiontype', 'Decomposition_Type'],
		['ea', 'East_Asian_Width'],
		['eastasianwidth', 'East_Asian_Width'],
		['gc', 'General_Category'],
		['generalcategory', 'General_Category'],
		['gcb', 'Grapheme_Cluster_Break'],
		['graphemeclusterbreak', 'Grapheme_Cluster_Break'],
		['hst', 'Hangul_Syllable_Type'],
		['hangulsyllabletype', 'Hangul_Syllable_Type'],
		['inpc', 'Indic_Positional_Category'],
		['indicpositionalcategory', 'Indic_Positional_Category'],
		['insc', 'Indic_Syllabic_Category'],
		['indicsyllabiccategory', 'Indic_Syllabic_Category'],
		['jg', 'Joining_Group'],
		['joininggroup', 'Joining_Group'],
		['jt', 'Joining_Type'],
		['joiningtype', 'Joining_Type'],
		['lb', 'Line_Break'],
		['linebreak', 'Line_Break'],
		['nfcqc', 'NFC_Quick_Check'],
		['nfcquickcheck', 'NFC_Quick_Check'],
		['nfdqc', 'NFD_Quick_Check'],
		['nfdquickcheck', 'NFD_Quick_Check'],
		['nfkcqc', 'NFKC_Quick_Check'],
		['nfkcquickcheck', 'NFKC_Quick_Check'],
		['nfkdqc', 'NFKD_Quick_Check'],
		['nfkdquickcheck', 'NFKD_Quick_Check'],
		['nt', 'Numeric_Type'],
		['numerictype', 'Numeric_Type'],
		['sb', 'Sentence_Break'],
		['sentencebreak', 'Sentence_Break'],
		['vo', 'Vertical_Orientation'],
		['verticalorientation', 'Vertical_Orientation'],
		['wb', 'Word_Break'],
		['wordbreak', 'Word_Break'],
		['ahex', 'ASCII_Hex_Digit'],
		['asciihexdigit', 'ASCII_Hex_Digit'],
		['alpha', 'Alphabetic'],
		['alphabetic', 'Alphabetic'],
		['bidic', 'Bidi_Control'],
		['bidicontrol', 'Bidi_Control'],
		['bidim', 'Bidi_Mirrored'],
		['bidimirrored', 'Bidi_Mirrored'],
		['cased', 'Cased'],
		['ce', 'Composition_Exclusion'],
		['compositionexclusion', 'Composition_Exclusion'],
		['ci', 'Case_Ignorable'],
		['caseignorable', 'Case_Ignorable'],
		['compex', 'Full_Composition_Exclusion'],
		['fullcompositionexclusion', 'Full_Composition_Exclusion'],
		['cwcf', 'Changes_When_Casefolded'],
		['changeswhencasefolded', 'Changes_When_Casefolded'],
		['cwcm', 'Changes_When_Casemapped'],
		['changeswhencasemapped', 'Changes_When_Casemapped'],
		['cwkcf', 'Changes_When_NFKC_Casefolded'],
		['changeswhennfkccasefolded', 'Changes_When_NFKC_Casefolded'],
		['cwl', 'Changes_When_Lowercased'],
		['changeswhenlowercased', 'Changes_When_Lowercased'],
		['cwt', 'Changes_When_Titlecased'],
		['changeswhentitlecased', 'Changes_When_Titlecased'],
		['cwu', 'Changes_When_Uppercased'],
		['changeswhenuppercased', 'Changes_When_Uppercased'],
		['dash', 'Dash'],
		['dep', 'Deprecated'],
		['deprecated', 'Deprecated'],
		['di', 'Default_Ignorable_Code_Point'],
		['defaultignorablecodepoint', 'Default_Ignorable_Code_Point'],
		['dia', 'Diacritic'],
		['diacritic', 'Diacritic'],
		['ext', 'Extender'],
		['extender', 'Extender'],
		['grbase', 'Grapheme_Base'],
		['graphemebase', 'Grapheme_Base'],
		['grext', 'Grapheme_Extend'],
		['graphemeextend', 'Grapheme_Extend'],
		['grlink', 'Grapheme_Link'],
		['graphemelink', 'Grapheme_Link'],
		['hex', 'Hex_Digit'],
		['hexdigit', 'Hex_Digit'],
		['hyphen', 'Hyphen'],
		['idc', 'ID_Continue'],
		['idcontinue', 'ID_Continue'],
		['ideo', 'Ideographic'],
		['ideographic', 'Ideographic'],
		['ids', 'ID_Start'],
		['idstart', 'ID_Start'],
		['idsb', 'IDS_Binary_Operator'],
		['idsbinaryoperator', 'IDS_Binary_Operator'],
		['idst', 'IDS_Trinary_Operator'],
		['idstrinaryoperator', 'IDS_Trinary_Operator'],
		['joinc', 'Join_Control'],
		['joincontrol', 'Join_Control'],
		['loe', 'Logical_Order_Exception'],
		['logicalorderexception', 'Logical_Order_Exception'],
		['lower', 'Lowercase'],
		['lowercase', 'Lowercase'],
		['math', 'Math'],
		['nchar', 'Noncharacter_Code_Point'],
		['noncharactercodepoint', 'Noncharacter_Code_Point'],
		['oalpha', 'Other_Alphabetic'],
		['otheralphabetic', 'Other_Alphabetic'],
		['odi', 'Other_Default_Ignorable_Code_Point'],
		['otherdefaultignorablecodepoint', 'Other_Default_Ignorable_Code_Point'],
		['ogrext', 'Other_Grapheme_Extend'],
		['othergraphemeextend', 'Other_Grapheme_Extend'],
		['oidc', 'Other_ID_Continue'],
		['otheridcontinue', 'Other_ID_Continue'],
		['oids', 'Other_ID_Start'],
		['otheridstart', 'Other_ID_Start'],
		['olower', 'Other_Lowercase'],
		['otherlowercase', 'Other_Lowercase'],
		['omath', 'Other_Math'],
		['othermath', 'Other_Math'],
		['oupper', 'Other_Uppercase'],
		['otheruppercase', 'Other_Uppercase'],
		['patsyn', 'Pattern_Syntax'],
		['patternsyntax', 'Pattern_Syntax'],
		['patws', 'Pattern_White_Space'],
		['patternwhitespace', 'Pattern_White_Space'],
		['pcm', 'Prepended_Concatenation_Mark'],
		['prependedconcatenationmark', 'Prepended_Concatenation_Mark'],
		['qmark', 'Quotation_Mark'],
		['quotationmark', 'Quotation_Mark'],
		['radical', 'Radical'],
		['ri', 'Regional_Indicator'],
		['regionalindicator', 'Regional_Indicator'],
		['sd', 'Soft_Dotted'],
		['softdotted', 'Soft_Dotted'],
		['sterm', 'Sentence_Terminal'],
		['sentenceterminal', 'Sentence_Terminal'],
		['term', 'Terminal_Punctuation'],
		['terminalpunctuation', 'Terminal_Punctuation'],
		['uideo', 'Unified_Ideograph'],
		['unifiedideograph', 'Unified_Ideograph'],
		['upper', 'Uppercase'],
		['uppercase', 'Uppercase'],
		['vs', 'Variation_Selector'],
		['variationselector', 'Variation_Selector'],
		['wspace', 'White_Space'],
		['whitespace', 'White_Space'],
		['space', 'White_Space'],
		['xidc', 'XID_Continue'],
		['xidcontinue', 'XID_Continue'],
		['xids', 'XID_Start'],
		['xidstart', 'XID_Start'],
		['xonfc', 'Expands_On_NFC'],
		['expandsonnfc', 'Expands_On_NFC'],
		['xonfd', 'Expands_On_NFD'],
		['expandsonnfd', 'Expands_On_NFD'],
		['xonfkc', 'Expands_On_NFKC'],
		['expandsonnfkc', 'Expands_On_NFKC'],
		['xonfkd', 'Expands_On_NFKD'],
		['expandsonnfkd', 'Expands_On_NFKD'],
		['ascii', 'ASCII'],
		['any', 'Any'],
		['assigned', 'Assigned'],
		['emoji', 'Emoji'],
		['emojicomponent', 'Emoji_Component'],
		['emojimodifier', 'Emoji_Modifier'],
		['emojimodifierbase', 'Emoji_Modifier_Base'],
		['emojipresentation', 'Emoji_Presentation'],
		['extendedpictographic', 'Extended_Pictographic']
	]),
	'propertyToValueAliases': new Map([
		['Jamo_Short_Name', new Map([
			['a', 'A'],
			['ae', 'AE'],
			['b', 'B'],
			['bb', 'BB'],
			['bs', 'BS'],
			['c', 'C'],
			['d', 'D'],
			['dd', 'DD'],
			['e', 'E'],
			['eo', 'EO'],
			['eu', 'EU'],
			['g', 'G'],
			['gg', 'GG'],
			['gs', 'GS'],
			['h', 'H'],
			['i', 'I'],
			['j', 'J'],
			['jj', 'JJ'],
			['k', 'K'],
			['l', 'L'],
			['lb', 'LB'],
			['lg', 'LG'],
			['lh', 'LH'],
			['lm', 'LM'],
			['lp', 'LP'],
			['ls', 'LS'],
			['lt', 'LT'],
			['m', 'M'],
			['n', 'N'],
			['ng', 'NG'],
			['nh', 'NH'],
			['nj', 'NJ'],
			['o', 'O'],
			['oe', 'OE'],
			['p', 'P'],
			['r', 'R'],
			['s', 'S'],
			['ss', 'SS'],
			['t', 'T'],
			['u', 'U'],
			['wa', 'WA'],
			['wae', 'WAE'],
			['we', 'WE'],
			['weo', 'WEO'],
			['wi', 'WI'],
			['ya', 'YA'],
			['yae', 'YAE'],
			['ye', 'YE'],
			['yeo', 'YEO'],
			['yi', 'YI'],
			['yo', 'YO'],
			['yu', 'YU']
		])],
		['Script_Extensions', new Map([
			['adlm', 'Adlam'],
			['adlam', 'Adlam'],
			['aghb', 'Caucasian_Albanian'],
			['caucasianalbanian', 'Caucasian_Albanian'],
			['ahom', 'Ahom'],
			['arab', 'Arabic'],
			['arabic', 'Arabic'],
			['armi', 'Imperial_Aramaic'],
			['imperialaramaic', 'Imperial_Aramaic'],
			['armn', 'Armenian'],
			['armenian', 'Armenian'],
			['avst', 'Avestan'],
			['avestan', 'Avestan'],
			['bali', 'Balinese'],
			['balinese', 'Balinese'],
			['bamu', 'Bamum'],
			['bamum', 'Bamum'],
			['bass', 'Bassa_Vah'],
			['bassavah', 'Bassa_Vah'],
			['batk', 'Batak'],
			['batak', 'Batak'],
			['beng', 'Bengali'],
			['bengali', 'Bengali'],
			['bhks', 'Bhaiksuki'],
			['bhaiksuki', 'Bhaiksuki'],
			['bopo', 'Bopomofo'],
			['bopomofo', 'Bopomofo'],
			['brah', 'Brahmi'],
			['brahmi', 'Brahmi'],
			['brai', 'Braille'],
			['braille', 'Braille'],
			['bugi', 'Buginese'],
			['buginese', 'Buginese'],
			['buhd', 'Buhid'],
			['buhid', 'Buhid'],
			['cakm', 'Chakma'],
			['chakma', 'Chakma'],
			['cans', 'Canadian_Aboriginal'],
			['canadianaboriginal', 'Canadian_Aboriginal'],
			['cari', 'Carian'],
			['carian', 'Carian'],
			['cham', 'Cham'],
			['cher', 'Cherokee'],
			['cherokee', 'Cherokee'],
			['copt', 'Coptic'],
			['coptic', 'Coptic'],
			['qaac', 'Coptic'],
			['cprt', 'Cypriot'],
			['cypriot', 'Cypriot'],
			['cyrl', 'Cyrillic'],
			['cyrillic', 'Cyrillic'],
			['deva', 'Devanagari'],
			['devanagari', 'Devanagari'],
			['dogr', 'Dogra'],
			['dogra', 'Dogra'],
			['dsrt', 'Deseret'],
			['deseret', 'Deseret'],
			['dupl', 'Duployan'],
			['duployan', 'Duployan'],
			['egyp', 'Egyptian_Hieroglyphs'],
			['egyptianhieroglyphs', 'Egyptian_Hieroglyphs'],
			['elba', 'Elbasan'],
			['elbasan', 'Elbasan'],
			['ethi', 'Ethiopic'],
			['ethiopic', 'Ethiopic'],
			['geor', 'Georgian'],
			['georgian', 'Georgian'],
			['glag', 'Glagolitic'],
			['glagolitic', 'Glagolitic'],
			['gong', 'Gunjala_Gondi'],
			['gunjalagondi', 'Gunjala_Gondi'],
			['gonm', 'Masaram_Gondi'],
			['masaramgondi', 'Masaram_Gondi'],
			['goth', 'Gothic'],
			['gothic', 'Gothic'],
			['gran', 'Grantha'],
			['grantha', 'Grantha'],
			['grek', 'Greek'],
			['greek', 'Greek'],
			['gujr', 'Gujarati'],
			['gujarati', 'Gujarati'],
			['guru', 'Gurmukhi'],
			['gurmukhi', 'Gurmukhi'],
			['hang', 'Hangul'],
			['hangul', 'Hangul'],
			['hani', 'Han'],
			['han', 'Han'],
			['hano', 'Hanunoo'],
			['hanunoo', 'Hanunoo'],
			['hatr', 'Hatran'],
			['hatran', 'Hatran'],
			['hebr', 'Hebrew'],
			['hebrew', 'Hebrew'],
			['hira', 'Hiragana'],
			['hiragana', 'Hiragana'],
			['hluw', 'Anatolian_Hieroglyphs'],
			['anatolianhieroglyphs', 'Anatolian_Hieroglyphs'],
			['hmng', 'Pahawh_Hmong'],
			['pahawhhmong', 'Pahawh_Hmong'],
			['hrkt', 'Katakana_Or_Hiragana'],
			['katakanaorhiragana', 'Katakana_Or_Hiragana'],
			['hung', 'Old_Hungarian'],
			['oldhungarian', 'Old_Hungarian'],
			['ital', 'Old_Italic'],
			['olditalic', 'Old_Italic'],
			['java', 'Javanese'],
			['javanese', 'Javanese'],
			['kali', 'Kayah_Li'],
			['kayahli', 'Kayah_Li'],
			['kana', 'Katakana'],
			['katakana', 'Katakana'],
			['khar', 'Kharoshthi'],
			['kharoshthi', 'Kharoshthi'],
			['khmr', 'Khmer'],
			['khmer', 'Khmer'],
			['khoj', 'Khojki'],
			['khojki', 'Khojki'],
			['knda', 'Kannada'],
			['kannada', 'Kannada'],
			['kthi', 'Kaithi'],
			['kaithi', 'Kaithi'],
			['lana', 'Tai_Tham'],
			['taitham', 'Tai_Tham'],
			['laoo', 'Lao'],
			['lao', 'Lao'],
			['latn', 'Latin'],
			['latin', 'Latin'],
			['lepc', 'Lepcha'],
			['lepcha', 'Lepcha'],
			['limb', 'Limbu'],
			['limbu', 'Limbu'],
			['lina', 'Linear_A'],
			['lineara', 'Linear_A'],
			['linb', 'Linear_B'],
			['linearb', 'Linear_B'],
			['lisu', 'Lisu'],
			['lyci', 'Lycian'],
			['lycian', 'Lycian'],
			['lydi', 'Lydian'],
			['lydian', 'Lydian'],
			['mahj', 'Mahajani'],
			['mahajani', 'Mahajani'],
			['maka', 'Makasar'],
			['makasar', 'Makasar'],
			['mand', 'Mandaic'],
			['mandaic', 'Mandaic'],
			['mani', 'Manichaean'],
			['manichaean', 'Manichaean'],
			['marc', 'Marchen'],
			['marchen', 'Marchen'],
			['medf', 'Medefaidrin'],
			['medefaidrin', 'Medefaidrin'],
			['mend', 'Mende_Kikakui'],
			['mendekikakui', 'Mende_Kikakui'],
			['merc', 'Meroitic_Cursive'],
			['meroiticcursive', 'Meroitic_Cursive'],
			['mero', 'Meroitic_Hieroglyphs'],
			['meroitichieroglyphs', 'Meroitic_Hieroglyphs'],
			['mlym', 'Malayalam'],
			['malayalam', 'Malayalam'],
			['modi', 'Modi'],
			['mong', 'Mongolian'],
			['mongolian', 'Mongolian'],
			['mroo', 'Mro'],
			['mro', 'Mro'],
			['mtei', 'Meetei_Mayek'],
			['meeteimayek', 'Meetei_Mayek'],
			['mult', 'Multani'],
			['multani', 'Multani'],
			['mymr', 'Myanmar'],
			['myanmar', 'Myanmar'],
			['narb', 'Old_North_Arabian'],
			['oldnortharabian', 'Old_North_Arabian'],
			['nbat', 'Nabataean'],
			['nabataean', 'Nabataean'],
			['newa', 'Newa'],
			['nkoo', 'Nko'],
			['nko', 'Nko'],
			['nshu', 'Nushu'],
			['nushu', 'Nushu'],
			['ogam', 'Ogham'],
			['ogham', 'Ogham'],
			['olck', 'Ol_Chiki'],
			['olchiki', 'Ol_Chiki'],
			['orkh', 'Old_Turkic'],
			['oldturkic', 'Old_Turkic'],
			['orya', 'Oriya'],
			['oriya', 'Oriya'],
			['osge', 'Osage'],
			['osage', 'Osage'],
			['osma', 'Osmanya'],
			['osmanya', 'Osmanya'],
			['palm', 'Palmyrene'],
			['palmyrene', 'Palmyrene'],
			['pauc', 'Pau_Cin_Hau'],
			['paucinhau', 'Pau_Cin_Hau'],
			['perm', 'Old_Permic'],
			['oldpermic', 'Old_Permic'],
			['phag', 'Phags_Pa'],
			['phagspa', 'Phags_Pa'],
			['phli', 'Inscriptional_Pahlavi'],
			['inscriptionalpahlavi', 'Inscriptional_Pahlavi'],
			['phlp', 'Psalter_Pahlavi'],
			['psalterpahlavi', 'Psalter_Pahlavi'],
			['phnx', 'Phoenician'],
			['phoenician', 'Phoenician'],
			['plrd', 'Miao'],
			['miao', 'Miao'],
			['prti', 'Inscriptional_Parthian'],
			['inscriptionalparthian', 'Inscriptional_Parthian'],
			['rjng', 'Rejang'],
			['rejang', 'Rejang'],
			['rohg', 'Hanifi_Rohingya'],
			['hanifirohingya', 'Hanifi_Rohingya'],
			['runr', 'Runic'],
			['runic', 'Runic'],
			['samr', 'Samaritan'],
			['samaritan', 'Samaritan'],
			['sarb', 'Old_South_Arabian'],
			['oldsoutharabian', 'Old_South_Arabian'],
			['saur', 'Saurashtra'],
			['saurashtra', 'Saurashtra'],
			['sgnw', 'SignWriting'],
			['signwriting', 'SignWriting'],
			['shaw', 'Shavian'],
			['shavian', 'Shavian'],
			['shrd', 'Sharada'],
			['sharada', 'Sharada'],
			['sidd', 'Siddham'],
			['siddham', 'Siddham'],
			['sind', 'Khudawadi'],
			['khudawadi', 'Khudawadi'],
			['sinh', 'Sinhala'],
			['sinhala', 'Sinhala'],
			['sogd', 'Sogdian'],
			['sogdian', 'Sogdian'],
			['sogo', 'Old_Sogdian'],
			['oldsogdian', 'Old_Sogdian'],
			['sora', 'Sora_Sompeng'],
			['sorasompeng', 'Sora_Sompeng'],
			['soyo', 'Soyombo'],
			['soyombo', 'Soyombo'],
			['sund', 'Sundanese'],
			['sundanese', 'Sundanese'],
			['sylo', 'Syloti_Nagri'],
			['sylotinagri', 'Syloti_Nagri'],
			['syrc', 'Syriac'],
			['syriac', 'Syriac'],
			['tagb', 'Tagbanwa'],
			['tagbanwa', 'Tagbanwa'],
			['takr', 'Takri'],
			['takri', 'Takri'],
			['tale', 'Tai_Le'],
			['taile', 'Tai_Le'],
			['talu', 'New_Tai_Lue'],
			['newtailue', 'New_Tai_Lue'],
			['taml', 'Tamil'],
			['tamil', 'Tamil'],
			['tang', 'Tangut'],
			['tangut', 'Tangut'],
			['tavt', 'Tai_Viet'],
			['taiviet', 'Tai_Viet'],
			['telu', 'Telugu'],
			['telugu', 'Telugu'],
			['tfng', 'Tifinagh'],
			['tifinagh', 'Tifinagh'],
			['tglg', 'Tagalog'],
			['tagalog', 'Tagalog'],
			['thaa', 'Thaana'],
			['thaana', 'Thaana'],
			['thai', 'Thai'],
			['tibt', 'Tibetan'],
			['tibetan', 'Tibetan'],
			['tirh', 'Tirhuta'],
			['tirhuta', 'Tirhuta'],
			['ugar', 'Ugaritic'],
			['ugaritic', 'Ugaritic'],
			['vaii', 'Vai'],
			['vai', 'Vai'],
			['wara', 'Warang_Citi'],
			['warangciti', 'Warang_Citi'],
			['xpeo', 'Old_Persian'],
			['oldpersian', 'Old_Persian'],
			['xsux', 'Cuneiform'],
			['cuneiform', 'Cuneiform'],
			['yiii', 'Yi'],
			['yi', 'Yi'],
			['zanb', 'Zanabazar_Square'],
			['zanabazarsquare', 'Zanabazar_Square'],
			['zinh', 'Inherited'],
			['inherited', 'Inherited'],
			['qaai', 'Inherited'],
			['zyyy', 'Common'],
			['common', 'Common'],
			['zzzz', 'Unknown'],
			['unknown', 'Unknown']
		])],
		['Age', new Map([
			['1.1', 'V1_1'],
			['v11', 'V1_1'],
			['2.0', 'V2_0'],
			['v20', 'V2_0'],
			['2.1', 'V2_1'],
			['v21', 'V2_1'],
			['3.0', 'V3_0'],
			['v30', 'V3_0'],
			['3.1', 'V3_1'],
			['v31', 'V3_1'],
			['3.2', 'V3_2'],
			['v32', 'V3_2'],
			['4.0', 'V4_0'],
			['v40', 'V4_0'],
			['4.1', 'V4_1'],
			['v41', 'V4_1'],
			['5.0', 'V5_0'],
			['v50', 'V5_0'],
			['5.1', 'V5_1'],
			['v51', 'V5_1'],
			['5.2', 'V5_2'],
			['v52', 'V5_2'],
			['6.0', 'V6_0'],
			['v60', 'V6_0'],
			['6.1', 'V6_1'],
			['v61', 'V6_1'],
			['6.2', 'V6_2'],
			['v62', 'V6_2'],
			['6.3', 'V6_3'],
			['v63', 'V6_3'],
			['7.0', 'V7_0'],
			['v70', 'V7_0'],
			['8.0', 'V8_0'],
			['v80', 'V8_0'],
			['9.0', 'V9_0'],
			['v90', 'V9_0'],
			['10.0', 'V10_0'],
			['v100', 'V10_0'],
			['11.0', 'V11_0'],
			['v110', 'V11_0'],
			['na', 'Unassigned'],
			['unassigned', 'Unassigned']
		])],
		['Block', new Map([
			['adlam', 'Adlam'],
			['aegeannumbers', 'Aegean_Numbers'],
			['ahom', 'Ahom'],
			['alchemical', 'Alchemical_Symbols'],
			['alchemicalsymbols', 'Alchemical_Symbols'],
			['alphabeticpf', 'Alphabetic_Presentation_Forms'],
			['alphabeticpresentationforms', 'Alphabetic_Presentation_Forms'],
			['anatolianhieroglyphs', 'Anatolian_Hieroglyphs'],
			['ancientgreekmusic', 'Ancient_Greek_Musical_Notation'],
			['ancientgreekmusicalnotation', 'Ancient_Greek_Musical_Notation'],
			['ancientgreeknumbers', 'Ancient_Greek_Numbers'],
			['ancientsymbols', 'Ancient_Symbols'],
			['arabic', 'Arabic'],
			['arabicexta', 'Arabic_Extended_A'],
			['arabicextendeda', 'Arabic_Extended_A'],
			['arabicmath', 'Arabic_Mathematical_Alphabetic_Symbols'],
			['arabicmathematicalalphabeticsymbols', 'Arabic_Mathematical_Alphabetic_Symbols'],
			['arabicpfa', 'Arabic_Presentation_Forms_A'],
			['arabicpresentationformsa', 'Arabic_Presentation_Forms_A'],
			['arabicpfb', 'Arabic_Presentation_Forms_B'],
			['arabicpresentationformsb', 'Arabic_Presentation_Forms_B'],
			['arabicsup', 'Arabic_Supplement'],
			['arabicsupplement', 'Arabic_Supplement'],
			['armenian', 'Armenian'],
			['arrows', 'Arrows'],
			['ascii', 'Basic_Latin'],
			['basiclatin', 'Basic_Latin'],
			['avestan', 'Avestan'],
			['balinese', 'Balinese'],
			['bamum', 'Bamum'],
			['bamumsup', 'Bamum_Supplement'],
			['bamumsupplement', 'Bamum_Supplement'],
			['bassavah', 'Bassa_Vah'],
			['batak', 'Batak'],
			['bengali', 'Bengali'],
			['bhaiksuki', 'Bhaiksuki'],
			['blockelements', 'Block_Elements'],
			['bopomofo', 'Bopomofo'],
			['bopomofoext', 'Bopomofo_Extended'],
			['bopomofoextended', 'Bopomofo_Extended'],
			['boxdrawing', 'Box_Drawing'],
			['brahmi', 'Brahmi'],
			['braille', 'Braille_Patterns'],
			['braillepatterns', 'Braille_Patterns'],
			['buginese', 'Buginese'],
			['buhid', 'Buhid'],
			['byzantinemusic', 'Byzantine_Musical_Symbols'],
			['byzantinemusicalsymbols', 'Byzantine_Musical_Symbols'],
			['carian', 'Carian'],
			['caucasianalbanian', 'Caucasian_Albanian'],
			['chakma', 'Chakma'],
			['cham', 'Cham'],
			['cherokee', 'Cherokee'],
			['cherokeesup', 'Cherokee_Supplement'],
			['cherokeesupplement', 'Cherokee_Supplement'],
			['chesssymbols', 'Chess_Symbols'],
			['cjk', 'CJK_Unified_Ideographs'],
			['cjkunifiedideographs', 'CJK_Unified_Ideographs'],
			['cjkcompat', 'CJK_Compatibility'],
			['cjkcompatibility', 'CJK_Compatibility'],
			['cjkcompatforms', 'CJK_Compatibility_Forms'],
			['cjkcompatibilityforms', 'CJK_Compatibility_Forms'],
			['cjkcompatideographs', 'CJK_Compatibility_Ideographs'],
			['cjkcompatibilityideographs', 'CJK_Compatibility_Ideographs'],
			['cjkcompatideographssup', 'CJK_Compatibility_Ideographs_Supplement'],
			['cjkcompatibilityideographssupplement', 'CJK_Compatibility_Ideographs_Supplement'],
			['cjkexta', 'CJK_Unified_Ideographs_Extension_A'],
			['cjkunifiedideographsextensiona', 'CJK_Unified_Ideographs_Extension_A'],
			['cjkextb', 'CJK_Unified_Ideographs_Extension_B'],
			['cjkunifiedideographsextensionb', 'CJK_Unified_Ideographs_Extension_B'],
			['cjkextc', 'CJK_Unified_Ideographs_Extension_C'],
			['cjkunifiedideographsextensionc', 'CJK_Unified_Ideographs_Extension_C'],
			['cjkextd', 'CJK_Unified_Ideographs_Extension_D'],
			['cjkunifiedideographsextensiond', 'CJK_Unified_Ideographs_Extension_D'],
			['cjkexte', 'CJK_Unified_Ideographs_Extension_E'],
			['cjkunifiedideographsextensione', 'CJK_Unified_Ideographs_Extension_E'],
			['cjkextf', 'CJK_Unified_Ideographs_Extension_F'],
			['cjkunifiedideographsextensionf', 'CJK_Unified_Ideographs_Extension_F'],
			['cjkradicalssup', 'CJK_Radicals_Supplement'],
			['cjkradicalssupplement', 'CJK_Radicals_Supplement'],
			['cjkstrokes', 'CJK_Strokes'],
			['cjksymbols', 'CJK_Symbols_And_Punctuation'],
			['cjksymbolsandpunctuation', 'CJK_Symbols_And_Punctuation'],
			['compatjamo', 'Hangul_Compatibility_Jamo'],
			['hangulcompatibilityjamo', 'Hangul_Compatibility_Jamo'],
			['controlpictures', 'Control_Pictures'],
			['coptic', 'Coptic'],
			['copticepactnumbers', 'Coptic_Epact_Numbers'],
			['countingrod', 'Counting_Rod_Numerals'],
			['countingrodnumerals', 'Counting_Rod_Numerals'],
			['cuneiform', 'Cuneiform'],
			['cuneiformnumbers', 'Cuneiform_Numbers_And_Punctuation'],
			['cuneiformnumbersandpunctuation', 'Cuneiform_Numbers_And_Punctuation'],
			['currencysymbols', 'Currency_Symbols'],
			['cypriotsyllabary', 'Cypriot_Syllabary'],
			['cyrillic', 'Cyrillic'],
			['cyrillicexta', 'Cyrillic_Extended_A'],
			['cyrillicextendeda', 'Cyrillic_Extended_A'],
			['cyrillicextb', 'Cyrillic_Extended_B'],
			['cyrillicextendedb', 'Cyrillic_Extended_B'],
			['cyrillicextc', 'Cyrillic_Extended_C'],
			['cyrillicextendedc', 'Cyrillic_Extended_C'],
			['cyrillicsup', 'Cyrillic_Supplement'],
			['cyrillicsupplement', 'Cyrillic_Supplement'],
			['cyrillicsupplementary', 'Cyrillic_Supplement'],
			['deseret', 'Deseret'],
			['devanagari', 'Devanagari'],
			['devanagariext', 'Devanagari_Extended'],
			['devanagariextended', 'Devanagari_Extended'],
			['diacriticals', 'Combining_Diacritical_Marks'],
			['combiningdiacriticalmarks', 'Combining_Diacritical_Marks'],
			['diacriticalsext', 'Combining_Diacritical_Marks_Extended'],
			['combiningdiacriticalmarksextended', 'Combining_Diacritical_Marks_Extended'],
			['diacriticalsforsymbols', 'Combining_Diacritical_Marks_For_Symbols'],
			['combiningdiacriticalmarksforsymbols', 'Combining_Diacritical_Marks_For_Symbols'],
			['combiningmarksforsymbols', 'Combining_Diacritical_Marks_For_Symbols'],
			['diacriticalssup', 'Combining_Diacritical_Marks_Supplement'],
			['combiningdiacriticalmarkssupplement', 'Combining_Diacritical_Marks_Supplement'],
			['dingbats', 'Dingbats'],
			['dogra', 'Dogra'],
			['domino', 'Domino_Tiles'],
			['dominotiles', 'Domino_Tiles'],
			['duployan', 'Duployan'],
			['earlydynasticcuneiform', 'Early_Dynastic_Cuneiform'],
			['egyptianhieroglyphs', 'Egyptian_Hieroglyphs'],
			['elbasan', 'Elbasan'],
			['emoticons', 'Emoticons'],
			['enclosedalphanum', 'Enclosed_Alphanumerics'],
			['enclosedalphanumerics', 'Enclosed_Alphanumerics'],
			['enclosedalphanumsup', 'Enclosed_Alphanumeric_Supplement'],
			['enclosedalphanumericsupplement', 'Enclosed_Alphanumeric_Supplement'],
			['enclosedcjk', 'Enclosed_CJK_Letters_And_Months'],
			['enclosedcjklettersandmonths', 'Enclosed_CJK_Letters_And_Months'],
			['enclosedideographicsup', 'Enclosed_Ideographic_Supplement'],
			['enclosedideographicsupplement', 'Enclosed_Ideographic_Supplement'],
			['ethiopic', 'Ethiopic'],
			['ethiopicext', 'Ethiopic_Extended'],
			['ethiopicextended', 'Ethiopic_Extended'],
			['ethiopicexta', 'Ethiopic_Extended_A'],
			['ethiopicextendeda', 'Ethiopic_Extended_A'],
			['ethiopicsup', 'Ethiopic_Supplement'],
			['ethiopicsupplement', 'Ethiopic_Supplement'],
			['geometricshapes', 'Geometric_Shapes'],
			['geometricshapesext', 'Geometric_Shapes_Extended'],
			['geometricshapesextended', 'Geometric_Shapes_Extended'],
			['georgian', 'Georgian'],
			['georgianext', 'Georgian_Extended'],
			['georgianextended', 'Georgian_Extended'],
			['georgiansup', 'Georgian_Supplement'],
			['georgiansupplement', 'Georgian_Supplement'],
			['glagolitic', 'Glagolitic'],
			['glagoliticsup', 'Glagolitic_Supplement'],
			['glagoliticsupplement', 'Glagolitic_Supplement'],
			['gothic', 'Gothic'],
			['grantha', 'Grantha'],
			['greek', 'Greek_And_Coptic'],
			['greekandcoptic', 'Greek_And_Coptic'],
			['greekext', 'Greek_Extended'],
			['greekextended', 'Greek_Extended'],
			['gujarati', 'Gujarati'],
			['gunjalagondi', 'Gunjala_Gondi'],
			['gurmukhi', 'Gurmukhi'],
			['halfandfullforms', 'Halfwidth_And_Fullwidth_Forms'],
			['halfwidthandfullwidthforms', 'Halfwidth_And_Fullwidth_Forms'],
			['halfmarks', 'Combining_Half_Marks'],
			['combininghalfmarks', 'Combining_Half_Marks'],
			['hangul', 'Hangul_Syllables'],
			['hangulsyllables', 'Hangul_Syllables'],
			['hanifirohingya', 'Hanifi_Rohingya'],
			['hanunoo', 'Hanunoo'],
			['hatran', 'Hatran'],
			['hebrew', 'Hebrew'],
			['highpusurrogates', 'High_Private_Use_Surrogates'],
			['highprivateusesurrogates', 'High_Private_Use_Surrogates'],
			['highsurrogates', 'High_Surrogates'],
			['hiragana', 'Hiragana'],
			['idc', 'Ideographic_Description_Characters'],
			['ideographicdescriptioncharacters', 'Ideographic_Description_Characters'],
			['ideographicsymbols', 'Ideographic_Symbols_And_Punctuation'],
			['ideographicsymbolsandpunctuation', 'Ideographic_Symbols_And_Punctuation'],
			['imperialaramaic', 'Imperial_Aramaic'],
			['indicnumberforms', 'Common_Indic_Number_Forms'],
			['commonindicnumberforms', 'Common_Indic_Number_Forms'],
			['indicsiyaqnumbers', 'Indic_Siyaq_Numbers'],
			['inscriptionalpahlavi', 'Inscriptional_Pahlavi'],
			['inscriptionalparthian', 'Inscriptional_Parthian'],
			['ipaext', 'IPA_Extensions'],
			['ipaextensions', 'IPA_Extensions'],
			['jamo', 'Hangul_Jamo'],
			['hanguljamo', 'Hangul_Jamo'],
			['jamoexta', 'Hangul_Jamo_Extended_A'],
			['hanguljamoextendeda', 'Hangul_Jamo_Extended_A'],
			['jamoextb', 'Hangul_Jamo_Extended_B'],
			['hanguljamoextendedb', 'Hangul_Jamo_Extended_B'],
			['javanese', 'Javanese'],
			['kaithi', 'Kaithi'],
			['kanaexta', 'Kana_Extended_A'],
			['kanaextendeda', 'Kana_Extended_A'],
			['kanasup', 'Kana_Supplement'],
			['kanasupplement', 'Kana_Supplement'],
			['kanbun', 'Kanbun'],
			['kangxi', 'Kangxi_Radicals'],
			['kangxiradicals', 'Kangxi_Radicals'],
			['kannada', 'Kannada'],
			['katakana', 'Katakana'],
			['katakanaext', 'Katakana_Phonetic_Extensions'],
			['katakanaphoneticextensions', 'Katakana_Phonetic_Extensions'],
			['kayahli', 'Kayah_Li'],
			['kharoshthi', 'Kharoshthi'],
			['khmer', 'Khmer'],
			['khmersymbols', 'Khmer_Symbols'],
			['khojki', 'Khojki'],
			['khudawadi', 'Khudawadi'],
			['lao', 'Lao'],
			['latin1sup', 'Latin_1_Supplement'],
			['latin1supplement', 'Latin_1_Supplement'],
			['latin1', 'Latin_1_Supplement'],
			['latinexta', 'Latin_Extended_A'],
			['latinextendeda', 'Latin_Extended_A'],
			['latinextadditional', 'Latin_Extended_Additional'],
			['latinextendedadditional', 'Latin_Extended_Additional'],
			['latinextb', 'Latin_Extended_B'],
			['latinextendedb', 'Latin_Extended_B'],
			['latinextc', 'Latin_Extended_C'],
			['latinextendedc', 'Latin_Extended_C'],
			['latinextd', 'Latin_Extended_D'],
			['latinextendedd', 'Latin_Extended_D'],
			['latinexte', 'Latin_Extended_E'],
			['latinextendede', 'Latin_Extended_E'],
			['lepcha', 'Lepcha'],
			['letterlikesymbols', 'Letterlike_Symbols'],
			['limbu', 'Limbu'],
			['lineara', 'Linear_A'],
			['linearbideograms', 'Linear_B_Ideograms'],
			['linearbsyllabary', 'Linear_B_Syllabary'],
			['lisu', 'Lisu'],
			['lowsurrogates', 'Low_Surrogates'],
			['lycian', 'Lycian'],
			['lydian', 'Lydian'],
			['mahajani', 'Mahajani'],
			['mahjong', 'Mahjong_Tiles'],
			['mahjongtiles', 'Mahjong_Tiles'],
			['makasar', 'Makasar'],
			['malayalam', 'Malayalam'],
			['mandaic', 'Mandaic'],
			['manichaean', 'Manichaean'],
			['marchen', 'Marchen'],
			['masaramgondi', 'Masaram_Gondi'],
			['mathalphanum', 'Mathematical_Alphanumeric_Symbols'],
			['mathematicalalphanumericsymbols', 'Mathematical_Alphanumeric_Symbols'],
			['mathoperators', 'Mathematical_Operators'],
			['mathematicaloperators', 'Mathematical_Operators'],
			['mayannumerals', 'Mayan_Numerals'],
			['medefaidrin', 'Medefaidrin'],
			['meeteimayek', 'Meetei_Mayek'],
			['meeteimayekext', 'Meetei_Mayek_Extensions'],
			['meeteimayekextensions', 'Meetei_Mayek_Extensions'],
			['mendekikakui', 'Mende_Kikakui'],
			['meroiticcursive', 'Meroitic_Cursive'],
			['meroitichieroglyphs', 'Meroitic_Hieroglyphs'],
			['miao', 'Miao'],
			['miscarrows', 'Miscellaneous_Symbols_And_Arrows'],
			['miscellaneoussymbolsandarrows', 'Miscellaneous_Symbols_And_Arrows'],
			['miscmathsymbolsa', 'Miscellaneous_Mathematical_Symbols_A'],
			['miscellaneousmathematicalsymbolsa', 'Miscellaneous_Mathematical_Symbols_A'],
			['miscmathsymbolsb', 'Miscellaneous_Mathematical_Symbols_B'],
			['miscellaneousmathematicalsymbolsb', 'Miscellaneous_Mathematical_Symbols_B'],
			['miscpictographs', 'Miscellaneous_Symbols_And_Pictographs'],
			['miscellaneoussymbolsandpictographs', 'Miscellaneous_Symbols_And_Pictographs'],
			['miscsymbols', 'Miscellaneous_Symbols'],
			['miscellaneoussymbols', 'Miscellaneous_Symbols'],
			['misctechnical', 'Miscellaneous_Technical'],
			['miscellaneoustechnical', 'Miscellaneous_Technical'],
			['modi', 'Modi'],
			['modifierletters', 'Spacing_Modifier_Letters'],
			['spacingmodifierletters', 'Spacing_Modifier_Letters'],
			['modifiertoneletters', 'Modifier_Tone_Letters'],
			['mongolian', 'Mongolian'],
			['mongoliansup', 'Mongolian_Supplement'],
			['mongoliansupplement', 'Mongolian_Supplement'],
			['mro', 'Mro'],
			['multani', 'Multani'],
			['music', 'Musical_Symbols'],
			['musicalsymbols', 'Musical_Symbols'],
			['myanmar', 'Myanmar'],
			['myanmarexta', 'Myanmar_Extended_A'],
			['myanmarextendeda', 'Myanmar_Extended_A'],
			['myanmarextb', 'Myanmar_Extended_B'],
			['myanmarextendedb', 'Myanmar_Extended_B'],
			['nabataean', 'Nabataean'],
			['nb', 'No_Block'],
			['noblock', 'No_Block'],
			['newtailue', 'New_Tai_Lue'],
			['newa', 'Newa'],
			['nko', 'NKo'],
			['numberforms', 'Number_Forms'],
			['nushu', 'Nushu'],
			['ocr', 'Optical_Character_Recognition'],
			['opticalcharacterrecognition', 'Optical_Character_Recognition'],
			['ogham', 'Ogham'],
			['olchiki', 'Ol_Chiki'],
			['oldhungarian', 'Old_Hungarian'],
			['olditalic', 'Old_Italic'],
			['oldnortharabian', 'Old_North_Arabian'],
			['oldpermic', 'Old_Permic'],
			['oldpersian', 'Old_Persian'],
			['oldsogdian', 'Old_Sogdian'],
			['oldsoutharabian', 'Old_South_Arabian'],
			['oldturkic', 'Old_Turkic'],
			['oriya', 'Oriya'],
			['ornamentaldingbats', 'Ornamental_Dingbats'],
			['osage', 'Osage'],
			['osmanya', 'Osmanya'],
			['pahawhhmong', 'Pahawh_Hmong'],
			['palmyrene', 'Palmyrene'],
			['paucinhau', 'Pau_Cin_Hau'],
			['phagspa', 'Phags_Pa'],
			['phaistos', 'Phaistos_Disc'],
			['phaistosdisc', 'Phaistos_Disc'],
			['phoenician', 'Phoenician'],
			['phoneticext', 'Phonetic_Extensions'],
			['phoneticextensions', 'Phonetic_Extensions'],
			['phoneticextsup', 'Phonetic_Extensions_Supplement'],
			['phoneticextensionssupplement', 'Phonetic_Extensions_Supplement'],
			['playingcards', 'Playing_Cards'],
			['psalterpahlavi', 'Psalter_Pahlavi'],
			['pua', 'Private_Use_Area'],
			['privateusearea', 'Private_Use_Area'],
			['privateuse', 'Private_Use_Area'],
			['punctuation', 'General_Punctuation'],
			['generalpunctuation', 'General_Punctuation'],
			['rejang', 'Rejang'],
			['rumi', 'Rumi_Numeral_Symbols'],
			['ruminumeralsymbols', 'Rumi_Numeral_Symbols'],
			['runic', 'Runic'],
			['samaritan', 'Samaritan'],
			['saurashtra', 'Saurashtra'],
			['sharada', 'Sharada'],
			['shavian', 'Shavian'],
			['shorthandformatcontrols', 'Shorthand_Format_Controls'],
			['siddham', 'Siddham'],
			['sinhala', 'Sinhala'],
			['sinhalaarchaicnumbers', 'Sinhala_Archaic_Numbers'],
			['smallforms', 'Small_Form_Variants'],
			['smallformvariants', 'Small_Form_Variants'],
			['sogdian', 'Sogdian'],
			['sorasompeng', 'Sora_Sompeng'],
			['soyombo', 'Soyombo'],
			['specials', 'Specials'],
			['sundanese', 'Sundanese'],
			['sundanesesup', 'Sundanese_Supplement'],
			['sundanesesupplement', 'Sundanese_Supplement'],
			['suparrowsa', 'Supplemental_Arrows_A'],
			['supplementalarrowsa', 'Supplemental_Arrows_A'],
			['suparrowsb', 'Supplemental_Arrows_B'],
			['supplementalarrowsb', 'Supplemental_Arrows_B'],
			['suparrowsc', 'Supplemental_Arrows_C'],
			['supplementalarrowsc', 'Supplemental_Arrows_C'],
			['supmathoperators', 'Supplemental_Mathematical_Operators'],
			['supplementalmathematicaloperators', 'Supplemental_Mathematical_Operators'],
			['suppuaa', 'Supplementary_Private_Use_Area_A'],
			['supplementaryprivateuseareaa', 'Supplementary_Private_Use_Area_A'],
			['suppuab', 'Supplementary_Private_Use_Area_B'],
			['supplementaryprivateuseareab', 'Supplementary_Private_Use_Area_B'],
			['suppunctuation', 'Supplemental_Punctuation'],
			['supplementalpunctuation', 'Supplemental_Punctuation'],
			['supsymbolsandpictographs', 'Supplemental_Symbols_And_Pictographs'],
			['supplementalsymbolsandpictographs', 'Supplemental_Symbols_And_Pictographs'],
			['superandsub', 'Superscripts_And_Subscripts'],
			['superscriptsandsubscripts', 'Superscripts_And_Subscripts'],
			['suttonsignwriting', 'Sutton_SignWriting'],
			['sylotinagri', 'Syloti_Nagri'],
			['syriac', 'Syriac'],
			['syriacsup', 'Syriac_Supplement'],
			['syriacsupplement', 'Syriac_Supplement'],
			['tagalog', 'Tagalog'],
			['tagbanwa', 'Tagbanwa'],
			['tags', 'Tags'],
			['taile', 'Tai_Le'],
			['taitham', 'Tai_Tham'],
			['taiviet', 'Tai_Viet'],
			['taixuanjing', 'Tai_Xuan_Jing_Symbols'],
			['taixuanjingsymbols', 'Tai_Xuan_Jing_Symbols'],
			['takri', 'Takri'],
			['tamil', 'Tamil'],
			['tangut', 'Tangut'],
			['tangutcomponents', 'Tangut_Components'],
			['telugu', 'Telugu'],
			['thaana', 'Thaana'],
			['thai', 'Thai'],
			['tibetan', 'Tibetan'],
			['tifinagh', 'Tifinagh'],
			['tirhuta', 'Tirhuta'],
			['transportandmap', 'Transport_And_Map_Symbols'],
			['transportandmapsymbols', 'Transport_And_Map_Symbols'],
			['ucas', 'Unified_Canadian_Aboriginal_Syllabics'],
			['unifiedcanadianaboriginalsyllabics', 'Unified_Canadian_Aboriginal_Syllabics'],
			['canadiansyllabics', 'Unified_Canadian_Aboriginal_Syllabics'],
			['ucasext', 'Unified_Canadian_Aboriginal_Syllabics_Extended'],
			['unifiedcanadianaboriginalsyllabicsextended', 'Unified_Canadian_Aboriginal_Syllabics_Extended'],
			['ugaritic', 'Ugaritic'],
			['vai', 'Vai'],
			['vedicext', 'Vedic_Extensions'],
			['vedicextensions', 'Vedic_Extensions'],
			['verticalforms', 'Vertical_Forms'],
			['vs', 'Variation_Selectors'],
			['variationselectors', 'Variation_Selectors'],
			['vssup', 'Variation_Selectors_Supplement'],
			['variationselectorssupplement', 'Variation_Selectors_Supplement'],
			['warangciti', 'Warang_Citi'],
			['yiradicals', 'Yi_Radicals'],
			['yisyllables', 'Yi_Syllables'],
			['yijing', 'Yijing_Hexagram_Symbols'],
			['yijinghexagramsymbols', 'Yijing_Hexagram_Symbols'],
			['zanabazarsquare', 'Zanabazar_Square']
		])],
		['Script', new Map([
			['adlm', 'Adlam'],
			['adlam', 'Adlam'],
			['aghb', 'Caucasian_Albanian'],
			['caucasianalbanian', 'Caucasian_Albanian'],
			['ahom', 'Ahom'],
			['arab', 'Arabic'],
			['arabic', 'Arabic'],
			['armi', 'Imperial_Aramaic'],
			['imperialaramaic', 'Imperial_Aramaic'],
			['armn', 'Armenian'],
			['armenian', 'Armenian'],
			['avst', 'Avestan'],
			['avestan', 'Avestan'],
			['bali', 'Balinese'],
			['balinese', 'Balinese'],
			['bamu', 'Bamum'],
			['bamum', 'Bamum'],
			['bass', 'Bassa_Vah'],
			['bassavah', 'Bassa_Vah'],
			['batk', 'Batak'],
			['batak', 'Batak'],
			['beng', 'Bengali'],
			['bengali', 'Bengali'],
			['bhks', 'Bhaiksuki'],
			['bhaiksuki', 'Bhaiksuki'],
			['bopo', 'Bopomofo'],
			['bopomofo', 'Bopomofo'],
			['brah', 'Brahmi'],
			['brahmi', 'Brahmi'],
			['brai', 'Braille'],
			['braille', 'Braille'],
			['bugi', 'Buginese'],
			['buginese', 'Buginese'],
			['buhd', 'Buhid'],
			['buhid', 'Buhid'],
			['cakm', 'Chakma'],
			['chakma', 'Chakma'],
			['cans', 'Canadian_Aboriginal'],
			['canadianaboriginal', 'Canadian_Aboriginal'],
			['cari', 'Carian'],
			['carian', 'Carian'],
			['cham', 'Cham'],
			['cher', 'Cherokee'],
			['cherokee', 'Cherokee'],
			['copt', 'Coptic'],
			['coptic', 'Coptic'],
			['qaac', 'Coptic'],
			['cprt', 'Cypriot'],
			['cypriot', 'Cypriot'],
			['cyrl', 'Cyrillic'],
			['cyrillic', 'Cyrillic'],
			['deva', 'Devanagari'],
			['devanagari', 'Devanagari'],
			['dogr', 'Dogra'],
			['dogra', 'Dogra'],
			['dsrt', 'Deseret'],
			['deseret', 'Deseret'],
			['dupl', 'Duployan'],
			['duployan', 'Duployan'],
			['egyp', 'Egyptian_Hieroglyphs'],
			['egyptianhieroglyphs', 'Egyptian_Hieroglyphs'],
			['elba', 'Elbasan'],
			['elbasan', 'Elbasan'],
			['ethi', 'Ethiopic'],
			['ethiopic', 'Ethiopic'],
			['geor', 'Georgian'],
			['georgian', 'Georgian'],
			['glag', 'Glagolitic'],
			['glagolitic', 'Glagolitic'],
			['gong', 'Gunjala_Gondi'],
			['gunjalagondi', 'Gunjala_Gondi'],
			['gonm', 'Masaram_Gondi'],
			['masaramgondi', 'Masaram_Gondi'],
			['goth', 'Gothic'],
			['gothic', 'Gothic'],
			['gran', 'Grantha'],
			['grantha', 'Grantha'],
			['grek', 'Greek'],
			['greek', 'Greek'],
			['gujr', 'Gujarati'],
			['gujarati', 'Gujarati'],
			['guru', 'Gurmukhi'],
			['gurmukhi', 'Gurmukhi'],
			['hang', 'Hangul'],
			['hangul', 'Hangul'],
			['hani', 'Han'],
			['han', 'Han'],
			['hano', 'Hanunoo'],
			['hanunoo', 'Hanunoo'],
			['hatr', 'Hatran'],
			['hatran', 'Hatran'],
			['hebr', 'Hebrew'],
			['hebrew', 'Hebrew'],
			['hira', 'Hiragana'],
			['hiragana', 'Hiragana'],
			['hluw', 'Anatolian_Hieroglyphs'],
			['anatolianhieroglyphs', 'Anatolian_Hieroglyphs'],
			['hmng', 'Pahawh_Hmong'],
			['pahawhhmong', 'Pahawh_Hmong'],
			['hrkt', 'Katakana_Or_Hiragana'],
			['katakanaorhiragana', 'Katakana_Or_Hiragana'],
			['hung', 'Old_Hungarian'],
			['oldhungarian', 'Old_Hungarian'],
			['ital', 'Old_Italic'],
			['olditalic', 'Old_Italic'],
			['java', 'Javanese'],
			['javanese', 'Javanese'],
			['kali', 'Kayah_Li'],
			['kayahli', 'Kayah_Li'],
			['kana', 'Katakana'],
			['katakana', 'Katakana'],
			['khar', 'Kharoshthi'],
			['kharoshthi', 'Kharoshthi'],
			['khmr', 'Khmer'],
			['khmer', 'Khmer'],
			['khoj', 'Khojki'],
			['khojki', 'Khojki'],
			['knda', 'Kannada'],
			['kannada', 'Kannada'],
			['kthi', 'Kaithi'],
			['kaithi', 'Kaithi'],
			['lana', 'Tai_Tham'],
			['taitham', 'Tai_Tham'],
			['laoo', 'Lao'],
			['lao', 'Lao'],
			['latn', 'Latin'],
			['latin', 'Latin'],
			['lepc', 'Lepcha'],
			['lepcha', 'Lepcha'],
			['limb', 'Limbu'],
			['limbu', 'Limbu'],
			['lina', 'Linear_A'],
			['lineara', 'Linear_A'],
			['linb', 'Linear_B'],
			['linearb', 'Linear_B'],
			['lisu', 'Lisu'],
			['lyci', 'Lycian'],
			['lycian', 'Lycian'],
			['lydi', 'Lydian'],
			['lydian', 'Lydian'],
			['mahj', 'Mahajani'],
			['mahajani', 'Mahajani'],
			['maka', 'Makasar'],
			['makasar', 'Makasar'],
			['mand', 'Mandaic'],
			['mandaic', 'Mandaic'],
			['mani', 'Manichaean'],
			['manichaean', 'Manichaean'],
			['marc', 'Marchen'],
			['marchen', 'Marchen'],
			['medf', 'Medefaidrin'],
			['medefaidrin', 'Medefaidrin'],
			['mend', 'Mende_Kikakui'],
			['mendekikakui', 'Mende_Kikakui'],
			['merc', 'Meroitic_Cursive'],
			['meroiticcursive', 'Meroitic_Cursive'],
			['mero', 'Meroitic_Hieroglyphs'],
			['meroitichieroglyphs', 'Meroitic_Hieroglyphs'],
			['mlym', 'Malayalam'],
			['malayalam', 'Malayalam'],
			['modi', 'Modi'],
			['mong', 'Mongolian'],
			['mongolian', 'Mongolian'],
			['mroo', 'Mro'],
			['mro', 'Mro'],
			['mtei', 'Meetei_Mayek'],
			['meeteimayek', 'Meetei_Mayek'],
			['mult', 'Multani'],
			['multani', 'Multani'],
			['mymr', 'Myanmar'],
			['myanmar', 'Myanmar'],
			['narb', 'Old_North_Arabian'],
			['oldnortharabian', 'Old_North_Arabian'],
			['nbat', 'Nabataean'],
			['nabataean', 'Nabataean'],
			['newa', 'Newa'],
			['nkoo', 'Nko'],
			['nko', 'Nko'],
			['nshu', 'Nushu'],
			['nushu', 'Nushu'],
			['ogam', 'Ogham'],
			['ogham', 'Ogham'],
			['olck', 'Ol_Chiki'],
			['olchiki', 'Ol_Chiki'],
			['orkh', 'Old_Turkic'],
			['oldturkic', 'Old_Turkic'],
			['orya', 'Oriya'],
			['oriya', 'Oriya'],
			['osge', 'Osage'],
			['osage', 'Osage'],
			['osma', 'Osmanya'],
			['osmanya', 'Osmanya'],
			['palm', 'Palmyrene'],
			['palmyrene', 'Palmyrene'],
			['pauc', 'Pau_Cin_Hau'],
			['paucinhau', 'Pau_Cin_Hau'],
			['perm', 'Old_Permic'],
			['oldpermic', 'Old_Permic'],
			['phag', 'Phags_Pa'],
			['phagspa', 'Phags_Pa'],
			['phli', 'Inscriptional_Pahlavi'],
			['inscriptionalpahlavi', 'Inscriptional_Pahlavi'],
			['phlp', 'Psalter_Pahlavi'],
			['psalterpahlavi', 'Psalter_Pahlavi'],
			['phnx', 'Phoenician'],
			['phoenician', 'Phoenician'],
			['plrd', 'Miao'],
			['miao', 'Miao'],
			['prti', 'Inscriptional_Parthian'],
			['inscriptionalparthian', 'Inscriptional_Parthian'],
			['rjng', 'Rejang'],
			['rejang', 'Rejang'],
			['rohg', 'Hanifi_Rohingya'],
			['hanifirohingya', 'Hanifi_Rohingya'],
			['runr', 'Runic'],
			['runic', 'Runic'],
			['samr', 'Samaritan'],
			['samaritan', 'Samaritan'],
			['sarb', 'Old_South_Arabian'],
			['oldsoutharabian', 'Old_South_Arabian'],
			['saur', 'Saurashtra'],
			['saurashtra', 'Saurashtra'],
			['sgnw', 'SignWriting'],
			['signwriting', 'SignWriting'],
			['shaw', 'Shavian'],
			['shavian', 'Shavian'],
			['shrd', 'Sharada'],
			['sharada', 'Sharada'],
			['sidd', 'Siddham'],
			['siddham', 'Siddham'],
			['sind', 'Khudawadi'],
			['khudawadi', 'Khudawadi'],
			['sinh', 'Sinhala'],
			['sinhala', 'Sinhala'],
			['sogd', 'Sogdian'],
			['sogdian', 'Sogdian'],
			['sogo', 'Old_Sogdian'],
			['oldsogdian', 'Old_Sogdian'],
			['sora', 'Sora_Sompeng'],
			['sorasompeng', 'Sora_Sompeng'],
			['soyo', 'Soyombo'],
			['soyombo', 'Soyombo'],
			['sund', 'Sundanese'],
			['sundanese', 'Sundanese'],
			['sylo', 'Syloti_Nagri'],
			['sylotinagri', 'Syloti_Nagri'],
			['syrc', 'Syriac'],
			['syriac', 'Syriac'],
			['tagb', 'Tagbanwa'],
			['tagbanwa', 'Tagbanwa'],
			['takr', 'Takri'],
			['takri', 'Takri'],
			['tale', 'Tai_Le'],
			['taile', 'Tai_Le'],
			['talu', 'New_Tai_Lue'],
			['newtailue', 'New_Tai_Lue'],
			['taml', 'Tamil'],
			['tamil', 'Tamil'],
			['tang', 'Tangut'],
			['tangut', 'Tangut'],
			['tavt', 'Tai_Viet'],
			['taiviet', 'Tai_Viet'],
			['telu', 'Telugu'],
			['telugu', 'Telugu'],
			['tfng', 'Tifinagh'],
			['tifinagh', 'Tifinagh'],
			['tglg', 'Tagalog'],
			['tagalog', 'Tagalog'],
			['thaa', 'Thaana'],
			['thaana', 'Thaana'],
			['thai', 'Thai'],
			['tibt', 'Tibetan'],
			['tibetan', 'Tibetan'],
			['tirh', 'Tirhuta'],
			['tirhuta', 'Tirhuta'],
			['ugar', 'Ugaritic'],
			['ugaritic', 'Ugaritic'],
			['vaii', 'Vai'],
			['vai', 'Vai'],
			['wara', 'Warang_Citi'],
			['warangciti', 'Warang_Citi'],
			['xpeo', 'Old_Persian'],
			['oldpersian', 'Old_Persian'],
			['xsux', 'Cuneiform'],
			['cuneiform', 'Cuneiform'],
			['yiii', 'Yi'],
			['yi', 'Yi'],
			['zanb', 'Zanabazar_Square'],
			['zanabazarsquare', 'Zanabazar_Square'],
			['zinh', 'Inherited'],
			['inherited', 'Inherited'],
			['qaai', 'Inherited'],
			['zyyy', 'Common'],
			['common', 'Common'],
			['zzzz', 'Unknown'],
			['unknown', 'Unknown']
		])],
		['Bidi_Class', new Map([
			['al', 'Arabic_Letter'],
			['arabicletter', 'Arabic_Letter'],
			['an', 'Arabic_Number'],
			['arabicnumber', 'Arabic_Number'],
			['b', 'Paragraph_Separator'],
			['paragraphseparator', 'Paragraph_Separator'],
			['bn', 'Boundary_Neutral'],
			['boundaryneutral', 'Boundary_Neutral'],
			['cs', 'Common_Separator'],
			['commonseparator', 'Common_Separator'],
			['en', 'European_Number'],
			['europeannumber', 'European_Number'],
			['es', 'European_Separator'],
			['europeanseparator', 'European_Separator'],
			['et', 'European_Terminator'],
			['europeanterminator', 'European_Terminator'],
			['fsi', 'First_Strong_Isolate'],
			['firststrongisolate', 'First_Strong_Isolate'],
			['l', 'Left_To_Right'],
			['lefttoright', 'Left_To_Right'],
			['lre', 'Left_To_Right_Embedding'],
			['lefttorightembedding', 'Left_To_Right_Embedding'],
			['lri', 'Left_To_Right_Isolate'],
			['lefttorightisolate', 'Left_To_Right_Isolate'],
			['lro', 'Left_To_Right_Override'],
			['lefttorightoverride', 'Left_To_Right_Override'],
			['nsm', 'Nonspacing_Mark'],
			['nonspacingmark', 'Nonspacing_Mark'],
			['on', 'Other_Neutral'],
			['otherneutral', 'Other_Neutral'],
			['pdf', 'Pop_Directional_Format'],
			['popdirectionalformat', 'Pop_Directional_Format'],
			['pdi', 'Pop_Directional_Isolate'],
			['popdirectionalisolate', 'Pop_Directional_Isolate'],
			['r', 'Right_To_Left'],
			['righttoleft', 'Right_To_Left'],
			['rle', 'Right_To_Left_Embedding'],
			['righttoleftembedding', 'Right_To_Left_Embedding'],
			['rli', 'Right_To_Left_Isolate'],
			['righttoleftisolate', 'Right_To_Left_Isolate'],
			['rlo', 'Right_To_Left_Override'],
			['righttoleftoverride', 'Right_To_Left_Override'],
			['s', 'Segment_Separator'],
			['segmentseparator', 'Segment_Separator'],
			['ws', 'White_Space'],
			['whitespace', 'White_Space']
		])],
		['Bidi_Paired_Bracket_Type', new Map([
			['c', 'Close'],
			['close', 'Close'],
			['n', 'None'],
			['none', 'None'],
			['o', 'Open'],
			['open', 'Open']
		])],
		['Canonical_Combining_Class', new Map([
			['nr', 'Not_Reordered'],
			['notreordered', 'Not_Reordered'],
			['ov', 'Overlay'],
			['overlay', 'Overlay'],
			['nk', 'Nukta'],
			['nukta', 'Nukta'],
			['kv', 'Kana_Voicing'],
			['kanavoicing', 'Kana_Voicing'],
			['vr', 'Virama'],
			['virama', 'Virama'],
			['ccc10', 'CCC10'],
			['ccc11', 'CCC11'],
			['ccc12', 'CCC12'],
			['ccc13', 'CCC13'],
			['ccc14', 'CCC14'],
			['ccc15', 'CCC15'],
			['ccc16', 'CCC16'],
			['ccc17', 'CCC17'],
			['ccc18', 'CCC18'],
			['ccc19', 'CCC19'],
			['ccc20', 'CCC20'],
			['ccc21', 'CCC21'],
			['ccc22', 'CCC22'],
			['ccc23', 'CCC23'],
			['ccc24', 'CCC24'],
			['ccc25', 'CCC25'],
			['ccc26', 'CCC26'],
			['ccc27', 'CCC27'],
			['ccc28', 'CCC28'],
			['ccc29', 'CCC29'],
			['ccc30', 'CCC30'],
			['ccc31', 'CCC31'],
			['ccc32', 'CCC32'],
			['ccc33', 'CCC33'],
			['ccc34', 'CCC34'],
			['ccc35', 'CCC35'],
			['ccc36', 'CCC36'],
			['ccc84', 'CCC84'],
			['ccc91', 'CCC91'],
			['ccc103', 'CCC103'],
			['ccc107', 'CCC107'],
			['ccc118', 'CCC118'],
			['ccc122', 'CCC122'],
			['ccc129', 'CCC129'],
			['ccc130', 'CCC130'],
			['ccc132', 'CCC132'],
			['ccc133', 'CCC133'],
			['atbl', 'Attached_Below_Left'],
			['attachedbelowleft', 'Attached_Below_Left'],
			['atb', 'Attached_Below'],
			['attachedbelow', 'Attached_Below'],
			['ata', 'Attached_Above'],
			['attachedabove', 'Attached_Above'],
			['atar', 'Attached_Above_Right'],
			['attachedaboveright', 'Attached_Above_Right'],
			['bl', 'Below_Left'],
			['belowleft', 'Below_Left'],
			['b', 'Below'],
			['below', 'Below'],
			['br', 'Below_Right'],
			['belowright', 'Below_Right'],
			['l', 'Left'],
			['left', 'Left'],
			['r', 'Right'],
			['right', 'Right'],
			['al', 'Above_Left'],
			['aboveleft', 'Above_Left'],
			['a', 'Above'],
			['above', 'Above'],
			['ar', 'Above_Right'],
			['aboveright', 'Above_Right'],
			['db', 'Double_Below'],
			['doublebelow', 'Double_Below'],
			['da', 'Double_Above'],
			['doubleabove', 'Double_Above'],
			['is', 'Iota_Subscript'],
			['iotasubscript', 'Iota_Subscript']
		])],
		['Decomposition_Type', new Map([
			['can', 'Canonical'],
			['canonical', 'Canonical'],
			['com', 'Compat'],
			['compat', 'Compat'],
			['enc', 'Circle'],
			['circle', 'Circle'],
			['fin', 'Final'],
			['final', 'Final'],
			['font', 'Font'],
			['fra', 'Fraction'],
			['fraction', 'Fraction'],
			['init', 'Initial'],
			['initial', 'Initial'],
			['iso', 'Isolated'],
			['isolated', 'Isolated'],
			['med', 'Medial'],
			['medial', 'Medial'],
			['nar', 'Narrow'],
			['narrow', 'Narrow'],
			['nb', 'Nobreak'],
			['nobreak', 'Nobreak'],
			['none', 'None'],
			['sml', 'Small'],
			['small', 'Small'],
			['sqr', 'Square'],
			['square', 'Square'],
			['sub', 'Sub'],
			['sup', 'Super'],
			['super', 'Super'],
			['vert', 'Vertical'],
			['vertical', 'Vertical'],
			['wide', 'Wide']
		])],
		['East_Asian_Width', new Map([
			['a', 'Ambiguous'],
			['ambiguous', 'Ambiguous'],
			['f', 'Fullwidth'],
			['fullwidth', 'Fullwidth'],
			['h', 'Halfwidth'],
			['halfwidth', 'Halfwidth'],
			['n', 'Neutral'],
			['neutral', 'Neutral'],
			['na', 'Narrow'],
			['narrow', 'Narrow'],
			['w', 'Wide'],
			['wide', 'Wide']
		])],
		['General_Category', new Map([
			['c', 'Other'],
			['other', 'Other'],
			['cc', 'Control'],
			['control', 'Control'],
			['cntrl', 'Control'],
			['cf', 'Format'],
			['format', 'Format'],
			['cn', 'Unassigned'],
			['unassigned', 'Unassigned'],
			['co', 'Private_Use'],
			['privateuse', 'Private_Use'],
			['cs', 'Surrogate'],
			['surrogate', 'Surrogate'],
			['l', 'Letter'],
			['letter', 'Letter'],
			['lc', 'Cased_Letter'],
			['casedletter', 'Cased_Letter'],
			['ll', 'Lowercase_Letter'],
			['lowercaseletter', 'Lowercase_Letter'],
			['lm', 'Modifier_Letter'],
			['modifierletter', 'Modifier_Letter'],
			['lo', 'Other_Letter'],
			['otherletter', 'Other_Letter'],
			['lt', 'Titlecase_Letter'],
			['titlecaseletter', 'Titlecase_Letter'],
			['lu', 'Uppercase_Letter'],
			['uppercaseletter', 'Uppercase_Letter'],
			['m', 'Mark'],
			['mark', 'Mark'],
			['combiningmark', 'Mark'],
			['mc', 'Spacing_Mark'],
			['spacingmark', 'Spacing_Mark'],
			['me', 'Enclosing_Mark'],
			['enclosingmark', 'Enclosing_Mark'],
			['mn', 'Nonspacing_Mark'],
			['nonspacingmark', 'Nonspacing_Mark'],
			['n', 'Number'],
			['number', 'Number'],
			['nd', 'Decimal_Number'],
			['decimalnumber', 'Decimal_Number'],
			['digit', 'Decimal_Number'],
			['nl', 'Letter_Number'],
			['letternumber', 'Letter_Number'],
			['no', 'Other_Number'],
			['othernumber', 'Other_Number'],
			['p', 'Punctuation'],
			['punctuation', 'Punctuation'],
			['punct', 'Punctuation'],
			['pc', 'Connector_Punctuation'],
			['connectorpunctuation', 'Connector_Punctuation'],
			['pd', 'Dash_Punctuation'],
			['dashpunctuation', 'Dash_Punctuation'],
			['pe', 'Close_Punctuation'],
			['closepunctuation', 'Close_Punctuation'],
			['pf', 'Final_Punctuation'],
			['finalpunctuation', 'Final_Punctuation'],
			['pi', 'Initial_Punctuation'],
			['initialpunctuation', 'Initial_Punctuation'],
			['po', 'Other_Punctuation'],
			['otherpunctuation', 'Other_Punctuation'],
			['ps', 'Open_Punctuation'],
			['openpunctuation', 'Open_Punctuation'],
			['s', 'Symbol'],
			['symbol', 'Symbol'],
			['sc', 'Currency_Symbol'],
			['currencysymbol', 'Currency_Symbol'],
			['sk', 'Modifier_Symbol'],
			['modifiersymbol', 'Modifier_Symbol'],
			['sm', 'Math_Symbol'],
			['mathsymbol', 'Math_Symbol'],
			['so', 'Other_Symbol'],
			['othersymbol', 'Other_Symbol'],
			['z', 'Separator'],
			['separator', 'Separator'],
			['zl', 'Line_Separator'],
			['lineseparator', 'Line_Separator'],
			['zp', 'Paragraph_Separator'],
			['paragraphseparator', 'Paragraph_Separator'],
			['zs', 'Space_Separator'],
			['spaceseparator', 'Space_Separator']
		])],
		['Grapheme_Cluster_Break', new Map([
			['cn', 'Control'],
			['control', 'Control'],
			['cr', 'CR'],
			['eb', 'E_Base'],
			['ebase', 'E_Base'],
			['ebg', 'E_Base_GAZ'],
			['ebasegaz', 'E_Base_GAZ'],
			['em', 'E_Modifier'],
			['emodifier', 'E_Modifier'],
			['ex', 'Extend'],
			['extend', 'Extend'],
			['gaz', 'Glue_After_Zwj'],
			['glueafterzwj', 'Glue_After_Zwj'],
			['l', 'L'],
			['lf', 'LF'],
			['lv', 'LV'],
			['lvt', 'LVT'],
			['pp', 'Prepend'],
			['prepend', 'Prepend'],
			['ri', 'Regional_Indicator'],
			['regionalindicator', 'Regional_Indicator'],
			['sm', 'SpacingMark'],
			['spacingmark', 'SpacingMark'],
			['t', 'T'],
			['v', 'V'],
			['xx', 'Other'],
			['other', 'Other'],
			['zwj', 'ZWJ']
		])],
		['Hangul_Syllable_Type', new Map([
			['l', 'Leading_Jamo'],
			['leadingjamo', 'Leading_Jamo'],
			['lv', 'LV_Syllable'],
			['lvsyllable', 'LV_Syllable'],
			['lvt', 'LVT_Syllable'],
			['lvtsyllable', 'LVT_Syllable'],
			['na', 'Not_Applicable'],
			['notapplicable', 'Not_Applicable'],
			['t', 'Trailing_Jamo'],
			['trailingjamo', 'Trailing_Jamo'],
			['v', 'Vowel_Jamo'],
			['voweljamo', 'Vowel_Jamo']
		])],
		['Indic_Positional_Category', new Map([
			['bottom', 'Bottom'],
			['bottomandleft', 'Bottom_And_Left'],
			['bottomandright', 'Bottom_And_Right'],
			['left', 'Left'],
			['leftandright', 'Left_And_Right'],
			['na', 'NA'],
			['overstruck', 'Overstruck'],
			['right', 'Right'],
			['top', 'Top'],
			['topandbottom', 'Top_And_Bottom'],
			['topandbottomandright', 'Top_And_Bottom_And_Right'],
			['topandleft', 'Top_And_Left'],
			['topandleftandright', 'Top_And_Left_And_Right'],
			['topandright', 'Top_And_Right'],
			['visualorderleft', 'Visual_Order_Left']
		])],
		['Indic_Syllabic_Category', new Map([
			['avagraha', 'Avagraha'],
			['bindu', 'Bindu'],
			['brahmijoiningnumber', 'Brahmi_Joining_Number'],
			['cantillationmark', 'Cantillation_Mark'],
			['consonant', 'Consonant'],
			['consonantdead', 'Consonant_Dead'],
			['consonantfinal', 'Consonant_Final'],
			['consonantheadletter', 'Consonant_Head_Letter'],
			['consonantinitialpostfixed', 'Consonant_Initial_Postfixed'],
			['consonantkiller', 'Consonant_Killer'],
			['consonantmedial', 'Consonant_Medial'],
			['consonantplaceholder', 'Consonant_Placeholder'],
			['consonantprecedingrepha', 'Consonant_Preceding_Repha'],
			['consonantprefixed', 'Consonant_Prefixed'],
			['consonantsubjoined', 'Consonant_Subjoined'],
			['consonantsucceedingrepha', 'Consonant_Succeeding_Repha'],
			['consonantwithstacker', 'Consonant_With_Stacker'],
			['geminationmark', 'Gemination_Mark'],
			['invisiblestacker', 'Invisible_Stacker'],
			['joiner', 'Joiner'],
			['modifyingletter', 'Modifying_Letter'],
			['nonjoiner', 'Non_Joiner'],
			['nukta', 'Nukta'],
			['number', 'Number'],
			['numberjoiner', 'Number_Joiner'],
			['other', 'Other'],
			['purekiller', 'Pure_Killer'],
			['registershifter', 'Register_Shifter'],
			['syllablemodifier', 'Syllable_Modifier'],
			['toneletter', 'Tone_Letter'],
			['tonemark', 'Tone_Mark'],
			['virama', 'Virama'],
			['visarga', 'Visarga'],
			['vowel', 'Vowel'],
			['voweldependent', 'Vowel_Dependent'],
			['vowelindependent', 'Vowel_Independent']
		])],
		['Joining_Group', new Map([
			['africanfeh', 'African_Feh'],
			['africannoon', 'African_Noon'],
			['africanqaf', 'African_Qaf'],
			['ain', 'Ain'],
			['alaph', 'Alaph'],
			['alef', 'Alef'],
			['beh', 'Beh'],
			['beth', 'Beth'],
			['burushaskiyehbarree', 'Burushaski_Yeh_Barree'],
			['dal', 'Dal'],
			['dalathrish', 'Dalath_Rish'],
			['e', 'E'],
			['farsiyeh', 'Farsi_Yeh'],
			['fe', 'Fe'],
			['feh', 'Feh'],
			['finalsemkath', 'Final_Semkath'],
			['gaf', 'Gaf'],
			['gamal', 'Gamal'],
			['hah', 'Hah'],
			['hanifirohingyakinnaya', 'Hanifi_Rohingya_Kinna_Ya'],
			['hanifirohingyapa', 'Hanifi_Rohingya_Pa'],
			['he', 'He'],
			['heh', 'Heh'],
			['hehgoal', 'Heh_Goal'],
			['heth', 'Heth'],
			['kaf', 'Kaf'],
			['kaph', 'Kaph'],
			['khaph', 'Khaph'],
			['knottedheh', 'Knotted_Heh'],
			['lam', 'Lam'],
			['lamadh', 'Lamadh'],
			['malayalambha', 'Malayalam_Bha'],
			['malayalamja', 'Malayalam_Ja'],
			['malayalamlla', 'Malayalam_Lla'],
			['malayalamllla', 'Malayalam_Llla'],
			['malayalamnga', 'Malayalam_Nga'],
			['malayalamnna', 'Malayalam_Nna'],
			['malayalamnnna', 'Malayalam_Nnna'],
			['malayalamnya', 'Malayalam_Nya'],
			['malayalamra', 'Malayalam_Ra'],
			['malayalamssa', 'Malayalam_Ssa'],
			['malayalamtta', 'Malayalam_Tta'],
			['manichaeanaleph', 'Manichaean_Aleph'],
			['manichaeanayin', 'Manichaean_Ayin'],
			['manichaeanbeth', 'Manichaean_Beth'],
			['manichaeandaleth', 'Manichaean_Daleth'],
			['manichaeandhamedh', 'Manichaean_Dhamedh'],
			['manichaeanfive', 'Manichaean_Five'],
			['manichaeangimel', 'Manichaean_Gimel'],
			['manichaeanheth', 'Manichaean_Heth'],
			['manichaeanhundred', 'Manichaean_Hundred'],
			['manichaeankaph', 'Manichaean_Kaph'],
			['manichaeanlamedh', 'Manichaean_Lamedh'],
			['manichaeanmem', 'Manichaean_Mem'],
			['manichaeannun', 'Manichaean_Nun'],
			['manichaeanone', 'Manichaean_One'],
			['manichaeanpe', 'Manichaean_Pe'],
			['manichaeanqoph', 'Manichaean_Qoph'],
			['manichaeanresh', 'Manichaean_Resh'],
			['manichaeansadhe', 'Manichaean_Sadhe'],
			['manichaeansamekh', 'Manichaean_Samekh'],
			['manichaeantaw', 'Manichaean_Taw'],
			['manichaeanten', 'Manichaean_Ten'],
			['manichaeanteth', 'Manichaean_Teth'],
			['manichaeanthamedh', 'Manichaean_Thamedh'],
			['manichaeantwenty', 'Manichaean_Twenty'],
			['manichaeanwaw', 'Manichaean_Waw'],
			['manichaeanyodh', 'Manichaean_Yodh'],
			['manichaeanzayin', 'Manichaean_Zayin'],
			['meem', 'Meem'],
			['mim', 'Mim'],
			['nojoininggroup', 'No_Joining_Group'],
			['noon', 'Noon'],
			['nun', 'Nun'],
			['nya', 'Nya'],
			['pe', 'Pe'],
			['qaf', 'Qaf'],
			['qaph', 'Qaph'],
			['reh', 'Reh'],
			['reversedpe', 'Reversed_Pe'],
			['rohingyayeh', 'Rohingya_Yeh'],
			['sad', 'Sad'],
			['sadhe', 'Sadhe'],
			['seen', 'Seen'],
			['semkath', 'Semkath'],
			['shin', 'Shin'],
			['straightwaw', 'Straight_Waw'],
			['swashkaf', 'Swash_Kaf'],
			['syriacwaw', 'Syriac_Waw'],
			['tah', 'Tah'],
			['taw', 'Taw'],
			['tehmarbuta', 'Teh_Marbuta'],
			['tehmarbutagoal', 'Hamza_On_Heh_Goal'],
			['hamzaonhehgoal', 'Hamza_On_Heh_Goal'],
			['teth', 'Teth'],
			['waw', 'Waw'],
			['yeh', 'Yeh'],
			['yehbarree', 'Yeh_Barree'],
			['yehwithtail', 'Yeh_With_Tail'],
			['yudh', 'Yudh'],
			['yudhhe', 'Yudh_He'],
			['zain', 'Zain'],
			['zhain', 'Zhain']
		])],
		['Joining_Type', new Map([
			['c', 'Join_Causing'],
			['joincausing', 'Join_Causing'],
			['d', 'Dual_Joining'],
			['dualjoining', 'Dual_Joining'],
			['l', 'Left_Joining'],
			['leftjoining', 'Left_Joining'],
			['r', 'Right_Joining'],
			['rightjoining', 'Right_Joining'],
			['t', 'Transparent'],
			['transparent', 'Transparent'],
			['u', 'Non_Joining'],
			['nonjoining', 'Non_Joining']
		])],
		['Line_Break', new Map([
			['ai', 'Ambiguous'],
			['ambiguous', 'Ambiguous'],
			['al', 'Alphabetic'],
			['alphabetic', 'Alphabetic'],
			['b2', 'Break_Both'],
			['breakboth', 'Break_Both'],
			['ba', 'Break_After'],
			['breakafter', 'Break_After'],
			['bb', 'Break_Before'],
			['breakbefore', 'Break_Before'],
			['bk', 'Mandatory_Break'],
			['mandatorybreak', 'Mandatory_Break'],
			['cb', 'Contingent_Break'],
			['contingentbreak', 'Contingent_Break'],
			['cj', 'Conditional_Japanese_Starter'],
			['conditionaljapanesestarter', 'Conditional_Japanese_Starter'],
			['cl', 'Close_Punctuation'],
			['closepunctuation', 'Close_Punctuation'],
			['cm', 'Combining_Mark'],
			['combiningmark', 'Combining_Mark'],
			['cp', 'Close_Parenthesis'],
			['closeparenthesis', 'Close_Parenthesis'],
			['cr', 'Carriage_Return'],
			['carriagereturn', 'Carriage_Return'],
			['eb', 'E_Base'],
			['ebase', 'E_Base'],
			['em', 'E_Modifier'],
			['emodifier', 'E_Modifier'],
			['ex', 'Exclamation'],
			['exclamation', 'Exclamation'],
			['gl', 'Glue'],
			['glue', 'Glue'],
			['h2', 'H2'],
			['h3', 'H3'],
			['hl', 'Hebrew_Letter'],
			['hebrewletter', 'Hebrew_Letter'],
			['hy', 'Hyphen'],
			['hyphen', 'Hyphen'],
			['id', 'Ideographic'],
			['ideographic', 'Ideographic'],
			['in', 'Inseparable'],
			['inseparable', 'Inseparable'],
			['inseperable', 'Inseparable'],
			['is', 'Infix_Numeric'],
			['infixnumeric', 'Infix_Numeric'],
			['jl', 'JL'],
			['jt', 'JT'],
			['jv', 'JV'],
			['lf', 'Line_Feed'],
			['linefeed', 'Line_Feed'],
			['nl', 'Next_Line'],
			['nextline', 'Next_Line'],
			['ns', 'Nonstarter'],
			['nonstarter', 'Nonstarter'],
			['nu', 'Numeric'],
			['numeric', 'Numeric'],
			['op', 'Open_Punctuation'],
			['openpunctuation', 'Open_Punctuation'],
			['po', 'Postfix_Numeric'],
			['postfixnumeric', 'Postfix_Numeric'],
			['pr', 'Prefix_Numeric'],
			['prefixnumeric', 'Prefix_Numeric'],
			['qu', 'Quotation'],
			['quotation', 'Quotation'],
			['ri', 'Regional_Indicator'],
			['regionalindicator', 'Regional_Indicator'],
			['sa', 'Complex_Context'],
			['complexcontext', 'Complex_Context'],
			['sg', 'Surrogate'],
			['surrogate', 'Surrogate'],
			['sp', 'Space'],
			['space', 'Space'],
			['sy', 'Break_Symbols'],
			['breaksymbols', 'Break_Symbols'],
			['wj', 'Word_Joiner'],
			['wordjoiner', 'Word_Joiner'],
			['xx', 'Unknown'],
			['unknown', 'Unknown'],
			['zw', 'ZWSpace'],
			['zwspace', 'ZWSpace'],
			['zwj', 'ZWJ']
		])],
		['NFC_Quick_Check', new Map([
			['m', 'Maybe'],
			['maybe', 'Maybe'],
			['n', 'No'],
			['no', 'No'],
			['y', 'Yes'],
			['yes', 'Yes']
		])],
		['NFD_Quick_Check', new Map([
			['n', 'No'],
			['no', 'No'],
			['y', 'Yes'],
			['yes', 'Yes']
		])],
		['NFKC_Quick_Check', new Map([
			['m', 'Maybe'],
			['maybe', 'Maybe'],
			['n', 'No'],
			['no', 'No'],
			['y', 'Yes'],
			['yes', 'Yes']
		])],
		['NFKD_Quick_Check', new Map([
			['n', 'No'],
			['no', 'No'],
			['y', 'Yes'],
			['yes', 'Yes']
		])],
		['Numeric_Type', new Map([
			['de', 'Decimal'],
			['decimal', 'Decimal'],
			['di', 'Digit'],
			['digit', 'Digit'],
			['none', 'None'],
			['nu', 'Numeric'],
			['numeric', 'Numeric']
		])],
		['Sentence_Break', new Map([
			['at', 'ATerm'],
			['aterm', 'ATerm'],
			['cl', 'Close'],
			['close', 'Close'],
			['cr', 'CR'],
			['ex', 'Extend'],
			['extend', 'Extend'],
			['fo', 'Format'],
			['format', 'Format'],
			['le', 'OLetter'],
			['oletter', 'OLetter'],
			['lf', 'LF'],
			['lo', 'Lower'],
			['lower', 'Lower'],
			['nu', 'Numeric'],
			['numeric', 'Numeric'],
			['sc', 'SContinue'],
			['scontinue', 'SContinue'],
			['se', 'Sep'],
			['sep', 'Sep'],
			['sp', 'Sp'],
			['st', 'STerm'],
			['sterm', 'STerm'],
			['up', 'Upper'],
			['upper', 'Upper'],
			['xx', 'Other'],
			['other', 'Other']
		])],
		['Vertical_Orientation', new Map([
			['r', 'Rotated'],
			['rotated', 'Rotated'],
			['tr', 'Transformed_Rotated'],
			['transformedrotated', 'Transformed_Rotated'],
			['tu', 'Transformed_Upright'],
			['transformedupright', 'Transformed_Upright'],
			['u', 'Upright'],
			['upright', 'Upright']
		])],
		['Word_Break', new Map([
			['cr', 'CR'],
			['dq', 'Double_Quote'],
			['doublequote', 'Double_Quote'],
			['eb', 'E_Base'],
			['ebase', 'E_Base'],
			['ebg', 'E_Base_GAZ'],
			['ebasegaz', 'E_Base_GAZ'],
			['em', 'E_Modifier'],
			['emodifier', 'E_Modifier'],
			['ex', 'ExtendNumLet'],
			['extendnumlet', 'ExtendNumLet'],
			['extend', 'Extend'],
			['fo', 'Format'],
			['format', 'Format'],
			['gaz', 'Glue_After_Zwj'],
			['glueafterzwj', 'Glue_After_Zwj'],
			['hl', 'Hebrew_Letter'],
			['hebrewletter', 'Hebrew_Letter'],
			['ka', 'Katakana'],
			['katakana', 'Katakana'],
			['le', 'ALetter'],
			['aletter', 'ALetter'],
			['lf', 'LF'],
			['mb', 'MidNumLet'],
			['midnumlet', 'MidNumLet'],
			['ml', 'MidLetter'],
			['midletter', 'MidLetter'],
			['mn', 'MidNum'],
			['midnum', 'MidNum'],
			['nl', 'Newline'],
			['newline', 'Newline'],
			['nu', 'Numeric'],
			['numeric', 'Numeric'],
			['ri', 'Regional_Indicator'],
			['regionalindicator', 'Regional_Indicator'],
			['sq', 'Single_Quote'],
			['singlequote', 'Single_Quote'],
			['wsegspace', 'WSegSpace'],
			['xx', 'Other'],
			['other', 'Other'],
			['zwj', 'ZWJ']
		])],
		['ASCII_Hex_Digit', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Alphabetic', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Bidi_Control', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Bidi_Mirrored', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Cased', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Composition_Exclusion', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Case_Ignorable', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Full_Composition_Exclusion', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Changes_When_Casefolded', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Changes_When_Casemapped', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Changes_When_NFKC_Casefolded', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Changes_When_Lowercased', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Changes_When_Titlecased', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Changes_When_Uppercased', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Dash', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Deprecated', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Default_Ignorable_Code_Point', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Diacritic', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Extender', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Grapheme_Base', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Grapheme_Extend', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Grapheme_Link', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Hex_Digit', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Hyphen', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['ID_Continue', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Ideographic', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['ID_Start', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['IDS_Binary_Operator', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['IDS_Trinary_Operator', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Join_Control', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Logical_Order_Exception', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Lowercase', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Math', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Noncharacter_Code_Point', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Other_Alphabetic', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Other_Default_Ignorable_Code_Point', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Other_Grapheme_Extend', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Other_ID_Continue', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Other_ID_Start', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Other_Lowercase', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Other_Math', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Other_Uppercase', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Pattern_Syntax', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Pattern_White_Space', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Prepended_Concatenation_Mark', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Quotation_Mark', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Radical', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Regional_Indicator', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Soft_Dotted', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Sentence_Terminal', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Terminal_Punctuation', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Unified_Ideograph', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Uppercase', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Variation_Selector', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['White_Space', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['XID_Continue', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['XID_Start', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Expands_On_NFC', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Expands_On_NFD', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Expands_On_NFKC', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])],
		['Expands_On_NFKD', new Map([
			['n', 'No'],
			['no', 'No'],
			['f', 'No'],
			['false', 'No'],
			['y', 'Yes'],
			['yes', 'Yes'],
			['t', 'Yes'],
			['true', 'Yes']
		])]
	])
};
