# Community contributions

The `contrib` directory contains community contributions
that are not yet ready to be part of the poliastro API,
but are nonetheless useful for Astrodynamics Python users.

If you have a small script or set of them
related to Astrodynamics and Orbital Mechanics
but you feel they are "ugly", "not polished",
or you are just not sure "if anybody will find it useful",
we would be thrilled if you shared it with us here!

If you want to upload your code here,
please follow these steps:

- If it's only one script,
  or comment at the top
  specifying your name, email,
  what the script does,
  what extra libraries are needed (if any),
  and cite any scientific references related to your work.
- If it's a series of scripts,
  create a new `lower_case` named directory
  having a `README.md` specifying your name, email,
  what the scripts do,
  and cite any scientific references related to your work,
  as well as a `requirements.txt` or conda `environment.yml`
  specifying any required dependencies.

And if you have any questions,
please [join our chat](http://chat.poliastro.space)
or [open an issue](https://github.com/poliastro/poliastro/issues/new)!

Note that:

- You don't need to use `git` or the command line!
  The GitHub UI helps you
  [add files to the repository](https://docs.github.com/en/github/managing-files-in-a-repository/adding-a-file-to-a-repository).
- We are interested in contributions that can be used from Python,
  so either they should be pure Python
  or be written in a compiled language with a Python wrapper.
- All contributions will be permissively licensed with the MIT license,
  the one that poliastro uses.
  If you don't agree with this,
  we ask you to find a different place to share your contribution.
