/* $Cambridge: hermes/src/prayer/session/mc.c,v 1.2 2008/09/16 09:59:58 dpc22 Exp $ */

#include "prayer_session.h"

/* mc_date_to_string() ***************************************************
 *
 * Convert (month, day, year) tuple into printable form.
 *   month: month in range 1 to 12
 *     day: Day in range 1 to 31
 *    year: Four digit date.
 *
 * Returns: Date in printable form
 ***********************************************************************/

char *mc_date_to_string(MESSAGECACHE *mc)
{
    static char result[64];
    static char *date_month[12] = {
        "Jan", "Feb", "Mar", "Apr", "May", "Jun",
        "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
    };

    if ((mc->month < 1) || (mc->month > 12))
        return ("");

    sprintf(result, "%s %d %d",
            date_month[mc->month - 1], mc->day, mc->year + BASEYEAR);

    return (result);
}

/* mc_date_to_string_full() **********************************************
 *
 * Convert (mins, hours, month, day, year) tuple into printable form.
 *    mins: minutes in range 0:59
 *   hours: hours in range 0:23
 *   month: month in range 1 to 12
 *     day: Day in range 1 to 31
 *    year: Four digit date.
 *
 * Returns: Date in printable form
 ***********************************************************************/

char *mc_date_to_string_full(MESSAGECACHE *mc)
{
    static char result[64];
    static char *date_month[12] = {
        "Jan", "Feb", "Mar", "Apr", "May", "Jun",
        "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
    };

    if ((mc->month < 1) || (mc->month > 12))
        return ("");

    sprintf(result, "%s %02d %04d %02d:%02d ",
            date_month[mc->month - 1], mc->day, 
            mc->year + BASEYEAR, mc->hours, mc->minutes);

    return (result);
}
