# This file is dual licensed under the terms of the Apache License, Version
# 2.0, and the BSD License. See the LICENSE file in the root of this repository
# for complete details.

# Cryptography documentation build configuration file, created by
# sphinx-quickstart on Tue Aug  6 19:19:14 2013.
#
# This file is execfile()d with the current directory set to its containing dir
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import os
import sys

try:
    import sphinx_rtd_theme
except ImportError:
    sphinx_rtd_theme = None

try:
    from sphinxcontrib import spelling
except ImportError:
    spelling = None


# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(0, os.path.abspath("_ext"))

# -- General configuration ----------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions  coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.autosectionlabel",
    "sphinx.ext.doctest",
    "sphinx.ext.intersphinx",
    "sphinx.ext.linkcode",
    "cryptography-docs",
    "sphinx_rtd_theme",
]

if spelling is not None:
    extensions.append("sphinxcontrib.spelling")

# Linkcode resolver
from linkcode_res import linkcode_resolve  # noqa: E402, F401

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

nitpicky = True

# The suffix of source filenames.
source_suffix = ".rst"

# The encoding of source files.
# source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "Cryptography"
copyright = "2013-2024, Individual Contributors"

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#

base_dir = os.path.join(os.path.dirname(__file__), os.pardir)
about = {}
with open(os.path.join(base_dir, "src", "cryptography", "__about__.py")) as f:
    exec(f.read(), about)

version = release = about["__version__"]

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
# language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ["_build"]

# The reST default role (used for this markup: `text`) to use for all documents
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# -- Options for HTML output --------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.

if sphinx_rtd_theme:
    html_theme = "sphinx_rtd_theme"
else:
    html_theme = "default"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

# Output file base name for HTML help builder.
htmlhelp_basename = "Cryptographydoc"


# -- Options for LaTeX output -------------------------------------------------

latex_elements = {}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howto/manual])
latex_documents = [
    (
        "index",
        "Cryptography.tex",
        "Cryptography Documentation",
        "Individual Contributors",
        "manual",
    ),
]

# -- Options for manual page output -------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (
        "index",
        "cryptography",
        "Cryptography Documentation",
        ["Individual Contributors"],
        1,
    )
]

# -- Options for Texinfo output -----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        "index",
        "Cryptography",
        "Cryptography Documentation",
        "Individual Contributors",
        "Cryptography",
        "One line description of project.",
        "Miscellaneous",
    ),
]

intersphinx_mapping = {"python": ("https://docs.python.org/3", None)}

epub_theme = "epub"

# Retry requests in the linkcheck builder so that we're resillient against
# transient network errors.
linkcheck_retries = 10

linkcheck_timeout = 5

linkcheck_ignore = [
    # Insecure renegotiation settings
    r"https://info.isl.ntt.co.jp/crypt/eng/camellia/",
    # Cloudflare returns 403s for all non-browser requests
    r"https://speakerdeck.com",
    r"https://\w+.stackexchange.com",
    r"https://stackoverflow.com",
    # GitHub changed how they do page renders so anchor detection
    # no longer works in source view
    r"https://github.com/.*/blob/.*#L\d+",
    # Kuleuven struggles with the endless forward march of time
    r"https://www.cosic.esat.kuleuven.be",
]

autosectionlabel_prefix_document = True
