# envs
Easy access of environment variables from Python with support for booleans, strings, lists, tuples, integers, floats, and dicts.

## Use Case

If you need environment variables for your settings but need an easy way of using Python objects instead of just strings. For example, if you need a list of strings.

## Features

- CLI to convert settings
- CLI to list and check environment variables
- Use strings, lists, tuples, integers, floats or dicts. **IMPORTANT:** When setting the variables in your environmenet (ex. in .env file) wrap them in single or double quotes (ex. `"['some','list']"`) 

[![Build Status](https://travis-ci.org/capless/envs.svg?branch=master)](https://travis-ci.org/capless/envs)

## Quick Start
### Install
#### Install without CLI Requirements

```commandline
pip install envs
```
#### Install with CLI Requirements

```commandline
pip install envs["cli"]
```
### Run Convert Settings

**IMPORTANT:** Don't name this file the same as the original module (you have added the imports back yet).  
```commandline
envs convert_settings --settings-file your.settings.module
```

### Copy and Paste the Imports and Logic Code From Original File

Envs does not copy and paste your imports from your original code, so you have to do this manually.

### Run List Envs

This tells you what envs have default v
```commandline
envs list_envs --settings-file your.settings.module
```
## General API

```python
from envs import env

env('SOMEVAR','default value for that var',var_type='string',allow_none=True)
```

### Strings

**Environment Variable Example:** SECRET_KEY='adfadfadfafasf'
```python
>>>from envs import env

>>>env('SECRET_KEY','default secret key here')
'adfadfadfafasf'
```

### Lists
**Environment Variable Example:** SERVER_NAMES="['coastal','inland','western']"
```python
>>>from envs import env

>>>env('SERVER_NAMES',var_type='list')
['coastal','inland','western']
```

### Tuples
**Environment Variable Example:** SERVER_NAMES="('coastal','inland','western')"

```python
>>>from envs import env

>>>env('SERVER_NAMES',var_type='tuple')
('coastal','inland','western')
```

### Dicts
**Environment Variable Example:** DATABASE="{'USER':'name','PASSWORD':'password'}"

```python
>>>from envs import env

>>>env('DATABASE',var_type='dict')
{'USER':'name','PASSWORD':'password'}
```

### Integers

**Environment Variable Example:** NO_SERVERS=12
```python
>>>from envs import env

>>>env('NO_SERVERS',var_type='integer')
12
```

### Floats

**Environment Variable Example:** INDEX_WEIGHT=0.9
```python
>>>from envs import env

>>>env('INDEX_WEIGHT',var_type='float')
0.9
```

### Booleans
**Environment Variable Example:** USE_PROFILE=false
```python
>>>from envs import env

>>>env('USE_PROFILE',var_type='boolean')
False
```

### Decimals
**Environment Variable Example:** HALF_SEVEN=3.5
```python
>>> from envs import env

>>> env('HALF_SEVEN', var_type='decimal')
Decimal('3.5')
```

## Command Line Utils

**IMPORTANT:** All of the command arguments will fallback to becoming prompts if not set when calling the commands.

### Convert Module (convert_module)

Converts an existing settings file so it uses envs. **IMPORTANT:** This command does not copy your **import** stataements to the new module. 

#### Arguments

- **settings-file:** - Dot notated import string for settings file

```commandline
envs convert_module --settings-file your.settings
```

### List Envs (list_envs)

Shows a list of env instances set in a settings file.

- **settings-file:** - Dot notated import string for settings file
- **keep-result:** - Keep the .env_results file generated by this command (**default:** False)

```commandline
envs list_envs --settings-file your.settings --keep-result False
```

### Check Envs (check_envs)

Make sure that the defined envs with no default value have a value set in the environment. This command will raise an **EnvsValueException** if there is environment variable that should be set that is not. This command is meant for use with a CI/CD tool as a way to halt the build if there isn't a value for an environment variable.

- **settings-file:** - Dot notated import string for settings file

```commandline
envs check_envs --settings-file your.settings
```

### Author

**Twitter:**:[@brianjinwright](https://twitter.com/brianjinwright)
**Github:** [bjinwright](https://github.com/bjinwright)
