/* Automatically generated nanopb header */
/* Generated by nanopb-0.4.6-dev */

#ifndef PB_PB_FLIPPER_PB_H_INCLUDED
#define PB_PB_FLIPPER_PB_H_INCLUDED
#include <pb.h>
#include "storage.pb.h"
#include "system.pb.h"
#include "application.pb.h"
#include "gui.pb.h"
#include "gpio.pb.h"
#include "property.pb.h"

#if PB_PROTO_HEADER_VERSION != 40
#error Regenerate this file with the current version of nanopb generator.
#endif

/* Enum definitions */
typedef enum _PB_CommandStatus { 
    PB_CommandStatus_OK = 0, 
    /* *< Common Errors */
    PB_CommandStatus_ERROR = 1, /* *< Unknown error */
    PB_CommandStatus_ERROR_DECODE = 2, /* *< Command can't be decoded successfully - command_id in response may be wrong! */
    PB_CommandStatus_ERROR_NOT_IMPLEMENTED = 3, /* *< Command succesfully decoded, but not implemented (deprecated or not yet implemented) */
    PB_CommandStatus_ERROR_BUSY = 4, /* *< Somebody took global lock, so not all commands are available */
    PB_CommandStatus_ERROR_CONTINUOUS_COMMAND_INTERRUPTED = 14, /* *< Not received has_next == 0 */
    PB_CommandStatus_ERROR_INVALID_PARAMETERS = 15, /* *< not provided (or provided invalid) crucial parameters to perform rpc */
    /* *< Storage Errors */
    PB_CommandStatus_ERROR_STORAGE_NOT_READY = 5, /* *< FS not ready */
    PB_CommandStatus_ERROR_STORAGE_EXIST = 6, /* *< File/Dir alrady exist */
    PB_CommandStatus_ERROR_STORAGE_NOT_EXIST = 7, /* *< File/Dir does not exist */
    PB_CommandStatus_ERROR_STORAGE_INVALID_PARAMETER = 8, /* *< Invalid API parameter */
    PB_CommandStatus_ERROR_STORAGE_DENIED = 9, /* *< Access denied */
    PB_CommandStatus_ERROR_STORAGE_INVALID_NAME = 10, /* *< Invalid name/path */
    PB_CommandStatus_ERROR_STORAGE_INTERNAL = 11, /* *< Internal error */
    PB_CommandStatus_ERROR_STORAGE_NOT_IMPLEMENTED = 12, /* *< Functon not implemented */
    PB_CommandStatus_ERROR_STORAGE_ALREADY_OPEN = 13, /* *< File/Dir already opened */
    PB_CommandStatus_ERROR_STORAGE_DIR_NOT_EMPTY = 18, /* *< Directory, you're going to remove is not empty */
    /* *< Application Errors */
    PB_CommandStatus_ERROR_APP_CANT_START = 16, /* *< Can't start app - internal error */
    PB_CommandStatus_ERROR_APP_SYSTEM_LOCKED = 17, /* *< Another app is running */
    PB_CommandStatus_ERROR_APP_NOT_RUNNING = 21, /* *< App is not running or doesn't support RPC commands */
    PB_CommandStatus_ERROR_APP_CMD_ERROR = 22, /* *< Command execution error */
    /* *< Virtual Display Errors */
    PB_CommandStatus_ERROR_VIRTUAL_DISPLAY_ALREADY_STARTED = 19, /* *< Virtual Display session can't be started twice */
    PB_CommandStatus_ERROR_VIRTUAL_DISPLAY_NOT_STARTED = 20, /* *< Virtual Display session can't be stopped when it's not started */
    /* *< GPIO Errors */
    PB_CommandStatus_ERROR_GPIO_MODE_INCORRECT = 58, 
    PB_CommandStatus_ERROR_GPIO_UNKNOWN_PIN_MODE = 59 
} PB_CommandStatus;

/* Struct definitions */
/* There are Server commands (e.g. Storage_write), which have no body message
 in response. But 'oneof' obligate to have at least 1 encoded message
 in scope. For this needs Empty message is implemented. */
typedef struct _PB_Empty { 
    char dummy_field;
} PB_Empty;

typedef struct _PB_Region { 
    pb_bytes_array_t *country_code; 
    pb_callback_t bands; 
} PB_Region;

typedef struct _PB_StopSession { 
    char dummy_field;
} PB_StopSession;

typedef struct _PB_Main { 
    uint32_t command_id; 
    PB_CommandStatus command_status; 
    bool has_next; 
    pb_callback_t cb_content;
    pb_size_t which_content;
    union {
        PB_Empty empty;
        PB_System_PingRequest system_ping_request;
        PB_System_PingResponse system_ping_response;
        PB_Storage_ListRequest storage_list_request;
        PB_Storage_ListResponse storage_list_response;
        PB_Storage_ReadRequest storage_read_request;
        PB_Storage_ReadResponse storage_read_response;
        PB_Storage_WriteRequest storage_write_request;
        PB_Storage_DeleteRequest storage_delete_request;
        PB_Storage_MkdirRequest storage_mkdir_request;
        PB_Storage_Md5sumRequest storage_md5sum_request;
        PB_Storage_Md5sumResponse storage_md5sum_response;
        PB_App_StartRequest app_start_request;
        PB_App_LockStatusRequest app_lock_status_request;
        PB_App_LockStatusResponse app_lock_status_response;
        PB_StopSession stop_session;
        PB_Gui_StartScreenStreamRequest gui_start_screen_stream_request;
        PB_Gui_StopScreenStreamRequest gui_stop_screen_stream_request;
        PB_Gui_ScreenFrame gui_screen_frame;
        PB_Gui_SendInputEventRequest gui_send_input_event_request;
        PB_Storage_StatRequest storage_stat_request;
        PB_Storage_StatResponse storage_stat_response;
        PB_Gui_StartVirtualDisplayRequest gui_start_virtual_display_request;
        PB_Gui_StopVirtualDisplayRequest gui_stop_virtual_display_request;
        PB_Storage_InfoRequest storage_info_request;
        PB_Storage_InfoResponse storage_info_response;
        PB_Storage_RenameRequest storage_rename_request;
        PB_System_RebootRequest system_reboot_request;
        PB_System_DeviceInfoRequest system_device_info_request;
        PB_System_DeviceInfoResponse system_device_info_response;
        PB_System_FactoryResetRequest system_factory_reset_request;
        PB_System_GetDateTimeRequest system_get_datetime_request;
        PB_System_GetDateTimeResponse system_get_datetime_response;
        PB_System_SetDateTimeRequest system_set_datetime_request;
        PB_System_PlayAudiovisualAlertRequest system_play_audiovisual_alert_request;
        PB_System_ProtobufVersionRequest system_protobuf_version_request;
        PB_System_ProtobufVersionResponse system_protobuf_version_response;
        PB_System_UpdateRequest system_update_request;
        PB_Storage_BackupCreateRequest storage_backup_create_request;
        PB_Storage_BackupRestoreRequest storage_backup_restore_request;
        PB_System_PowerInfoRequest system_power_info_request;
        PB_System_PowerInfoResponse system_power_info_response;
        PB_System_UpdateResponse system_update_response;
        PB_App_AppExitRequest app_exit_request;
        PB_App_AppLoadFileRequest app_load_file_request;
        PB_App_AppButtonPressRequest app_button_press_request;
        PB_App_AppButtonReleaseRequest app_button_release_request;
        PB_Gpio_SetPinMode gpio_set_pin_mode;
        PB_Gpio_SetInputPull gpio_set_input_pull;
        PB_Gpio_GetPinMode gpio_get_pin_mode;
        PB_Gpio_GetPinModeResponse gpio_get_pin_mode_response;
        PB_Gpio_ReadPin gpio_read_pin;
        PB_Gpio_ReadPinResponse gpio_read_pin_response;
        PB_Gpio_WritePin gpio_write_pin;
        PB_App_AppStateResponse app_state_response;
        PB_Storage_TimestampRequest storage_timestamp_request;
        PB_Storage_TimestampResponse storage_timestamp_response;
        PB_Property_GetRequest property_get_request;
        PB_Property_GetResponse property_get_response;
        PB_App_GetErrorRequest app_get_error_request;
        PB_App_GetErrorResponse app_get_error_response;
        PB_App_DataExchangeRequest app_data_exchange_request;
    } content; 
} PB_Main;

typedef struct _PB_Region_Band { 
    uint32_t start; 
    uint32_t end; 
    int8_t power_limit; 
    uint8_t duty_cycle; 
} PB_Region_Band;


/* Helper constants for enums */
#define _PB_CommandStatus_MIN PB_CommandStatus_OK
#define _PB_CommandStatus_MAX PB_CommandStatus_ERROR_GPIO_UNKNOWN_PIN_MODE
#define _PB_CommandStatus_ARRAYSIZE ((PB_CommandStatus)(PB_CommandStatus_ERROR_GPIO_UNKNOWN_PIN_MODE+1))


#ifdef __cplusplus
extern "C" {
#endif

/* Initializer values for message structs */
#define PB_Empty_init_default                    {0}
#define PB_StopSession_init_default              {0}
#define PB_Main_init_default                     {0, _PB_CommandStatus_MIN, 0, {{NULL}, NULL}, 0, {PB_Empty_init_default}}
#define PB_Region_init_default                   {NULL, {{NULL}, NULL}}
#define PB_Region_Band_init_default              {0, 0, 0, 0}
#define PB_Empty_init_zero                       {0}
#define PB_StopSession_init_zero                 {0}
#define PB_Main_init_zero                        {0, _PB_CommandStatus_MIN, 0, {{NULL}, NULL}, 0, {PB_Empty_init_zero}}
#define PB_Region_init_zero                      {NULL, {{NULL}, NULL}}
#define PB_Region_Band_init_zero                 {0, 0, 0, 0}

/* Field tags (for use in manual encoding/decoding) */
#define PB_Region_country_code_tag               1
#define PB_Region_bands_tag                      2
#define PB_Main_command_id_tag                   1
#define PB_Main_command_status_tag               2
#define PB_Main_has_next_tag                     3
#define PB_Main_empty_tag                        4
#define PB_Main_system_ping_request_tag          5
#define PB_Main_system_ping_response_tag         6
#define PB_Main_storage_list_request_tag         7
#define PB_Main_storage_list_response_tag        8
#define PB_Main_storage_read_request_tag         9
#define PB_Main_storage_read_response_tag        10
#define PB_Main_storage_write_request_tag        11
#define PB_Main_storage_delete_request_tag       12
#define PB_Main_storage_mkdir_request_tag        13
#define PB_Main_storage_md5sum_request_tag       14
#define PB_Main_storage_md5sum_response_tag      15
#define PB_Main_app_start_request_tag            16
#define PB_Main_app_lock_status_request_tag      17
#define PB_Main_app_lock_status_response_tag     18
#define PB_Main_stop_session_tag                 19
#define PB_Main_gui_start_screen_stream_request_tag 20
#define PB_Main_gui_stop_screen_stream_request_tag 21
#define PB_Main_gui_screen_frame_tag             22
#define PB_Main_gui_send_input_event_request_tag 23
#define PB_Main_storage_stat_request_tag         24
#define PB_Main_storage_stat_response_tag        25
#define PB_Main_gui_start_virtual_display_request_tag 26
#define PB_Main_gui_stop_virtual_display_request_tag 27
#define PB_Main_storage_info_request_tag         28
#define PB_Main_storage_info_response_tag        29
#define PB_Main_storage_rename_request_tag       30
#define PB_Main_system_reboot_request_tag        31
#define PB_Main_system_device_info_request_tag   32
#define PB_Main_system_device_info_response_tag  33
#define PB_Main_system_factory_reset_request_tag 34
#define PB_Main_system_get_datetime_request_tag  35
#define PB_Main_system_get_datetime_response_tag 36
#define PB_Main_system_set_datetime_request_tag  37
#define PB_Main_system_play_audiovisual_alert_request_tag 38
#define PB_Main_system_protobuf_version_request_tag 39
#define PB_Main_system_protobuf_version_response_tag 40
#define PB_Main_system_update_request_tag        41
#define PB_Main_storage_backup_create_request_tag 42
#define PB_Main_storage_backup_restore_request_tag 43
#define PB_Main_system_power_info_request_tag    44
#define PB_Main_system_power_info_response_tag   45
#define PB_Main_system_update_response_tag       46
#define PB_Main_app_exit_request_tag             47
#define PB_Main_app_load_file_request_tag        48
#define PB_Main_app_button_press_request_tag     49
#define PB_Main_app_button_release_request_tag   50
#define PB_Main_gpio_set_pin_mode_tag            51
#define PB_Main_gpio_set_input_pull_tag          52
#define PB_Main_gpio_get_pin_mode_tag            53
#define PB_Main_gpio_get_pin_mode_response_tag   54
#define PB_Main_gpio_read_pin_tag                55
#define PB_Main_gpio_read_pin_response_tag       56
#define PB_Main_gpio_write_pin_tag               57
#define PB_Main_app_state_response_tag           58
#define PB_Main_storage_timestamp_request_tag    59
#define PB_Main_storage_timestamp_response_tag   60
#define PB_Main_property_get_request_tag         61
#define PB_Main_property_get_response_tag        62
#define PB_Main_app_get_error_request_tag        63
#define PB_Main_app_get_error_response_tag       64
#define PB_Main_app_data_exchange_request_tag    65
#define PB_Region_Band_start_tag                 1
#define PB_Region_Band_end_tag                   2
#define PB_Region_Band_power_limit_tag           3
#define PB_Region_Band_duty_cycle_tag            4

/* Struct field encoding specification for nanopb */
#define PB_Empty_FIELDLIST(X, a) \

#define PB_Empty_CALLBACK NULL
#define PB_Empty_DEFAULT NULL

#define PB_StopSession_FIELDLIST(X, a) \

#define PB_StopSession_CALLBACK NULL
#define PB_StopSession_DEFAULT NULL

#define PB_Main_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   command_id,        1) \
X(a, STATIC,   SINGULAR, UENUM,    command_status,    2) \
X(a, STATIC,   SINGULAR, BOOL,     has_next,          3) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,empty,content.empty),   4) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,system_ping_request,content.system_ping_request),   5) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,system_ping_response,content.system_ping_response),   6) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_list_request,content.storage_list_request),   7) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_list_response,content.storage_list_response),   8) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_read_request,content.storage_read_request),   9) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_read_response,content.storage_read_response),  10) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_write_request,content.storage_write_request),  11) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_delete_request,content.storage_delete_request),  12) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_mkdir_request,content.storage_mkdir_request),  13) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_md5sum_request,content.storage_md5sum_request),  14) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_md5sum_response,content.storage_md5sum_response),  15) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,app_start_request,content.app_start_request),  16) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,app_lock_status_request,content.app_lock_status_request),  17) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,app_lock_status_response,content.app_lock_status_response),  18) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,stop_session,content.stop_session),  19) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,gui_start_screen_stream_request,content.gui_start_screen_stream_request),  20) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,gui_stop_screen_stream_request,content.gui_stop_screen_stream_request),  21) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,gui_screen_frame,content.gui_screen_frame),  22) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,gui_send_input_event_request,content.gui_send_input_event_request),  23) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_stat_request,content.storage_stat_request),  24) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_stat_response,content.storage_stat_response),  25) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,gui_start_virtual_display_request,content.gui_start_virtual_display_request),  26) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,gui_stop_virtual_display_request,content.gui_stop_virtual_display_request),  27) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_info_request,content.storage_info_request),  28) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_info_response,content.storage_info_response),  29) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_rename_request,content.storage_rename_request),  30) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,system_reboot_request,content.system_reboot_request),  31) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,system_device_info_request,content.system_device_info_request),  32) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,system_device_info_response,content.system_device_info_response),  33) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,system_factory_reset_request,content.system_factory_reset_request),  34) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,system_get_datetime_request,content.system_get_datetime_request),  35) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,system_get_datetime_response,content.system_get_datetime_response),  36) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,system_set_datetime_request,content.system_set_datetime_request),  37) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,system_play_audiovisual_alert_request,content.system_play_audiovisual_alert_request),  38) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,system_protobuf_version_request,content.system_protobuf_version_request),  39) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,system_protobuf_version_response,content.system_protobuf_version_response),  40) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,system_update_request,content.system_update_request),  41) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_backup_create_request,content.storage_backup_create_request),  42) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_backup_restore_request,content.storage_backup_restore_request),  43) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,system_power_info_request,content.system_power_info_request),  44) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,system_power_info_response,content.system_power_info_response),  45) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,system_update_response,content.system_update_response),  46) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,app_exit_request,content.app_exit_request),  47) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,app_load_file_request,content.app_load_file_request),  48) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,app_button_press_request,content.app_button_press_request),  49) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,app_button_release_request,content.app_button_release_request),  50) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,gpio_set_pin_mode,content.gpio_set_pin_mode),  51) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,gpio_set_input_pull,content.gpio_set_input_pull),  52) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,gpio_get_pin_mode,content.gpio_get_pin_mode),  53) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,gpio_get_pin_mode_response,content.gpio_get_pin_mode_response),  54) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,gpio_read_pin,content.gpio_read_pin),  55) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,gpio_read_pin_response,content.gpio_read_pin_response),  56) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,gpio_write_pin,content.gpio_write_pin),  57) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,app_state_response,content.app_state_response),  58) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_timestamp_request,content.storage_timestamp_request),  59) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,storage_timestamp_response,content.storage_timestamp_response),  60) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,property_get_request,content.property_get_request),  61) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,property_get_response,content.property_get_response),  62) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,app_get_error_request,content.app_get_error_request),  63) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,app_get_error_response,content.app_get_error_response),  64) \
X(a, STATIC,   ONEOF,    MSG_W_CB, (content,app_data_exchange_request,content.app_data_exchange_request),  65)
#define PB_Main_CALLBACK NULL
#define PB_Main_DEFAULT NULL
#define PB_Main_content_empty_MSGTYPE PB_Empty
#define PB_Main_content_system_ping_request_MSGTYPE PB_System_PingRequest
#define PB_Main_content_system_ping_response_MSGTYPE PB_System_PingResponse
#define PB_Main_content_storage_list_request_MSGTYPE PB_Storage_ListRequest
#define PB_Main_content_storage_list_response_MSGTYPE PB_Storage_ListResponse
#define PB_Main_content_storage_read_request_MSGTYPE PB_Storage_ReadRequest
#define PB_Main_content_storage_read_response_MSGTYPE PB_Storage_ReadResponse
#define PB_Main_content_storage_write_request_MSGTYPE PB_Storage_WriteRequest
#define PB_Main_content_storage_delete_request_MSGTYPE PB_Storage_DeleteRequest
#define PB_Main_content_storage_mkdir_request_MSGTYPE PB_Storage_MkdirRequest
#define PB_Main_content_storage_md5sum_request_MSGTYPE PB_Storage_Md5sumRequest
#define PB_Main_content_storage_md5sum_response_MSGTYPE PB_Storage_Md5sumResponse
#define PB_Main_content_app_start_request_MSGTYPE PB_App_StartRequest
#define PB_Main_content_app_lock_status_request_MSGTYPE PB_App_LockStatusRequest
#define PB_Main_content_app_lock_status_response_MSGTYPE PB_App_LockStatusResponse
#define PB_Main_content_stop_session_MSGTYPE PB_StopSession
#define PB_Main_content_gui_start_screen_stream_request_MSGTYPE PB_Gui_StartScreenStreamRequest
#define PB_Main_content_gui_stop_screen_stream_request_MSGTYPE PB_Gui_StopScreenStreamRequest
#define PB_Main_content_gui_screen_frame_MSGTYPE PB_Gui_ScreenFrame
#define PB_Main_content_gui_send_input_event_request_MSGTYPE PB_Gui_SendInputEventRequest
#define PB_Main_content_storage_stat_request_MSGTYPE PB_Storage_StatRequest
#define PB_Main_content_storage_stat_response_MSGTYPE PB_Storage_StatResponse
#define PB_Main_content_gui_start_virtual_display_request_MSGTYPE PB_Gui_StartVirtualDisplayRequest
#define PB_Main_content_gui_stop_virtual_display_request_MSGTYPE PB_Gui_StopVirtualDisplayRequest
#define PB_Main_content_storage_info_request_MSGTYPE PB_Storage_InfoRequest
#define PB_Main_content_storage_info_response_MSGTYPE PB_Storage_InfoResponse
#define PB_Main_content_storage_rename_request_MSGTYPE PB_Storage_RenameRequest
#define PB_Main_content_system_reboot_request_MSGTYPE PB_System_RebootRequest
#define PB_Main_content_system_device_info_request_MSGTYPE PB_System_DeviceInfoRequest
#define PB_Main_content_system_device_info_response_MSGTYPE PB_System_DeviceInfoResponse
#define PB_Main_content_system_factory_reset_request_MSGTYPE PB_System_FactoryResetRequest
#define PB_Main_content_system_get_datetime_request_MSGTYPE PB_System_GetDateTimeRequest
#define PB_Main_content_system_get_datetime_response_MSGTYPE PB_System_GetDateTimeResponse
#define PB_Main_content_system_set_datetime_request_MSGTYPE PB_System_SetDateTimeRequest
#define PB_Main_content_system_play_audiovisual_alert_request_MSGTYPE PB_System_PlayAudiovisualAlertRequest
#define PB_Main_content_system_protobuf_version_request_MSGTYPE PB_System_ProtobufVersionRequest
#define PB_Main_content_system_protobuf_version_response_MSGTYPE PB_System_ProtobufVersionResponse
#define PB_Main_content_system_update_request_MSGTYPE PB_System_UpdateRequest
#define PB_Main_content_storage_backup_create_request_MSGTYPE PB_Storage_BackupCreateRequest
#define PB_Main_content_storage_backup_restore_request_MSGTYPE PB_Storage_BackupRestoreRequest
#define PB_Main_content_system_power_info_request_MSGTYPE PB_System_PowerInfoRequest
#define PB_Main_content_system_power_info_response_MSGTYPE PB_System_PowerInfoResponse
#define PB_Main_content_system_update_response_MSGTYPE PB_System_UpdateResponse
#define PB_Main_content_app_exit_request_MSGTYPE PB_App_AppExitRequest
#define PB_Main_content_app_load_file_request_MSGTYPE PB_App_AppLoadFileRequest
#define PB_Main_content_app_button_press_request_MSGTYPE PB_App_AppButtonPressRequest
#define PB_Main_content_app_button_release_request_MSGTYPE PB_App_AppButtonReleaseRequest
#define PB_Main_content_gpio_set_pin_mode_MSGTYPE PB_Gpio_SetPinMode
#define PB_Main_content_gpio_set_input_pull_MSGTYPE PB_Gpio_SetInputPull
#define PB_Main_content_gpio_get_pin_mode_MSGTYPE PB_Gpio_GetPinMode
#define PB_Main_content_gpio_get_pin_mode_response_MSGTYPE PB_Gpio_GetPinModeResponse
#define PB_Main_content_gpio_read_pin_MSGTYPE PB_Gpio_ReadPin
#define PB_Main_content_gpio_read_pin_response_MSGTYPE PB_Gpio_ReadPinResponse
#define PB_Main_content_gpio_write_pin_MSGTYPE PB_Gpio_WritePin
#define PB_Main_content_app_state_response_MSGTYPE PB_App_AppStateResponse
#define PB_Main_content_storage_timestamp_request_MSGTYPE PB_Storage_TimestampRequest
#define PB_Main_content_storage_timestamp_response_MSGTYPE PB_Storage_TimestampResponse
#define PB_Main_content_property_get_request_MSGTYPE PB_Property_GetRequest
#define PB_Main_content_property_get_response_MSGTYPE PB_Property_GetResponse
#define PB_Main_content_app_get_error_request_MSGTYPE PB_App_GetErrorRequest
#define PB_Main_content_app_get_error_response_MSGTYPE PB_App_GetErrorResponse
#define PB_Main_content_app_data_exchange_request_MSGTYPE PB_App_DataExchangeRequest

#define PB_Region_FIELDLIST(X, a) \
X(a, POINTER,  SINGULAR, BYTES,    country_code,      1) \
X(a, CALLBACK, REPEATED, MESSAGE,  bands,             2)
#define PB_Region_CALLBACK pb_default_field_callback
#define PB_Region_DEFAULT NULL
#define PB_Region_bands_MSGTYPE PB_Region_Band

#define PB_Region_Band_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   start,             1) \
X(a, STATIC,   SINGULAR, UINT32,   end,               2) \
X(a, STATIC,   SINGULAR, INT32,    power_limit,       3) \
X(a, STATIC,   SINGULAR, UINT32,   duty_cycle,        4)
#define PB_Region_Band_CALLBACK NULL
#define PB_Region_Band_DEFAULT NULL

extern const pb_msgdesc_t PB_Empty_msg;
extern const pb_msgdesc_t PB_StopSession_msg;
extern const pb_msgdesc_t PB_Main_msg;
extern const pb_msgdesc_t PB_Region_msg;
extern const pb_msgdesc_t PB_Region_Band_msg;

/* Defines for backwards compatibility with code written before nanopb-0.4.0 */
#define PB_Empty_fields &PB_Empty_msg
#define PB_StopSession_fields &PB_StopSession_msg
#define PB_Main_fields &PB_Main_msg
#define PB_Region_fields &PB_Region_msg
#define PB_Region_Band_fields &PB_Region_Band_msg

/* Maximum encoded size of messages (where known) */
#if defined(PB_System_PingRequest_size) && defined(PB_System_PingResponse_size) && defined(PB_Storage_ListRequest_size) && defined(PB_Storage_ListResponse_size) && defined(PB_Storage_ReadRequest_size) && defined(PB_Storage_ReadResponse_size) && defined(PB_Storage_WriteRequest_size) && defined(PB_Storage_DeleteRequest_size) && defined(PB_Storage_MkdirRequest_size) && defined(PB_Storage_Md5sumRequest_size) && defined(PB_App_StartRequest_size) && defined(PB_Gui_ScreenFrame_size) && defined(PB_Storage_StatRequest_size) && defined(PB_Storage_StatResponse_size) && defined(PB_Gui_StartVirtualDisplayRequest_size) && defined(PB_Storage_InfoRequest_size) && defined(PB_Storage_RenameRequest_size) && defined(PB_System_DeviceInfoResponse_size) && defined(PB_System_UpdateRequest_size) && defined(PB_Storage_BackupCreateRequest_size) && defined(PB_Storage_BackupRestoreRequest_size) && defined(PB_System_PowerInfoResponse_size) && defined(PB_Storage_TimestampRequest_size) && defined(PB_Property_GetRequest_size) && defined(PB_Property_GetResponse_size) && defined(PB_App_GetErrorResponse_size) && defined(PB_App_DataExchangeRequest_size)
union PB_Main_content_size_union {char f5[(6 + PB_System_PingRequest_size)]; char f6[(6 + PB_System_PingResponse_size)]; char f7[(6 + PB_Storage_ListRequest_size)]; char f8[(6 + PB_Storage_ListResponse_size)]; char f9[(6 + PB_Storage_ReadRequest_size)]; char f10[(6 + PB_Storage_ReadResponse_size)]; char f11[(6 + PB_Storage_WriteRequest_size)]; char f12[(6 + PB_Storage_DeleteRequest_size)]; char f13[(6 + PB_Storage_MkdirRequest_size)]; char f14[(6 + PB_Storage_Md5sumRequest_size)]; char f16[(7 + PB_App_StartRequest_size)]; char f22[(7 + PB_Gui_ScreenFrame_size)]; char f24[(7 + PB_Storage_StatRequest_size)]; char f25[(7 + PB_Storage_StatResponse_size)]; char f26[(7 + PB_Gui_StartVirtualDisplayRequest_size)]; char f28[(7 + PB_Storage_InfoRequest_size)]; char f30[(7 + PB_Storage_RenameRequest_size)]; char f33[(7 + PB_System_DeviceInfoResponse_size)]; char f41[(7 + PB_System_UpdateRequest_size)]; char f42[(7 + PB_Storage_BackupCreateRequest_size)]; char f43[(7 + PB_Storage_BackupRestoreRequest_size)]; char f45[(7 + PB_System_PowerInfoResponse_size)]; char f59[(7 + PB_Storage_TimestampRequest_size)]; char f61[(7 + PB_Property_GetRequest_size)]; char f62[(7 + PB_Property_GetResponse_size)]; char f64[(7 + PB_App_GetErrorResponse_size)]; char f65[(7 + PB_App_DataExchangeRequest_size)]; char f0[519];};
#endif
/* PB_Region_size depends on runtime parameters */
#define PB_Empty_size                            0
#define PB_Region_Band_size                      26
#define PB_StopSession_size                      0
#if defined(PB_System_PingRequest_size) && defined(PB_System_PingResponse_size) && defined(PB_Storage_ListRequest_size) && defined(PB_Storage_ListResponse_size) && defined(PB_Storage_ReadRequest_size) && defined(PB_Storage_ReadResponse_size) && defined(PB_Storage_WriteRequest_size) && defined(PB_Storage_DeleteRequest_size) && defined(PB_Storage_MkdirRequest_size) && defined(PB_Storage_Md5sumRequest_size) && defined(PB_App_StartRequest_size) && defined(PB_Gui_ScreenFrame_size) && defined(PB_Storage_StatRequest_size) && defined(PB_Storage_StatResponse_size) && defined(PB_Gui_StartVirtualDisplayRequest_size) && defined(PB_Storage_InfoRequest_size) && defined(PB_Storage_RenameRequest_size) && defined(PB_System_DeviceInfoResponse_size) && defined(PB_System_UpdateRequest_size) && defined(PB_Storage_BackupCreateRequest_size) && defined(PB_Storage_BackupRestoreRequest_size) && defined(PB_System_PowerInfoResponse_size) && defined(PB_Storage_TimestampRequest_size) && defined(PB_Property_GetRequest_size) && defined(PB_Property_GetResponse_size) && defined(PB_App_GetErrorResponse_size) && defined(PB_App_DataExchangeRequest_size)
#define PB_Main_size                             (10 + sizeof(union PB_Main_content_size_union))
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
