% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-equal.R
\name{all_equal}
\alias{all_equal}
\title{Flexible equality comparison for data frames}
\usage{
all_equal(
  target,
  current,
  ignore_col_order = TRUE,
  ignore_row_order = TRUE,
  convert = FALSE,
  ...
)
}
\arguments{
\item{target, current}{Two data frames to compare.}

\item{ignore_col_order}{Should order of columns be ignored?}

\item{ignore_row_order}{Should order of rows be ignored?}

\item{convert}{Should similar classes be converted? Currently this will
convert factor to character and integer to double.}

\item{...}{Ignored. Needed for compatibility with \code{all.equal()}.}
}
\value{
\code{TRUE} if equal, otherwise a character vector describing
the reasons why they're not equal. Use \code{\link[=isTRUE]{isTRUE()}} if using the
result in an \code{if} expression.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{all_equal()} allows you to compare data frames, optionally ignoring
row and column names. It is deprecated as of dplyr 1.1.0, because it
makes it too easy to ignore important differences.
}
\examples{
scramble <- function(x) x[sample(nrow(x)), sample(ncol(x))]

# `all_equal()` ignored row and column ordering by default,
# but we now feel that that makes it too easy to make mistakes
mtcars2 <- scramble(mtcars)
all_equal(mtcars, mtcars2)

# Instead, be explicit about the row and column ordering
all.equal(
  mtcars,
  mtcars2[rownames(mtcars), names(mtcars)]
)
}
\keyword{internal}
