% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc-gridmapping.R
\name{nc_prj_to_gridmapping}
\alias{nc_prj_to_gridmapping}
\title{Get NetCDF-CF grid mapping from projection}
\usage{
nc_prj_to_gridmapping(prj)
}
\arguments{
\item{prj}{character PROJ string as used in raster, sf, sp, proj4, and rgdal packages.}
}
\value{
A named list containing attributes required for that grid_mapping.
}
\description{
Takes a proj4 string and returns a NetCDF-CF projection as
a named list of attributes.
}
\examples{
prj <- "+proj=longlat +datum=NAD27 +no_defs"
nc_prj_to_gridmapping(prj)
p1 <- "+proj=aea +lat_1=29.5 +lat_2=45.5 +lat_0=23 +lon_0=-96"
p2 <- "+x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
prj2 <- sprintf("\%s \%s", p1, p2) 
nc_prj_to_gridmapping(prj2)

nc_prj_to_gridmapping("+proj=longlat +a=6378137 +f=0.00335281066474748 +pm=0 +no_defs")

}
\references{
\enumerate{
\item \url{https://en.wikibooks.org/wiki/PROJ.4}
\item \url{https://trac.osgeo.org/gdal/wiki/NetCDF_ProjectionTestingStatus}
\item \url{http://cfconventions.org/cf-conventions/cf-conventions.html#appendix-grid-mappings}
}
}
