% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{py_list_packages}
\alias{py_list_packages}
\title{List installed Python packages}
\usage{
py_list_packages(
  envname = NULL,
  type = c("auto", "virtualenv", "conda"),
  python = NULL
)
}
\arguments{
\item{envname}{The name of, or path to, a Python virtual environment.
Ignored when \code{python} is non-\code{NULL}.}

\item{type}{The virtual environment type. Useful if you have both
virtual environments and Conda environments of the same name on
your system, and you need to disambiguate them.}

\item{python}{The path to a Python executable.}
}
\value{
An \R data.frame, with columns:

\describe{
\item{\code{package}}{The package name.}
\item{\code{version}}{The package version.}
\item{\code{requirement}}{The package requirement.}
\item{\code{channel}}{(Conda only) The channel associated with this package.}
}
}
\description{
List the Python packages that are installed in the requested Python
environment.
}
\details{
When \code{envname} is \code{NULL}, \code{reticulate} will use the "default" version
of Python, as reported by \code{\link[=py_exe]{py_exe()}}. This implies that you
can call \code{py_list_packages()} without arguments in order to list
the installed Python packages in the version of Python currently
used by \code{reticulate}.
}
