% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots-ellipsis.R
\name{check_dots_used}
\alias{check_dots_used}
\title{Check that all dots have been used}
\usage{
check_dots_used(
  env = caller_env(),
  call = caller_env(),
  error = NULL,
  action = deprecated()
)
}
\arguments{
\item{env}{Environment in which to look for \code{...} and to set up handler.}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[=abort]{abort()}} for more information.}

\item{error}{An optional error handler passed to \code{\link[=try_fetch]{try_fetch()}}. Use
this e.g. to demote an error into a warning.}

\item{action}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\description{
When \code{...} arguments are passed to methods, it is assumed there
method will match and use these arguments. If this isn't the case,
this often indicates a programming error. Call \code{check_dots_used()}
to fail with an error when unused arguments are detected.
}
\details{
In packages, document \code{...} with this standard tag:

\if{html}{\out{<div class="sourceCode">}}\preformatted{ @inheritParams rlang::args_dots_used
}\if{html}{\out{</div>}}

\code{check_dots_used()} implicitly calls \code{\link[=on.exit]{on.exit()}} to check that all
elements of \code{...} have been used when the function exits. If you
use \code{\link[=on.exit]{on.exit()}} elsewhere in your function, make sure to use \code{add = TRUE} so that you don't override the handler set up by
\code{check_dots_used()}.
}
\examples{
f <- function(...) {
  check_dots_used()
  g(...)
}

g <- function(x, y, ...) {
  x + y
}
f(x = 1, y = 2)

try(f(x = 1, y = 2, z = 3))

try(f(x = 1, y = 2, 3, 4, 5))

}
