% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-number-si.R
\name{label_number_si}
\alias{label_number_si}
\title{Label numbers with SI prefixes (2 kg, 5 mm, etc)}
\usage{
label_number_si(unit = "", accuracy = NULL, scale = 1, suffix = "", ...)
}
\arguments{
\item{unit}{Unit of measurement (e.g. \code{"m"} for meter, the SI unit of length).}

\item{accuracy}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}

\item{scale}{A scaling factor: \code{x} will be multiplied by \code{scale} before
formatting. This is useful if the underlying data is already using an SI
prefix.}

\item{suffix}{Additional text to display after the number.}

\item{...}{Other arguments passed on to \code{\link[base:format]{base::format()}}.}
}
\value{
All \code{label_()} functions return a "labelling" function, i.e. a function that
takes a vector \code{x} and returns a character vector of \code{length(x)} giving a
label for each input value.

Labelling functions are designed to be used with the \code{labels} argument of
ggplot2 scales. The examples demonstrate their use with x scales, but
they work similarly for all scales, including those that generate legends
rather than axes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{label_number_si()} is deprecated because the previous unit didn't actually
use SI units, but instead used the so called "short scale". You can now get the
same results as before with
\code{label_number(scale_cut = cut_short_scale())}, or if you want correct SI
units, \code{label_number(scale_cut = cut_si("unit"))}.
}
\examples{
\dontshow{if (getRversion() >= "3.5") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# label_number_si() doesn't actually produce SI prefixes:
demo_continuous(c(1, 1e9), labels = label_number_si("g"))

# If you want real SI prefixes, use cut_si()
demo_continuous(c(1, 1e9), labels = label_number(scale_cut = cut_si("m")))

# If you want the existing behavior, use cut_short_scale()
demo_continuous(c(1, 1e9), labels = label_number(scale_cut = cut_short_scale()))
\dontshow{\}) # examplesIf}
}
\seealso{
Other labels for continuous scales: 
\code{\link{label_bytes}()},
\code{\link{label_dollar}()},
\code{\link{label_number_auto}()},
\code{\link{label_ordinal}()},
\code{\link{label_parse}()},
\code{\link{label_percent}()},
\code{\link{label_pvalue}()},
\code{\link{label_scientific}()}

Other labels for log scales: 
\code{\link{label_bytes}()},
\code{\link{label_log}()},
\code{\link{label_scientific}()}
}
\concept{labels for continuous scales}
\concept{labels for log scales}
\keyword{internal}
