# Tests for sedsed command line usage

Use [clitest](https://github.com/aureliojargas/clitest) to run the tests from this file.

    clitest test/command_line.md

## Setup

Make sure we always run the `sedsed` copy from this repository.

```
$ sedsed() { python ./sedsed.py --nocolor "$@"; }
$
```

## Test errors

Called with no parameters.

```
$ sedsed
ERROR: sedsed: there's no SED script to parse! (try --help)
$
```

Called with parameters, but no input file.

```
$ sedsed --indent
ERROR: sedsed: there's no SED script to parse! (try --help)
$
```

Missing argument for one option.

```
$ sedsed -f
ERROR: sedsed: option -f requires argument (try --help)
$
```

Input file not found.

```
$ sedsed -f 404
ERROR: sedsed: Cannot read file: 404
[Errno 2] No such file or directory: '404'
$
```

Invalid options.

```
$ sedsed -Z
ERROR: sedsed: option -Z not recognized (try --help)
$ sedsed --zoo
ERROR: sedsed: option --zoo not recognized (try --help)
$
```

Non-space argument for `--prefix`.

```
$ sedsed --prefix x
ERROR: sedsed: --prefix: must be spaces and/or TABs
$
```

Invalid sed script when formatting.

```
$ sedsed Z
ERROR: sedsed: sedparse: -e expression #1, char 1: unknown command: `Z'
$
```

Invalid sed script when debugging.

```
$ sedsed -d Z 2>&1 | sed 's/file .* line/line/'
sed: line 1: unknown command: `Z'
ERROR: sedsed: 1: Failed validating your script using system's sed: sed
$
```

## Test informing multiple actions

The last one wins.

```
$ sedsed -d -H -t -i 5x
5 x
$
```

## Test -h, --help

```
$ sedsed -h

Usage: sedsed OPTION [-e sedscript] [-f sedscriptfile] [inputfile]

OPTIONS:

     -f, --file          add file contents to the commands to be parsed
     -e, --expression    add the script to the commands to be parsed
     -n, --quiet         suppress automatic printing of pattern space
         --silent        alias to --quiet

     -d, --debug         debug the sed script
         --hide          hide some debug info (options: PATT,HOLD,COMM)
         --color         shows debug output in colors (default: ON)
         --nocolor       no colors on debug output
         --dump-debug    dumps to screen the debugged sed script

     -i, --indent        script beautifier, prints indented and
                         one-command-per-line output do STDOUT
         --prefix        indent prefix string (default: 4 spaces)

     -t, --tokenize      script tokenizer, prints extensive
                         command by command information
     -H, --htmlize       converts sed script to a colorful HTML page

     -V, --version       prints the program version and exit
     -h, --help          prints this help message and exit

Website: https://aurelio.net/projects/sedsed/

$ sedsed --help | sed -n 2p
Usage: sedsed OPTION [-e sedscript] [-f sedscriptfile] [inputfile]
$
```

## Test -V, --version

```
$ sedsed --version | tr -s 0-9 9 | sed 's/-dev//'
sedsed v9.9
$ sedsed -V        | tr -s 0-9 9 | sed 's/-dev//'
sedsed v9.9
$
```

## Test -d, --debug

```
$ echo abc | sedsed -d p
PATT:abc$
HOLD:$
COMM:p
abc
PATT:abc$
HOLD:$
abc
$ echo abc | sedsed --debug p
PATT:abc$
HOLD:$
COMM:p
abc
PATT:abc$
HOLD:$
abc
$
```

## Test --hide

```
$ echo abc | sedsed -d --hide=comm p
PATT:abc$
HOLD:$
abc
PATT:abc$
HOLD:$
abc
$ echo abc | sedsed -d --hide=comm,patt p
HOLD:$
abc
HOLD:$
abc
$ echo abc | sedsed -d --hide=comm,patt,hold p
abc
abc
$ echo abc | sedsed -d --hide=COMM,PATT,HOLD p
abc
abc
$
```

## Test -n, --quiet, --silent

Note how `abc` does not show up in the last line of the output when using those options.

```
$ echo abc | sedsed -n -d p
PATT:abc$
HOLD:$
COMM:p
abc
PATT:abc$
HOLD:$
$ echo abc | sedsed --quiet -d p
PATT:abc$
HOLD:$
COMM:p
abc
PATT:abc$
HOLD:$
$ echo abc | sedsed --silent -d p
PATT:abc$
HOLD:$
COMM:p
abc
PATT:abc$
HOLD:$
$
```

## Test --dump-debug

```
$ sedsed --dump-debug p | tr '\t' ' ' | sed 's/sedsed-.*/sedsed/'
  s/^/PATT:/
  l
  s/^PATT://
  x
  s/^/HOLD:/
  l
  s/^HOLD://
  x
  i\
COMM:p
#--------------------------------------------------
p
  s/^/PATT:/
  l
  s/^PATT://
  x
  s/^/HOLD:/
  l
  s/^HOLD://
  x

# Debugged SED script generated by sedsed
$
```

When the `t` command is present, some extra debug commands are added:

```
$ sedsed --dump-debug t | tr '\t' ' ' | sed 's/sedsed-.*/sedsed/ ; s/t $/t/'
  t zzset001
  s/^/PATT:/
  l
  s/^PATT://
  x
  s/^/HOLD:/
  l
  s/^HOLD://
  x
  i\
COMM:t

  t zzclr001
  :zzset001
  s/^/PATT:/
  l
  s/^PATT://
  x
  s/^/HOLD:/
  l
  s/^HOLD://
  x
  i\
COMM:t

  :zzclr001
#--------------------------------------------------
t
  s/^/PATT:/
  l
  s/^PATT://
  x
  s/^/HOLD:/
  l
  s/^HOLD://
  x

# Debugged SED script generated by sedsed
$
```

## Test -i, --indent

Indent is the default action, so when no other action option is informed, sedsed will indent the script.

```
$ sedsed {5d}
{
    5 d
}
$ sedsed -i {5d}
{
    5 d
}
$ sedsed --indent  {5d}
{
    5 d
}
$
```

## Test --prefix

Using 0-spaces, 1-space, 2-spaces and a tab.

```
$ sedsed --indent --prefix '' {5d}
{
5 d
}
$ sedsed --indent --prefix ' ' {5d}
{
 5 d
}
$ sedsed --indent --prefix '  ' {5d}
{
  5 d
}
$ sedsed --indent --prefix '	' {5d}
{
	5 d
}
$
```

## Test -t, --tokenize

```
$ sedsed -t '99p'
    linenr:1
     addr1:99
 addr1flag:
     addr2:
 addr2flag:
  lastaddr:
  modifier:
        id:p
   content:
 delimiter:
   pattern:
   replace:
      flag:
   comment:

$ sedsed --tokenize '99p'
    linenr:1
     addr1:99
 addr1flag:
     addr2:
 addr2flag:
  lastaddr:
  modifier:
        id:p
   content:
 delimiter:
   pattern:
   replace:
      flag:
   comment:

$
```

## Test -H, --htmlize

```
$ sedsed -H '99p' | sed -n '/99/ p'
<font color="#8080ff"><b>99</b></font> <font color="#ffff00"><b>p</b></font>
$ sedsed --htmlize '99p' | sed -n '/99/ p'
<font color="#8080ff"><b>99</b></font> <font color="#ffff00"><b>p</b></font>
$
```

## Test -e, --expression

```
$ sedsed -e 5p
5 p
$ sedsed --expression 5p
5 p
$ sedsed -e 5p --expression 10x -e 15q
5 p
10 x
15 q
$
```

## Test -f, --file

```
$ echo 5p > f1
$ echo 10x > f2
$ echo 15q > f3
$ sedsed -f f1
5 p
$ sedsed --file f1
5 p
$ sedsed -f f1 --file f2 -f f3
5 p
10 x
15 q
$
```

Now mixing `-e` and `-f`:

```
$ sedsed -f f1 -e 10x -f f3
5 p
10 x
15 q
$
```

Remove the temporary files:

```
$ rm f1 f2 f3
$
```
