## Copyright (C) 1993,1994 by the author(s).
# 
# This software is published in the hope that it will be useful, but
# WITHOUT ANY WARRANTY for any part of this software to work correctly
# or as described in the manuals. See the ShapeTools Public License
# for details.
#
# Permission is granted to use, copy, modify, or distribute any part of
# this software but only under the conditions described in the ShapeTools 
# Public License. A copy of this license is supposed to have been given
# to you along with ShapeTools in a file named LICENSE. Among other
# things, this copyright notice and the Public License must be
# preserved on all copies.

#
# Authors: Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
#          Juergen Nickelsen (Juergen.Nickelsen@cs.tu-berlin.de)
#
# Little utility to print essential information about last 
# release of a (Sub-)System managed with shapeTools RMS.
#
# $Header: lastrelease.sh[6.0] Fri Jun 25 17:01:22 1993 andy@cs.tu-berlin.de frozen $
#
# $__xpoff$
#

argc=$#
short=nope

while [ $argc -gt 0 ]
do
  i=$1
  shift
  argc=`expr $argc - 1`
  case $i in
    -s) 
	short=yes;;
  esac
done

if [ "$short" = "yes" ]
  then
    vl -format '$__lastrelease$' -lastsaved `shape -echo VERSIONFILE`
    exit 0
  fi

node=`shape -echo NODENAME`
echo -n Last release of $node
vl -format ': $__lastrelease$\nMade on $__ctime$ by $__author$.\n' \
-lastsaved `shape -echo VERSIONFILE`
