/* dhparam.c: initial DH parameters for stunnel */
#include "prototypes.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void) {
    static unsigned char dhp_2048[] = {
        0xd4, 0x8a, 0x10, 0xd2, 0xa8, 0x33, 0xa9, 0x00, 0x57, 0x67, 0xf7, 0x14,
        0xff, 0x5d, 0x78, 0x94, 0x09, 0x1f, 0x33, 0xce, 0x7d, 0x01, 0xf5, 0x5b,
        0x67, 0xe1, 0x75, 0x92, 0xf4, 0xdb, 0x50, 0x69, 0x30, 0x28, 0x72, 0x84,
        0x45, 0x1f, 0x76, 0xbd, 0x06, 0x24, 0x39, 0x46, 0x12, 0xaf, 0x05, 0x6d,
        0xa1, 0x74, 0xc8, 0x36, 0x7a, 0x39, 0x03, 0x89, 0x75, 0x79, 0x90, 0x4c,
        0x3c, 0xd5, 0xe1, 0xa2, 0x8a, 0x38, 0x86, 0x46, 0x11, 0xaf, 0xaa, 0x7d,
        0xda, 0xd9, 0xb1, 0x65, 0x02, 0xe3, 0x98, 0x78, 0xf5, 0x79, 0x0f, 0x0f,
        0x41, 0x64, 0x20, 0x67, 0x05, 0x5c, 0x45, 0xd3, 0x4b, 0x0f, 0xea, 0xd8,
        0xdc, 0xfc, 0xf3, 0xc3, 0x46, 0xcc, 0xda, 0x28, 0xa8, 0xaa, 0x39, 0x2b,
        0xa4, 0xf9, 0x0a, 0x4e, 0xa2, 0xb8, 0xec, 0x4f, 0x89, 0x63, 0xaa, 0xb0,
        0x87, 0xe6, 0x47, 0xed, 0x53, 0x48, 0x31, 0xb9, 0xf5, 0x09, 0xfe, 0x0a,
        0xcd, 0x48, 0x45, 0x6d, 0xc9, 0x5e, 0x0e, 0x22, 0x0e, 0xcc, 0xe8, 0x85,
        0xe4, 0x02, 0xb6, 0xd4, 0x62, 0xda, 0xa0, 0x9f, 0x51, 0x61, 0xf7, 0xf5,
        0xf9, 0xf1, 0x2f, 0x3b, 0x4b, 0xc1, 0x03, 0xa1, 0x10, 0xae, 0x12, 0x34,
        0x33, 0xed, 0xf5, 0xba, 0xd6, 0x2d, 0x10, 0xa3, 0x7d, 0x83, 0x5e, 0xed,
        0x7a, 0x26, 0xfc, 0x05, 0xa7, 0x64, 0xf8, 0x15, 0x74, 0x3d, 0xfc, 0x21,
        0x1e, 0x5a, 0x76, 0xfe, 0xfc, 0x6a, 0x18, 0x46, 0x03, 0xf4, 0x24, 0xb4,
        0x3b, 0xe1, 0xed, 0x99, 0x0d, 0x07, 0x7f, 0x71, 0x19, 0x95, 0xcd, 0xc0,
        0x1f, 0xd8, 0x13, 0x5a, 0x7c, 0x8e, 0x84, 0x83, 0x14, 0xb9, 0x24, 0xea,
        0x20, 0x97, 0x8c, 0x3a, 0xe1, 0x98, 0x17, 0x02, 0x12, 0x55, 0xc1, 0x8c,
        0x07, 0xf6, 0x70, 0x7b, 0x37, 0xc0, 0xca, 0x01, 0x20, 0xd1, 0x83, 0x18,
        0x7b, 0x2f, 0x31, 0x5b
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.68 */
